(define (array-ref a . xs)
  (or (array:array? a)
      (error "array-ref: not an array"))
  (let ((shape (array:shape a)))
    (if (null? xs)
        (array:check-indices "array-ref" xs shape)
        (let ((x (car xs)))
          (if (vector? x)
              (array:check-index-vector "array-ref" x shape)
              (if (integer? x)
                  (array:check-indices "array-ref" xs shape)
                  (if (array:array? x)
                      (array:check-index-actor "array-ref" x shape)
                      (error "not an index object"))))))
    (vector-ref
     (array:vector a)
     (if (null? xs)
         ((car (array:index a)))
         (let ((x (car xs)))
           (if (vector? x)
               (array:index/vector
                (quotient (vector-length shape) 2)
                (array:index a)
                x)
               (if (integer? x)
                   (apply (car (array:index a)) xs)
                   (if (array:array? x)
                       (array:index/array
                        (quotient (vector-length shape) 2)
                        (array:index a)
                        (array:vector x)
                        (array:index x))
                       (error "array-ref: bad index object")))))))))

(define (array-set! a x . xs)
  (or (array:array? a)
      (error "array-set!: not an array"))
  (let ((shape (array:shape a)))
    (if (null? xs)
        (array:check-indices "array-set!" '() shape)
        (if (vector? x)
            (array:check-index-vector "array-set!" x shape)
            (if (integer? x)
                (array:check-indices.o "array-set!" (cons x xs) shape)
                (if (array:array? x)
                    (array:check-index-actor "array-set!" x shape)
                    (error "array-set!: not an index object")))))
    (if (null? xs)
        ((cdr (array:index a)) (array:vector a) x)
        (if (vector? x)
            (vector-set!
             (array:vector a)
             (array:index/vector
              (quotient (vector-length shape) 2)
              (array:index a)
              x)
             (car xs))
            (if (integer? x)
                (apply (cdr (array:index a)) (array:vector a) x xs)
                (if (array:array? x)
                    (vector-set!
                     (array:vector a)
                     (array:index/array
                      (quotient (vector-length shape) 2)
                      (array:index a)
                      (array:vector x)
                      (array:index x))
                     (car xs))
                    (error "array:set!: bad index object")))))))
