(begin
  (define array:opt-args '(mbda (3 -1 0 1) (4 0 1)))
  (define (array:optimize f r)
    (case r
      ((0) (let ((n0 (f))) (array:0 n0)))
      ((1) (let ((n0 (f 0))) (array:1 n0 (- (f 1) n0))))
      ((2)
       (let ((n0 (f 0 0)))
         (array:2 n0 (- (f 1 0) n0) (- (f 0 1) n0))))
      ((3)
       (let ((n0 (f 0 0 0)))
         (array:3
           n0
           (- (f 1 0 0) n0)
           (- (f 0 1 0) n0)
           (- (f 0 0 1) n0))))
      (else
       (let ((v
              (do ((k 0 (+ k 1)) (v '() (cons 0 v)))
                  ((= k r) v))))
         (let ((n0 (apply f v)))
           (apply
            array:n
            n0
            (array:coefficients f n0 v v)))))))
  (define (array:optimize-empty r)
    (lambda ks
      (if (= (length ks) r)
        -1
        (values -1 (car (reverse ks))))))
  (define (array:coefficients f n0 vs vp)
    (case vp
      ((()) '())
      (else
       (set-car! vp 1)
       (let ((n (- (apply f vs) n0)))
         (set-car! vp 0)
         (cons n (array:coefficients f n0 vs (cdr vp)))))))
  (define (array:vector-index x ks) (apply x ks))
  (define (array:shape-index)
    (lambda (r k . o)
      (if (null? o) (+ r r k) (values (+ r r k) (car o)))))
  (define (array:empty-shape-index)
    (lambda (r k . o)
      (if (null? o) -1 (values -1 (car o)))))
  (define (array:shape-vector-index x r k) (x r k))
  (define (array:actor-index x k) (x k))
  (define (array:0 n0)
    (if (= n0 0) (array:0+0) (array:0+n n0)))
  (define (array:0+0)
    (lambda o (if (null? o) 0 (values 0 (car o)))))
  (define (array:0+n n0)
    (lambda o (if (null? o) n0 (values n0 (car o)))))
  (define (array:1 n0 n1)
    (if (= n0 0)
      (case n1
        ((-1) (array:1+0-1))
        ((0) (array:1+0+0))
        ((1) (array:1+0+1))
        (else (array:1+0+n n1)))
      (case n1
        ((-1) (array:1+n-1 n0))
        ((0) (array:1+n+0 n0))
        ((1) (array:1+n+1 n0))
        (else (array:1+n+n n0 n1)))))
  (define (array:1+0-1)
    (lambda (k1 . o)
      (if (null? o) (- k1) (values (- k1) (car o)))))
  (define (array:1+0+0)
    (lambda (k1 . o) (if (null? o) 0 (values 0 (car o)))))
  (define (array:1+0+1)
    (lambda (k1 . o) (if (null? o) k1 (values k1 (car o)))))
  (define (array:1+0+n n1)
    (lambda (k1 . o)
      (if (null? o) (* n1 k1) (values (* n1 k1) (car o)))))
  (define (array:1+n-1 n0)
    (lambda (k1 . o)
      (if (null? o)
        (+ n0 (- k1))
        (values (+ n0 (- k1)) (car o)))))
  (define (array:1+n+0 n0)
    (lambda (k1 . o) (if (null? o) n0 (values n0 (car o)))))
  (define (array:1+n+1 n0)
    (lambda (k1 . o)
      (if (null? o) (+ n0 k1) (values (+ n0 k1) (car o)))))
  (define (array:1+n+n n0 n1)
    (lambda (k1 . o)
      (if (null? o)
        (+ n0 (* n1 k1))
        (values (+ n0 (* n1 k1)) (car o)))))
  (define (array:2 n0 n1 n2)
    (if (= n0 0)
      (case n1
        ((-1)
         (case n2
           ((-1) (array:2+0-1-1))
           ((0) (array:2+0-1+0))
           ((1) (array:2+0-1+1))
           (else (array:2+0-1+n n2))))
        ((0)
         (case n2
           ((-1) (array:2+0+0-1))
           ((0) (array:2+0+0+0))
           ((1) (array:2+0+0+1))
           (else (array:2+0+0+n n2))))
        ((1)
         (case n2
           ((-1) (array:2+0+1-1))
           ((0) (array:2+0+1+0))
           ((1) (array:2+0+1+1))
           (else (array:2+0+1+n n2))))
        (else
         (case n2
           ((-1) (array:2+0+n-1 n1))
           ((0) (array:2+0+n+0 n1))
           ((1) (array:2+0+n+1 n1))
           (else (array:2+0+n+n n1 n2)))))
      (case n1
        ((-1)
         (case n2
           ((-1) (array:2+n-1-1 n0))
           ((0) (array:2+n-1+0 n0))
           ((1) (array:2+n-1+1 n0))
           (else (array:2+n-1+n n0 n2))))
        ((0)
         (case n2
           ((-1) (array:2+n+0-1 n0))
           ((0) (array:2+n+0+0 n0))
           ((1) (array:2+n+0+1 n0))
           (else (array:2+n+0+n n0 n2))))
        ((1)
         (case n2
           ((-1) (array:2+n+1-1 n0))
           ((0) (array:2+n+1+0 n0))
           ((1) (array:2+n+1+1 n0))
           (else (array:2+n+1+n n0 n2))))
        (else
         (case n2
           ((-1) (array:2+n+n-1 n0 n1))
           ((0) (array:2+n+n+0 n0 n1))
           ((1) (array:2+n+n+1 n0 n1))
           (else (array:2+n+n+n n0 n1 n2)))))))
  (define (array:2+0-1-1)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ (- k1) (- k2))
        (values (+ (- k1) (- k2)) (car o)))))
  (define (array:2+0-1+0)
    (lambda (k1 k2 . o)
      (if (null? o) (- k1) (values (- k1) (car o)))))
  (define (array:2+0-1+1)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ (- k1) k2)
        (values (+ (- k1) k2) (car o)))))
  (define (array:2+0-1+n n2)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ (- k1) (* n2 k2))
        (values (+ (- k1) (* n2 k2)) (car o)))))
  (define (array:2+0+0-1)
    (lambda (k1 k2 . o)
      (if (null? o) (- k2) (values (- k2) (car o)))))
  (define (array:2+0+0+0)
    (lambda (k1 k2 . o)
      (if (null? o) 0 (values 0 (car o)))))
  (define (array:2+0+0+1)
    (lambda (k1 k2 . o)
      (if (null? o) k2 (values k2 (car o)))))
  (define (array:2+0+0+n n2)
    (lambda (k1 k2 . o)
      (if (null? o) (* n2 k2) (values (* n2 k2) (car o)))))
  (define (array:2+0+1-1)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ k1 (- k2))
        (values (+ k1 (- k2)) (car o)))))
  (define (array:2+0+1+0)
    (lambda (k1 k2 . o)
      (if (null? o) k1 (values k1 (car o)))))
  (define (array:2+0+1+1)
    (lambda (k1 k2 . o)
      (if (null? o) (+ k1 k2) (values (+ k1 k2) (car o)))))
  (define (array:2+0+1+n n2)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ k1 (* n2 k2))
        (values (+ k1 (* n2 k2)) (car o)))))
  (define (array:2+0+n-1 n1)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ (* n1 k1) (- k2))
        (values (+ (* n1 k1) (- k2)) (car o)))))
  (define (array:2+0+n+0 n1)
    (lambda (k1 k2 . o)
      (if (null? o) (* n1 k1) (values (* n1 k1) (car o)))))
  (define (array:2+0+n+1 n1)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ (* n1 k1) k2)
        (values (+ (* n1 k1) k2) (car o)))))
  (define (array:2+0+n+n n1 n2)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ (* n1 k1) (* n2 k2))
        (values (+ (* n1 k1) (* n2 k2)) (car o)))))
  (define (array:2+n-1-1 n0)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ n0 (- k1) (- k2))
        (values (+ n0 (- k1) (- k2)) (car o)))))
  (define (array:2+n-1+0 n0)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ n0 (- k1))
        (values (+ n0 (- k1)) (car o)))))
  (define (array:2+n-1+1 n0)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ n0 (- k1) k2)
        (values (+ n0 (- k1) k2) (car o)))))
  (define (array:2+n-1+n n0 n2)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ n0 (- k1) (* n2 k2))
        (values (+ n0 (- k1) (* n2 k2)) (car o)))))
  (define (array:2+n+0-1 n0)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ n0 (- k2))
        (values (+ n0 (- k2)) (car o)))))
  (define (array:2+n+0+0 n0)
    (lambda (k1 k2 . o)
      (if (null? o) n0 (values n0 (car o)))))
  (define (array:2+n+0+1 n0)
    (lambda (k1 k2 . o)
      (if (null? o) (+ n0 k2) (values (+ n0 k2) (car o)))))
  (define (array:2+n+0+n n0 n2)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ n0 (* n2 k2))
        (values (+ n0 (* n2 k2)) (car o)))))
  (define (array:2+n+1-1 n0)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ n0 k1 (- k2))
        (values (+ n0 k1 (- k2)) (car o)))))
  (define (array:2+n+1+0 n0)
    (lambda (k1 k2 . o)
      (if (null? o) (+ n0 k1) (values (+ n0 k1) (car o)))))
  (define (array:2+n+1+1 n0)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ n0 k1 k2)
        (values (+ n0 k1 k2) (car o)))))
  (define (array:2+n+1+n n0 n2)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ n0 k1 (* n2 k2))
        (values (+ n0 k1 (* n2 k2)) (car o)))))
  (define (array:2+n+n-1 n0 n1)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ n0 (* n1 k1) (- k2))
        (values (+ n0 (* n1 k1) (- k2)) (car o)))))
  (define (array:2+n+n+0 n0 n1)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ n0 (* n1 k1))
        (values (+ n0 (* n1 k1)) (car o)))))
  (define (array:2+n+n+1 n0 n1)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ n0 (* n1 k1) k2)
        (values (+ n0 (* n1 k1) k2) (car o)))))
  (define (array:2+n+n+n n0 n1 n2)
    (lambda (k1 k2 . o)
      (if (null? o)
        (+ n0 (* n1 k1) (* n2 k2))
        (values (+ n0 (* n1 k1) (* n2 k2)) (car o)))))
  (define (array:3 n0 n1 n2 n3)
    (if (= n0 0)
      (case n1
        ((0)
         (case n2
           ((0)
            (case n3
              ((0) (array:3+0+0+0+0))
              ((1) (array:3+0+0+0+1))
              (else (array:3+0+0+0+n n3))))
           ((1)
            (case n3
              ((0) (array:3+0+0+1+0))
              ((1) (array:3+0+0+1+1))
              (else (array:3+0+0+1+n n3))))
           (else
            (case n3
              ((0) (array:3+0+0+n+0 n2))
              ((1) (array:3+0+0+n+1 n2))
              (else (array:3+0+0+n+n n2 n3))))))
        ((1)
         (case n2
           ((0)
            (case n3
              ((0) (array:3+0+1+0+0))
              ((1) (array:3+0+1+0+1))
              (else (array:3+0+1+0+n n3))))
           ((1)
            (case n3
              ((0) (array:3+0+1+1+0))
              ((1) (array:3+0+1+1+1))
              (else (array:3+0+1+1+n n3))))
           (else
            (case n3
              ((0) (array:3+0+1+n+0 n2))
              ((1) (array:3+0+1+n+1 n2))
              (else (array:3+0+1+n+n n2 n3))))))
        (else
         (case n2
           ((0)
            (case n3
              ((0) (array:3+0+n+0+0 n1))
              ((1) (array:3+0+n+0+1 n1))
              (else (array:3+0+n+0+n n1 n3))))
           ((1)
            (case n3
              ((0) (array:3+0+n+1+0 n1))
              ((1) (array:3+0+n+1+1 n1))
              (else (array:3+0+n+1+n n1 n3))))
           (else
            (case n3
              ((0) (array:3+0+n+n+0 n1 n2))
              ((1) (array:3+0+n+n+1 n1 n2))
              (else (array:3+0+n+n+n n1 n2 n3)))))))
      (case n1
        ((0)
         (case n2
           ((0)
            (case n3
              ((0) (array:3+n+0+0+0 n0))
              ((1) (array:3+n+0+0+1 n0))
              (else (array:3+n+0+0+n n0 n3))))
           ((1)
            (case n3
              ((0) (array:3+n+0+1+0 n0))
              ((1) (array:3+n+0+1+1 n0))
              (else (array:3+n+0+1+n n0 n3))))
           (else
            (case n3
              ((0) (array:3+n+0+n+0 n0 n2))
              ((1) (array:3+n+0+n+1 n0 n2))
              (else (array:3+n+0+n+n n0 n2 n3))))))
        ((1)
         (case n2
           ((0)
            (case n3
              ((0) (array:3+n+1+0+0 n0))
              ((1) (array:3+n+1+0+1 n0))
              (else (array:3+n+1+0+n n0 n3))))
           ((1)
            (case n3
              ((0) (array:3+n+1+1+0 n0))
              ((1) (array:3+n+1+1+1 n0))
              (else (array:3+n+1+1+n n0 n3))))
           (else
            (case n3
              ((0) (array:3+n+1+n+0 n0 n2))
              ((1) (array:3+n+1+n+1 n0 n2))
              (else (array:3+n+1+n+n n0 n2 n3))))))
        (else
         (case n2
           ((0)
            (case n3
              ((0) (array:3+n+n+0+0 n0 n1))
              ((1) (array:3+n+n+0+1 n0 n1))
              (else (array:3+n+n+0+n n0 n1 n3))))
           ((1)
            (case n3
              ((0) (array:3+n+n+1+0 n0 n1))
              ((1) (array:3+n+n+1+1 n0 n1))
              (else (array:3+n+n+1+n n0 n1 n3))))
           (else
            (case n3
              ((0) (array:3+n+n+n+0 n0 n1 n2))
              ((1) (array:3+n+n+n+1 n0 n1 n2))
              (else (array:3+n+n+n+n n0 n1 n2 n3)))))))))
  (define (array:3+0+0+0+0)
    (lambda (k1 k2 k3 . o)
      (if (null? o) 0 (values 0 (car o)))))
  (define (array:3+0+0+0+1)
    (lambda (k1 k2 k3 . o)
      (if (null? o) k3 (values k3 (car o)))))
  (define (array:3+0+0+0+n n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o) (* n3 k3) (values (* n3 k3) (car o)))))
  (define (array:3+0+0+1+0)
    (lambda (k1 k2 k3 . o)
      (if (null? o) k2 (values k2 (car o)))))
  (define (array:3+0+0+1+1)
    (lambda (k1 k2 k3 . o)
      (if (null? o) (+ k2 k3) (values (+ k2 k3) (car o)))))
  (define (array:3+0+0+1+n n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ k2 (* n3 k3))
        (values (+ k2 (* n3 k3)) (car o)))))
  (define (array:3+0+0+n+0 n2)
    (lambda (k1 k2 k3 . o)
      (if (null? o) (* n2 k2) (values (* n2 k2) (car o)))))
  (define (array:3+0+0+n+1 n2)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ (* n2 k2) k3)
        (values (+ (* n2 k2) k3) (car o)))))
  (define (array:3+0+0+n+n n2 n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ (* n2 k2) (* n3 k3))
        (values (+ (* n2 k2) (* n3 k3)) (car o)))))
  (define (array:3+0+1+0+0)
    (lambda (k1 k2 k3 . o)
      (if (null? o) k1 (values k1 (car o)))))
  (define (array:3+0+1+0+1)
    (lambda (k1 k2 k3 . o)
      (if (null? o) (+ k1 k3) (values (+ k1 k3) (car o)))))
  (define (array:3+0+1+0+n n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ k1 (* n3 k3))
        (values (+ k1 (* n3 k3)) (car o)))))
  (define (array:3+0+1+1+0)
    (lambda (k1 k2 k3 . o)
      (if (null? o) (+ k1 k2) (values (+ k1 k2) (car o)))))
  (define (array:3+0+1+1+1)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ k1 k2 k3)
        (values (+ k1 k2 k3) (car o)))))
  (define (array:3+0+1+1+n n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ k1 k2 (* n3 k3))
        (values (+ k1 k2 (* n3 k3)) (car o)))))
  (define (array:3+0+1+n+0 n2)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ k1 (* n2 k2))
        (values (+ k1 (* n2 k2)) (car o)))))
  (define (array:3+0+1+n+1 n2)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ k1 (* n2 k2) k3)
        (values (+ k1 (* n2 k2) k3) (car o)))))
  (define (array:3+0+1+n+n n2 n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ k1 (* n2 k2) (* n3 k3))
        (values (+ k1 (* n2 k2) (* n3 k3)) (car o)))))
  (define (array:3+0+n+0+0 n1)
    (lambda (k1 k2 k3 . o)
      (if (null? o) (* n1 k1) (values (* n1 k1) (car o)))))
  (define (array:3+0+n+0+1 n1)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ (* n1 k1) k3)
        (values (+ (* n1 k1) k3) (car o)))))
  (define (array:3+0+n+0+n n1 n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ (* n1 k1) (* n3 k3))
        (values (+ (* n1 k1) (* n3 k3)) (car o)))))
  (define (array:3+0+n+1+0 n1)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ (* n1 k1) k2)
        (values (+ (* n1 k1) k2) (car o)))))
  (define (array:3+0+n+1+1 n1)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ (* n1 k1) k2 k3)
        (values (+ (* n1 k1) k2 k3) (car o)))))
  (define (array:3+0+n+1+n n1 n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ (* n1 k1) k2 (* n3 k3))
        (values (+ (* n1 k1) k2 (* n3 k3)) (car o)))))
  (define (array:3+0+n+n+0 n1 n2)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ (* n1 k1) (* n2 k2))
        (values (+ (* n1 k1) (* n2 k2)) (car o)))))
  (define (array:3+0+n+n+1 n1 n2)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ (* n1 k1) (* n2 k2) k3)
        (values (+ (* n1 k1) (* n2 k2) k3) (car o)))))
  (define (array:3+0+n+n+n n1 n2 n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ (* n1 k1) (* n2 k2) (* n3 k3))
        (values
          (+ (* n1 k1) (* n2 k2) (* n3 k3))
          (car o)))))
  (define (array:3+n+0+0+0 n0)
    (lambda (k1 k2 k3 . o)
      (if (null? o) n0 (values n0 (car o)))))
  (define (array:3+n+0+0+1 n0)
    (lambda (k1 k2 k3 . o)
      (if (null? o) (+ n0 k3) (values (+ n0 k3) (car o)))))
  (define (array:3+n+0+0+n n0 n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 (* n3 k3))
        (values (+ n0 (* n3 k3)) (car o)))))
  (define (array:3+n+0+1+0 n0)
    (lambda (k1 k2 k3 . o)
      (if (null? o) (+ n0 k2) (values (+ n0 k2) (car o)))))
  (define (array:3+n+0+1+1 n0)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 k2 k3)
        (values (+ n0 k2 k3) (car o)))))
  (define (array:3+n+0+1+n n0 n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 k2 (* n3 k3))
        (values (+ n0 k2 (* n3 k3)) (car o)))))
  (define (array:3+n+0+n+0 n0 n2)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 (* n2 k2))
        (values (+ n0 (* n2 k2)) (car o)))))
  (define (array:3+n+0+n+1 n0 n2)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 (* n2 k2) k3)
        (values (+ n0 (* n2 k2) k3) (car o)))))
  (define (array:3+n+0+n+n n0 n2 n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 (* n2 k2) (* n3 k3))
        (values (+ n0 (* n2 k2) (* n3 k3)) (car o)))))
  (define (array:3+n+1+0+0 n0)
    (lambda (k1 k2 k3 . o)
      (if (null? o) (+ n0 k1) (values (+ n0 k1) (car o)))))
  (define (array:3+n+1+0+1 n0)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 k1 k3)
        (values (+ n0 k1 k3) (car o)))))
  (define (array:3+n+1+0+n n0 n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 k1 (* n3 k3))
        (values (+ n0 k1 (* n3 k3)) (car o)))))
  (define (array:3+n+1+1+0 n0)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 k1 k2)
        (values (+ n0 k1 k2) (car o)))))
  (define (array:3+n+1+1+1 n0)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 k1 k2 k3)
        (values (+ n0 k1 k2 k3) (car o)))))
  (define (array:3+n+1+1+n n0 n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 k1 k2 (* n3 k3))
        (values (+ n0 k1 k2 (* n3 k3)) (car o)))))
  (define (array:3+n+1+n+0 n0 n2)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 k1 (* n2 k2))
        (values (+ n0 k1 (* n2 k2)) (car o)))))
  (define (array:3+n+1+n+1 n0 n2)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 k1 (* n2 k2) k3)
        (values (+ n0 k1 (* n2 k2) k3) (car o)))))
  (define (array:3+n+1+n+n n0 n2 n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 k1 (* n2 k2) (* n3 k3))
        (values (+ n0 k1 (* n2 k2) (* n3 k3)) (car o)))))
  (define (array:3+n+n+0+0 n0 n1)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 (* n1 k1))
        (values (+ n0 (* n1 k1)) (car o)))))
  (define (array:3+n+n+0+1 n0 n1)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 (* n1 k1) k3)
        (values (+ n0 (* n1 k1) k3) (car o)))))
  (define (array:3+n+n+0+n n0 n1 n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 (* n1 k1) (* n3 k3))
        (values (+ n0 (* n1 k1) (* n3 k3)) (car o)))))
  (define (array:3+n+n+1+0 n0 n1)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 (* n1 k1) k2)
        (values (+ n0 (* n1 k1) k2) (car o)))))
  (define (array:3+n+n+1+1 n0 n1)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 (* n1 k1) k2 k3)
        (values (+ n0 (* n1 k1) k2 k3) (car o)))))
  (define (array:3+n+n+1+n n0 n1 n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 (* n1 k1) k2 (* n3 k3))
        (values (+ n0 (* n1 k1) k2 (* n3 k3)) (car o)))))
  (define (array:3+n+n+n+0 n0 n1 n2)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 (* n1 k1) (* n2 k2))
        (values (+ n0 (* n1 k1) (* n2 k2)) (car o)))))
  (define (array:3+n+n+n+1 n0 n1 n2)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 (* n1 k1) (* n2 k2) k3)
        (values (+ n0 (* n1 k1) (* n2 k2) k3) (car o)))))
  (define (array:3+n+n+n+n n0 n1 n2 n3)
    (lambda (k1 k2 k3 . o)
      (if (null? o)
        (+ n0 (* n1 k1) (* n2 k2) (* n3 k3))
        (values
          (+ n0 (* n1 k1) (* n2 k2) (* n3 k3))
          (car o)))))
  (define (array:n n0 n1 n2 n3 n4 . ns)
    (lambda (k1 k2 k3 k4 . ks)
      (do ((ns ns (cdr ns))
           (ks ks (cdr ks))
           (dx
            (+ n0 (* n1 k1) (* n2 k2) (* n3 k3) (* n4 k4))
            (+ dx (* (car ns) (car ks)))))
          ((null? ns)
           (if (null? ks) dx (values dx (car ks)))))))
  (define (array:maker r)
    (case r
      ((0) array:0)
      ((1) array:1)
      ((2) array:2)
      ((3) array:3)
      (else array:n)))
  (define array:indexer/vector
    (let ((em
           (vector
             (lambda (x i) (x))
             (lambda (x i) (x (vector-ref i 0)))
             (lambda (x i)
               (x (vector-ref i 0) (vector-ref i 1)))
             (lambda (x i)
               (x
                (vector-ref i 0)
                (vector-ref i 1)
                (vector-ref i 2)))
             (lambda (x i)
               (x
                (vector-ref i 0)
                (vector-ref i 1)
                (vector-ref i 2)
                (vector-ref i 3)))
             (lambda (x i)
               (x
                (vector-ref i 0)
                (vector-ref i 1)
                (vector-ref i 2)
                (vector-ref i 3)
                (vector-ref i 4)))
             (lambda (x i)
               (x
                (vector-ref i 0)
                (vector-ref i 1)
                (vector-ref i 2)
                (vector-ref i 3)
                (vector-ref i 4)
                (vector-ref i 5)))
             (lambda (x i)
               (x
                (vector-ref i 0)
                (vector-ref i 1)
                (vector-ref i 2)
                (vector-ref i 3)
                (vector-ref i 4)
                (vector-ref i 5)
                (vector-ref i 6)))
             (lambda (x i)
               (x
                (vector-ref i 0)
                (vector-ref i 1)
                (vector-ref i 2)
                (vector-ref i 3)
                (vector-ref i 4)
                (vector-ref i 5)
                (vector-ref i 6)
                (vector-ref i 7)))
             (lambda (x i)
               (x
                (vector-ref i 0)
                (vector-ref i 1)
                (vector-ref i 2)
                (vector-ref i 3)
                (vector-ref i 4)
                (vector-ref i 5)
                (vector-ref i 6)
                (vector-ref i 7)
                (vector-ref i 8)))))
          (it
           (lambda (w)
             (lambda (x i)
               (apply
                x
                (vector-ref i 0)
                (vector-ref i 1)
                (vector-ref i 2)
                (vector-ref i 3)
                (vector-ref i 4)
                (vector-ref i 5)
                (vector-ref i 6)
                (vector-ref i 7)
                (vector-ref i 8)
                (vector-ref i 9)
                (do ((ks '() (cons (vector-ref i u) ks))
                     (u (- w 1) (- u 1)))
                    ((< u 10) ks)))))))
      (lambda (r) (if (< r 10) (vector-ref em r) (it r)))))
  (define array:indexer/array
    (let ((em
           (vector
             (lambda (x v i) (x))
             (lambda (x v i)
               (x (vector-ref v (array:actor-index i 0))))
             (lambda (x v i)
               (x
                (vector-ref v (array:actor-index i 0))
                (vector-ref v (array:actor-index i 1))))
             (lambda (x v i)
               (x
                (vector-ref v (array:actor-index i 0))
                (vector-ref v (array:actor-index i 1))
                (vector-ref v (array:actor-index i 2))))
             (lambda (x v i)
               (x
                (vector-ref v (array:actor-index i 0))
                (vector-ref v (array:actor-index i 1))
                (vector-ref v (array:actor-index i 2))
                (vector-ref v (array:actor-index i 3))))
             (lambda (x v i)
               (x
                (vector-ref v (array:actor-index i 0))
                (vector-ref v (array:actor-index i 1))
                (vector-ref v (array:actor-index i 2))
                (vector-ref v (array:actor-index i 3))
                (vector-ref v (array:actor-index i 4))))
             (lambda (x v i)
               (x
                (vector-ref v (array:actor-index i 0))
                (vector-ref v (array:actor-index i 1))
                (vector-ref v (array:actor-index i 2))
                (vector-ref v (array:actor-index i 3))
                (vector-ref v (array:actor-index i 4))
                (vector-ref v (array:actor-index i 5))))
             (lambda (x v i)
               (x
                (vector-ref v (array:actor-index i 0))
                (vector-ref v (array:actor-index i 1))
                (vector-ref v (array:actor-index i 2))
                (vector-ref v (array:actor-index i 3))
                (vector-ref v (array:actor-index i 4))
                (vector-ref v (array:actor-index i 5))
                (vector-ref v (array:actor-index i 6))))
             (lambda (x v i)
               (x
                (vector-ref v (array:actor-index i 0))
                (vector-ref v (array:actor-index i 1))
                (vector-ref v (array:actor-index i 2))
                (vector-ref v (array:actor-index i 3))
                (vector-ref v (array:actor-index i 4))
                (vector-ref v (array:actor-index i 5))
                (vector-ref v (array:actor-index i 6))
                (vector-ref v (array:actor-index i 7))))
             (lambda (x v i)
               (x
                (vector-ref v (array:actor-index i 0))
                (vector-ref v (array:actor-index i 1))
                (vector-ref v (array:actor-index i 2))
                (vector-ref v (array:actor-index i 3))
                (vector-ref v (array:actor-index i 4))
                (vector-ref v (array:actor-index i 5))
                (vector-ref v (array:actor-index i 6))
                (vector-ref v (array:actor-index i 7))
                (vector-ref v (array:actor-index i 8))))))
          (it
           (lambda (w)
             (lambda (x v i)
               (apply
                x
                (vector-ref v (array:actor-index i 0))
                (vector-ref v (array:actor-index i 1))
                (vector-ref v (array:actor-index i 2))
                (vector-ref v (array:actor-index i 3))
                (vector-ref v (array:actor-index i 4))
                (vector-ref v (array:actor-index i 5))
                (vector-ref v (array:actor-index i 6))
                (vector-ref v (array:actor-index i 7))
                (vector-ref v (array:actor-index i 8))
                (vector-ref v (array:actor-index i 9))
                (do ((ks
                      '()
                      (cons
                       (vector-ref
                         v
                         (array:actor-index i u))
                       ks))
                     (u (- w 1) (- u 1)))
                    ((< u 10) ks)))))))
      (lambda (r) (if (< r 10) (vector-ref em r) (it r)))))
  (define array:applier-to-vector
    (let ((em
           (vector
             (lambda (p v) (p))
             (lambda (p v) (p (vector-ref v 0)))
             (lambda (p v)
               (p (vector-ref v 0) (vector-ref v 1)))
             (lambda (p v)
               (p
                (vector-ref v 0)
                (vector-ref v 1)
                (vector-ref v 2)))
             (lambda (p v)
               (p
                (vector-ref v 0)
                (vector-ref v 1)
                (vector-ref v 2)
                (vector-ref v 3)))
             (lambda (p v)
               (p
                (vector-ref v 0)
                (vector-ref v 1)
                (vector-ref v 2)
                (vector-ref v 3)
                (vector-ref v 4)))
             (lambda (p v)
               (p
                (vector-ref v 0)
                (vector-ref v 1)
                (vector-ref v 2)
                (vector-ref v 3)
                (vector-ref v 4)
                (vector-ref v 5)))
             (lambda (p v)
               (p
                (vector-ref v 0)
                (vector-ref v 1)
                (vector-ref v 2)
                (vector-ref v 3)
                (vector-ref v 4)
                (vector-ref v 5)
                (vector-ref v 6)))
             (lambda (p v)
               (p
                (vector-ref v 0)
                (vector-ref v 1)
                (vector-ref v 2)
                (vector-ref v 3)
                (vector-ref v 4)
                (vector-ref v 5)
                (vector-ref v 6)
                (vector-ref v 7)))
             (lambda (p v)
               (p
                (vector-ref v 0)
                (vector-ref v 1)
                (vector-ref v 2)
                (vector-ref v 3)
                (vector-ref v 4)
                (vector-ref v 5)
                (vector-ref v 6)
                (vector-ref v 7)
                (vector-ref v 8)))))
          (it
           (lambda (r)
             (lambda (p v)
               (apply
                p
                (vector-ref v 0)
                (vector-ref v 1)
                (vector-ref v 2)
                (vector-ref v 3)
                (vector-ref v 4)
                (vector-ref v 5)
                (vector-ref v 6)
                (vector-ref v 7)
                (vector-ref v 8)
                (vector-ref v 9)
                (do ((k r (- k 1))
                     (r
                      '()
                      (cons (vector-ref v (- k 1)) r)))
                    ((= k 10) r)))))))
      (lambda (r) (if (< r 10) (vector-ref em r) (it r)))))
  (define array:applier-to-actor
    (let ((em
           (vector
             (lambda (p a) (p))
             (lambda (p a) (p (array-ref a 0)))
             (lambda (p a)
               (p (array-ref a 0) (array-ref a 1)))
             (lambda (p a)
               (p
                (array-ref a 0)
                (array-ref a 1)
                (array-ref a 2)))
             (lambda (p a)
               (p
                (array-ref a 0)
                (array-ref a 1)
                (array-ref a 2)
                (array-ref a 3)))
             (lambda (p a)
               (p
                (array-ref a 0)
                (array-ref a 1)
                (array-ref a 2)
                (array-ref a 3)
                (array-ref a 4)))
             (lambda (p a)
               (p
                (array-ref a 0)
                (array-ref a 1)
                (array-ref a 2)
                (array-ref a 3)
                (array-ref a 4)
                (array-ref a 5)))
             (lambda (p a)
               (p
                (array-ref a 0)
                (array-ref a 1)
                (array-ref a 2)
                (array-ref a 3)
                (array-ref a 4)
                (array-ref a 5)
                (array-ref a 6)))
             (lambda (p a)
               (p
                (array-ref a 0)
                (array-ref a 1)
                (array-ref a 2)
                (array-ref a 3)
                (array-ref a 4)
                (array-ref a 5)
                (array-ref a 6)
                (array-ref a 7)))
             (lambda (p a)
               (p
                (array-ref a 0)
                (array-ref a 1)
                (array-ref a 2)
                (array-ref a 3)
                (array-ref a 4)
                (array-ref a 5)
                (array-ref a 6)
                (array-ref a 7)
                (array-ref a 8)))))
          (it
           (lambda (r)
             (lambda (p a)
               (apply
                a
                (array-ref a 0)
                (array-ref a 1)
                (array-ref a 2)
                (array-ref a 3)
                (array-ref a 4)
                (array-ref a 5)
                (array-ref a 6)
                (array-ref a 7)
                (array-ref a 8)
                (array-ref a 9)
                (do ((k r (- k 1))
                     (r '() (cons (array-ref a (- k 1)) r)))
                    ((= k 10) r)))))))
      (lambda (r)
        "These are high level, hiding implementation at call site."
        (if (< r 10) (vector-ref em r) (it r)))))
  (define array:applier-to-backing-vector
    (let ((em
           (vector
             (lambda (p ai av) (p))
             (lambda (p ai av)
               (p (vector-ref av (array:actor-index ai 0))))
             (lambda (p ai av)
               (p
                (vector-ref av (array:actor-index ai 0))
                (vector-ref av (array:actor-index ai 1))))
             (lambda (p ai av)
               (p
                (vector-ref av (array:actor-index ai 0))
                (vector-ref av (array:actor-index ai 1))
                (vector-ref av (array:actor-index ai 2))))
             (lambda (p ai av)
               (p
                (vector-ref av (array:actor-index ai 0))
                (vector-ref av (array:actor-index ai 1))
                (vector-ref av (array:actor-index ai 2))
                (vector-ref av (array:actor-index ai 3))))
             (lambda (p ai av)
               (p
                (vector-ref av (array:actor-index ai 0))
                (vector-ref av (array:actor-index ai 1))
                (vector-ref av (array:actor-index ai 2))
                (vector-ref av (array:actor-index ai 3))
                (vector-ref av (array:actor-index ai 4))))
             (lambda (p ai av)
               (p
                (vector-ref av (array:actor-index ai 0))
                (vector-ref av (array:actor-index ai 1))
                (vector-ref av (array:actor-index ai 2))
                (vector-ref av (array:actor-index ai 3))
                (vector-ref av (array:actor-index ai 4))
                (vector-ref av (array:actor-index ai 5))))
             (lambda (p ai av)
               (p
                (vector-ref av (array:actor-index ai 0))
                (vector-ref av (array:actor-index ai 1))
                (vector-ref av (array:actor-index ai 2))
                (vector-ref av (array:actor-index ai 3))
                (vector-ref av (array:actor-index ai 4))
                (vector-ref av (array:actor-index ai 5))
                (vector-ref av (array:actor-index ai 6))))
             (lambda (p ai av)
               (p
                (vector-ref av (array:actor-index ai 0))
                (vector-ref av (array:actor-index ai 1))
                (vector-ref av (array:actor-index ai 2))
                (vector-ref av (array:actor-index ai 3))
                (vector-ref av (array:actor-index ai 4))
                (vector-ref av (array:actor-index ai 5))
                (vector-ref av (array:actor-index ai 6))
                (vector-ref av (array:actor-index ai 7))))
             (lambda (p ai av)
               (p
                (vector-ref av (array:actor-index ai 0))
                (vector-ref av (array:actor-index ai 1))
                (vector-ref av (array:actor-index ai 2))
                (vector-ref av (array:actor-index ai 3))
                (vector-ref av (array:actor-index ai 4))
                (vector-ref av (array:actor-index ai 5))
                (vector-ref av (array:actor-index ai 6))
                (vector-ref av (array:actor-index ai 7))
                (vector-ref av (array:actor-index ai 8))))))
          (it
           (lambda (r)
             (lambda (p ai av)
               (apply
                p
                (vector-ref av (array:actor-index ai 0))
                (vector-ref av (array:actor-index ai 1))
                (vector-ref av (array:actor-index ai 2))
                (vector-ref av (array:actor-index ai 3))
                (vector-ref av (array:actor-index ai 4))
                (vector-ref av (array:actor-index ai 5))
                (vector-ref av (array:actor-index ai 6))
                (vector-ref av (array:actor-index ai 7))
                (vector-ref av (array:actor-index ai 8))
                (vector-ref av (array:actor-index ai 9))
                (do ((k r (- k 1))
                     (r
                      '()
                      (cons
                       (vector-ref
                         av
                         (array:actor-index ai (- k 1)))
                       r)))
                    ((= k 10) r)))))))
      (lambda (r)
        "These are low level, exposing implementation at call site."
        (if (< r 10) (vector-ref em r) (it r)))))
  (define (array:index/vector r x v)
    ((array:indexer/vector r) x v))
  (define (array:index/array r x av ai)
    ((array:indexer/array r) x av ai))
  (define (array:apply-to-vector r p v)
    ((array:applier-to-vector r) p v))
  (define (array:apply-to-actor r p a)
    ((array:applier-to-actor r) p a)))
