/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#ifndef UPM_SYSTEMIDLE_H
#define UPM_SYSTEMIDLE_H

#include <QObject>
#include <QTimer>

#include "common.h"

#define DEFAULE_SLEEP_DISPLAY_TIME      600
#define DEFAULE_SLEEP_COMPUTER_TIME     900

class UpmSystemIdle : public QObject
{
    Q_OBJECT
public:
    explicit UpmSystemIdle(QObject *parent = nullptr);

private:
    int m_turnoffDisplayAc;
    int m_turnoffDisplayBattery;
    int m_systemSuspendAc;
    int m_systemSuspendBattery;

    QTimer *m_turnOffDisplayTimer;
    QTimer *m_systemSuspendTimer;
    QTimer *m_reduceBrightnessTimer;

    int m_enterIdleTime = 60;

    void dealSystemStatusChanged(quint32);
    int getTurnOffDisplayTime();
    int getSystemSuspendTime();

private slots:
    void dealSystemIdleStatus(bool);
    void dealTurnOffDisplay();
    void dealSystemSuspend();
    void dealReduceBrightness();

    void stopTimer();

signals:
    void brightnessControlSignal(int);
};

#endif // UPM_SYSTEMIDLE_H
