// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SUB_4S_TRACE_AARCH64_H_
#define VIXL_SIM_SUB_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_sub_4S[] = {
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff00, 0xff808200, 0x007ffd00, 0xffffffff,
  0xff808100, 0x00007f00, 0x007ffcff, 0xfffffffe,
  0x00007e00, 0x00007eff, 0x007ffcfe, 0xffffffe0,
  0x00007dff, 0x00007efe, 0x007ffce0, 0xffffff83,
  0x00007dfe, 0x00007ee0, 0x007ffc83, 0xffffff82,
  0x00007de0, 0x00007e83, 0x007ffc82, 0xffffff81,
  0x00007d83, 0x00007e82, 0x007ffc81, 0xffff8003,
  0x00007d82, 0x00007e81, 0x007f7d03, 0xffff8002,
  0x00007d81, 0xffffff03, 0x007f7d02, 0xffff8001,
  0xfffffe03, 0xffffff02, 0x007f7d01, 0xcccccccd,
  0xfffffe02, 0xffffff01, 0xcd4cc9cd, 0xaaaaaaab,
  0xfffffe01, 0xcccd4bcd, 0xab2aa7ab, 0x80000003,
  0xcccd4acd, 0xaaab29ab, 0x807ffd03, 0x80000002,
  0xaaab28ab, 0x80007f03, 0x807ffd02, 0x80000001,
  0x80007e03, 0x80007f02, 0x807ffd01, 0x80000000,
  0x80007e02, 0x80007f01, 0x807ffd00, 0x7fffffff,
  0x80007e01, 0x80007f00, 0x807ffcff, 0x55555556,
  0x80007e00, 0x80007eff, 0x55d55256, 0x33333334,
  0x80007dff, 0x5555d456, 0x33b33034, 0x00008000,
  0x5555d356, 0x3333b234, 0x00807d00, 0x00007fff,
  0x3333b134, 0x0000ff00, 0x00807cff, 0x00007ffe,
  0x0000fe00, 0x0000feff, 0x00807cfe, 0x00007ffd,
  0x0000fdff, 0x0000fefe, 0x00807cfd, 0x00000080,
  0x0000fdfe, 0x0000fefd, 0x007ffd80, 0x0000007f,
  0x0000fdfd, 0x00007f80, 0x007ffd7f, 0x0000007e,
  0x00007e80, 0x00007f7f, 0x007ffd7e, 0x0000007d,
  0x00007e7f, 0x00007f7e, 0x007ffd7d, 0x00000020,
  0x00007e7e, 0x00007f7d, 0x007ffd20, 0x00000003,
  0x00007e7d, 0x00007f20, 0x007ffd03, 0x00000002,
  0x00007e20, 0x00007f03, 0x007ffd02, 0x00000001,
  0x00007f03, 0x007ffd02, 0x00000001, 0x00000001,
  0x00007f02, 0x007ffd01, 0x00000000, 0x00000000,
  0x00007f01, 0x007ffd00, 0xffffffff, 0xffffffff,
  0x00007f00, 0x007ffcff, 0xfffffffe, 0xffffffe1,
  0x00007eff, 0x007ffcfe, 0xffffffe0, 0xffffff84,
  0x00007efe, 0x007ffce0, 0xffffff83, 0xffffff83,
  0x00007ee0, 0x007ffc83, 0xffffff82, 0xffffff82,
  0x00007e83, 0x007ffc82, 0xffffff81, 0xffff8004,
  0x00007e82, 0x007ffc81, 0xffff8003, 0xffff8003,
  0x00007e81, 0x007f7d03, 0xffff8002, 0xffff8002,
  0xffffff03, 0x007f7d02, 0xffff8001, 0xccccccce,
  0xffffff02, 0x007f7d01, 0xcccccccd, 0xaaaaaaac,
  0xffffff01, 0xcd4cc9cd, 0xaaaaaaab, 0x80000004,
  0xcccd4bcd, 0xab2aa7ab, 0x80000003, 0x80000003,
  0xaaab29ab, 0x807ffd03, 0x80000002, 0x80000002,
  0x80007f03, 0x807ffd02, 0x80000001, 0x80000001,
  0x80007f02, 0x807ffd01, 0x80000000, 0x80000000,
  0x80007f01, 0x807ffd00, 0x7fffffff, 0x55555557,
  0x80007f00, 0x807ffcff, 0x55555556, 0x33333335,
  0x80007eff, 0x55d55256, 0x33333334, 0x00008001,
  0x5555d456, 0x33b33034, 0x00008000, 0x00008000,
  0x3333b234, 0x00807d00, 0x00007fff, 0x00007fff,
  0x0000ff00, 0x00807cff, 0x00007ffe, 0x00007ffe,
  0x0000feff, 0x00807cfe, 0x00007ffd, 0x00000081,
  0x0000fefe, 0x00807cfd, 0x00000080, 0x00000080,
  0x0000fefd, 0x007ffd80, 0x0000007f, 0x0000007f,
  0x00007f80, 0x007ffd7f, 0x0000007e, 0x0000007e,
  0x00007f7f, 0x007ffd7e, 0x0000007d, 0x00000021,
  0x00007f7e, 0x007ffd7d, 0x00000020, 0x00000004,
  0x00007f7d, 0x007ffd20, 0x00000003, 0x00000003,
  0x00007f20, 0x007ffd03, 0x00000002, 0x00000002,
  0x007ffd03, 0x00000002, 0x00000002, 0x00000002,
  0x007ffd02, 0x00000001, 0x00000001, 0x00000001,
  0x007ffd01, 0x00000000, 0x00000000, 0x00000000,
  0x007ffd00, 0xffffffff, 0xffffffff, 0xffffffe2,
  0x007ffcff, 0xfffffffe, 0xffffffe1, 0xffffff85,
  0x007ffcfe, 0xffffffe0, 0xffffff84, 0xffffff84,
  0x007ffce0, 0xffffff83, 0xffffff83, 0xffffff83,
  0x007ffc83, 0xffffff82, 0xffffff82, 0xffff8005,
  0x007ffc82, 0xffffff81, 0xffff8004, 0xffff8004,
  0x007ffc81, 0xffff8003, 0xffff8003, 0xffff8003,
  0x007f7d03, 0xffff8002, 0xffff8002, 0xcccccccf,
  0x007f7d02, 0xffff8001, 0xccccccce, 0xaaaaaaad,
  0x007f7d01, 0xcccccccd, 0xaaaaaaac, 0x80000005,
  0xcd4cc9cd, 0xaaaaaaab, 0x80000004, 0x80000004,
  0xab2aa7ab, 0x80000003, 0x80000003, 0x80000003,
  0x807ffd03, 0x80000002, 0x80000002, 0x80000002,
  0x807ffd02, 0x80000001, 0x80000001, 0x80000001,
  0x807ffd01, 0x80000000, 0x80000000, 0x55555558,
  0x807ffd00, 0x7fffffff, 0x55555557, 0x33333336,
  0x807ffcff, 0x55555556, 0x33333335, 0x00008002,
  0x55d55256, 0x33333334, 0x00008001, 0x00008001,
  0x33b33034, 0x00008000, 0x00008000, 0x00008000,
  0x00807d00, 0x00007fff, 0x00007fff, 0x00007fff,
  0x00807cff, 0x00007ffe, 0x00007ffe, 0x00000082,
  0x00807cfe, 0x00007ffd, 0x00000081, 0x00000081,
  0x00807cfd, 0x00000080, 0x00000080, 0x00000080,
  0x007ffd80, 0x0000007f, 0x0000007f, 0x0000007f,
  0x007ffd7f, 0x0000007e, 0x0000007e, 0x00000022,
  0x007ffd7e, 0x0000007d, 0x00000021, 0x00000005,
  0x007ffd7d, 0x00000020, 0x00000004, 0x00000004,
  0x007ffd20, 0x00000003, 0x00000003, 0x00000003,
  0x00000003, 0x00000003, 0x00000003, 0x00000020,
  0x00000002, 0x00000002, 0x00000002, 0x0000001f,
  0x00000001, 0x00000001, 0x00000001, 0x0000001e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xffffffe2, 0xffffffa3,
  0xfffffffe, 0xffffffe1, 0xffffff85, 0xffffffa2,
  0xffffffe0, 0xffffff84, 0xffffff84, 0xffffffa1,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffff8023,
  0xffffff82, 0xffffff82, 0xffff8005, 0xffff8022,
  0xffffff81, 0xffff8004, 0xffff8004, 0xffff8021,
  0xffff8003, 0xffff8003, 0xffff8003, 0xcccccced,
  0xffff8002, 0xffff8002, 0xcccccccf, 0xaaaaaacb,
  0xffff8001, 0xccccccce, 0xaaaaaaad, 0x80000023,
  0xcccccccd, 0xaaaaaaac, 0x80000005, 0x80000022,
  0xaaaaaaab, 0x80000004, 0x80000004, 0x80000021,
  0x80000003, 0x80000003, 0x80000003, 0x80000020,
  0x80000002, 0x80000002, 0x80000002, 0x8000001f,
  0x80000001, 0x80000001, 0x80000001, 0x55555576,
  0x80000000, 0x80000000, 0x55555558, 0x33333354,
  0x7fffffff, 0x55555557, 0x33333336, 0x00008020,
  0x55555556, 0x33333335, 0x00008002, 0x0000801f,
  0x33333334, 0x00008001, 0x00008001, 0x0000801e,
  0x00008000, 0x00008000, 0x00008000, 0x0000801d,
  0x00007fff, 0x00007fff, 0x00007fff, 0x000000a0,
  0x00007ffe, 0x00007ffe, 0x00000082, 0x0000009f,
  0x00007ffd, 0x00000081, 0x00000081, 0x0000009e,
  0x00000080, 0x00000080, 0x00000080, 0x0000009d,
  0x0000007f, 0x0000007f, 0x0000007f, 0x00000040,
  0x0000007e, 0x0000007e, 0x00000022, 0x00000023,
  0x0000007d, 0x00000021, 0x00000005, 0x00000022,
  0x00000020, 0x00000004, 0x00000004, 0x00000021,
  0x00000004, 0x00000004, 0x00000021, 0x0000007d,
  0x00000003, 0x00000003, 0x00000020, 0x0000007c,
  0x00000002, 0x00000002, 0x0000001f, 0x0000007b,
  0x00000001, 0x00000001, 0x0000001e, 0x0000005d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffe2, 0xffffffa3, 0xffffffff,
  0xffffffe1, 0xffffff85, 0xffffffa2, 0xfffffffe,
  0xffffff84, 0xffffff84, 0xffffffa1, 0xffff8080,
  0xffffff83, 0xffffff83, 0xffff8023, 0xffff807f,
  0xffffff82, 0xffff8005, 0xffff8022, 0xffff807e,
  0xffff8004, 0xffff8004, 0xffff8021, 0xcccccd4a,
  0xffff8003, 0xffff8003, 0xcccccced, 0xaaaaab28,
  0xffff8002, 0xcccccccf, 0xaaaaaacb, 0x80000080,
  0xccccccce, 0xaaaaaaad, 0x80000023, 0x8000007f,
  0xaaaaaaac, 0x80000005, 0x80000022, 0x8000007e,
  0x80000004, 0x80000004, 0x80000021, 0x8000007d,
  0x80000003, 0x80000003, 0x80000020, 0x8000007c,
  0x80000002, 0x80000002, 0x8000001f, 0x555555d3,
  0x80000001, 0x80000001, 0x55555576, 0x333333b1,
  0x80000000, 0x55555558, 0x33333354, 0x0000807d,
  0x55555557, 0x33333336, 0x00008020, 0x0000807c,
  0x33333335, 0x00008002, 0x0000801f, 0x0000807b,
  0x00008001, 0x00008001, 0x0000801e, 0x0000807a,
  0x00008000, 0x00008000, 0x0000801d, 0x000000fd,
  0x00007fff, 0x00007fff, 0x000000a0, 0x000000fc,
  0x00007ffe, 0x00000082, 0x0000009f, 0x000000fb,
  0x00000081, 0x00000081, 0x0000009e, 0x000000fa,
  0x00000080, 0x00000080, 0x0000009d, 0x0000009d,
  0x0000007f, 0x0000007f, 0x00000040, 0x00000080,
  0x0000007e, 0x00000022, 0x00000023, 0x0000007f,
  0x00000021, 0x00000005, 0x00000022, 0x0000007e,
  0x00000005, 0x00000022, 0x0000007e, 0x0000007e,
  0x00000004, 0x00000021, 0x0000007d, 0x0000007d,
  0x00000003, 0x00000020, 0x0000007c, 0x0000007c,
  0x00000002, 0x0000001f, 0x0000007b, 0x0000005e,
  0x00000001, 0x0000001e, 0x0000005d, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffe2, 0xffffffa3, 0xffffffff, 0xffffffff,
  0xffffff85, 0xffffffa2, 0xfffffffe, 0xffff8081,
  0xffffff84, 0xffffffa1, 0xffff8080, 0xffff8080,
  0xffffff83, 0xffff8023, 0xffff807f, 0xffff807f,
  0xffff8005, 0xffff8022, 0xffff807e, 0xcccccd4b,
  0xffff8004, 0xffff8021, 0xcccccd4a, 0xaaaaab29,
  0xffff8003, 0xcccccced, 0xaaaaab28, 0x80000081,
  0xcccccccf, 0xaaaaaacb, 0x80000080, 0x80000080,
  0xaaaaaaad, 0x80000023, 0x8000007f, 0x8000007f,
  0x80000005, 0x80000022, 0x8000007e, 0x8000007e,
  0x80000004, 0x80000021, 0x8000007d, 0x8000007d,
  0x80000003, 0x80000020, 0x8000007c, 0x555555d4,
  0x80000002, 0x8000001f, 0x555555d3, 0x333333b2,
  0x80000001, 0x55555576, 0x333333b1, 0x0000807e,
  0x55555558, 0x33333354, 0x0000807d, 0x0000807d,
  0x33333336, 0x00008020, 0x0000807c, 0x0000807c,
  0x00008002, 0x0000801f, 0x0000807b, 0x0000807b,
  0x00008001, 0x0000801e, 0x0000807a, 0x000000fe,
  0x00008000, 0x0000801d, 0x000000fd, 0x000000fd,
  0x00007fff, 0x000000a0, 0x000000fc, 0x000000fc,
  0x00000082, 0x0000009f, 0x000000fb, 0x000000fb,
  0x00000081, 0x0000009e, 0x000000fa, 0x0000009e,
  0x00000080, 0x0000009d, 0x0000009d, 0x00000081,
  0x0000007f, 0x00000040, 0x00000080, 0x00000080,
  0x00000022, 0x00000023, 0x0000007f, 0x0000007f,
  0x00000023, 0x0000007f, 0x0000007f, 0x0000007f,
  0x00000022, 0x0000007e, 0x0000007e, 0x0000007e,
  0x00000021, 0x0000007d, 0x0000007d, 0x0000007d,
  0x00000020, 0x0000007c, 0x0000007c, 0x0000005f,
  0x0000001f, 0x0000007b, 0x0000005e, 0x00000002,
  0x0000001e, 0x0000005d, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffa3, 0xffffffff, 0xffffffff, 0xffff8082,
  0xffffffa2, 0xfffffffe, 0xffff8081, 0xffff8081,
  0xffffffa1, 0xffff8080, 0xffff8080, 0xffff8080,
  0xffff8023, 0xffff807f, 0xffff807f, 0xcccccd4c,
  0xffff8022, 0xffff807e, 0xcccccd4b, 0xaaaaab2a,
  0xffff8021, 0xcccccd4a, 0xaaaaab29, 0x80000082,
  0xcccccced, 0xaaaaab28, 0x80000081, 0x80000081,
  0xaaaaaacb, 0x80000080, 0x80000080, 0x80000080,
  0x80000023, 0x8000007f, 0x8000007f, 0x8000007f,
  0x80000022, 0x8000007e, 0x8000007e, 0x8000007e,
  0x80000021, 0x8000007d, 0x8000007d, 0x555555d5,
  0x80000020, 0x8000007c, 0x555555d4, 0x333333b3,
  0x8000001f, 0x555555d3, 0x333333b2, 0x0000807f,
  0x55555576, 0x333333b1, 0x0000807e, 0x0000807e,
  0x33333354, 0x0000807d, 0x0000807d, 0x0000807d,
  0x00008020, 0x0000807c, 0x0000807c, 0x0000807c,
  0x0000801f, 0x0000807b, 0x0000807b, 0x000000ff,
  0x0000801e, 0x0000807a, 0x000000fe, 0x000000fe,
  0x0000801d, 0x000000fd, 0x000000fd, 0x000000fd,
  0x000000a0, 0x000000fc, 0x000000fc, 0x000000fc,
  0x0000009f, 0x000000fb, 0x000000fb, 0x0000009f,
  0x0000009e, 0x000000fa, 0x0000009e, 0x00000082,
  0x0000009d, 0x0000009d, 0x00000081, 0x00000081,
  0x00000040, 0x00000080, 0x00000080, 0x00000080,
  0x00000080, 0x00000080, 0x00000080, 0x00007ffd,
  0x0000007f, 0x0000007f, 0x0000007f, 0x00007ffc,
  0x0000007e, 0x0000007e, 0x0000007e, 0x00007ffb,
  0x0000007d, 0x0000007d, 0x0000007d, 0x00007fdd,
  0x0000007c, 0x0000007c, 0x0000005f, 0x00007f80,
  0x0000007b, 0x0000005e, 0x00000002, 0x00007f7f,
  0x0000005d, 0x00000001, 0x00000001, 0x00007f7e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xffff8082, 0xffffffff,
  0xfffffffe, 0xffff8081, 0xffff8081, 0xfffffffe,
  0xffff8080, 0xffff8080, 0xffff8080, 0xcccd4cca,
  0xffff807f, 0xffff807f, 0xcccccd4c, 0xaaab2aa8,
  0xffff807e, 0xcccccd4b, 0xaaaaab2a, 0x80008000,
  0xcccccd4a, 0xaaaaab29, 0x80000082, 0x80007fff,
  0xaaaaab28, 0x80000081, 0x80000081, 0x80007ffe,
  0x80000080, 0x80000080, 0x80000080, 0x80007ffd,
  0x8000007f, 0x8000007f, 0x8000007f, 0x80007ffc,
  0x8000007e, 0x8000007e, 0x8000007e, 0x5555d553,
  0x8000007d, 0x8000007d, 0x555555d5, 0x3333b331,
  0x8000007c, 0x555555d4, 0x333333b3, 0x0000fffd,
  0x555555d3, 0x333333b2, 0x0000807f, 0x0000fffc,
  0x333333b1, 0x0000807e, 0x0000807e, 0x0000fffb,
  0x0000807d, 0x0000807d, 0x0000807d, 0x0000fffa,
  0x0000807c, 0x0000807c, 0x0000807c, 0x0000807d,
  0x0000807b, 0x0000807b, 0x000000ff, 0x0000807c,
  0x0000807a, 0x000000fe, 0x000000fe, 0x0000807b,
  0x000000fd, 0x000000fd, 0x000000fd, 0x0000807a,
  0x000000fc, 0x000000fc, 0x000000fc, 0x0000801d,
  0x000000fb, 0x000000fb, 0x0000009f, 0x00008000,
  0x000000fa, 0x0000009e, 0x00000082, 0x00007fff,
  0x0000009d, 0x00000081, 0x00000081, 0x00007ffe,
  0x00000081, 0x00000081, 0x00007ffe, 0x00007ffe,
  0x00000080, 0x00000080, 0x00007ffd, 0x00007ffd,
  0x0000007f, 0x0000007f, 0x00007ffc, 0x00007ffc,
  0x0000007e, 0x0000007e, 0x00007ffb, 0x00007fde,
  0x0000007d, 0x0000007d, 0x00007fdd, 0x00007f81,
  0x0000007c, 0x0000005f, 0x00007f80, 0x00007f80,
  0x0000005e, 0x00000002, 0x00007f7f, 0x00007f7f,
  0x00000001, 0x00000001, 0x00007f7e, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffff8082, 0xffffffff, 0xffffffff,
  0xffff8081, 0xffff8081, 0xfffffffe, 0xcccd4ccb,
  0xffff8080, 0xffff8080, 0xcccd4cca, 0xaaab2aa9,
  0xffff807f, 0xcccccd4c, 0xaaab2aa8, 0x80008001,
  0xcccccd4b, 0xaaaaab2a, 0x80008000, 0x80008000,
  0xaaaaab29, 0x80000082, 0x80007fff, 0x80007fff,
  0x80000081, 0x80000081, 0x80007ffe, 0x80007ffe,
  0x80000080, 0x80000080, 0x80007ffd, 0x80007ffd,
  0x8000007f, 0x8000007f, 0x80007ffc, 0x5555d554,
  0x8000007e, 0x8000007e, 0x5555d553, 0x3333b332,
  0x8000007d, 0x555555d5, 0x3333b331, 0x0000fffe,
  0x555555d4, 0x333333b3, 0x0000fffd, 0x0000fffd,
  0x333333b2, 0x0000807f, 0x0000fffc, 0x0000fffc,
  0x0000807e, 0x0000807e, 0x0000fffb, 0x0000fffb,
  0x0000807d, 0x0000807d, 0x0000fffa, 0x0000807e,
  0x0000807c, 0x0000807c, 0x0000807d, 0x0000807d,
  0x0000807b, 0x000000ff, 0x0000807c, 0x0000807c,
  0x000000fe, 0x000000fe, 0x0000807b, 0x0000807b,
  0x000000fd, 0x000000fd, 0x0000807a, 0x0000801e,
  0x000000fc, 0x000000fc, 0x0000801d, 0x00008001,
  0x000000fb, 0x0000009f, 0x00008000, 0x00008000,
  0x0000009e, 0x00000082, 0x00007fff, 0x00007fff,
  0x00000082, 0x00007fff, 0x00007fff, 0x00007fff,
  0x00000081, 0x00007ffe, 0x00007ffe, 0x00007ffe,
  0x00000080, 0x00007ffd, 0x00007ffd, 0x00007ffd,
  0x0000007f, 0x00007ffc, 0x00007ffc, 0x00007fdf,
  0x0000007e, 0x00007ffb, 0x00007fde, 0x00007f82,
  0x0000007d, 0x00007fdd, 0x00007f81, 0x00007f81,
  0x0000005f, 0x00007f80, 0x00007f80, 0x00007f80,
  0x00000002, 0x00007f7f, 0x00007f7f, 0x00000002,
  0x00000001, 0x00007f7e, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff8082, 0xffffffff, 0xffffffff, 0xcccd4ccc,
  0xffff8081, 0xfffffffe, 0xcccd4ccb, 0xaaab2aaa,
  0xffff8080, 0xcccd4cca, 0xaaab2aa9, 0x80008002,
  0xcccccd4c, 0xaaab2aa8, 0x80008001, 0x80008001,
  0xaaaaab2a, 0x80008000, 0x80008000, 0x80008000,
  0x80000082, 0x80007fff, 0x80007fff, 0x80007fff,
  0x80000081, 0x80007ffe, 0x80007ffe, 0x80007ffe,
  0x80000080, 0x80007ffd, 0x80007ffd, 0x5555d555,
  0x8000007f, 0x80007ffc, 0x5555d554, 0x3333b333,
  0x8000007e, 0x5555d553, 0x3333b332, 0x0000ffff,
  0x555555d5, 0x3333b331, 0x0000fffe, 0x0000fffe,
  0x333333b3, 0x0000fffd, 0x0000fffd, 0x0000fffd,
  0x0000807f, 0x0000fffc, 0x0000fffc, 0x0000fffc,
  0x0000807e, 0x0000fffb, 0x0000fffb, 0x0000807f,
  0x0000807d, 0x0000fffa, 0x0000807e, 0x0000807e,
  0x0000807c, 0x0000807d, 0x0000807d, 0x0000807d,
  0x000000ff, 0x0000807c, 0x0000807c, 0x0000807c,
  0x000000fe, 0x0000807b, 0x0000807b, 0x0000801f,
  0x000000fd, 0x0000807a, 0x0000801e, 0x00008002,
  0x000000fc, 0x0000801d, 0x00008001, 0x00008001,
  0x0000009f, 0x00008000, 0x00008000, 0x00008000,
  0x00008000, 0x00008000, 0x00008000, 0x33333333,
  0x00007fff, 0x00007fff, 0x00007fff, 0x33333332,
  0x00007ffe, 0x00007ffe, 0x00007ffe, 0x33333331,
  0x00007ffd, 0x00007ffd, 0x00007ffd, 0x33333313,
  0x00007ffc, 0x00007ffc, 0x00007fdf, 0x333332b6,
  0x00007ffb, 0x00007fde, 0x00007f82, 0x333332b5,
  0x00007fdd, 0x00007f81, 0x00007f81, 0x333332b4,
  0x00007f80, 0x00007f80, 0x00007f80, 0x3332b336,
  0x00007f7f, 0x00007f7f, 0x00000002, 0x3332b335,
  0x00007f7e, 0x00000001, 0x00000001, 0x3332b334,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xcccd4ccc, 0xddddddde,
  0xfffffffe, 0xcccd4ccb, 0xaaab2aaa, 0xb3333336,
  0xcccd4cca, 0xaaab2aa9, 0x80008002, 0xb3333335,
  0xaaab2aa8, 0x80008001, 0x80008001, 0xb3333334,
  0x80008000, 0x80008000, 0x80008000, 0xb3333333,
  0x80007fff, 0x80007fff, 0x80007fff, 0xb3333332,
  0x80007ffe, 0x80007ffe, 0x80007ffe, 0x88888889,
  0x80007ffd, 0x80007ffd, 0x5555d555, 0x66666667,
  0x80007ffc, 0x5555d554, 0x3333b333, 0x3333b333,
  0x5555d553, 0x3333b332, 0x0000ffff, 0x3333b332,
  0x3333b331, 0x0000fffe, 0x0000fffe, 0x3333b331,
  0x0000fffd, 0x0000fffd, 0x0000fffd, 0x3333b330,
  0x0000fffc, 0x0000fffc, 0x0000fffc, 0x333333b3,
  0x0000fffb, 0x0000fffb, 0x0000807f, 0x333333b2,
  0x0000fffa, 0x0000807e, 0x0000807e, 0x333333b1,
  0x0000807d, 0x0000807d, 0x0000807d, 0x333333b0,
  0x0000807c, 0x0000807c, 0x0000807c, 0x33333353,
  0x0000807b, 0x0000807b, 0x0000801f, 0x33333336,
  0x0000807a, 0x0000801e, 0x00008002, 0x33333335,
  0x0000801d, 0x00008001, 0x00008001, 0x33333334,
  0x00008001, 0x00008001, 0x33333334, 0x55555555,
  0x00008000, 0x00008000, 0x33333333, 0x55555554,
  0x00007fff, 0x00007fff, 0x33333332, 0x55555553,
  0x00007ffe, 0x00007ffe, 0x33333331, 0x55555535,
  0x00007ffd, 0x00007ffd, 0x33333313, 0x555554d8,
  0x00007ffc, 0x00007fdf, 0x333332b6, 0x555554d7,
  0x00007fde, 0x00007f82, 0x333332b5, 0x555554d6,
  0x00007f81, 0x00007f81, 0x333332b4, 0x5554d558,
  0x00007f80, 0x00007f80, 0x3332b336, 0x5554d557,
  0x00007f7f, 0x00000002, 0x3332b335, 0x5554d556,
  0x00000001, 0x00000001, 0x3332b334, 0x22222222,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xcccd4ccc, 0xddddddde, 0xd5555558,
  0xcccd4ccb, 0xaaab2aaa, 0xb3333336, 0xd5555557,
  0xaaab2aa9, 0x80008002, 0xb3333335, 0xd5555556,
  0x80008001, 0x80008001, 0xb3333334, 0xd5555555,
  0x80008000, 0x80008000, 0xb3333333, 0xd5555554,
  0x80007fff, 0x80007fff, 0xb3333332, 0xaaaaaaab,
  0x80007ffe, 0x80007ffe, 0x88888889, 0x88888889,
  0x80007ffd, 0x5555d555, 0x66666667, 0x5555d555,
  0x5555d554, 0x3333b333, 0x3333b333, 0x5555d554,
  0x3333b332, 0x0000ffff, 0x3333b332, 0x5555d553,
  0x0000fffe, 0x0000fffe, 0x3333b331, 0x5555d552,
  0x0000fffd, 0x0000fffd, 0x3333b330, 0x555555d5,
  0x0000fffc, 0x0000fffc, 0x333333b3, 0x555555d4,
  0x0000fffb, 0x0000807f, 0x333333b2, 0x555555d3,
  0x0000807e, 0x0000807e, 0x333333b1, 0x555555d2,
  0x0000807d, 0x0000807d, 0x333333b0, 0x55555575,
  0x0000807c, 0x0000807c, 0x33333353, 0x55555558,
  0x0000807b, 0x0000801f, 0x33333336, 0x55555557,
  0x0000801e, 0x00008002, 0x33333335, 0x55555556,
  0x00008002, 0x33333335, 0x55555556, 0x7ffffffd,
  0x00008001, 0x33333334, 0x55555555, 0x7ffffffc,
  0x00008000, 0x33333333, 0x55555554, 0x7ffffffb,
  0x00007fff, 0x33333332, 0x55555553, 0x7fffffdd,
  0x00007ffe, 0x33333331, 0x55555535, 0x7fffff80,
  0x00007ffd, 0x33333313, 0x555554d8, 0x7fffff7f,
  0x00007fdf, 0x333332b6, 0x555554d7, 0x7fffff7e,
  0x00007f82, 0x333332b5, 0x555554d6, 0x7fff8000,
  0x00007f81, 0x333332b4, 0x5554d558, 0x7fff7fff,
  0x00007f80, 0x3332b336, 0x5554d557, 0x7fff7ffe,
  0x00000002, 0x3332b335, 0x5554d556, 0x4cccccca,
  0x00000001, 0x3332b334, 0x22222222, 0x2aaaaaa8,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xcccd4ccc, 0xddddddde, 0xd5555558, 0xffffffff,
  0xaaab2aaa, 0xb3333336, 0xd5555557, 0xfffffffe,
  0x80008002, 0xb3333335, 0xd5555556, 0xfffffffd,
  0x80008001, 0xb3333334, 0xd5555555, 0xfffffffc,
  0x80008000, 0xb3333333, 0xd5555554, 0xd5555553,
  0x80007fff, 0xb3333332, 0xaaaaaaab, 0xb3333331,
  0x80007ffe, 0x88888889, 0x88888889, 0x80007ffd,
  0x5555d555, 0x66666667, 0x5555d555, 0x80007ffc,
  0x3333b333, 0x3333b333, 0x5555d554, 0x80007ffb,
  0x0000ffff, 0x3333b332, 0x5555d553, 0x80007ffa,
  0x0000fffe, 0x3333b331, 0x5555d552, 0x8000007d,
  0x0000fffd, 0x3333b330, 0x555555d5, 0x8000007c,
  0x0000fffc, 0x333333b3, 0x555555d4, 0x8000007b,
  0x0000807f, 0x333333b2, 0x555555d3, 0x8000007a,
  0x0000807e, 0x333333b1, 0x555555d2, 0x8000001d,
  0x0000807d, 0x333333b0, 0x55555575, 0x80000000,
  0x0000807c, 0x33333353, 0x55555558, 0x7fffffff,
  0x0000801f, 0x33333336, 0x55555557, 0x7ffffffe,
  0x33333336, 0x55555557, 0x7ffffffe, 0x7ffffffe,
  0x33333335, 0x55555556, 0x7ffffffd, 0x7ffffffd,
  0x33333334, 0x55555555, 0x7ffffffc, 0x7ffffffc,
  0x33333333, 0x55555554, 0x7ffffffb, 0x7fffffde,
  0x33333332, 0x55555553, 0x7fffffdd, 0x7fffff81,
  0x33333331, 0x55555535, 0x7fffff80, 0x7fffff80,
  0x33333313, 0x555554d8, 0x7fffff7f, 0x7fffff7f,
  0x333332b6, 0x555554d7, 0x7fffff7e, 0x7fff8001,
  0x333332b5, 0x555554d6, 0x7fff8000, 0x7fff8000,
  0x333332b4, 0x5554d558, 0x7fff7fff, 0x7fff7fff,
  0x3332b336, 0x5554d557, 0x7fff7ffe, 0x4ccccccb,
  0x3332b335, 0x5554d556, 0x4cccccca, 0x2aaaaaa9,
  0x3332b334, 0x22222222, 0x2aaaaaa8, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xddddddde, 0xd5555558, 0xffffffff, 0xffffffff,
  0xb3333336, 0xd5555557, 0xfffffffe, 0xfffffffe,
  0xb3333335, 0xd5555556, 0xfffffffd, 0xfffffffd,
  0xb3333334, 0xd5555555, 0xfffffffc, 0xd5555554,
  0xb3333333, 0xd5555554, 0xd5555553, 0xb3333332,
  0xb3333332, 0xaaaaaaab, 0xb3333331, 0x80007ffe,
  0x88888889, 0x88888889, 0x80007ffd, 0x80007ffd,
  0x66666667, 0x5555d555, 0x80007ffc, 0x80007ffc,
  0x3333b333, 0x5555d554, 0x80007ffb, 0x80007ffb,
  0x3333b332, 0x5555d553, 0x80007ffa, 0x8000007e,
  0x3333b331, 0x5555d552, 0x8000007d, 0x8000007d,
  0x3333b330, 0x555555d5, 0x8000007c, 0x8000007c,
  0x333333b3, 0x555555d4, 0x8000007b, 0x8000007b,
  0x333333b2, 0x555555d3, 0x8000007a, 0x8000001e,
  0x333333b1, 0x555555d2, 0x8000001d, 0x80000001,
  0x333333b0, 0x55555575, 0x80000000, 0x80000000,
  0x33333353, 0x55555558, 0x7fffffff, 0x7fffffff,
  0x55555558, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x55555557, 0x7ffffffe, 0x7ffffffe, 0x7ffffffe,
  0x55555556, 0x7ffffffd, 0x7ffffffd, 0x7ffffffd,
  0x55555555, 0x7ffffffc, 0x7ffffffc, 0x7fffffdf,
  0x55555554, 0x7ffffffb, 0x7fffffde, 0x7fffff82,
  0x55555553, 0x7fffffdd, 0x7fffff81, 0x7fffff81,
  0x55555535, 0x7fffff80, 0x7fffff80, 0x7fffff80,
  0x555554d8, 0x7fffff7f, 0x7fffff7f, 0x7fff8002,
  0x555554d7, 0x7fffff7e, 0x7fff8001, 0x7fff8001,
  0x555554d6, 0x7fff8000, 0x7fff8000, 0x7fff8000,
  0x5554d558, 0x7fff7fff, 0x7fff7fff, 0x4ccccccc,
  0x5554d557, 0x7fff7ffe, 0x4ccccccb, 0x2aaaaaaa,
  0x5554d556, 0x4cccccca, 0x2aaaaaa9, 0x00000002,
  0x22222222, 0x2aaaaaa8, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xd5555558, 0xffffffff, 0xffffffff, 0xffffffff,
  0xd5555557, 0xfffffffe, 0xfffffffe, 0xfffffffe,
  0xd5555556, 0xfffffffd, 0xfffffffd, 0xd5555555,
  0xd5555555, 0xfffffffc, 0xd5555554, 0xb3333333,
  0xd5555554, 0xd5555553, 0xb3333332, 0x80007fff,
  0xaaaaaaab, 0xb3333331, 0x80007ffe, 0x80007ffe,
  0x88888889, 0x80007ffd, 0x80007ffd, 0x80007ffd,
  0x5555d555, 0x80007ffc, 0x80007ffc, 0x80007ffc,
  0x5555d554, 0x80007ffb, 0x80007ffb, 0x8000007f,
  0x5555d553, 0x80007ffa, 0x8000007e, 0x8000007e,
  0x5555d552, 0x8000007d, 0x8000007d, 0x8000007d,
  0x555555d5, 0x8000007c, 0x8000007c, 0x8000007c,
  0x555555d4, 0x8000007b, 0x8000007b, 0x8000001f,
  0x555555d3, 0x8000007a, 0x8000001e, 0x80000002,
  0x555555d2, 0x8000001d, 0x80000001, 0x80000001,
  0x55555575, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7ffffffe, 0x7ffffffe, 0x7ffffffe, 0x7ffffffe,
  0x7ffffffd, 0x7ffffffd, 0x7ffffffd, 0x7fffffe0,
  0x7ffffffc, 0x7ffffffc, 0x7fffffdf, 0x7fffff83,
  0x7ffffffb, 0x7fffffde, 0x7fffff82, 0x7fffff82,
  0x7fffffdd, 0x7fffff81, 0x7fffff81, 0x7fffff81,
  0x7fffff80, 0x7fffff80, 0x7fffff80, 0x7fff8003,
  0x7fffff7f, 0x7fffff7f, 0x7fff8002, 0x7fff8002,
  0x7fffff7e, 0x7fff8001, 0x7fff8001, 0x7fff8001,
  0x7fff8000, 0x7fff8000, 0x7fff8000, 0x4ccccccd,
  0x7fff7fff, 0x7fff7fff, 0x4ccccccc, 0x2aaaaaab,
  0x7fff7ffe, 0x4ccccccb, 0x2aaaaaaa, 0x00000003,
  0x4cccccca, 0x2aaaaaa9, 0x00000002, 0x00000002,
  0x2aaaaaa8, 0x00000001, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffffe, 0xfffffffe, 0xfffffffe, 0xd5555556,
  0xfffffffd, 0xfffffffd, 0xd5555555, 0xb3333334,
  0xfffffffc, 0xd5555554, 0xb3333333, 0x80008000,
  0xd5555553, 0xb3333332, 0x80007fff, 0x80007fff,
  0xb3333331, 0x80007ffe, 0x80007ffe, 0x80007ffe,
  0x80007ffd, 0x80007ffd, 0x80007ffd, 0x80007ffd,
  0x80007ffc, 0x80007ffc, 0x80007ffc, 0x80000080,
  0x80007ffb, 0x80007ffb, 0x8000007f, 0x8000007f,
  0x80007ffa, 0x8000007e, 0x8000007e, 0x8000007e,
  0x8000007d, 0x8000007d, 0x8000007d, 0x8000007d,
  0x8000007c, 0x8000007c, 0x8000007c, 0x80000020,
  0x8000007b, 0x8000007b, 0x8000001f, 0x80000003,
  0x8000007a, 0x8000001e, 0x80000002, 0x80000002,
  0x8000001d, 0x80000001, 0x80000001, 0x80000001,
  0x80000001, 0x80000001, 0x80000001, 0x80000001,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7ffffffe, 0x7ffffffe, 0x7ffffffe, 0x7fffffe1,
  0x7ffffffd, 0x7ffffffd, 0x7fffffe0, 0x7fffff84,
  0x7ffffffc, 0x7fffffdf, 0x7fffff83, 0x7fffff83,
  0x7fffffde, 0x7fffff82, 0x7fffff82, 0x7fffff82,
  0x7fffff81, 0x7fffff81, 0x7fffff81, 0x7fff8004,
  0x7fffff80, 0x7fffff80, 0x7fff8003, 0x7fff8003,
  0x7fffff7f, 0x7fff8002, 0x7fff8002, 0x7fff8002,
  0x7fff8001, 0x7fff8001, 0x7fff8001, 0x4cccccce,
  0x7fff8000, 0x7fff8000, 0x4ccccccd, 0x2aaaaaac,
  0x7fff7fff, 0x4ccccccc, 0x2aaaaaab, 0x00000004,
  0x4ccccccb, 0x2aaaaaaa, 0x00000003, 0x00000003,
  0x2aaaaaa9, 0x00000002, 0x00000002, 0x00000002,
  0x00000001, 0x00000001, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xffffffff, 0xd5555557,
  0xfffffffe, 0xfffffffe, 0xd5555556, 0xb3333335,
  0xfffffffd, 0xd5555555, 0xb3333334, 0x80008001,
  0xd5555554, 0xb3333333, 0x80008000, 0x80008000,
  0xb3333332, 0x80007fff, 0x80007fff, 0x80007fff,
  0x80007ffe, 0x80007ffe, 0x80007ffe, 0x80007ffe,
  0x80007ffd, 0x80007ffd, 0x80007ffd, 0x80000081,
  0x80007ffc, 0x80007ffc, 0x80000080, 0x80000080,
  0x80007ffb, 0x8000007f, 0x8000007f, 0x8000007f,
  0x8000007e, 0x8000007e, 0x8000007e, 0x8000007e,
  0x8000007d, 0x8000007d, 0x8000007d, 0x80000021,
  0x8000007c, 0x8000007c, 0x80000020, 0x80000004,
  0x8000007b, 0x8000001f, 0x80000003, 0x80000003,
  0x8000001e, 0x80000002, 0x80000002, 0x80000002,
  0x80000002, 0x80000002, 0x80000002, 0xaaaaaaaa,
  0x80000001, 0x80000001, 0x80000001, 0xaaaaaaa9,
  0x80000000, 0x80000000, 0x80000000, 0xaaaaaaa8,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0xaaaaaa8a,
  0x7ffffffe, 0x7ffffffe, 0x7fffffe1, 0xaaaaaa2d,
  0x7ffffffd, 0x7fffffe0, 0x7fffff84, 0xaaaaaa2c,
  0x7fffffdf, 0x7fffff83, 0x7fffff83, 0xaaaaaa2b,
  0x7fffff82, 0x7fffff82, 0x7fffff82, 0xaaaa2aad,
  0x7fffff81, 0x7fffff81, 0x7fff8004, 0xaaaa2aac,
  0x7fffff80, 0x7fff8003, 0x7fff8003, 0xaaaa2aab,
  0x7fff8002, 0x7fff8002, 0x7fff8002, 0x77777777,
  0x7fff8001, 0x7fff8001, 0x4cccccce, 0x55555555,
  0x7fff8000, 0x4ccccccd, 0x2aaaaaac, 0x2aaaaaad,
  0x4ccccccc, 0x2aaaaaab, 0x00000004, 0x2aaaaaac,
  0x2aaaaaaa, 0x00000003, 0x00000003, 0x2aaaaaab,
  0x00000002, 0x00000002, 0x00000002, 0x2aaaaaaa,
  0x00000001, 0x00000001, 0x00000001, 0x2aaaaaa9,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xd5555557, 0xddddddde,
  0xfffffffe, 0xd5555556, 0xb3333335, 0xaaab2aaa,
  0xd5555555, 0xb3333334, 0x80008001, 0xaaab2aa9,
  0xb3333333, 0x80008000, 0x80008000, 0xaaab2aa8,
  0x80007fff, 0x80007fff, 0x80007fff, 0xaaab2aa7,
  0x80007ffe, 0x80007ffe, 0x80007ffe, 0xaaaaab2a,
  0x80007ffd, 0x80007ffd, 0x80000081, 0xaaaaab29,
  0x80007ffc, 0x80000080, 0x80000080, 0xaaaaab28,
  0x8000007f, 0x8000007f, 0x8000007f, 0xaaaaab27,
  0x8000007e, 0x8000007e, 0x8000007e, 0xaaaaaaca,
  0x8000007d, 0x8000007d, 0x80000021, 0xaaaaaaad,
  0x8000007c, 0x80000020, 0x80000004, 0xaaaaaaac,
  0x8000001f, 0x80000003, 0x80000003, 0xaaaaaaab,
  0x80000003, 0x80000003, 0xaaaaaaab, 0xcccccccc,
  0x80000002, 0x80000002, 0xaaaaaaaa, 0xcccccccb,
  0x80000001, 0x80000001, 0xaaaaaaa9, 0xccccccca,
  0x80000000, 0x80000000, 0xaaaaaaa8, 0xccccccac,
  0x7fffffff, 0x7fffffff, 0xaaaaaa8a, 0xcccccc4f,
  0x7ffffffe, 0x7fffffe1, 0xaaaaaa2d, 0xcccccc4e,
  0x7fffffe0, 0x7fffff84, 0xaaaaaa2c, 0xcccccc4d,
  0x7fffff83, 0x7fffff83, 0xaaaaaa2b, 0xcccc4ccf,
  0x7fffff82, 0x7fffff82, 0xaaaa2aad, 0xcccc4cce,
  0x7fffff81, 0x7fff8004, 0xaaaa2aac, 0xcccc4ccd,
  0x7fff8003, 0x7fff8003, 0xaaaa2aab, 0x99999999,
  0x7fff8002, 0x7fff8002, 0x77777777, 0x77777777,
  0x7fff8001, 0x4cccccce, 0x55555555, 0x4ccccccf,
  0x4ccccccd, 0x2aaaaaac, 0x2aaaaaad, 0x4cccccce,
  0x2aaaaaab, 0x00000004, 0x2aaaaaac, 0x4ccccccd,
  0x00000003, 0x00000003, 0x2aaaaaab, 0x4ccccccc,
  0x00000002, 0x00000002, 0x2aaaaaaa, 0x4ccccccb,
  0x00000001, 0x00000001, 0x2aaaaaa9, 0x22222222,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xd5555557, 0xddddddde, 0xcccd4ccc,
  0xd5555556, 0xb3333335, 0xaaab2aaa, 0xcccd4ccb,
  0xb3333334, 0x80008001, 0xaaab2aa9, 0xcccd4cca,
  0x80008000, 0x80008000, 0xaaab2aa8, 0xcccd4cc9,
  0x80007fff, 0x80007fff, 0xaaab2aa7, 0xcccccd4c,
  0x80007ffe, 0x80007ffe, 0xaaaaab2a, 0xcccccd4b,
  0x80007ffd, 0x80000081, 0xaaaaab29, 0xcccccd4a,
  0x80000080, 0x80000080, 0xaaaaab28, 0xcccccd49,
  0x8000007f, 0x8000007f, 0xaaaaab27, 0xccccccec,
  0x8000007e, 0x8000007e, 0xaaaaaaca, 0xcccccccf,
  0x8000007d, 0x80000021, 0xaaaaaaad, 0xccccccce,
  0x80000020, 0x80000004, 0xaaaaaaac, 0xcccccccd,
  0x80000004, 0xaaaaaaac, 0xcccccccd, 0xffff8000,
  0x80000003, 0xaaaaaaab, 0xcccccccc, 0xffff7fff,
  0x80000002, 0xaaaaaaaa, 0xcccccccb, 0xffff7ffe,
  0x80000001, 0xaaaaaaa9, 0xccccccca, 0xffff7fe0,
  0x80000000, 0xaaaaaaa8, 0xccccccac, 0xffff7f83,
  0x7fffffff, 0xaaaaaa8a, 0xcccccc4f, 0xffff7f82,
  0x7fffffe1, 0xaaaaaa2d, 0xcccccc4e, 0xffff7f81,
  0x7fffff84, 0xaaaaaa2c, 0xcccccc4d, 0xffff0003,
  0x7fffff83, 0xaaaaaa2b, 0xcccc4ccf, 0xffff0002,
  0x7fffff82, 0xaaaa2aad, 0xcccc4cce, 0xffff0001,
  0x7fff8004, 0xaaaa2aac, 0xcccc4ccd, 0xcccc4ccd,
  0x7fff8003, 0xaaaa2aab, 0x99999999, 0xaaaa2aab,
  0x7fff8002, 0x77777777, 0x77777777, 0x7fff8003,
  0x4cccccce, 0x55555555, 0x4ccccccf, 0x7fff8002,
  0x2aaaaaac, 0x2aaaaaad, 0x4cccccce, 0x7fff8001,
  0x00000004, 0x2aaaaaac, 0x4ccccccd, 0x7fff8000,
  0x00000003, 0x2aaaaaab, 0x4ccccccc, 0x7fff7fff,
  0x00000002, 0x2aaaaaaa, 0x4ccccccb, 0x5554d556,
  0x00000001, 0x2aaaaaa9, 0x22222222, 0x3332b334,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xd5555557, 0xddddddde, 0xcccd4ccc, 0xffffffff,
  0xb3333335, 0xaaab2aaa, 0xcccd4ccb, 0xfffffffe,
  0x80008001, 0xaaab2aa9, 0xcccd4cca, 0xfffffffd,
  0x80008000, 0xaaab2aa8, 0xcccd4cc9, 0xffff8080,
  0x80007fff, 0xaaab2aa7, 0xcccccd4c, 0xffff807f,
  0x80007ffe, 0xaaaaab2a, 0xcccccd4b, 0xffff807e,
  0x80000081, 0xaaaaab29, 0xcccccd4a, 0xffff807d,
  0x80000080, 0xaaaaab28, 0xcccccd49, 0xffff8020,
  0x8000007f, 0xaaaaab27, 0xccccccec, 0xffff8003,
  0x8000007e, 0xaaaaaaca, 0xcccccccf, 0xffff8002,
  0x80000021, 0xaaaaaaad, 0xccccccce, 0xffff8001,
  0xaaaaaaad, 0xccccccce, 0xffff8001, 0xffff8001,
  0xaaaaaaac, 0xcccccccd, 0xffff8000, 0xffff8000,
  0xaaaaaaab, 0xcccccccc, 0xffff7fff, 0xffff7fff,
  0xaaaaaaaa, 0xcccccccb, 0xffff7ffe, 0xffff7fe1,
  0xaaaaaaa9, 0xccccccca, 0xffff7fe0, 0xffff7f84,
  0xaaaaaaa8, 0xccccccac, 0xffff7f83, 0xffff7f83,
  0xaaaaaa8a, 0xcccccc4f, 0xffff7f82, 0xffff7f82,
  0xaaaaaa2d, 0xcccccc4e, 0xffff7f81, 0xffff0004,
  0xaaaaaa2c, 0xcccccc4d, 0xffff0003, 0xffff0003,
  0xaaaaaa2b, 0xcccc4ccf, 0xffff0002, 0xffff0002,
  0xaaaa2aad, 0xcccc4cce, 0xffff0001, 0xcccc4cce,
  0xaaaa2aac, 0xcccc4ccd, 0xcccc4ccd, 0xaaaa2aac,
  0xaaaa2aab, 0x99999999, 0xaaaa2aab, 0x7fff8004,
  0x77777777, 0x77777777, 0x7fff8003, 0x7fff8003,
  0x55555555, 0x4ccccccf, 0x7fff8002, 0x7fff8002,
  0x2aaaaaad, 0x4cccccce, 0x7fff8001, 0x7fff8001,
  0x2aaaaaac, 0x4ccccccd, 0x7fff8000, 0x7fff8000,
  0x2aaaaaab, 0x4ccccccc, 0x7fff7fff, 0x5554d557,
  0x2aaaaaaa, 0x4ccccccb, 0x5554d556, 0x3332b335,
  0x2aaaaaa9, 0x22222222, 0x3332b334, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xddddddde, 0xcccd4ccc, 0xffffffff, 0xffffffff,
  0xaaab2aaa, 0xcccd4ccb, 0xfffffffe, 0xfffffffe,
  0xaaab2aa9, 0xcccd4cca, 0xfffffffd, 0xffff8081,
  0xaaab2aa8, 0xcccd4cc9, 0xffff8080, 0xffff8080,
  0xaaab2aa7, 0xcccccd4c, 0xffff807f, 0xffff807f,
  0xaaaaab2a, 0xcccccd4b, 0xffff807e, 0xffff807e,
  0xaaaaab29, 0xcccccd4a, 0xffff807d, 0xffff8021,
  0xaaaaab28, 0xcccccd49, 0xffff8020, 0xffff8004,
  0xaaaaab27, 0xccccccec, 0xffff8003, 0xffff8003,
  0xaaaaaaca, 0xcccccccf, 0xffff8002, 0xffff8002,
  0xcccccccf, 0xffff8002, 0xffff8002, 0xffff8002,
  0xccccccce, 0xffff8001, 0xffff8001, 0xffff8001,
  0xcccccccd, 0xffff8000, 0xffff8000, 0xffff8000,
  0xcccccccc, 0xffff7fff, 0xffff7fff, 0xffff7fe2,
  0xcccccccb, 0xffff7ffe, 0xffff7fe1, 0xffff7f85,
  0xccccccca, 0xffff7fe0, 0xffff7f84, 0xffff7f84,
  0xccccccac, 0xffff7f83, 0xffff7f83, 0xffff7f83,
  0xcccccc4f, 0xffff7f82, 0xffff7f82, 0xffff0005,
  0xcccccc4e, 0xffff7f81, 0xffff0004, 0xffff0004,
  0xcccccc4d, 0xffff0003, 0xffff0003, 0xffff0003,
  0xcccc4ccf, 0xffff0002, 0xffff0002, 0xcccc4ccf,
  0xcccc4cce, 0xffff0001, 0xcccc4cce, 0xaaaa2aad,
  0xcccc4ccd, 0xcccc4ccd, 0xaaaa2aac, 0x7fff8005,
  0x99999999, 0xaaaa2aab, 0x7fff8004, 0x7fff8004,
  0x77777777, 0x7fff8003, 0x7fff8003, 0x7fff8003,
  0x4ccccccf, 0x7fff8002, 0x7fff8002, 0x7fff8002,
  0x4cccccce, 0x7fff8001, 0x7fff8001, 0x7fff8001,
  0x4ccccccd, 0x7fff8000, 0x7fff8000, 0x5554d558,
  0x4ccccccc, 0x7fff7fff, 0x5554d557, 0x3332b336,
  0x4ccccccb, 0x5554d556, 0x3332b335, 0x00000002,
  0x22222222, 0x3332b334, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xcccd4ccc, 0xffffffff, 0xffffffff, 0xffffffff,
  0xcccd4ccb, 0xfffffffe, 0xfffffffe, 0xffff8082,
  0xcccd4cca, 0xfffffffd, 0xffff8081, 0xffff8081,
  0xcccd4cc9, 0xffff8080, 0xffff8080, 0xffff8080,
  0xcccccd4c, 0xffff807f, 0xffff807f, 0xffff807f,
  0xcccccd4b, 0xffff807e, 0xffff807e, 0xffff8022,
  0xcccccd4a, 0xffff807d, 0xffff8021, 0xffff8005,
  0xcccccd49, 0xffff8020, 0xffff8004, 0xffff8004,
  0xccccccec, 0xffff8003, 0xffff8003, 0xffff8003,
  0xffff8003, 0xffff8003, 0xffff8003, 0xffff8003,
  0xffff8002, 0xffff8002, 0xffff8002, 0xffff8002,
  0xffff8001, 0xffff8001, 0xffff8001, 0xffff8001,
  0xffff8000, 0xffff8000, 0xffff8000, 0xffff7fe3,
  0xffff7fff, 0xffff7fff, 0xffff7fe2, 0xffff7f86,
  0xffff7ffe, 0xffff7fe1, 0xffff7f85, 0xffff7f85,
  0xffff7fe0, 0xffff7f84, 0xffff7f84, 0xffff7f84,
  0xffff7f83, 0xffff7f83, 0xffff7f83, 0xffff0006,
  0xffff7f82, 0xffff7f82, 0xffff0005, 0xffff0005,
  0xffff7f81, 0xffff0004, 0xffff0004, 0xffff0004,
  0xffff0003, 0xffff0003, 0xffff0003, 0xcccc4cd0,
  0xffff0002, 0xffff0002, 0xcccc4ccf, 0xaaaa2aae,
  0xffff0001, 0xcccc4cce, 0xaaaa2aad, 0x7fff8006,
  0xcccc4ccd, 0xaaaa2aac, 0x7fff8005, 0x7fff8005,
  0xaaaa2aab, 0x7fff8004, 0x7fff8004, 0x7fff8004,
  0x7fff8003, 0x7fff8003, 0x7fff8003, 0x7fff8003,
  0x7fff8002, 0x7fff8002, 0x7fff8002, 0x7fff8002,
  0x7fff8001, 0x7fff8001, 0x7fff8001, 0x5554d559,
  0x7fff8000, 0x7fff8000, 0x5554d558, 0x3332b337,
  0x7fff7fff, 0x5554d557, 0x3332b336, 0x00000003,
  0x5554d556, 0x3332b335, 0x00000002, 0x00000002,
  0x3332b334, 0x00000001, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffff8083,
  0xfffffffe, 0xfffffffe, 0xffff8082, 0xffff8082,
  0xfffffffd, 0xffff8081, 0xffff8081, 0xffff8081,
  0xffff8080, 0xffff8080, 0xffff8080, 0xffff8080,
  0xffff807f, 0xffff807f, 0xffff807f, 0xffff8023,
  0xffff807e, 0xffff807e, 0xffff8022, 0xffff8006,
  0xffff807d, 0xffff8021, 0xffff8005, 0xffff8005,
  0xffff8020, 0xffff8004, 0xffff8004, 0xffff8004,
  0xffff8004, 0xffff8004, 0xffff8004, 0xffffff80,
  0xffff8003, 0xffff8003, 0xffff8003, 0xffffff7f,
  0xffff8002, 0xffff8002, 0xffff8002, 0xffffff7e,
  0xffff8001, 0xffff8001, 0xffff8001, 0xffffff60,
  0xffff8000, 0xffff8000, 0xffff7fe3, 0xffffff03,
  0xffff7fff, 0xffff7fe2, 0xffff7f86, 0xffffff02,
  0xffff7fe1, 0xffff7f85, 0xffff7f85, 0xffffff01,
  0xffff7f84, 0xffff7f84, 0xffff7f84, 0xffff7f83,
  0xffff7f83, 0xffff7f83, 0xffff0006, 0xffff7f82,
  0xffff7f82, 0xffff0005, 0xffff0005, 0xffff7f81,
  0xffff0004, 0xffff0004, 0xffff0004, 0xcccccc4d,
  0xffff0003, 0xffff0003, 0xcccc4cd0, 0xaaaaaa2b,
  0xffff0002, 0xcccc4ccf, 0xaaaa2aae, 0x7fffff83,
  0xcccc4cce, 0xaaaa2aad, 0x7fff8006, 0x7fffff82,
  0xaaaa2aac, 0x7fff8005, 0x7fff8005, 0x7fffff81,
  0x7fff8004, 0x7fff8004, 0x7fff8004, 0x7fffff80,
  0x7fff8003, 0x7fff8003, 0x7fff8003, 0x7fffff7f,
  0x7fff8002, 0x7fff8002, 0x7fff8002, 0x555554d6,
  0x7fff8001, 0x7fff8001, 0x5554d559, 0x333332b4,
  0x7fff8000, 0x5554d558, 0x3332b337, 0x00007f80,
  0x5554d557, 0x3332b336, 0x00000003, 0x00007f7f,
  0x3332b335, 0x00000002, 0x00000002, 0x00007f7e,
  0x00000001, 0x00000001, 0x00000001, 0x00007f7d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xffff8083, 0xffffffff,
  0xfffffffe, 0xffff8082, 0xffff8082, 0xfffffffe,
  0xffff8081, 0xffff8081, 0xffff8081, 0xfffffffd,
  0xffff8080, 0xffff8080, 0xffff8080, 0xffffffa0,
  0xffff807f, 0xffff807f, 0xffff8023, 0xffffff83,
  0xffff807e, 0xffff8022, 0xffff8006, 0xffffff82,
  0xffff8021, 0xffff8005, 0xffff8005, 0xffffff81,
  0xffff8005, 0xffff8005, 0xffffff81, 0xffffff81,
  0xffff8004, 0xffff8004, 0xffffff80, 0xffffff80,
  0xffff8003, 0xffff8003, 0xffffff7f, 0xffffff7f,
  0xffff8002, 0xffff8002, 0xffffff7e, 0xffffff61,
  0xffff8001, 0xffff8001, 0xffffff60, 0xffffff04,
  0xffff8000, 0xffff7fe3, 0xffffff03, 0xffffff03,
  0xffff7fe2, 0xffff7f86, 0xffffff02, 0xffffff02,
  0xffff7f85, 0xffff7f85, 0xffffff01, 0xffff7f84,
  0xffff7f84, 0xffff7f84, 0xffff7f83, 0xffff7f83,
  0xffff7f83, 0xffff0006, 0xffff7f82, 0xffff7f82,
  0xffff0005, 0xffff0005, 0xffff7f81, 0xcccccc4e,
  0xffff0004, 0xffff0004, 0xcccccc4d, 0xaaaaaa2c,
  0xffff0003, 0xcccc4cd0, 0xaaaaaa2b, 0x7fffff84,
  0xcccc4ccf, 0xaaaa2aae, 0x7fffff83, 0x7fffff83,
  0xaaaa2aad, 0x7fff8006, 0x7fffff82, 0x7fffff82,
  0x7fff8005, 0x7fff8005, 0x7fffff81, 0x7fffff81,
  0x7fff8004, 0x7fff8004, 0x7fffff80, 0x7fffff80,
  0x7fff8003, 0x7fff8003, 0x7fffff7f, 0x555554d7,
  0x7fff8002, 0x7fff8002, 0x555554d6, 0x333332b5,
  0x7fff8001, 0x5554d559, 0x333332b4, 0x00007f81,
  0x5554d558, 0x3332b337, 0x00007f80, 0x00007f80,
  0x3332b336, 0x00000003, 0x00007f7f, 0x00007f7f,
  0x00000002, 0x00000002, 0x00007f7e, 0x00007f7e,
  0x00000001, 0x00000001, 0x00007f7d, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffff8083, 0xffffffff, 0xffffffff,
  0xffff8082, 0xffff8082, 0xfffffffe, 0xfffffffe,
  0xffff8081, 0xffff8081, 0xfffffffd, 0xffffffa1,
  0xffff8080, 0xffff8080, 0xffffffa0, 0xffffff84,
  0xffff807f, 0xffff8023, 0xffffff83, 0xffffff83,
  0xffff8022, 0xffff8006, 0xffffff82, 0xffffff82,
  0xffff8006, 0xffffff82, 0xffffff82, 0xffffff82,
  0xffff8005, 0xffffff81, 0xffffff81, 0xffffff81,
  0xffff8004, 0xffffff80, 0xffffff80, 0xffffff80,
  0xffff8003, 0xffffff7f, 0xffffff7f, 0xffffff62,
  0xffff8002, 0xffffff7e, 0xffffff61, 0xffffff05,
  0xffff8001, 0xffffff60, 0xffffff04, 0xffffff04,
  0xffff7fe3, 0xffffff03, 0xffffff03, 0xffffff03,
  0xffff7f86, 0xffffff02, 0xffffff02, 0xffff7f85,
  0xffff7f85, 0xffffff01, 0xffff7f84, 0xffff7f84,
  0xffff7f84, 0xffff7f83, 0xffff7f83, 0xffff7f83,
  0xffff0006, 0xffff7f82, 0xffff7f82, 0xcccccc4f,
  0xffff0005, 0xffff7f81, 0xcccccc4e, 0xaaaaaa2d,
  0xffff0004, 0xcccccc4d, 0xaaaaaa2c, 0x7fffff85,
  0xcccc4cd0, 0xaaaaaa2b, 0x7fffff84, 0x7fffff84,
  0xaaaa2aae, 0x7fffff83, 0x7fffff83, 0x7fffff83,
  0x7fff8006, 0x7fffff82, 0x7fffff82, 0x7fffff82,
  0x7fff8005, 0x7fffff81, 0x7fffff81, 0x7fffff81,
  0x7fff8004, 0x7fffff80, 0x7fffff80, 0x555554d8,
  0x7fff8003, 0x7fffff7f, 0x555554d7, 0x333332b6,
  0x7fff8002, 0x555554d6, 0x333332b5, 0x00007f82,
  0x5554d559, 0x333332b4, 0x00007f81, 0x00007f81,
  0x3332b337, 0x00007f80, 0x00007f80, 0x00007f80,
  0x00000003, 0x00007f7f, 0x00007f7f, 0x00007f7f,
  0x00000002, 0x00007f7e, 0x00007f7e, 0x00000002,
  0x00000001, 0x00007f7d, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff8083, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffff8082, 0xfffffffe, 0xfffffffe, 0xffffffa2,
  0xffff8081, 0xfffffffd, 0xffffffa1, 0xffffff85,
  0xffff8080, 0xffffffa0, 0xffffff84, 0xffffff84,
  0xffff8023, 0xffffff83, 0xffffff83, 0xffffff83,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffffff83,
  0xffffff82, 0xffffff82, 0xffffff82, 0xffffff82,
  0xffffff81, 0xffffff81, 0xffffff81, 0xffffff81,
  0xffffff80, 0xffffff80, 0xffffff80, 0xffffff63,
  0xffffff7f, 0xffffff7f, 0xffffff62, 0xffffff06,
  0xffffff7e, 0xffffff61, 0xffffff05, 0xffffff05,
  0xffffff60, 0xffffff04, 0xffffff04, 0xffffff04,
  0xffffff03, 0xffffff03, 0xffffff03, 0xffff7f86,
  0xffffff02, 0xffffff02, 0xffff7f85, 0xffff7f85,
  0xffffff01, 0xffff7f84, 0xffff7f84, 0xffff7f84,
  0xffff7f83, 0xffff7f83, 0xffff7f83, 0xcccccc50,
  0xffff7f82, 0xffff7f82, 0xcccccc4f, 0xaaaaaa2e,
  0xffff7f81, 0xcccccc4e, 0xaaaaaa2d, 0x7fffff86,
  0xcccccc4d, 0xaaaaaa2c, 0x7fffff85, 0x7fffff85,
  0xaaaaaa2b, 0x7fffff84, 0x7fffff84, 0x7fffff84,
  0x7fffff83, 0x7fffff83, 0x7fffff83, 0x7fffff83,
  0x7fffff82, 0x7fffff82, 0x7fffff82, 0x7fffff82,
  0x7fffff81, 0x7fffff81, 0x7fffff81, 0x555554d9,
  0x7fffff80, 0x7fffff80, 0x555554d8, 0x333332b7,
  0x7fffff7f, 0x555554d7, 0x333332b6, 0x00007f83,
  0x555554d6, 0x333332b5, 0x00007f82, 0x00007f82,
  0x333332b4, 0x00007f81, 0x00007f81, 0x00007f81,
  0x00007f80, 0x00007f80, 0x00007f80, 0x00007f80,
  0x00007f7f, 0x00007f7f, 0x00007f7f, 0x00000003,
  0x00007f7e, 0x00007f7e, 0x00000002, 0x00000002,
  0x00007f7d, 0x00000001, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffa3,
  0xfffffffe, 0xfffffffe, 0xffffffa2, 0xffffff86,
  0xfffffffd, 0xffffffa1, 0xffffff85, 0xffffff85,
  0xffffffa0, 0xffffff84, 0xffffff84, 0xffffff84,
  0xffffff84, 0xffffff84, 0xffffff84, 0xffffffe0,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffffffdf,
  0xffffff82, 0xffffff82, 0xffffff82, 0xffffffde,
  0xffffff81, 0xffffff81, 0xffffff81, 0xffffffc0,
  0xffffff80, 0xffffff80, 0xffffff63, 0xffffff63,
  0xffffff7f, 0xffffff62, 0xffffff06, 0xffffff62,
  0xffffff61, 0xffffff05, 0xffffff05, 0xffffff61,
  0xffffff04, 0xffffff04, 0xffffff04, 0xffff7fe3,
  0xffffff03, 0xffffff03, 0xffff7f86, 0xffff7fe2,
  0xffffff02, 0xffff7f85, 0xffff7f85, 0xffff7fe1,
  0xffff7f84, 0xffff7f84, 0xffff7f84, 0xccccccad,
  0xffff7f83, 0xffff7f83, 0xcccccc50, 0xaaaaaa8b,
  0xffff7f82, 0xcccccc4f, 0xaaaaaa2e, 0x7fffffe3,
  0xcccccc4e, 0xaaaaaa2d, 0x7fffff86, 0x7fffffe2,
  0xaaaaaa2c, 0x7fffff85, 0x7fffff85, 0x7fffffe1,
  0x7fffff84, 0x7fffff84, 0x7fffff84, 0x7fffffe0,
  0x7fffff83, 0x7fffff83, 0x7fffff83, 0x7fffffdf,
  0x7fffff82, 0x7fffff82, 0x7fffff82, 0x55555536,
  0x7fffff81, 0x7fffff81, 0x555554d9, 0x33333314,
  0x7fffff80, 0x555554d8, 0x333332b7, 0x00007fe0,
  0x555554d7, 0x333332b6, 0x00007f83, 0x00007fdf,
  0x333332b5, 0x00007f82, 0x00007f82, 0x00007fde,
  0x00007f81, 0x00007f81, 0x00007f81, 0x00007fdd,
  0x00007f80, 0x00007f80, 0x00007f80, 0x00000060,
  0x00007f7f, 0x00007f7f, 0x00000003, 0x0000005f,
  0x00007f7e, 0x00000002, 0x00000002, 0x0000005e,
  0x00000001, 0x00000001, 0x00000001, 0x0000005d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xffffffa3, 0xffffffe3,
  0xfffffffe, 0xffffffa2, 0xffffff86, 0xffffffe2,
  0xffffffa1, 0xffffff85, 0xffffff85, 0xffffffe1,
  0xffffff85, 0xffffff85, 0xffffffe1, 0xfffffffd,
  0xffffff84, 0xffffff84, 0xffffffe0, 0xfffffffc,
  0xffffff83, 0xffffff83, 0xffffffdf, 0xfffffffb,
  0xffffff82, 0xffffff82, 0xffffffde, 0xffffffdd,
  0xffffff81, 0xffffff81, 0xffffffc0, 0xffffff80,
  0xffffff80, 0xffffff63, 0xffffff63, 0xffffff7f,
  0xffffff62, 0xffffff06, 0xffffff62, 0xffffff7e,
  0xffffff05, 0xffffff05, 0xffffff61, 0xffff8000,
  0xffffff04, 0xffffff04, 0xffff7fe3, 0xffff7fff,
  0xffffff03, 0xffff7f86, 0xffff7fe2, 0xffff7ffe,
  0xffff7f85, 0xffff7f85, 0xffff7fe1, 0xccccccca,
  0xffff7f84, 0xffff7f84, 0xccccccad, 0xaaaaaaa8,
  0xffff7f83, 0xcccccc50, 0xaaaaaa8b, 0x80000000,
  0xcccccc4f, 0xaaaaaa2e, 0x7fffffe3, 0x7fffffff,
  0xaaaaaa2d, 0x7fffff86, 0x7fffffe2, 0x7ffffffe,
  0x7fffff85, 0x7fffff85, 0x7fffffe1, 0x7ffffffd,
  0x7fffff84, 0x7fffff84, 0x7fffffe0, 0x7ffffffc,
  0x7fffff83, 0x7fffff83, 0x7fffffdf, 0x55555553,
  0x7fffff82, 0x7fffff82, 0x55555536, 0x33333331,
  0x7fffff81, 0x555554d9, 0x33333314, 0x00007ffd,
  0x555554d8, 0x333332b7, 0x00007fe0, 0x00007ffc,
  0x333332b6, 0x00007f83, 0x00007fdf, 0x00007ffb,
  0x00007f82, 0x00007f82, 0x00007fde, 0x00007ffa,
  0x00007f81, 0x00007f81, 0x00007fdd, 0x0000007d,
  0x00007f80, 0x00007f80, 0x00000060, 0x0000007c,
  0x00007f7f, 0x00000003, 0x0000005f, 0x0000007b,
  0x00000002, 0x00000002, 0x0000005e, 0x0000007a,
  0x00000001, 0x00000001, 0x0000005d, 0x0000001d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffa3, 0xffffffe3, 0xffffffff,
  0xffffffa2, 0xffffff86, 0xffffffe2, 0xfffffffe,
  0xffffff86, 0xffffffe2, 0xfffffffe, 0xfffffffe,
  0xffffff85, 0xffffffe1, 0xfffffffd, 0xfffffffd,
  0xffffff84, 0xffffffe0, 0xfffffffc, 0xfffffffc,
  0xffffff83, 0xffffffdf, 0xfffffffb, 0xffffffde,
  0xffffff82, 0xffffffde, 0xffffffdd, 0xffffff81,
  0xffffff81, 0xffffffc0, 0xffffff80, 0xffffff80,
  0xffffff63, 0xffffff63, 0xffffff7f, 0xffffff7f,
  0xffffff06, 0xffffff62, 0xffffff7e, 0xffff8001,
  0xffffff05, 0xffffff61, 0xffff8000, 0xffff8000,
  0xffffff04, 0xffff7fe3, 0xffff7fff, 0xffff7fff,
  0xffff7f86, 0xffff7fe2, 0xffff7ffe, 0xcccccccb,
  0xffff7f85, 0xffff7fe1, 0xccccccca, 0xaaaaaaa9,
  0xffff7f84, 0xccccccad, 0xaaaaaaa8, 0x80000001,
  0xcccccc50, 0xaaaaaa8b, 0x80000000, 0x80000000,
  0xaaaaaa2e, 0x7fffffe3, 0x7fffffff, 0x7fffffff,
  0x7fffff86, 0x7fffffe2, 0x7ffffffe, 0x7ffffffe,
  0x7fffff85, 0x7fffffe1, 0x7ffffffd, 0x7ffffffd,
  0x7fffff84, 0x7fffffe0, 0x7ffffffc, 0x55555554,
  0x7fffff83, 0x7fffffdf, 0x55555553, 0x33333332,
  0x7fffff82, 0x55555536, 0x33333331, 0x00007ffe,
  0x555554d9, 0x33333314, 0x00007ffd, 0x00007ffd,
  0x333332b7, 0x00007fe0, 0x00007ffc, 0x00007ffc,
  0x00007f83, 0x00007fdf, 0x00007ffb, 0x00007ffb,
  0x00007f82, 0x00007fde, 0x00007ffa, 0x0000007e,
  0x00007f81, 0x00007fdd, 0x0000007d, 0x0000007d,
  0x00007f80, 0x00000060, 0x0000007c, 0x0000007c,
  0x00000003, 0x0000005f, 0x0000007b, 0x0000007b,
  0x00000002, 0x0000005e, 0x0000007a, 0x0000001e,
  0x00000001, 0x0000005d, 0x0000001d, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffa3, 0xffffffe3, 0xffffffff, 0xffffffff,
  0xffffffe3, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffe2, 0xfffffffe, 0xfffffffe, 0xfffffffe,
  0xffffffe1, 0xfffffffd, 0xfffffffd, 0xfffffffd,
  0xffffffe0, 0xfffffffc, 0xfffffffc, 0xffffffdf,
  0xffffffdf, 0xfffffffb, 0xffffffde, 0xffffff82,
  0xffffffde, 0xffffffdd, 0xffffff81, 0xffffff81,
  0xffffffc0, 0xffffff80, 0xffffff80, 0xffffff80,
  0xffffff63, 0xffffff7f, 0xffffff7f, 0xffff8002,
  0xffffff62, 0xffffff7e, 0xffff8001, 0xffff8001,
  0xffffff61, 0xffff8000, 0xffff8000, 0xffff8000,
  0xffff7fe3, 0xffff7fff, 0xffff7fff, 0xcccccccc,
  0xffff7fe2, 0xffff7ffe, 0xcccccccb, 0xaaaaaaaa,
  0xffff7fe1, 0xccccccca, 0xaaaaaaa9, 0x80000002,
  0xccccccad, 0xaaaaaaa8, 0x80000001, 0x80000001,
  0xaaaaaa8b, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffe3, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffe2, 0x7ffffffe, 0x7ffffffe, 0x7ffffffe,
  0x7fffffe1, 0x7ffffffd, 0x7ffffffd, 0x55555555,
  0x7fffffe0, 0x7ffffffc, 0x55555554, 0x33333333,
  0x7fffffdf, 0x55555553, 0x33333332, 0x00007fff,
  0x55555536, 0x33333331, 0x00007ffe, 0x00007ffe,
  0x33333314, 0x00007ffd, 0x00007ffd, 0x00007ffd,
  0x00007fe0, 0x00007ffc, 0x00007ffc, 0x00007ffc,
  0x00007fdf, 0x00007ffb, 0x00007ffb, 0x0000007f,
  0x00007fde, 0x00007ffa, 0x0000007e, 0x0000007e,
  0x00007fdd, 0x0000007d, 0x0000007d, 0x0000007d,
  0x00000060, 0x0000007c, 0x0000007c, 0x0000007c,
  0x0000005f, 0x0000007b, 0x0000007b, 0x0000001f,
  0x0000005e, 0x0000007a, 0x0000001e, 0x00000002,
  0x0000005d, 0x0000001d, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
};
const unsigned kExpectedCount_NEON_sub_4S = 961;

#endif  // VIXL_SIM_SUB_4S_TRACE_AARCH64_H_
