// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UABDL2_8H_TRACE_AARCH64_H_
#define VIXL_SIM_UABDL2_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_uabdl2_8H[] = {
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0x00ff, 0x0001,
  0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0x00fe, 0x00fe, 0x0002,
  0x0075, 0x0053, 0x0032, 0x0007, 0x00fd, 0x00fd, 0x00fd, 0x0008,
  0x007a, 0x0054, 0x0033, 0x00f8, 0x00fc, 0x00fc, 0x00f7, 0x0033,
  0x007b, 0x0055, 0x00cc, 0x00f7, 0x00fb, 0x00f6, 0x00cc, 0x0055,
  0x007c, 0x00aa, 0x00cb, 0x00f6, 0x00f5, 0x00cb, 0x00aa, 0x007d,
  0x0083, 0x00a9, 0x00ca, 0x00f0, 0x00ca, 0x00a9, 0x0082, 0x007e,
  0x0082, 0x00a8, 0x00c4, 0x00c5, 0x00a8, 0x0081, 0x0081, 0x007f,
  0x0081, 0x00a2, 0x0099, 0x00a3, 0x0080, 0x0080, 0x0080, 0x0080,
  0x007b, 0x0077, 0x0077, 0x007b, 0x007f, 0x007f, 0x007f, 0x0081,
  0x0050, 0x0055, 0x004f, 0x007a, 0x007e, 0x007e, 0x007e, 0x0082,
  0x002e, 0x002d, 0x004e, 0x0079, 0x007d, 0x007d, 0x007d, 0x0083,
  0x0006, 0x002c, 0x004d, 0x0078, 0x007c, 0x007c, 0x007c, 0x00aa,
  0x0005, 0x002b, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0x00cc,
  0x0004, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0x00f8,
  0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0x00fd,
  0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0x00fe,
  0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0x00ff,
  0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0x00ff, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0x00ff, 0x0001, 0x0001,
  0x004e, 0x0031, 0x0006, 0x0002, 0x00fe, 0x00fe, 0x0002, 0x0007,
  0x0053, 0x0032, 0x0007, 0x00fd, 0x00fd, 0x00fd, 0x0008, 0x0032,
  0x0054, 0x0033, 0x00f8, 0x00fc, 0x00fc, 0x00f7, 0x0033, 0x0054,
  0x0055, 0x00cc, 0x00f7, 0x00fb, 0x00f6, 0x00cc, 0x0055, 0x007c,
  0x00aa, 0x00cb, 0x00f6, 0x00f5, 0x00cb, 0x00aa, 0x007d, 0x007d,
  0x00a9, 0x00ca, 0x00f0, 0x00ca, 0x00a9, 0x0082, 0x007e, 0x007e,
  0x00a8, 0x00c4, 0x00c5, 0x00a8, 0x0081, 0x0081, 0x007f, 0x007f,
  0x00a2, 0x0099, 0x00a3, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
  0x0077, 0x0077, 0x007b, 0x007f, 0x007f, 0x007f, 0x0081, 0x0081,
  0x0055, 0x004f, 0x007a, 0x007e, 0x007e, 0x007e, 0x0082, 0x0082,
  0x002d, 0x004e, 0x0079, 0x007d, 0x007d, 0x007d, 0x0083, 0x00a9,
  0x002c, 0x004d, 0x0078, 0x007c, 0x007c, 0x007c, 0x00aa, 0x00cb,
  0x002b, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0x00cc, 0x00f7,
  0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0x00f8, 0x00fc,
  0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0x00fd, 0x00fd,
  0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0x00fe, 0x00fe,
  0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0x00fe, 0x00fe, 0x0002,
  0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0x00ff, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x002c, 0x0005, 0x0001, 0x0001, 0x00ff, 0x0001, 0x0001, 0x0006,
  0x0031, 0x0006, 0x0002, 0x00fe, 0x00fe, 0x0002, 0x0007, 0x0031,
  0x0032, 0x0007, 0x00fd, 0x00fd, 0x00fd, 0x0008, 0x0032, 0x0053,
  0x0033, 0x00f8, 0x00fc, 0x00fc, 0x00f7, 0x0033, 0x0054, 0x007b,
  0x00cc, 0x00f7, 0x00fb, 0x00f6, 0x00cc, 0x0055, 0x007c, 0x007c,
  0x00cb, 0x00f6, 0x00f5, 0x00cb, 0x00aa, 0x007d, 0x007d, 0x007d,
  0x00ca, 0x00f0, 0x00ca, 0x00a9, 0x0082, 0x007e, 0x007e, 0x007e,
  0x00c4, 0x00c5, 0x00a8, 0x0081, 0x0081, 0x007f, 0x007f, 0x007f,
  0x0099, 0x00a3, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
  0x0077, 0x007b, 0x007f, 0x007f, 0x007f, 0x0081, 0x0081, 0x0081,
  0x004f, 0x007a, 0x007e, 0x007e, 0x007e, 0x0082, 0x0082, 0x00a8,
  0x004e, 0x0079, 0x007d, 0x007d, 0x007d, 0x0083, 0x00a9, 0x00ca,
  0x004d, 0x0078, 0x007c, 0x007c, 0x007c, 0x00aa, 0x00cb, 0x00f6,
  0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0x00cc, 0x00f7, 0x00fb,
  0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0x00f8, 0x00fc, 0x00fc,
  0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0x00fd, 0x00fd, 0x00fd,
  0x0075, 0x0053, 0x0032, 0x0007, 0x00fd, 0x00fd, 0x00fd, 0x0008,
  0x004e, 0x0031, 0x0006, 0x0002, 0x00fe, 0x00fe, 0x0002, 0x0007,
  0x002c, 0x0005, 0x0001, 0x0001, 0x00ff, 0x0001, 0x0001, 0x0006,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0005, 0x0001, 0x0001, 0x00ff, 0x0001, 0x0001, 0x0006, 0x002b,
  0x0006, 0x0002, 0x00fe, 0x00fe, 0x0002, 0x0007, 0x0031, 0x004d,
  0x0007, 0x00fd, 0x00fd, 0x00fd, 0x0008, 0x0032, 0x0053, 0x0075,
  0x00f8, 0x00fc, 0x00fc, 0x00f7, 0x0033, 0x0054, 0x007b, 0x0076,
  0x00f7, 0x00fb, 0x00f6, 0x00cc, 0x0055, 0x007c, 0x007c, 0x0077,
  0x00f6, 0x00f5, 0x00cb, 0x00aa, 0x007d, 0x007d, 0x007d, 0x0078,
  0x00f0, 0x00ca, 0x00a9, 0x0082, 0x007e, 0x007e, 0x007e, 0x0079,
  0x00c5, 0x00a8, 0x0081, 0x0081, 0x007f, 0x007f, 0x007f, 0x007a,
  0x00a3, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x007b,
  0x007b, 0x007f, 0x007f, 0x007f, 0x0081, 0x0081, 0x0081, 0x00a2,
  0x007a, 0x007e, 0x007e, 0x007e, 0x0082, 0x0082, 0x00a8, 0x00c4,
  0x0079, 0x007d, 0x007d, 0x007d, 0x0083, 0x00a9, 0x00ca, 0x00f0,
  0x0078, 0x007c, 0x007c, 0x007c, 0x00aa, 0x00cb, 0x00f6, 0x00f5,
  0x0077, 0x007b, 0x007b, 0x0055, 0x00cc, 0x00f7, 0x00fb, 0x00f6,
  0x0076, 0x007a, 0x0054, 0x0033, 0x00f8, 0x00fc, 0x00fc, 0x00f7,
  0x007a, 0x0054, 0x0033, 0x00f8, 0x00fc, 0x00fc, 0x00f7, 0x0033,
  0x0053, 0x0032, 0x0007, 0x00fd, 0x00fd, 0x00fd, 0x0008, 0x0032,
  0x0031, 0x0006, 0x0002, 0x00fe, 0x00fe, 0x0002, 0x0007, 0x0031,
  0x0005, 0x0001, 0x0001, 0x00ff, 0x0001, 0x0001, 0x0006, 0x002b,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x00ff, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022,
  0x0002, 0x00fe, 0x00fe, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a,
  0x00fd, 0x00fd, 0x00fd, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b,
  0x00fc, 0x00fc, 0x00f7, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c,
  0x00fb, 0x00f6, 0x00cc, 0x0055, 0x007c, 0x007c, 0x0077, 0x004d,
  0x00f5, 0x00cb, 0x00aa, 0x007d, 0x007d, 0x007d, 0x0078, 0x004e,
  0x00ca, 0x00a9, 0x0082, 0x007e, 0x007e, 0x007e, 0x0079, 0x004f,
  0x00a8, 0x0081, 0x0081, 0x007f, 0x007f, 0x007f, 0x007a, 0x0050,
  0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x007b, 0x0077,
  0x007f, 0x007f, 0x007f, 0x0081, 0x0081, 0x0081, 0x00a2, 0x0099,
  0x007e, 0x007e, 0x007e, 0x0082, 0x0082, 0x00a8, 0x00c4, 0x00c5,
  0x007d, 0x007d, 0x007d, 0x0083, 0x00a9, 0x00ca, 0x00f0, 0x00ca,
  0x007c, 0x007c, 0x007c, 0x00aa, 0x00cb, 0x00f6, 0x00f5, 0x00cb,
  0x007b, 0x007b, 0x0055, 0x00cc, 0x00f7, 0x00fb, 0x00f6, 0x00cc,
  0x007b, 0x0055, 0x00cc, 0x00f7, 0x00fb, 0x00f6, 0x00cc, 0x0055,
  0x0054, 0x0033, 0x00f8, 0x00fc, 0x00fc, 0x00f7, 0x0033, 0x0054,
  0x0032, 0x0007, 0x00fd, 0x00fd, 0x00fd, 0x0008, 0x0032, 0x0053,
  0x0006, 0x0002, 0x00fe, 0x00fe, 0x0002, 0x0007, 0x0031, 0x004d,
  0x0001, 0x0001, 0x00ff, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x00ff, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028,
  0x00fe, 0x00fe, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029,
  0x00fd, 0x00fd, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a,
  0x00fc, 0x00f7, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0x002b,
  0x00f6, 0x00cc, 0x0055, 0x007c, 0x007c, 0x0077, 0x004d, 0x002c,
  0x00cb, 0x00aa, 0x007d, 0x007d, 0x007d, 0x0078, 0x004e, 0x002d,
  0x00a9, 0x0082, 0x007e, 0x007e, 0x007e, 0x0079, 0x004f, 0x002e,
  0x0081, 0x0081, 0x007f, 0x007f, 0x007f, 0x007a, 0x0050, 0x0055,
  0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x007b, 0x0077, 0x0077,
  0x007f, 0x007f, 0x0081, 0x0081, 0x0081, 0x00a2, 0x0099, 0x00a3,
  0x007e, 0x007e, 0x0082, 0x0082, 0x00a8, 0x00c4, 0x00c5, 0x00a8,
  0x007d, 0x007d, 0x0083, 0x00a9, 0x00ca, 0x00f0, 0x00ca, 0x00a9,
  0x007c, 0x007c, 0x00aa, 0x00cb, 0x00f6, 0x00f5, 0x00cb, 0x00aa,
  0x007c, 0x00aa, 0x00cb, 0x00f6, 0x00f5, 0x00cb, 0x00aa, 0x007d,
  0x0055, 0x00cc, 0x00f7, 0x00fb, 0x00f6, 0x00cc, 0x0055, 0x007c,
  0x0033, 0x00f8, 0x00fc, 0x00fc, 0x00f7, 0x0033, 0x0054, 0x007b,
  0x0007, 0x00fd, 0x00fd, 0x00fd, 0x0008, 0x0032, 0x0053, 0x0075,
  0x0002, 0x00fe, 0x00fe, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a,
  0x0001, 0x00ff, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00ff, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001,
  0x00fe, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002,
  0x00fd, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0x0003,
  0x00f7, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0x002b, 0x0004,
  0x00cc, 0x0055, 0x007c, 0x007c, 0x0077, 0x004d, 0x002c, 0x0005,
  0x00aa, 0x007d, 0x007d, 0x007d, 0x0078, 0x004e, 0x002d, 0x0006,
  0x0082, 0x007e, 0x007e, 0x007e, 0x0079, 0x004f, 0x002e, 0x002d,
  0x0081, 0x007f, 0x007f, 0x007f, 0x007a, 0x0050, 0x0055, 0x004f,
  0x0080, 0x0080, 0x0080, 0x0080, 0x007b, 0x0077, 0x0077, 0x007b,
  0x007f, 0x0081, 0x0081, 0x0081, 0x00a2, 0x0099, 0x00a3, 0x0080,
  0x007e, 0x0082, 0x0082, 0x00a8, 0x00c4, 0x00c5, 0x00a8, 0x0081,
  0x007d, 0x0083, 0x00a9, 0x00ca, 0x00f0, 0x00ca, 0x00a9, 0x0082,
  0x0083, 0x00a9, 0x00ca, 0x00f0, 0x00ca, 0x00a9, 0x0082, 0x007e,
  0x00aa, 0x00cb, 0x00f6, 0x00f5, 0x00cb, 0x00aa, 0x007d, 0x007d,
  0x00cc, 0x00f7, 0x00fb, 0x00f6, 0x00cc, 0x0055, 0x007c, 0x007c,
  0x00f8, 0x00fc, 0x00fc, 0x00f7, 0x0033, 0x0054, 0x007b, 0x0076,
  0x00fd, 0x00fd, 0x00fd, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b,
  0x00fe, 0x00fe, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029,
  0x00ff, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001,
  0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0x0002,
  0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0x0003, 0x0003,
  0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0x002b, 0x0004, 0x0004,
  0x0055, 0x007c, 0x007c, 0x0077, 0x004d, 0x002c, 0x0005, 0x0005,
  0x007d, 0x007d, 0x007d, 0x0078, 0x004e, 0x002d, 0x0006, 0x002c,
  0x007e, 0x007e, 0x007e, 0x0079, 0x004f, 0x002e, 0x002d, 0x004e,
  0x007f, 0x007f, 0x007f, 0x007a, 0x0050, 0x0055, 0x004f, 0x007a,
  0x0080, 0x0080, 0x0080, 0x007b, 0x0077, 0x0077, 0x007b, 0x007f,
  0x0081, 0x0081, 0x0081, 0x00a2, 0x0099, 0x00a3, 0x0080, 0x0080,
  0x0082, 0x0082, 0x00a8, 0x00c4, 0x00c5, 0x00a8, 0x0081, 0x0081,
  0x0082, 0x00a8, 0x00c4, 0x00c5, 0x00a8, 0x0081, 0x0081, 0x007f,
  0x00a9, 0x00ca, 0x00f0, 0x00ca, 0x00a9, 0x0082, 0x007e, 0x007e,
  0x00cb, 0x00f6, 0x00f5, 0x00cb, 0x00aa, 0x007d, 0x007d, 0x007d,
  0x00f7, 0x00fb, 0x00f6, 0x00cc, 0x0055, 0x007c, 0x007c, 0x0077,
  0x00fc, 0x00fc, 0x00f7, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c,
  0x00fd, 0x00fd, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a,
  0x00fe, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002,
  0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0x0001,
  0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0x0002, 0x0002,
  0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0x0003, 0x0003, 0x0003,
  0x0054, 0x007b, 0x0076, 0x004c, 0x002b, 0x0004, 0x0004, 0x0004,
  0x007c, 0x007c, 0x0077, 0x004d, 0x002c, 0x0005, 0x0005, 0x002b,
  0x007d, 0x007d, 0x0078, 0x004e, 0x002d, 0x0006, 0x002c, 0x004d,
  0x007e, 0x007e, 0x0079, 0x004f, 0x002e, 0x002d, 0x004e, 0x0079,
  0x007f, 0x007f, 0x007a, 0x0050, 0x0055, 0x004f, 0x007a, 0x007e,
  0x0080, 0x0080, 0x007b, 0x0077, 0x0077, 0x007b, 0x007f, 0x007f,
  0x0081, 0x0081, 0x00a2, 0x0099, 0x00a3, 0x0080, 0x0080, 0x0080,
  0x0081, 0x00a2, 0x0099, 0x00a3, 0x0080, 0x0080, 0x0080, 0x0080,
  0x00a8, 0x00c4, 0x00c5, 0x00a8, 0x0081, 0x0081, 0x007f, 0x007f,
  0x00ca, 0x00f0, 0x00ca, 0x00a9, 0x0082, 0x007e, 0x007e, 0x007e,
  0x00f6, 0x00f5, 0x00cb, 0x00aa, 0x007d, 0x007d, 0x007d, 0x0078,
  0x00fb, 0x00f6, 0x00cc, 0x0055, 0x007c, 0x007c, 0x0077, 0x004d,
  0x00fc, 0x00f7, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0x002b,
  0x00fd, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0x0003,
  0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0x0002,
  0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0x0001, 0x0001,
  0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0x0002, 0x0002, 0x0002,
  0x0053, 0x0075, 0x004b, 0x002a, 0x0003, 0x0003, 0x0003, 0x0003,
  0x007b, 0x0076, 0x004c, 0x002b, 0x0004, 0x0004, 0x0004, 0x002a,
  0x007c, 0x0077, 0x004d, 0x002c, 0x0005, 0x0005, 0x002b, 0x004c,
  0x007d, 0x0078, 0x004e, 0x002d, 0x0006, 0x002c, 0x004d, 0x0078,
  0x007e, 0x0079, 0x004f, 0x002e, 0x002d, 0x004e, 0x0079, 0x007d,
  0x007f, 0x007a, 0x0050, 0x0055, 0x004f, 0x007a, 0x007e, 0x007e,
  0x0080, 0x007b, 0x0077, 0x0077, 0x007b, 0x007f, 0x007f, 0x007f,
  0x007b, 0x0077, 0x0077, 0x007b, 0x007f, 0x007f, 0x007f, 0x0081,
  0x00a2, 0x0099, 0x00a3, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
  0x00c4, 0x00c5, 0x00a8, 0x0081, 0x0081, 0x007f, 0x007f, 0x007f,
  0x00f0, 0x00ca, 0x00a9, 0x0082, 0x007e, 0x007e, 0x007e, 0x0079,
  0x00f5, 0x00cb, 0x00aa, 0x007d, 0x007d, 0x007d, 0x0078, 0x004e,
  0x00f6, 0x00cc, 0x0055, 0x007c, 0x007c, 0x0077, 0x004d, 0x002c,
  0x00f7, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0x002b, 0x0004,
  0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0x0003, 0x0003,
  0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0x0002, 0x0002,
  0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
  0x004d, 0x004a, 0x0029, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
  0x0075, 0x004b, 0x002a, 0x0003, 0x0003, 0x0003, 0x0003, 0x0029,
  0x0076, 0x004c, 0x002b, 0x0004, 0x0004, 0x0004, 0x002a, 0x004b,
  0x0077, 0x004d, 0x002c, 0x0005, 0x0005, 0x002b, 0x004c, 0x0077,
  0x0078, 0x004e, 0x002d, 0x0006, 0x002c, 0x004d, 0x0078, 0x007c,
  0x0079, 0x004f, 0x002e, 0x002d, 0x004e, 0x0079, 0x007d, 0x007d,
  0x007a, 0x0050, 0x0055, 0x004f, 0x007a, 0x007e, 0x007e, 0x007e,
  0x0050, 0x0055, 0x004f, 0x007a, 0x007e, 0x007e, 0x007e, 0x0082,
  0x0077, 0x0077, 0x007b, 0x007f, 0x007f, 0x007f, 0x0081, 0x0081,
  0x0099, 0x00a3, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
  0x00c5, 0x00a8, 0x0081, 0x0081, 0x007f, 0x007f, 0x007f, 0x007a,
  0x00ca, 0x00a9, 0x0082, 0x007e, 0x007e, 0x007e, 0x0079, 0x004f,
  0x00cb, 0x00aa, 0x007d, 0x007d, 0x007d, 0x0078, 0x004e, 0x002d,
  0x00cc, 0x0055, 0x007c, 0x007c, 0x0077, 0x004d, 0x002c, 0x0005,
  0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0x002b, 0x0004, 0x0004,
  0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0x0003, 0x0003, 0x0003,
  0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0x0002, 0x0002, 0x0002,
  0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0022, 0x0028, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
  0x004a, 0x0029, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0028,
  0x004b, 0x002a, 0x0003, 0x0003, 0x0003, 0x0003, 0x0029, 0x004a,
  0x004c, 0x002b, 0x0004, 0x0004, 0x0004, 0x002a, 0x004b, 0x0076,
  0x004d, 0x002c, 0x0005, 0x0005, 0x002b, 0x004c, 0x0077, 0x007b,
  0x004e, 0x002d, 0x0006, 0x002c, 0x004d, 0x0078, 0x007c, 0x007c,
  0x004f, 0x002e, 0x002d, 0x004e, 0x0079, 0x007d, 0x007d, 0x007d,
  0x002e, 0x002d, 0x004e, 0x0079, 0x007d, 0x007d, 0x007d, 0x0083,
  0x0055, 0x004f, 0x007a, 0x007e, 0x007e, 0x007e, 0x0082, 0x0082,
  0x0077, 0x007b, 0x007f, 0x007f, 0x007f, 0x0081, 0x0081, 0x0081,
  0x00a3, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x007b,
  0x00a8, 0x0081, 0x0081, 0x007f, 0x007f, 0x007f, 0x007a, 0x0050,
  0x00a9, 0x0082, 0x007e, 0x007e, 0x007e, 0x0079, 0x004f, 0x002e,
  0x00aa, 0x007d, 0x007d, 0x007d, 0x0078, 0x004e, 0x002d, 0x0006,
  0x0055, 0x007c, 0x007c, 0x0077, 0x004d, 0x002c, 0x0005, 0x0005,
  0x0054, 0x007b, 0x0076, 0x004c, 0x002b, 0x0004, 0x0004, 0x0004,
  0x0053, 0x0075, 0x004b, 0x002a, 0x0003, 0x0003, 0x0003, 0x0003,
  0x004d, 0x004a, 0x0029, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
  0x0022, 0x0028, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0028, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0027,
  0x0029, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0028, 0x0049,
  0x002a, 0x0003, 0x0003, 0x0003, 0x0003, 0x0029, 0x004a, 0x0075,
  0x002b, 0x0004, 0x0004, 0x0004, 0x002a, 0x004b, 0x0076, 0x007a,
  0x002c, 0x0005, 0x0005, 0x002b, 0x004c, 0x0077, 0x007b, 0x007b,
  0x002d, 0x0006, 0x002c, 0x004d, 0x0078, 0x007c, 0x007c, 0x007c,
  0x0006, 0x002c, 0x004d, 0x0078, 0x007c, 0x007c, 0x007c, 0x00aa,
  0x002d, 0x004e, 0x0079, 0x007d, 0x007d, 0x007d, 0x0083, 0x00a9,
  0x004f, 0x007a, 0x007e, 0x007e, 0x007e, 0x0082, 0x0082, 0x00a8,
  0x007b, 0x007f, 0x007f, 0x007f, 0x0081, 0x0081, 0x0081, 0x00a2,
  0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x007b, 0x0077,
  0x0081, 0x0081, 0x007f, 0x007f, 0x007f, 0x007a, 0x0050, 0x0055,
  0x0082, 0x007e, 0x007e, 0x007e, 0x0079, 0x004f, 0x002e, 0x002d,
  0x007d, 0x007d, 0x007d, 0x0078, 0x004e, 0x002d, 0x0006, 0x002c,
  0x007c, 0x007c, 0x0077, 0x004d, 0x002c, 0x0005, 0x0005, 0x002b,
  0x007b, 0x0076, 0x004c, 0x002b, 0x0004, 0x0004, 0x0004, 0x002a,
  0x0075, 0x004b, 0x002a, 0x0003, 0x0003, 0x0003, 0x0003, 0x0029,
  0x004a, 0x0029, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0028,
  0x0028, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0027,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022,
  0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e,
  0x0003, 0x0003, 0x0003, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053,
  0x0004, 0x0004, 0x0004, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054,
  0x0005, 0x0005, 0x002b, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055,
  0x0005, 0x002b, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0x00cc,
  0x002c, 0x004d, 0x0078, 0x007c, 0x007c, 0x007c, 0x00aa, 0x00cb,
  0x004e, 0x0079, 0x007d, 0x007d, 0x007d, 0x0083, 0x00a9, 0x00ca,
  0x007a, 0x007e, 0x007e, 0x007e, 0x0082, 0x0082, 0x00a8, 0x00c4,
  0x007f, 0x007f, 0x007f, 0x0081, 0x0081, 0x0081, 0x00a2, 0x0099,
  0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x007b, 0x0077, 0x0077,
  0x0081, 0x007f, 0x007f, 0x007f, 0x007a, 0x0050, 0x0055, 0x004f,
  0x007e, 0x007e, 0x007e, 0x0079, 0x004f, 0x002e, 0x002d, 0x004e,
  0x007d, 0x007d, 0x0078, 0x004e, 0x002d, 0x0006, 0x002c, 0x004d,
  0x007c, 0x0077, 0x004d, 0x002c, 0x0005, 0x0005, 0x002b, 0x004c,
  0x0076, 0x004c, 0x002b, 0x0004, 0x0004, 0x0004, 0x002a, 0x004b,
  0x004b, 0x002a, 0x0003, 0x0003, 0x0003, 0x0003, 0x0029, 0x004a,
  0x0029, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0028, 0x0049,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c,
  0x0002, 0x0002, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031,
  0x0003, 0x0003, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032,
  0x0004, 0x0004, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033,
  0x0004, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0x00f8,
  0x002b, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0x00cc, 0x00f7,
  0x004d, 0x0078, 0x007c, 0x007c, 0x007c, 0x00aa, 0x00cb, 0x00f6,
  0x0079, 0x007d, 0x007d, 0x007d, 0x0083, 0x00a9, 0x00ca, 0x00f0,
  0x007e, 0x007e, 0x007e, 0x0082, 0x0082, 0x00a8, 0x00c4, 0x00c5,
  0x007f, 0x007f, 0x0081, 0x0081, 0x0081, 0x00a2, 0x0099, 0x00a3,
  0x0080, 0x0080, 0x0080, 0x0080, 0x007b, 0x0077, 0x0077, 0x007b,
  0x007f, 0x007f, 0x007f, 0x007a, 0x0050, 0x0055, 0x004f, 0x007a,
  0x007e, 0x007e, 0x0079, 0x004f, 0x002e, 0x002d, 0x004e, 0x0079,
  0x007d, 0x0078, 0x004e, 0x002d, 0x0006, 0x002c, 0x004d, 0x0078,
  0x0077, 0x004d, 0x002c, 0x0005, 0x0005, 0x002b, 0x004c, 0x0077,
  0x004c, 0x002b, 0x0004, 0x0004, 0x0004, 0x002a, 0x004b, 0x0076,
  0x002a, 0x0003, 0x0003, 0x0003, 0x0003, 0x0029, 0x004a, 0x0075,
  0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005,
  0x0002, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006,
  0x0003, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007,
  0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0x00fd,
  0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0x00f8, 0x00fc,
  0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0x00cc, 0x00f7, 0x00fb,
  0x0078, 0x007c, 0x007c, 0x007c, 0x00aa, 0x00cb, 0x00f6, 0x00f5,
  0x007d, 0x007d, 0x007d, 0x0083, 0x00a9, 0x00ca, 0x00f0, 0x00ca,
  0x007e, 0x007e, 0x0082, 0x0082, 0x00a8, 0x00c4, 0x00c5, 0x00a8,
  0x007f, 0x0081, 0x0081, 0x0081, 0x00a2, 0x0099, 0x00a3, 0x0080,
  0x0080, 0x0080, 0x0080, 0x007b, 0x0077, 0x0077, 0x007b, 0x007f,
  0x007f, 0x007f, 0x007a, 0x0050, 0x0055, 0x004f, 0x007a, 0x007e,
  0x007e, 0x0079, 0x004f, 0x002e, 0x002d, 0x004e, 0x0079, 0x007d,
  0x0078, 0x004e, 0x002d, 0x0006, 0x002c, 0x004d, 0x0078, 0x007c,
  0x004d, 0x002c, 0x0005, 0x0005, 0x002b, 0x004c, 0x0077, 0x007b,
  0x002b, 0x0004, 0x0004, 0x0004, 0x002a, 0x004b, 0x0076, 0x007a,
  0x0003, 0x0003, 0x0003, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053,
  0x0002, 0x0002, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001,
  0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002,
  0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0x00fe,
  0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0x00fd, 0x00fd,
  0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0x00f8, 0x00fc, 0x00fc,
  0x0077, 0x007b, 0x007b, 0x0055, 0x00cc, 0x00f7, 0x00fb, 0x00f6,
  0x007c, 0x007c, 0x007c, 0x00aa, 0x00cb, 0x00f6, 0x00f5, 0x00cb,
  0x007d, 0x007d, 0x0083, 0x00a9, 0x00ca, 0x00f0, 0x00ca, 0x00a9,
  0x007e, 0x0082, 0x0082, 0x00a8, 0x00c4, 0x00c5, 0x00a8, 0x0081,
  0x0081, 0x0081, 0x0081, 0x00a2, 0x0099, 0x00a3, 0x0080, 0x0080,
  0x0080, 0x0080, 0x007b, 0x0077, 0x0077, 0x007b, 0x007f, 0x007f,
  0x007f, 0x007a, 0x0050, 0x0055, 0x004f, 0x007a, 0x007e, 0x007e,
  0x0079, 0x004f, 0x002e, 0x002d, 0x004e, 0x0079, 0x007d, 0x007d,
  0x004e, 0x002d, 0x0006, 0x002c, 0x004d, 0x0078, 0x007c, 0x007c,
  0x002c, 0x0005, 0x0005, 0x002b, 0x004c, 0x0077, 0x007b, 0x007b,
  0x0004, 0x0004, 0x0004, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054,
  0x0003, 0x0003, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032,
  0x0002, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006,
  0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001,
  0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0x00ff,
  0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0x00fe, 0x00fe,
  0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0x00fd, 0x00fd, 0x00fd,
  0x0076, 0x007a, 0x0054, 0x0033, 0x00f8, 0x00fc, 0x00fc, 0x00f7,
  0x007b, 0x007b, 0x0055, 0x00cc, 0x00f7, 0x00fb, 0x00f6, 0x00cc,
  0x007c, 0x007c, 0x00aa, 0x00cb, 0x00f6, 0x00f5, 0x00cb, 0x00aa,
  0x007d, 0x0083, 0x00a9, 0x00ca, 0x00f0, 0x00ca, 0x00a9, 0x0082,
  0x0082, 0x0082, 0x00a8, 0x00c4, 0x00c5, 0x00a8, 0x0081, 0x0081,
  0x0081, 0x0081, 0x00a2, 0x0099, 0x00a3, 0x0080, 0x0080, 0x0080,
  0x0080, 0x007b, 0x0077, 0x0077, 0x007b, 0x007f, 0x007f, 0x007f,
  0x007a, 0x0050, 0x0055, 0x004f, 0x007a, 0x007e, 0x007e, 0x007e,
  0x004f, 0x002e, 0x002d, 0x004e, 0x0079, 0x007d, 0x007d, 0x007d,
  0x002d, 0x0006, 0x002c, 0x004d, 0x0078, 0x007c, 0x007c, 0x007c,
  0x0005, 0x0005, 0x002b, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055,
  0x0004, 0x0004, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033,
  0x0003, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007,
  0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002,
  0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_uabdl2_8H = 361;

#endif  // VIXL_SIM_UABDL2_8H_TRACE_AARCH64_H_
