import { Data } from "./data.js";
import { Accounts } from "./accounts.js";
import { Authenticate } from "./authenticate.js";
import { Sessions } from "./sessions.js";
import { TimeDate } from "./timeDate.js";
import { Layouts } from "./layouts.js";
import { Power } from "./power.js";
import { Battery } from "./battery.js";
import { Brightness } from "./brightness.js";
import { Backgrounds } from "./background.js";
import "./mock.js";

declare global {
  interface Window {
    themeData: Data;
    accounts: Accounts;
    sessions: Sessions;
    authenticate: Authenticate;
    timeDate: TimeDate;
    layouts: Layouts;
    power: Power;
    battery: Battery;
    brightness: Brightness;
    backgrounds: Backgrounds;

    wait(ms: number): Promise<void>;
  }
}

async function wait(ms: number): Promise<void> {
  return new Promise((resolve) => {
    setTimeout(() => {
      resolve();
    }, ms);
  });
}

window.wait = wait;

async function initGreeter(): Promise<void> {
  if (window.greeter_config?.greeter.debug_mode) {
    // Run debug
  }

  window.themeData = new Data();

  window.accounts = new Accounts();

  window.sessions = new Sessions();

  window.authenticate = new Authenticate();

  window.timeDate = new TimeDate();

  window.layouts = new Layouts();

  window.power = new Power();

  window.battery = new Battery();

  window.brightness = new Brightness();

  window.backgrounds = new Backgrounds();
  await window.backgrounds.init();

  if (window.lightdm?.lock_hint) {
    document.querySelector("#lock-label")?.classList.remove("hide");
  }
}

window.addEventListener("GreeterReady", () => {
  initGreeter();
});
