/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.LocalizedException;
import flex.messaging.MessageException;
import flex.messaging.io.AbstractProxy;
import flex.messaging.io.BeanProxy;
import flex.messaging.io.DictionaryProxy;
import flex.messaging.io.MapProxy;
import flex.messaging.io.PageableRowSet;
import flex.messaging.io.PageableRowSetProxy;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.ThrowableProxy;
import flex.messaging.io.amf.ASObject;
import java.util.AbstractMap;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.sql.RowSet;

public class PropertyProxyRegistry {
    private Map classRegistry = new IdentityHashMap();
    private static final PropertyProxyRegistry registry = new PropertyProxyRegistry();
    private static boolean preregistered = false;

    public static PropertyProxyRegistry getRegistry() {
        if (!preregistered) {
            PropertyProxyRegistry.preRegister();
            preregistered = true;
        }
        return registry;
    }

    private static void preRegister() {
        ThrowableProxy proxy = new ThrowableProxy();
        registry.register(MessageException.class, proxy);
        registry.register(LocalizedException.class, proxy);
        registry.register(Throwable.class, proxy);
        MapProxy mapProxy = new MapProxy();
        registry.register(ASObject.class, mapProxy);
        registry.register(HashMap.class, mapProxy);
        registry.register(AbstractMap.class, mapProxy);
        registry.register(Map.class, mapProxy);
    }

    public static PropertyProxy getProxyAndRegister(Object instance) {
        if (instance instanceof PropertyProxy) {
            return (PropertyProxy)instance;
        }
        Class<?> c = instance.getClass();
        PropertyProxy proxy = PropertyProxyRegistry.getRegistry().getProxyAndRegister(c);
        if (proxy == null) {
            proxy = PropertyProxyRegistry.guessProxy(instance);
            PropertyProxyRegistry.getRegistry().register(c, proxy);
        }
        return proxy;
    }

    public static PropertyProxy getProxy(Object instance) {
        if (instance instanceof PropertyProxy) {
            return (PropertyProxy)instance;
        }
        Class<?> c = instance.getClass();
        PropertyProxy proxy = PropertyProxyRegistry.getRegistry().getProxy(c);
        if (proxy == null) {
            proxy = PropertyProxyRegistry.guessProxy(instance);
        }
        proxy = (PropertyProxy)proxy.clone();
        proxy.setDefaultInstance(instance);
        return proxy;
    }

    private static PropertyProxy guessProxy(Object instance) {
        AbstractProxy proxy = instance instanceof Map ? new MapProxy() : (instance instanceof Throwable ? new ThrowableProxy() : (instance instanceof PageableRowSet || instance instanceof RowSet ? new PageableRowSetProxy() : (instance instanceof Dictionary ? new DictionaryProxy() : new BeanProxy())));
        return proxy;
    }

    public PropertyProxy getProxy(Class c) {
        return this.getProxy(c, true, false);
    }

    public PropertyProxy getProxyAndRegister(Class c) {
        return this.getProxy(c, true, true);
    }

    public PropertyProxy getProxy(Class c, boolean searchHierarchy, boolean autoRegister) {
        Class<?> superclass;
        PropertyProxy proxy;
        if (c == null) {
            return null;
        }
        if (c.isArray()) {
            c = c.getComponentType();
        }
        if ((proxy = (PropertyProxy)this.classRegistry.get(c)) == null && searchHierarchy) {
            Class<?>[] interfaces = c.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> interfaceClass = interfaces[i];
                proxy = (PropertyProxy)this.classRegistry.get(interfaceClass);
                if (proxy != null && autoRegister) {
                    this.register(c, proxy);
                    break;
                }
                proxy = this.getProxy(interfaceClass, searchHierarchy, autoRegister);
                if (proxy != null) break;
            }
        }
        if (proxy == null && searchHierarchy && (superclass = c.getSuperclass()) != null && (proxy = this.getProxy(superclass, searchHierarchy, autoRegister)) != null && autoRegister) {
            this.register(c, proxy);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.classRegistry;
        synchronized (map) {
            this.classRegistry.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Class c, PropertyProxy proxy) {
        Map map = this.classRegistry;
        synchronized (map) {
            this.classRegistry.put(c, proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Class c) {
        Map map = this.classRegistry;
        synchronized (map) {
            this.classRegistry.remove(c);
        }
    }
}

