/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Defines SAP component states 
 */

#ifndef LLC_S_ST_H
#define LLC_S_ST_H


#define SAP_STATE_INACTIVE         1
#define SAP_STATE_ACTIVE           2

#define NBR_SAP_STATES             2       /* size of state table */


#ifndef LLC_MAIN_C


/* structures and types */

/* SAP state table structure */
typedef struct
{
#if 0
   us8                event;
#else
   sap_event_t        event;
#endif
   us8                next_state;
   sap_action_t *     event_actions;
} sap_state_transition_t;


typedef struct
{
    us8  		        current_state;
    sap_state_transition_t **
                       transitions;
} sap_state_t;


#ifdef LLC_S_ST_C
#define EXTRN
#else
#define EXTRN extern

/* only access to SAP state table */
EXTRN sap_state_t          Sap_state_table [NBR_SAP_STATES];

#endif /* LLC_S_ST_C */


#endif /* LLC_MAIN_C */


#undef EXTRN
#endif /* LLC_S_ST_H */

