/*
 *
 *  Embedded Linux library
 *
 *  Copyright (C) 2011-2014  Intel Corporation. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <assert.h>
#include <math.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

#include <ell/ell.h>

#include "ell/dbus-private.h"

static bool do_print = true;

struct message_data {
	const char *type;
	const char *sender;
	const char *path;
	const char *interface;
	const char *member;
	const char *destination;
	const char *signature;
	uint32_t serial;
	uint32_t reply_serial;
	bool no_reply;
	bool auto_start;
	uint32_t unix_fds;
	const unsigned char *binary;
	size_t binary_len;
	int *fds;
};

static const unsigned char message_binary_basic_1[] = {
			0x6c, 0x01, 0x00, 0x01, 0x13, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x01, 0x73, 0x00, 0x00,
			0x0e, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75,
			0x73, 0x20, 0x54, 0x6f, 0x72, 0x76, 0x61, 0x6c,
			0x64, 0x73, 0x00,
};

static const struct message_data message_data_basic_1 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "s",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_basic_1,
	.binary_len	= 147,
};

static const unsigned char message_binary_basic_2[] = {
			0x6c, 0x01, 0x00, 0x01, 0x19, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x02, 0x73, 0x73, 0x00,
			0x05, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75,
			0x73, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x54, 0x6f, 0x72, 0x76, 0x61, 0x6c, 0x64, 0x73,
			0x00,
};

static const struct message_data message_data_basic_2 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "ss",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_basic_2,
	.binary_len	= 153,
};

static const unsigned char message_binary_basic_3[] = {
			0x6c, 0x01, 0x00, 0x01, 0x18, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x02, 0x73, 0x62, 0x00,
			0x0e, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75,
			0x73, 0x20, 0x54, 0x6f, 0x72, 0x76, 0x61, 0x6c,
			0x64, 0x73, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
};

static const struct message_data message_data_basic_3 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "sb",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_basic_3,
	.binary_len	= 152,
};

static const unsigned char message_binary_basic_4[] = {
			0x6c, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x01, 0x79, 0x00, 0x00,
			0x17,
};

static const struct message_data message_data_basic_4 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "y",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_basic_4,
	.binary_len	= 129,
};

static const unsigned char message_binary_basic_5[] = {
			0x6c, 0x01, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x01, 0x71, 0x00, 0x00,
			0x2a, 0x00,
};

static const struct message_data message_data_basic_5 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "q",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_basic_5,
	.binary_len	= 130,
};

static const unsigned char message_binary_basic_6[] = {
			0x6c, 0x01, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x01, 0x75, 0x00, 0x00,
			0x67, 0x12, 0x00, 0x00,
};

static const struct message_data message_data_basic_6 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "u",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_basic_6,
	.binary_len	= 132,
};

static const unsigned char message_binary_basic_7[] = {
			0x6c, 0x01, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x01, 0x74, 0x00, 0x00,
			0x10, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static const struct message_data message_data_basic_7 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "t",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_basic_7,
	.binary_len	= 136,
};

static const unsigned char message_binary_basic_8[] = {
			0x6c, 0x01, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x01, 0x6e, 0x00, 0x00,
			0xd6, 0xff,
};

static const struct message_data message_data_basic_8 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "n",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_basic_8,
	.binary_len	= 130,
};

static const unsigned char message_binary_basic_9[] = {
			0x6c, 0x01, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x01, 0x69, 0x00, 0x00,
			0x99, 0xed, 0xff, 0xff,
};

static const struct message_data message_data_basic_9 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "i",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_basic_9,
	.binary_len	= 132,
};

static const unsigned char message_binary_basic_10[] = {
			0x6c, 0x01, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x01, 0x78, 0x00, 0x00,
			0xf0, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

static const struct message_data message_data_basic_10 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "x",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_basic_10,
	.binary_len	= 136,
};

static const unsigned char message_binary_basic_11[] = {
			0x6c, 0x01, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x01, 0x64, 0x00, 0x00,
			0x18, 0x2d, 0x44, 0x54, 0xfb, 0x21, 0x09, 0x40,
};

static const struct message_data message_data_basic_11 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "d",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_basic_11,
	.binary_len	= 136,
};

static const unsigned char message_binary_struct_1[] = {
			0x6c, 0x01, 0x00, 0x01, 0x19, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x72, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x04, 0x28, 0x73, 0x73,
			0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x05, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75,
			0x73, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x54, 0x6f, 0x72, 0x76, 0x61, 0x6c, 0x64, 0x73,
			0x00,
};

static const struct message_data message_data_struct_1 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "(ss)",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_struct_1,
	.binary_len	= 161,
};

static const unsigned char message_binary_struct_2[] = {
			0x6c, 0x01, 0x00, 0x01, 0x31, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x75, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x07, 0x28, 0x73, 0x28,
			0x73, 0x73, 0x29, 0x29, 0x00, 0x00, 0x00, 0x00,
			0x0e, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75,
			0x73, 0x20, 0x54, 0x6f, 0x72, 0x76, 0x61, 0x6c,
			0x64, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x05, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75,
			0x73, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x54, 0x6f, 0x72, 0x76, 0x61, 0x6c, 0x64, 0x73,
			0x00,
};

static const struct message_data message_data_struct_2 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "(s(ss))",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_struct_2,
	.binary_len	= 185,
};

static const unsigned char message_binary_struct_3[] = {
			0x6c, 0x01, 0x00, 0x01, 0xfc, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xce, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x60, 0x28, 0x69, 0x28,
			0x69, 0x28, 0x69, 0x28, 0x69, 0x28, 0x69, 0x28,
			0x69, 0x28, 0x69, 0x28, 0x69, 0x28, 0x69, 0x28,
			0x69, 0x28, 0x69, 0x28, 0x69, 0x28, 0x69, 0x28,
			0x69, 0x28, 0x69, 0x28, 0x69, 0x28, 0x69, 0x28,
			0x69, 0x28, 0x69, 0x28, 0x69, 0x28, 0x69, 0x28,
			0x69, 0x28, 0x69, 0x28, 0x69, 0x28, 0x69, 0x28,
			0x69, 0x28, 0x69, 0x28, 0x69, 0x28, 0x69, 0x28,
			0x69, 0x28, 0x69, 0x28, 0x69, 0x29, 0x29, 0x29,
			0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29,
			0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29,
			0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29,
			0x29, 0x29, 0x29, 0x29, 0x29, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x1f, 0x00, 0x00, 0x00};

#define MESSAGE_SIGNATURE_STRUCT_3					\
	"(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i" \
	"))))))))))))))))))))))))))))))))"

static const struct message_data message_data_struct_3 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= MESSAGE_SIGNATURE_STRUCT_3,
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_struct_3,
	.binary_len	= 476,
};

#define MESSAGE_SIGNATURE_STRUCT_4					\
	"(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i(i" \
	")))))))))))))))))))))))))))))))))"

static const struct message_data message_data_struct_4 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= MESSAGE_SIGNATURE_STRUCT_4,
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
};

static const unsigned char message_binary_array_1[] = {
			0x6c, 0x01, 0x00, 0x01, 0x1d, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x02, 0x61, 0x73, 0x00,
			0x19, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
			0x4c, 0x69, 0x6e, 0x75, 0x73, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x54, 0x6f, 0x72, 0x76,
			0x61, 0x6c, 0x64, 0x73, 0x00,
};

static const struct message_data message_data_array_1 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "as",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_array_1,
	.binary_len	= 157,
};

static const unsigned char message_binary_array_2[] = {
			0x6c, 0x01, 0x00, 0x01, 0x10, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x02, 0x61, 0x62, 0x00,
			0x0c, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static const struct message_data message_data_array_2 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "ab",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_array_2,
	.binary_len	= 144,
};

static const unsigned char message_binary_array_3[] = {
			0x6c, 0x01, 0x00, 0x01, 0x40, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x71, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x03, 0x61, 0x61, 0x73,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x3c, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x0e, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75,
			0x73, 0x20, 0x54, 0x6f, 0x72, 0x76, 0x61, 0x6c,
			0x64, 0x73, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00,
			0x05, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75,
			0x73, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x54, 0x6f, 0x72, 0x76, 0x61, 0x6c, 0x64, 0x73,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static const struct message_data message_data_array_3 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "aas",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_array_3,
	.binary_len	= 200,
};

static const unsigned char message_binary_array_4[] = {
			0x6c, 0x01, 0x00, 0x01, 0x41, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x73, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x05, 0x61, 0x28, 0x73,
			0x73, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x05, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75,
			0x73, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x54, 0x6f, 0x72, 0x76, 0x61, 0x6c, 0x64, 0x73,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x00, 0x00, 0x00, 0x4d, 0x61, 0x72, 0x63,
			0x65, 0x6c, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x48, 0x6f, 0x6c, 0x74, 0x6d, 0x61, 0x6e, 0x6e,
			0x00,
};

static const struct message_data message_data_array_4 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "a(ss)",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_array_4,
	.binary_len	= 201,
};

static const unsigned char message_binary_array_5[] = {
			0x6c, 0x01, 0x00, 0x01, 0x3d, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x72, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x04, 0x61, 0x73, 0x61,
			0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x19, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
			0x4c, 0x69, 0x6e, 0x75, 0x73, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x54, 0x6f, 0x72, 0x76,
			0x61, 0x6c, 0x64, 0x73, 0x00, 0x00, 0x00, 0x00,
			0x19, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x4d, 0x61, 0x72, 0x63, 0x65, 0x6c, 0x00, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x48, 0x6f, 0x6c, 0x74,
			0x6d, 0x61, 0x6e, 0x6e, 0x00,
};

static const struct message_data message_data_array_5 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "asas",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_array_5,
	.binary_len	= 197,
};

static const unsigned char message_binary_array_6[] = {
			0x6c, 0x01, 0x00, 0x01, 0x24, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x02, 0x61, 0x76, 0x00,
			0x20, 0x00, 0x00, 0x00, 0x01, 0x73, 0x00, 0x00,
			0x0e, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75,
			0x73, 0x20, 0x54, 0x6f, 0x72, 0x76, 0x61, 0x6c,
			0x64, 0x73, 0x00, 0x01, 0x62, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00,
};

static const struct message_data message_data_array_6 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "av",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_array_6,
	.binary_len	= 164,
};

static const unsigned char message_binary_dict_1[] = {
			0x6c, 0x01, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x73, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x05, 0x61, 0x7b, 0x73,
			0x76, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static const struct message_data message_data_dict_1 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "a{sv}",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_dict_1,
	.binary_len	= 144,
};

static const unsigned char message_binary_dict_2[] = {
			0x6c, 0x01, 0x00, 0x01, 0x40, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x73, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x05, 0x61, 0x7b, 0x73,
			0x76, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x4e, 0x61, 0x6d, 0x65,
			0x00, 0x01, 0x73, 0x00, 0x0e, 0x00, 0x00, 0x00,
			0x4c, 0x69, 0x6e, 0x75, 0x73, 0x20, 0x54, 0x6f,
			0x72, 0x76, 0x61, 0x6c, 0x64, 0x73, 0x00, 0x00,
			0x09, 0x00, 0x00, 0x00, 0x44, 0x65, 0x76, 0x65,
			0x6c, 0x6f, 0x70, 0x65, 0x72, 0x00, 0x01, 0x62,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
};

static const struct message_data message_data_dict_2 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "a{sv}",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_dict_2,
	.binary_len	= 200,
};

static const unsigned char message_binary_dict_3[] = {
			0x6c, 0x01, 0x00, 0x01, 0x41, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x73, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x05, 0x61, 0x7b, 0x73,
			0x73, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x05, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75,
			0x73, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x54, 0x6f, 0x72, 0x76, 0x61, 0x6c, 0x64, 0x73,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x00, 0x00, 0x00, 0x4d, 0x61, 0x72, 0x63,
			0x65, 0x6c, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x48, 0x6f, 0x6c, 0x74, 0x6d, 0x61, 0x6e, 0x6e,
			0x00,
};

static const struct message_data message_data_dict_3 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "a{ss}",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_dict_3,
	.binary_len	= 201,
};

static const unsigned char message_binary_variant_1[] = {
			0x6c, 0x01, 0x00, 0x01, 0x17, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x01, 0x76, 0x00, 0x00,
			0x01, 0x73, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
			0x4c, 0x69, 0x6e, 0x75, 0x73, 0x20, 0x54, 0x6f,
			0x72, 0x76, 0x61, 0x6c, 0x64, 0x73, 0x00,
};

static const struct message_data message_data_variant_1 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "v",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_variant_1,
	.binary_len	= 151,
};

static const unsigned char message_binary_variant_2[] = {
			0x6c, 0x01, 0x00, 0x01, 0x21, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x01, 0x76, 0x00, 0x00,
			0x02, 0x61, 0x73, 0x00, 0x19, 0x00, 0x00, 0x00,
			0x05, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75,
			0x73, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x54, 0x6f, 0x72, 0x76, 0x61, 0x6c, 0x64, 0x73,
			0x00,
};

static const struct message_data message_data_variant_2 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "v",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_variant_2,
	.binary_len	= 161,
};

static const unsigned char message_binary_variant_3[] = {
			0x6c, 0x01, 0x00, 0x01, 0x28, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x01, 0x76, 0x00, 0x00,
			0x05, 0x28, 0x73, 0x73, 0x62, 0x29, 0x00, 0x00,
			0x05, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75,
			0x73, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x54, 0x6f, 0x72, 0x76, 0x61, 0x6c, 0x64, 0x73,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
};

static const struct message_data message_data_variant_3 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "v",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_variant_3,
	.binary_len	= 168,
};

static const unsigned char message_binary_variant_4[] = {
			0x6c, 0x01, 0x00, 0x01, 0x1b, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x01, 0x76, 0x00, 0x00,
			0x01, 0x76, 0x00, 0x01, 0x73, 0x00, 0x00, 0x00,
			0x0e, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75,
			0x73, 0x20, 0x54, 0x6f, 0x72, 0x76, 0x61, 0x6c,
			0x64, 0x73, 0x00,
};

static const struct message_data message_data_variant_4 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "v",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_variant_4,
	.binary_len	= 155,
};

static const unsigned char message_binary_variant_5[] = {
			0x6c, 0x01, 0x00, 0x01, 0x24, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x01, 0x76, 0x00, 0x00,
			0x04, 0x28, 0x73, 0x76, 0x29, 0x00, 0x00, 0x00,
			0x0e, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75,
			0x73, 0x20, 0x54, 0x6f, 0x72, 0x76, 0x61, 0x6c,
			0x64, 0x73, 0x00, 0x01, 0x62, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00,
};

static const struct message_data message_data_variant_5 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "v",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_variant_5,
	.binary_len	= 164,
};

static const unsigned char message_binary_complex_1[] = {
			0x6c, 0x01, 0x00, 0x01, 0x58, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x06, 0x6f, 0x61, 0x7b,
			0x73, 0x76, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x13, 0x00, 0x00, 0x00, 0x2f, 0x63, 0x6f, 0x6d,
			0x2f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
			0x2f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x00,
			0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x4e, 0x61, 0x6d, 0x65,
			0x00, 0x01, 0x73, 0x00, 0x0e, 0x00, 0x00, 0x00,
			0x4c, 0x69, 0x6e, 0x75, 0x73, 0x20, 0x54, 0x6f,
			0x72, 0x76, 0x61, 0x6c, 0x64, 0x73, 0x00, 0x00,
			0x09, 0x00, 0x00, 0x00, 0x44, 0x65, 0x76, 0x65,
			0x6c, 0x6f, 0x70, 0x65, 0x72, 0x00, 0x01, 0x62,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
};

static const struct message_data message_data_complex_1 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "oa{sv}",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_complex_1,
	.binary_len	= 224,
};

static const unsigned char message_binary_complex_2[] = {
			0x6c, 0x01, 0x00, 0x01, 0x88, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
			0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
			0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
			0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
			0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
			0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
			0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x09, 0x61, 0x28, 0x6f,
			0x61, 0x7b, 0x73, 0x76, 0x7d, 0x29, 0x00, 0x00,
			0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x14, 0x00, 0x00, 0x00, 0x2f, 0x63, 0x6f, 0x6d,
			0x2f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
			0x2f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x31,
			0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x4e, 0x61, 0x6d, 0x65,
			0x00, 0x01, 0x73, 0x00, 0x0e, 0x00, 0x00, 0x00,
			0x4c, 0x69, 0x6e, 0x75, 0x73, 0x20, 0x54, 0x6f,
			0x72, 0x76, 0x61, 0x6c, 0x64, 0x73, 0x00, 0x00,
			0x14, 0x00, 0x00, 0x00, 0x2f, 0x63, 0x6f, 0x6d,
			0x2f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
			0x2f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x32,
			0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x4e, 0x61, 0x6d, 0x65,
			0x00, 0x01, 0x73, 0x00, 0x0f, 0x00, 0x00, 0x00,
			0x4d, 0x61, 0x72, 0x63, 0x65, 0x6c, 0x20, 0x48,
			0x6f, 0x6c, 0x74, 0x6d, 0x61, 0x6e, 0x6e, 0x00,
};

static const struct message_data message_data_complex_2 = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "a(oa{sv})",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_complex_2,
	.binary_len	= 272,
};

static const unsigned char message_binary_complex_3[] = {
			0x6c, 0x01, 0x00, 0x01, 0x61, 0x00, 0x00, 0x00,
			0x02, 0x00, 0x00, 0x00, 0xbe, 0x00, 0x00, 0x00,
			0x01, 0x01, 0x6f, 0x00, 0x25, 0x00, 0x00, 0x00,
			0x2f, 0x6f, 0x72, 0x67, 0x2f, 0x66, 0x72, 0x65,
			0x65, 0x64, 0x65, 0x73, 0x6b, 0x74, 0x6f, 0x70,
			0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b,
			0x69, 0x74, 0x31, 0x2f, 0x41, 0x75, 0x74, 0x68,
			0x6f, 0x72, 0x69, 0x74, 0x79, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x1a, 0x00, 0x00, 0x00,
			0x6f, 0x72, 0x67, 0x2e, 0x66, 0x72, 0x65, 0x65,
			0x64, 0x65, 0x73, 0x6b, 0x74, 0x6f, 0x70, 0x2e,
			0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x69,
			0x74, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x01, 0x73, 0x00, 0x24, 0x00, 0x00, 0x00,
			0x6f, 0x72, 0x67, 0x2e, 0x66, 0x72, 0x65, 0x65,
			0x64, 0x65, 0x73, 0x6b, 0x74, 0x6f, 0x70, 0x2e,
			0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x69,
			0x74, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f,
			0x72, 0x69, 0x74, 0x79, 0x00, 0x00, 0x00, 0x00,
			0x03, 0x01, 0x73, 0x00, 0x12, 0x00, 0x00, 0x00,
			0x43, 0x68, 0x65, 0x63, 0x6b, 0x41, 0x75, 0x74,
			0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
			0x6f, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x10, 0x28, 0x73, 0x61,
			0x7b, 0x73, 0x76, 0x7d, 0x29, 0x73, 0x61, 0x7b,
			0x73, 0x73, 0x7d, 0x75, 0x73, 0x00, 0x00, 0x00,
			0x0f, 0x00, 0x00, 0x00, 0x73, 0x79, 0x73, 0x74,
			0x65, 0x6d, 0x2d, 0x62, 0x75, 0x73, 0x2d, 0x6e,
			0x61, 0x6d, 0x65, 0x00, 0x18, 0x00, 0x00, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x6e, 0x61, 0x6d, 0x65,
			0x00, 0x01, 0x73, 0x00, 0x07, 0x00, 0x00, 0x00,
			0x3a, 0x31, 0x2e, 0x33, 0x33, 0x30, 0x37, 0x00,
			0x1e, 0x00, 0x00, 0x00, 0x6f, 0x72, 0x67, 0x2e,
			0x66, 0x72, 0x65, 0x65, 0x64, 0x65, 0x73, 0x6b,
			0x74, 0x6f, 0x70, 0x2e, 0x70, 0x6f, 0x6c, 0x69,
			0x63, 0x79, 0x6b, 0x69, 0x74, 0x2e, 0x65, 0x78,
			0x65, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00,
};

static const struct message_data message_data_complex_3 = {
	.type		= "method_call",
	.path		= "/org/freedesktop/PolicyKit1/Authority",
	.interface	= "org.freedesktop.PolicyKit1.Authority",
	.member		= "CheckAuthorization",
	.destination	= "org.freedesktop.PolicyKit1",
	.signature	= "(sa{sv})sa{ss}us",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 0,
	.binary		= message_binary_complex_3,
	.binary_len	= 305,
};

static const unsigned char message_binary_complex_4[] = {
			0x6c, 0x02, 0x01, 0x01, 0x31, 0x00, 0x00, 0x00,
			0x45, 0x2e, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x09, 0x28, 0x62, 0x62,
			0x61, 0x7b, 0x73, 0x73, 0x7d, 0x29, 0x00, 0x00,
			0x05, 0x01, 0x75, 0x00, 0x02, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x07, 0x00, 0x00, 0x00,
			0x3a, 0x31, 0x2e, 0x33, 0x33, 0x30, 0x37, 0x00,
			0x07, 0x01, 0x73, 0x00, 0x04, 0x00, 0x00, 0x00,
			0x3a, 0x31, 0x2e, 0x38, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x10, 0x00, 0x00, 0x00, 0x70, 0x6f, 0x6c, 0x6b,
			0x69, 0x74, 0x2e, 0x64, 0x69, 0x73, 0x6d, 0x69,
			0x73, 0x73, 0x65, 0x64, 0x00, 0x00, 0x00, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x74, 0x72, 0x75, 0x65,
			0x00,
};

static const struct message_data message_data_complex_4 = {
	.binary		= message_binary_complex_4,
	.binary_len	= 121,
};

static const unsigned char message_binary_complex_5[] = {
			0x6c, 0x02, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00,
			0x64, 0x2e, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00,
			0x08, 0x01, 0x67, 0x00, 0x09, 0x28, 0x62, 0x62,
			0x61, 0x7b, 0x73, 0x73, 0x7d, 0x29, 0x00, 0x00,
			0x05, 0x01, 0x75, 0x00, 0x02, 0x00, 0x00, 0x00,
			0x06, 0x01, 0x73, 0x00, 0x07, 0x00, 0x00, 0x00,
			0x3a, 0x31, 0x2e, 0x33, 0x33, 0x30, 0x39, 0x00,
			0x07, 0x01, 0x73, 0x00, 0x04, 0x00, 0x00, 0x00,
			0x3a, 0x31, 0x2e, 0x38, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static const struct message_data message_data_complex_5 = {
	.binary		= message_binary_complex_5,
	.binary_len	= 88,
};

static void do_debug(const char *str, void *user_data)
{
	const char *prefix = user_data;

	l_info("%s%s", prefix, str);
}

static struct l_dbus_message *check_message(const struct message_data *msg_data)
{
	struct l_dbus_message *msg;

	msg = dbus_message_from_blob(msg_data->binary, msg_data->binary_len,
					msg_data->fds, msg_data->unix_fds);
	assert(msg);

	if (do_print)
		l_util_hexdump(false, msg_data->binary, msg_data->binary_len,
							do_debug, "[MSG] ");

	if (msg_data->sender) {
		const char *sender;

		sender = l_dbus_message_get_sender(msg);
		assert(sender);
		assert(!strcmp(msg_data->sender, sender));

		if (do_print)
			l_info("sender=%s", sender);
        }

	if (msg_data->destination) {
		const char *destination;

		destination = l_dbus_message_get_destination(msg);
		assert(destination);
		assert(!strcmp(msg_data->destination, destination));

		if (do_print)
			l_info("destination=%s", destination);
	}

	return msg;
}

static struct l_dbus_message *build_message(const struct message_data *msg_data)
{
	struct l_dbus_message *msg;

	msg = _dbus_message_new_method_call(1, msg_data->destination,
			msg_data->path, msg_data->interface, msg_data->member);
	assert(msg);

	return msg;
}

static void compare_message(struct l_dbus_message *msg,
					const struct message_data *msg_data)
{
	bool result;

	/* Shut valgrind up */
	_dbus_message_set_serial(msg, 0);

	if (do_print) {
		void *blob;
		void *header, *body;
		size_t header_size, body_size;

		header = _dbus_message_get_header(msg, &header_size);
		body = _dbus_message_get_body(msg, &body_size);
		blob = l_malloc(header_size + body_size);
		memcpy(blob, header, header_size);
		memcpy(blob + header_size, body, body_size);

		l_util_hexdump(true, blob, header_size + body_size,
				do_debug, "[MSG] ");

		l_free(blob);

		l_util_hexdump(true, msg_data->binary, msg_data->binary_len,
							do_debug, "[MSG] ");
	}

	result = dbus_message_compare(msg, msg_data->binary,
						msg_data->binary_len);
	assert(result);

	l_dbus_message_unref(msg);
}

static void parse_basic_1(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	const char *str;
	bool result;

	result = l_dbus_message_get_arguments(msg, "s", &str);
	assert(result);
	assert(!strcmp(str, "Linus Torvalds"));

	l_dbus_message_unref(msg);
}

static void build_basic_1(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	const char *str = "Linus Torvalds";

	l_dbus_message_set_arguments(msg, "s", str);

	compare_message(msg, data);
}

static void parse_basic_2(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	const char *str1, *str2;
	bool result;

	result = l_dbus_message_get_arguments(msg, "ss", &str1, &str2);
	assert(result);
	assert(!strcmp(str1, "Linus"));
	assert(!strcmp(str2, "Torvalds"));

	l_dbus_message_unref(msg);
}

static void build_basic_2(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	const char *str1 = "Linus";
	const char *str2 = "Torvalds";

	l_dbus_message_set_arguments(msg, "ss", str1, str2);

	compare_message(msg, data);
}

static void parse_basic_3(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	const char *str;
	bool result, val;

	result = l_dbus_message_get_arguments(msg, "sb", &str, &val);
	assert(result);
	assert(!strcmp(str, "Linus Torvalds"));
	assert(val);

	l_dbus_message_unref(msg);
}

static void build_basic_3(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	const char *str = "Linus Torvalds";

	l_dbus_message_set_arguments(msg, "sb", str, true);

	compare_message(msg, data);
}

static void parse_basic_4(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	uint8_t val;
	bool result;

	result = l_dbus_message_get_arguments(msg, "y", &val);
	assert(result);
	assert(val == 23);

	l_dbus_message_unref(msg);
}

static void build_basic_4(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	uint8_t val = 23;

	l_dbus_message_set_arguments(msg, "y", val);

	compare_message(msg, data);
}

static void parse_basic_5(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	uint16_t val;
	bool result;

	result = l_dbus_message_get_arguments(msg, "q", &val);
	assert(result);
	assert(val == 42);

	l_dbus_message_unref(msg);
}

static void build_basic_5(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	uint16_t val = 42;

	l_dbus_message_set_arguments(msg, "q", val);

	compare_message(msg, data);
}

static void parse_basic_6(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	uint32_t val;
	bool result;

	result = l_dbus_message_get_arguments(msg, "u", &val);
	assert(result);
	assert(val == 4711);

	l_dbus_message_unref(msg);
}

static void build_basic_6(const void *data)
{
	struct l_dbus_message *msg = build_message(data);

	l_dbus_message_set_arguments(msg, "u", 4711);

	compare_message(msg, data);
}

static void parse_basic_7(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	uint64_t val;
	bool result;

	result = l_dbus_message_get_arguments(msg, "t", &val);
	assert(result);
	assert(val == 10000);

	l_dbus_message_unref(msg);
}

static void build_basic_7(const void *data)
{
	struct l_dbus_message *msg = build_message(data);

	l_dbus_message_set_arguments(msg, "t", (uint64_t) 10000);

	compare_message(msg, data);
}

static void parse_basic_8(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	int16_t val;
	bool result;

	result = l_dbus_message_get_arguments(msg, "n", &val);
	assert(result);
	assert(val == -42);

	l_dbus_message_unref(msg);
}

static void build_basic_8(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	int16_t val = -42;

	l_dbus_message_set_arguments(msg, "n", val);

	compare_message(msg, data);
}

static void parse_basic_9(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	int32_t val;
	bool result;

	result = l_dbus_message_get_arguments(msg, "i", &val);
	assert(result);
	assert(val == -4711);

	l_dbus_message_unref(msg);
}

static void build_basic_9(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	int32_t val = -4711;

	l_dbus_message_set_arguments(msg, "i", val);

	compare_message(msg, data);
}

static void parse_basic_10(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	int64_t val;
	bool result;

	result = l_dbus_message_get_arguments(msg, "x", &val);
	assert(result);
	assert(val == -10000);

	l_dbus_message_unref(msg);
}

static void build_basic_10(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	int64_t val = -10000;

	l_dbus_message_set_arguments(msg, "x", val);

	compare_message(msg, data);
}

static void parse_basic_11(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	double val;
	bool result;

	result = l_dbus_message_get_arguments(msg, "d", &val);
	assert(result);
	assert(val == M_PI);

	l_dbus_message_unref(msg);
}

static void build_basic_11(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	double val = M_PI;

	l_dbus_message_set_arguments(msg, "d", val);

	compare_message(msg, data);
}

static void parse_struct_1(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	const char *str1, *str2;
	bool result;

	result = l_dbus_message_get_arguments(msg, "(ss)", &str1, &str2);
	assert(result);
	assert(!strcmp(str1, "Linus"));
	assert(!strcmp(str2, "Torvalds"));

	l_dbus_message_unref(msg);
}

static void build_struct_1(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	const char *str1 = "Linus";
	const char *str2 = "Torvalds";
	bool result;

	result = l_dbus_message_set_arguments(msg, "(ss)", str1, str2);
	assert(result);

	compare_message(msg, data);
}

static void parse_struct_2(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	const char *str, *str1, *str2;
	bool result;

	result = l_dbus_message_get_arguments(msg, "(s(ss))",
							&str, &str1, &str2);
	assert(result);
	assert(!strcmp(str, "Linus Torvalds"));
	assert(!strcmp(str1, "Linus"));
	assert(!strcmp(str2, "Torvalds"));

	l_dbus_message_unref(msg);
}

static void build_struct_2(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	const char *str = "Linus Torvalds";
	const char *str1 = "Linus";
	const char *str2 = "Torvalds";
	bool result;

	result = l_dbus_message_set_arguments(msg, "(s(ss))",
							str, str1, str2);
	assert(result);

	compare_message(msg, data);
}

static void parse_struct_3(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	const int num[32] = { 0 };
	bool result;

	result = l_dbus_message_get_arguments(msg, MESSAGE_SIGNATURE_STRUCT_3,
		      &num[0], &num[1], &num[2], &num[3],
		      &num[4], &num[5], &num[6], &num[7],
		      &num[8], &num[9], &num[10], &num[11],
		      &num[12], &num[13], &num[14], &num[15],
		      &num[16], &num[17], &num[18], &num[19],
		      &num[20], &num[21], &num[22], &num[23],
		      &num[24], &num[25], &num[26], &num[27],
		      &num[28], &num[29], &num[30], &num[31]);

	assert(result);

	for (int i = 0; i < 32; i++) {
		assert(i == num[i]);
	}

	l_dbus_message_unref(msg);
}

static void build_struct_3(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	bool result;

	result = l_dbus_message_set_arguments(msg, MESSAGE_SIGNATURE_STRUCT_3,
		0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
		18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31);

	assert(result);

	compare_message(msg, data);
}

static void build_struct_4(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	bool result;

	result = l_dbus_message_set_arguments(msg, MESSAGE_SIGNATURE_STRUCT_4,
		0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
		18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32);

	assert(!result);

	l_dbus_message_unref(msg);
}

static void check_array_1(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter iter;
	const char *str;
	bool result;

	result = l_dbus_message_get_arguments(msg, "as", &iter);
	assert(result);

	result = l_dbus_message_iter_next_entry(&iter, &str);
	assert(result);
	assert(!strcmp(str, "Linus"));

	result = l_dbus_message_iter_next_entry(&iter, &str);
	assert(result);
	assert(!strcmp(str, "Torvalds"));

	result = l_dbus_message_iter_next_entry(&iter, &str);
	assert(!result);

	l_dbus_message_unref(msg);
}

static void build_array_1(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	const char *str1 = "Linus";
	const char *str2 = "Torvalds";
	bool result;

	result = l_dbus_message_set_arguments(msg, "as", 2, str1, str2);
	assert(result);

	compare_message(msg, data);
}

static void check_array_2(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter iter;
	bool result, val;

	result = l_dbus_message_get_arguments(msg, "ab", &iter);
	assert(result);

	result = l_dbus_message_iter_next_entry(&iter, &val);
	assert(result);
	assert(val);

	result = l_dbus_message_iter_next_entry(&iter, &val);
	assert(result);
	assert(val);

	result = l_dbus_message_iter_next_entry(&iter, &val);
	assert(result);
	assert(!val);

	result = l_dbus_message_iter_next_entry(&iter, &val);
	assert(!result);

	l_dbus_message_unref(msg);
}

static void build_array_2(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	bool result;

	result = l_dbus_message_set_arguments(msg, "ab", 3, true, true, false);
	assert(result);

	compare_message(msg, data);
}

static void check_array_3(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter array, iter;
	const char *str;
	bool result;

	result = l_dbus_message_get_arguments(msg, "aas", &array);
	assert(result);

	/* Top-level array's first element */
	result = l_dbus_message_iter_next_entry(&array, &iter);
	assert(result);

	result = l_dbus_message_iter_next_entry(&iter, &str);
	assert(result);
	assert(!strcmp(str, "Linus Torvalds"));

	result = l_dbus_message_iter_next_entry(&iter, &str);
	assert(!result);

	/* Top-level array's second element */
	result = l_dbus_message_iter_next_entry(&array, &iter);
	assert(result);

	result = l_dbus_message_iter_next_entry(&iter, &str);
	assert(result);
	assert(!strcmp(str, "Linus"));

	result = l_dbus_message_iter_next_entry(&iter, &str);
	assert(result);
	assert(!strcmp(str, "Torvalds"));

	result = l_dbus_message_iter_next_entry(&iter, &str);
	assert(!result);

	/* Top-level array's third element */
	result = l_dbus_message_iter_next_entry(&array, &iter);
	assert(result);

	result = l_dbus_message_iter_next_entry(&iter, &str);
	assert(!result);

	/* Top-level array's end element */
	result = l_dbus_message_iter_next_entry(&array, &iter);
	assert(!result);

	l_dbus_message_unref(msg);
}

static void build_array_3(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	bool result;

	result = l_dbus_message_set_arguments(msg, "aas", 3,
						1, "Linus Torvalds",
						2, "Linus", "Torvalds",
						0);
	assert(result);

	compare_message(msg, data);
}

static void check_array_4(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter array;
	const char *str1, *str2;
	bool result;

	result = l_dbus_message_get_arguments(msg, "a(ss)", &array);
	assert(result);

	result = l_dbus_message_iter_next_entry(&array, &str1, &str2);
	assert(result);
	assert(!strcmp(str1, "Linus"));
	assert(!strcmp(str2, "Torvalds"));

	result = l_dbus_message_iter_next_entry(&array, &str1, &str2);
	assert(result);
	assert(!strcmp(str1, "Marcel"));
	assert(!strcmp(str2, "Holtmann"));

	result = l_dbus_message_iter_next_entry(&array, &str1, &str2);
	assert(!result);

	l_dbus_message_unref(msg);
}

static void build_array_4(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	bool result;

	result = l_dbus_message_set_arguments(msg, "a(ss)", 2,
						"Linus", "Torvalds",
						"Marcel", "Holtmann");
	assert(result);

	compare_message(msg, data);
}

static void check_array_5(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter array1, array2;
	const char *str;
	bool result;

	result = l_dbus_message_get_arguments(msg, "asas", &array1, &array2);
	assert(result);

	result = l_dbus_message_iter_next_entry(&array1, &str);
	assert(result);
	assert(!strcmp(str, "Linus"));

	result = l_dbus_message_iter_next_entry(&array1, &str);
	assert(result);
	assert(!strcmp(str, "Torvalds"));

	result = l_dbus_message_iter_next_entry(&array1, &str);
	assert(!result);

	result = l_dbus_message_iter_next_entry(&array2, &str);
	assert(result);
	assert(!strcmp(str, "Marcel"));

	result = l_dbus_message_iter_next_entry(&array2, &str);
	assert(result);
	assert(!strcmp(str, "Holtmann"));

	result = l_dbus_message_iter_next_entry(&array2, &str);
	assert(!result);

	l_dbus_message_unref(msg);
}

static void build_array_5(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	bool result;

	result = l_dbus_message_set_arguments(msg, "asas",
						2, "Linus", "Torvalds",
						2, "Marcel", "Holtmann");
	assert(result);

	compare_message(msg, data);
}

static void check_array_6(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter array, iter;
	const char *str;
	bool result, val;

	result = l_dbus_message_get_arguments(msg, "av", &array);
	assert(result);

	result = l_dbus_message_iter_next_entry(&array, &iter);
	assert(result);

	result = l_dbus_message_iter_get_variant(&iter, "s", &str);
	assert(result);
	assert(!strcmp(str, "Linus Torvalds"));

	result = l_dbus_message_iter_next_entry(&array, &iter);
	assert(result);

	result = l_dbus_message_iter_get_variant(&iter, "b", &val);
	assert(result);
	assert(val);

	result = l_dbus_message_iter_next_entry(&array, &iter);
	assert(!result);

	l_dbus_message_unref(msg);
}

static void build_array_6(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	bool result;

	result = l_dbus_message_set_arguments(msg, "av", 2,
						"s", "Linus Torvalds",
						"b", true);
	assert(result);

	compare_message(msg, data);
}

static void check_dict_1(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter dict, iter;
	const char *str;
	bool result;

	result = l_dbus_message_get_arguments(msg, "a{sv}", &dict);
	assert(result);

	result = l_dbus_message_iter_next_entry(&dict, &str, &iter);
	assert(!result);

	l_dbus_message_unref(msg);
}

static void build_dict_1(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	bool result;

	result = l_dbus_message_set_arguments(msg, "a{sv}", 0);
	assert(result);

	compare_message(msg, data);
}

static void check_dict_2(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter dict, iter;
	const char *str;
	bool result, val;

	result = l_dbus_message_get_arguments(msg, "a{sv}", &dict);
	assert(result);

	result = l_dbus_message_iter_next_entry(&dict, &str, &iter);
	assert(result);
	assert(!strcmp(str, "Name"));

	result = l_dbus_message_iter_get_variant(&iter, "s", &str);
	assert(result);
	assert(!strcmp(str, "Linus Torvalds"));

	result = l_dbus_message_iter_next_entry(&dict, &str, &iter);
	assert(result);
	assert(!strcmp(str, "Developer"));

	result = l_dbus_message_iter_get_variant(&iter, "b", &val);
	assert(result);
	assert(val);

	result = l_dbus_message_iter_next_entry(&dict, &str, &iter);
	assert(!result);

	l_dbus_message_unref(msg);
}

static void build_dict_2(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	bool result;

	result = l_dbus_message_set_arguments(msg, "a{sv}", 2,
						"Name", "s", "Linus Torvalds",
						"Developer", "b", true);
	assert(result);

	compare_message(msg, data);
}

static void check_dict_3(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter dict;
	const char *str1, *str2;
	bool result;

	result = l_dbus_message_get_arguments(msg, "a{ss}", &dict);
	assert(result);

	result = l_dbus_message_iter_next_entry(&dict, &str1, &str2);
	assert(result);
	assert(!strcmp(str1, "Linus"));
	assert(!strcmp(str2, "Torvalds"));

	result = l_dbus_message_iter_next_entry(&dict, &str1, &str2);
	assert(result);
	assert(!strcmp(str1, "Marcel"));
	assert(!strcmp(str2, "Holtmann"));

	result = l_dbus_message_iter_next_entry(&dict, &str1, &str2);
	assert(!result);

        l_dbus_message_unref(msg);
}

static void build_dict_3(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	bool result;

	result = l_dbus_message_set_arguments(msg, "a{ss}", 2,
						"Linus", "Torvalds",
						"Marcel", "Holtmann");
	assert(result);

	compare_message(msg, data);
}

static void check_variant_1(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter iter;
	const char *str;
	bool result;

	result = l_dbus_message_get_arguments(msg, "v", &iter);
	assert(result);

	result = l_dbus_message_iter_get_variant(&iter, "s", &str);
	assert(result);
	assert(!strcmp(str, "Linus Torvalds"));

	l_dbus_message_unref(msg);
}

static void build_variant_1(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	const char *str = "Linus Torvalds";
	bool result;

	result = l_dbus_message_set_arguments(msg, "v", "s", str);
	assert(result);

	compare_message(msg, data);
}

static void check_variant_2(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter iter, array;
	const char *str;
	bool result;

	result = l_dbus_message_get_arguments(msg, "v", &iter);
	assert(result);

	result = l_dbus_message_iter_get_variant(&iter, "as", &array);
	assert(result);

	result = l_dbus_message_iter_next_entry(&array, &str);
	assert(result);
	assert(!strcmp(str, "Linus"));

	result = l_dbus_message_iter_next_entry(&array, &str);
	assert(result);
	assert(!strcmp(str, "Torvalds"));

	result = l_dbus_message_iter_next_entry(&array, &str);
	assert(!result);

	l_dbus_message_unref(msg);
}

static void build_variant_2(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	bool result;

	result = l_dbus_message_set_arguments(msg, "v", "as", 2,
						"Linus", "Torvalds");
	assert(result);

	compare_message(msg, data);
}

static void check_variant_3(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter iter;
	const char *str1, *str2;
	bool result, val;

	result = l_dbus_message_get_arguments(msg, "v", &iter);
	assert(result);

	result = l_dbus_message_iter_get_variant(&iter, "(ssb)",
							&str1, &str2, &val);
	assert(result);
	assert(!strcmp(str1, "Linus"));
	assert(!strcmp(str2, "Torvalds"));
	assert(val);

	l_dbus_message_unref(msg);
}

static void build_variant_3(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	const char *str1 = "Linus";
	const char *str2 = "Torvalds";
	bool result;

	result = l_dbus_message_set_arguments(msg, "v", "(ssb)",
						str1, str2, true);
	assert(result);

	compare_message(msg, data);
}

static void check_variant_4(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter entry, iter;
	const char *str;
	bool result;

	result = l_dbus_message_get_arguments(msg, "v", &entry);
	assert(result);

	result = l_dbus_message_iter_get_variant(&entry, "v", &iter);
	assert(result);

	result = l_dbus_message_iter_get_variant(&iter, "s", &str);
	assert(result);
	assert(!strcmp(str, "Linus Torvalds"));

	l_dbus_message_unref(msg);
}

static void build_variant_4(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	bool result;

	result = l_dbus_message_set_arguments(msg, "v", "v", "s",
						"Linus Torvalds");
	assert(result);

	compare_message(msg, data);
}

static void check_variant_5(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter entry, iter;
	const char *str;
	bool result, val;

	result = l_dbus_message_get_arguments(msg, "v", &entry);
	assert(result);

	result = l_dbus_message_iter_get_variant(&entry, "(sv)", &str, &iter);
	assert(result);
	assert(!strcmp(str, "Linus Torvalds"));

	result = l_dbus_message_iter_get_variant(&iter, "b", &val);
	assert(result);
	assert(val);

	l_dbus_message_unref(msg);
}

static void build_variant_5(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	bool result;

	result = l_dbus_message_set_arguments(msg, "v", "(sv)",
						"Linus Torvalds",
						"b", true);
	assert(result);

	compare_message(msg, data);
}

static void check_complex_1(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter dict, iter;
	const char *path, *str;
	bool result, val;

	result = l_dbus_message_get_arguments(msg, "oa{sv}", &path, &dict);
	assert(result);
	assert(!strcmp(path, "/com/example/object"));

	result = l_dbus_message_iter_next_entry(&dict, &str, &iter);
	assert(result);
	assert(!strcmp(str, "Name"));

	result = l_dbus_message_iter_get_variant(&iter, "s", &str);
	assert(result);
	assert(!strcmp(str, "Linus Torvalds"));

	result = l_dbus_message_iter_next_entry(&dict, &str, &iter);
	assert(result);
	assert(!strcmp(str, "Developer"));

	result = l_dbus_message_iter_get_variant(&iter, "b", &val);
	assert(result);
	assert(val);

	result = l_dbus_message_iter_next_entry(&dict, &str, &iter);
	assert(!result);

	l_dbus_message_unref(msg);
}

static void build_complex_1(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	bool result;

	result = l_dbus_message_set_arguments(msg, "oa{sv}",
						"/com/example/object", 2,
						"Name", "s", "Linus Torvalds",
						"Developer", "b", true);
	assert(result);

	compare_message(msg, data);
}

static void check_complex_2(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter array, dict, iter;
	const char *path, *str;
	bool result;

	result = l_dbus_message_get_arguments(msg, "a(oa{sv})", &array);
	assert(result);

	/* First object path + properties */
	result = l_dbus_message_iter_next_entry(&array, &path, &dict);
	assert(result);
	assert(!strcmp(path, "/com/example/object1"));

	result = l_dbus_message_iter_next_entry(&dict, &str, &iter);
	assert(result);
	assert(!strcmp(str, "Name"));

	result = l_dbus_message_iter_get_variant(&iter, "s", &str);
	assert(result);
	assert(!strcmp(str, "Linus Torvalds"));

	result = l_dbus_message_iter_next_entry(&dict, &str, &iter);
	assert(!result);

	/* Second object path + properties */
	result = l_dbus_message_iter_next_entry(&array, &path, &dict);
	assert(result);
	assert(!strcmp(path, "/com/example/object2"));

	result = l_dbus_message_iter_next_entry(&dict, &str, &iter);
	assert(result);
	assert(!strcmp(str, "Name"));

	result = l_dbus_message_iter_get_variant(&iter, "s", &str);
	assert(result);
	assert(!strcmp(str, "Marcel Holtmann"));

	result = l_dbus_message_iter_next_entry(&dict, &str, &iter);
	assert(!result);

	/* End element */
	result = l_dbus_message_iter_next_entry(&array, &path, &dict);
	assert(!result);

	l_dbus_message_unref(msg);
}

static void build_complex_2(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	bool result;

	result = l_dbus_message_set_arguments(msg, "a(oa{sv})", 2,
						"/com/example/object1", 1,
						"Name", "s", "Linus Torvalds",
						"/com/example/object2", 1,
						"Name", "s", "Marcel Holtmann");
	assert(result);

	compare_message(msg, data);
}

static void check_complex_3(const void *data)
{
        struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter dict1, dict2, iter;
	const char *str1, *str2, *str3;
	uint32_t val;
	bool result;

	result = l_dbus_message_get_arguments(msg, "(sa{sv})sa{ss}us",
				&str1, &dict1, &str2, &dict2, &val, &str3);
	assert(result);
	assert(!strcmp(str1, "system-bus-name"));
	assert(!strcmp(str2, "org.freedesktop.policykit.exec"));
	assert(val == 1);
	assert(!strcmp(str3, ""));

	result = l_dbus_message_iter_next_entry(&dict1, &str1, &iter);
	assert(result);
	assert(!strcmp(str1, "name"));

	result = l_dbus_message_iter_get_variant(&iter, "s", &str2);
	assert(result);
	assert(!strcmp(str2, ":1.3307"));

	result = l_dbus_message_iter_next_entry(&dict1, &str1, &iter);
	assert(!result);

	result = l_dbus_message_iter_next_entry(&dict2, &str1, &str2);
	assert(!result);

	l_dbus_message_unref(msg);
}

static void build_complex_3(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	bool result;

	result = l_dbus_message_set_arguments(msg, "(sa{sv})sa{ss}us",
					"system-bus-name", 1,
					"name", "s", ":1.3307",
					"org.freedesktop.policykit.exec", 0,
					1, "");
	assert(result);

	compare_message(msg, data);
}

static void builder_complex_3(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	struct l_dbus_message_builder *builder;
	uint32_t u = 1;

	builder = l_dbus_message_builder_new(msg);
	assert(builder);

	assert(l_dbus_message_builder_enter_struct(builder, "sa{sv}"));
	assert(l_dbus_message_builder_append_basic(builder, 's',
							"system-bus-name"));
	assert(l_dbus_message_builder_enter_array(builder, "{sv}"));
	assert(l_dbus_message_builder_enter_dict(builder, "sv"));
	assert(l_dbus_message_builder_append_basic(builder, 's', "name"));
	assert(l_dbus_message_builder_enter_variant(builder, "s"));
	assert(l_dbus_message_builder_append_basic(builder, 's', ":1.3307"));
	assert(l_dbus_message_builder_leave_variant(builder));
	assert(l_dbus_message_builder_leave_dict(builder));
	assert(l_dbus_message_builder_leave_array(builder));
	assert(l_dbus_message_builder_leave_struct(builder));

	assert(l_dbus_message_builder_append_basic(builder, 's',
					"org.freedesktop.policykit.exec"));

	assert(l_dbus_message_builder_enter_array(builder, "{ss}"));
	assert(l_dbus_message_builder_leave_array(builder));

	assert(l_dbus_message_builder_append_basic(builder, 'u', &u));

	assert(l_dbus_message_builder_append_basic(builder, 's', ""));

	assert(l_dbus_message_builder_finalize(builder));

	l_dbus_message_builder_destroy(builder);

	compare_message(msg, data);
}

static void check_complex_4(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter dict;
	const char *str1, *str2;
	bool result, val1, val2;

	result = l_dbus_message_get_arguments(msg, "(bba{ss})",
						&val1, &val2, &dict);
	assert(result);
	assert(!val1);
	assert(!val2);

	result = l_dbus_message_iter_next_entry(&dict, &str1, &str2);
	assert(result);
	assert(!strcmp(str1, "polkit.dismissed"));
	assert(!strcmp(str2, "true"));

	result = l_dbus_message_iter_next_entry(&dict, &str1, &str2);
	assert(!result);

	l_dbus_message_unref(msg);
}

static void check_complex_5(const void *data)
{
	struct l_dbus_message *msg = check_message(data);
	struct l_dbus_message_iter dict;
	const char *str1, *str2;
	bool result, val1, val2;

	result = l_dbus_message_get_arguments(msg, "(bba{ss})",
						&val1, &val2, &dict);
	assert(result);
	assert(val1);
	assert(!val2);

	result = l_dbus_message_iter_next_entry(&dict, &str1, &str2);
	assert(!result);

	l_dbus_message_unref(msg);
}

static void builder_rewind(const void *data)
{
	struct l_dbus_message *msg = build_message(data);
	struct l_dbus_message_builder *builder;
	bool b = true;

	builder = l_dbus_message_builder_new(msg);
	assert(builder);

	assert(l_dbus_message_builder_append_basic(builder, 'o',
							"/com/example/object"));

	assert(l_dbus_message_builder_enter_array(builder, "{sv}"));

	assert(_dbus_message_builder_mark(builder));

	assert(l_dbus_message_builder_enter_dict(builder, "sv"));
	assert(l_dbus_message_builder_append_basic(builder, 's', "Name"));
	assert(l_dbus_message_builder_enter_variant(builder, "s"));
	assert(l_dbus_message_builder_append_basic(builder, 's',
							"Invalid"));
	assert(l_dbus_message_builder_leave_variant(builder));
	assert(l_dbus_message_builder_leave_dict(builder));

	assert(_dbus_message_builder_rewind(builder));

	assert(l_dbus_message_builder_enter_dict(builder, "sv"));
	assert(l_dbus_message_builder_append_basic(builder, 's', "Name"));
	assert(l_dbus_message_builder_enter_variant(builder, "s"));
	assert(l_dbus_message_builder_append_basic(builder, 's',
							"Linus Torvalds"));
	assert(l_dbus_message_builder_leave_variant(builder));
	assert(l_dbus_message_builder_leave_dict(builder));

	assert(l_dbus_message_builder_enter_dict(builder, "sv"));
	assert(l_dbus_message_builder_append_basic(builder, 's', "Developer"));
	assert(l_dbus_message_builder_enter_variant(builder, "b"));
	assert(l_dbus_message_builder_append_basic(builder, 'b', &b));
	assert(l_dbus_message_builder_leave_variant(builder));
	assert(l_dbus_message_builder_leave_dict(builder));

	assert(l_dbus_message_builder_leave_array(builder));

	assert(l_dbus_message_builder_finalize(builder));
	l_dbus_message_builder_destroy(builder);

	compare_message(msg, data);
}

static int count_fds(void)
{
	int fd;
	int count = 0;
	int flags;

	for (fd = 0; fd < FD_SETSIZE; fd++) {
		flags = fcntl(fd, F_GETFL);
		if (flags < 0) /* ignore any files we can't operate on */
			continue;

		/*
		 * Only count files that are read-only or write-only.  This is
		 * to work around the issue that fakeroot opens a TCP socket
		 * in RDWR mode in a separate thread
		 *
		 * Note: This means that files used for file-descriptor passing
		 * tests should be opened RDONLY or WRONLY
		 */
		if (flags & O_RDWR)
			continue;

		count++;
	}

	return count;
}

static void compare_files(int a, int b)
{
	struct stat sa, sb;

	assert(fstat(a, &sa) == 0);
	assert(fstat(b, &sb) == 0);

	assert(sa.st_dev == sb.st_dev);
	assert(sa.st_ino == sb.st_ino);
	assert(sa.st_rdev == sb.st_rdev);
}

static const unsigned char message_binary_basic_h[] = {
	0x6c, 0x01, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00,
	0x01, 0x01, 0x6f, 0x00, 0x13, 0x00, 0x00, 0x00,
	0x2f, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x01, 0x73, 0x00, 0x06, 0x00, 0x00, 0x00,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x00, 0x00,
	0x02, 0x01, 0x73, 0x00, 0x15, 0x00, 0x00, 0x00,
	0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x66, 0x61, 0x63, 0x65, 0x00, 0x00, 0x00,
	0x06, 0x01, 0x73, 0x00, 0x0b, 0x00, 0x00, 0x00,
	0x63, 0x6f, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x01, 0x67, 0x00, 0x01, 0x68, 0x00, 0x00,
	0x09, 0x01, 0x75, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

static const struct message_data message_data_basic_h = {
	.type		= "method_call",
	.path		= "/com/example/object",
	.interface	= "com.example.interface",
	.member		= "method",
	.destination	= "com.example",
	.signature	= "h",
	.serial		= 0,
	.reply_serial	= 0,
	.no_reply	= 0,
	.auto_start	= 1,
	.unix_fds	= 1,
	.binary		= message_binary_basic_h,
	.binary_len	= sizeof(message_binary_basic_h),
};

static void message_fds_parse(const void *data)
{
	struct message_data message_data = message_data_basic_h;
	struct l_dbus_message *msg;
	int fd0, fd1;
	int open_fds;
	bool result;

	open_fds = count_fds();

	fd0 = open("/dev/random", O_RDONLY);
	assert(fd0 != -1);

	message_data.fds = &fd0;
	msg = check_message(&message_data);

	result = l_dbus_message_get_arguments(msg, "h", &fd1);
	assert(result);
	assert(fd1 != -1 && fd0 != fd1);

	compare_files(fd0, fd1);

	assert(count_fds() != open_fds);

	close(fd1);

	assert(count_fds() != open_fds);

	l_dbus_message_unref(msg);

	assert(count_fds() == open_fds);
}

static void message_fds_build(const void *data)
{
	struct message_data message_data = message_data_basic_h;
	struct l_dbus_message *msg;
	int fd;
	int open_fds;

	open_fds = count_fds();

	fd = open("/dev/random", O_RDONLY);
	assert(fd != -1);

	msg = build_message(&message_data);

	l_dbus_message_set_arguments(msg, "h", fd);

	close(fd);

	assert(count_fds() != open_fds);

	compare_message(msg, &message_data);

	assert(count_fds() == open_fds);
}

int main(int argc, char *argv[])
{
	l_test_init(&argc, &argv);

	l_test_add("Basic 1 (parse)", parse_basic_1, &message_data_basic_1);
	l_test_add("Basic 1 (build)", build_basic_1, &message_data_basic_1);
	l_test_add("Basic 2 (parse)", parse_basic_2, &message_data_basic_2);
	l_test_add("Basic 3 (build)", build_basic_2, &message_data_basic_2);
	l_test_add("Basic 3 (parse)", parse_basic_3, &message_data_basic_3);
	l_test_add("Basic 3 (build)", build_basic_3, &message_data_basic_3);
	l_test_add("Basic 4 (parse)", parse_basic_4, &message_data_basic_4);
	l_test_add("Basic 4 (build)", build_basic_4, &message_data_basic_4);
	l_test_add("Basic 5 (parse)", parse_basic_5, &message_data_basic_5);
	l_test_add("Basic 5 (build)", build_basic_5, &message_data_basic_5);
	l_test_add("Basic 6 (parse)", parse_basic_6, &message_data_basic_6);
	l_test_add("Basic 6 (build)", build_basic_6, &message_data_basic_6);
	l_test_add("Basic 7 (parse)", parse_basic_7, &message_data_basic_7);
	l_test_add("Basic 7 (build)", build_basic_7, &message_data_basic_7);
	l_test_add("Basic 8 (parse)", parse_basic_8, &message_data_basic_8);
	l_test_add("Basic 8 (build)", build_basic_8, &message_data_basic_8);
	l_test_add("Basic 9 (parse)", parse_basic_9, &message_data_basic_9);
	l_test_add("Basic 9 (build)", build_basic_9, &message_data_basic_9);
	l_test_add("Basic 10 (parse)", parse_basic_10, &message_data_basic_10);
	l_test_add("Basic 10 (build)", build_basic_10, &message_data_basic_10);
	l_test_add("Basic 11 (parse)", parse_basic_11, &message_data_basic_11);
	l_test_add("Basic 11 (build)", build_basic_11, &message_data_basic_11);

	l_test_add("Struct 1 (parse)", parse_struct_1, &message_data_struct_1);
	l_test_add("Struct 1 (build)", build_struct_1, &message_data_struct_1);
	l_test_add("Struct 2 (parse)", parse_struct_2, &message_data_struct_2);
	l_test_add("Struct 2 (build)", build_struct_2, &message_data_struct_2);
	l_test_add("Struct 3 (parse)", parse_struct_3, &message_data_struct_3);
	l_test_add("Struct 3 (build)", build_struct_3, &message_data_struct_3);
	l_test_add("Struct 4 (build)", build_struct_4, &message_data_struct_4);

	l_test_add("Array 1 (parse)", check_array_1, &message_data_array_1);
	l_test_add("Array 1 (build)", build_array_1, &message_data_array_1);
	l_test_add("Array 2 (parse)", check_array_2, &message_data_array_2);
	l_test_add("Array 2 (build)", build_array_2, &message_data_array_2);
	l_test_add("Array 3 (parse)", check_array_3, &message_data_array_3);
	l_test_add("Array 3 (build)", build_array_3, &message_data_array_3);
	l_test_add("Array 4 (parse)", check_array_4, &message_data_array_4);
	l_test_add("Array 4 (build)", build_array_4, &message_data_array_4);
	l_test_add("Array 5 (parse)", check_array_5, &message_data_array_5);
	l_test_add("Array 5 (build)", build_array_5, &message_data_array_5);
	l_test_add("Array 6 (parse)", check_array_6, &message_data_array_6);
	l_test_add("Array 6 (build)", build_array_6, &message_data_array_6);

	l_test_add("Dict 1 (parse)", check_dict_1, &message_data_dict_1);
	l_test_add("Dict 1 (build)", build_dict_1, &message_data_dict_1);
	l_test_add("Dict 2 (parse)", check_dict_2, &message_data_dict_2);
	l_test_add("Dict 2 (build)", build_dict_2, &message_data_dict_2);
	l_test_add("Dict 3 (parse)", check_dict_3, &message_data_dict_3);
	l_test_add("Dict 3 (build)", build_dict_3, &message_data_dict_3);

	l_test_add("Variant 1 (parse)", check_variant_1,
						&message_data_variant_1);
	l_test_add("Variant 1 (build)", build_variant_1,
						&message_data_variant_1);
	l_test_add("Variant 2 (parse)", check_variant_2,
						&message_data_variant_2);
	l_test_add("Variant 2 (build)", build_variant_2,
						&message_data_variant_2);
	l_test_add("Variant 3 (parse)", check_variant_3,
						&message_data_variant_3);
	l_test_add("Variant 3 (build)", build_variant_3,
						&message_data_variant_3);
	l_test_add("Variant 4 (parse)", check_variant_4,
						&message_data_variant_4);
	l_test_add("Variant 4 (build)", build_variant_4,
						&message_data_variant_4);
	l_test_add("Variant 5 (parse)", check_variant_5,
						&message_data_variant_5);
	l_test_add("Variant 5 (build)", build_variant_5,
						&message_data_variant_5);

	l_test_add("Complex 1 (parse)", check_complex_1,
						&message_data_complex_1);
	l_test_add("Complex 1 (build)", build_complex_1,
						&message_data_complex_1);
	l_test_add("Complex 2 (parse)", check_complex_2,
						&message_data_complex_2);
	l_test_add("Complex 2 (build)", build_complex_2,
						&message_data_complex_2);
	l_test_add("Complex 3 (parse)", check_complex_3,
						&message_data_complex_3);
	l_test_add("Complex 3 (build)", build_complex_3,
						&message_data_complex_3);
	l_test_add("Complex 4", check_complex_4, &message_data_complex_4);
	l_test_add("Complex 5", check_complex_5, &message_data_complex_5);

	l_test_add("Message Builder Complex 3", builder_complex_3,
						&message_data_complex_3);

	l_test_add("Message Builder Rewind Complex 1", builder_rewind,
						&message_data_complex_1);

	l_test_add("FDs (parse)", message_fds_parse, NULL);
	l_test_add("FDs (build)", message_fds_build, NULL);

	return l_test_run();
}
