#ifndef _AuthP_h
#define _AuthP_h

/*
 * Copyright (c) 1997 Ben Buxton
 */

#include "Auth.h"
#include <X11/CoreP.h>

typedef struct {
    int junk;
} AuthClassPart;

typedef struct _AuthClassRec {
    CoreClassPart	core_class;
    AuthClassPart	auth_class;
} AuthClassRec;

extern AuthClassRec authClassRec;

typedef struct {
    int	shadow_width;
    Pixel	top_pixel;
    Pixel	bot_pixel;
    Pixel	l_foreground;
    Pixel	m_foreground;
    Pixel	m_background;
    Pixel	p_foreground;
    Pixel	e_foreground;
    Pixmap	screw;
    XFontStruct *label_font;
    XFontStruct *prompt_font;
    XFontStruct *entry_font;
    XFontStruct *message_font;
    char	*banner_string;
    char	*message_string;
    void	(*ok_notify)(Widget, Prompt *, int);	/* Notify callback */
    void	(*abor_notify)(Widget);                  /* Abort callback */
    Dimension	lheight;
    Dimension	mheight;
    Dimension	entrymargin;
    int	label_x;
    int	label_y;
    int 	message_x;
    int 	message_y;
    Prompt	*prompts;
    int	cursorpos; /* Current position of cursor */
    int	numprompts;	/* Number of prompts to display */
    int	where;	/* Which prompt are we in? */
    Boolean	grabbed;	/* Keyboard grabbed? */

    /*
     * This seems like a lot of GCs, but this widget consists of one
     * window, rather than several subwidgets
     */
    GC	topGC;
    GC	botGC;
    GC	normGC;
    GC	labelGC;
    GC	promptGC;
    GC	entryGC;
    GC	messageGC;
    GC	messagebGC;

    char  *addEchoString;
    char  *addLabelString;
    char  *addNoEchoString;

    Boolean clearPrompts;
    Boolean clearMessage;
} AuthPart;

typedef struct _AuthRec {
    CorePart		core;
    AuthPart	auth;
} AuthRec;

#endif /* _AuthP_h */
