/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.util.Collection;
import net.sourceforge.stripes.validation.NumberTypeConverterSupport;
import net.sourceforge.stripes.validation.ScopedLocalizableError;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatTypeConverter
extends NumberTypeConverterSupport
implements TypeConverter<Float> {
    public static final float MIN_VALUE = -3.4028235E38f;
    public static final float MAX_VALUE = Float.MAX_VALUE;

    @Override
    public Float convert(String input, Class<? extends Float> targetType, Collection<ValidationError> errors) {
        Number number = this.parse(input, errors);
        Float retval = null;
        if (errors.size() == 0) {
            double output = number.doubleValue();
            if (output > 3.4028234663852886E38 || output < -3.4028234663852886E38) {
                errors.add(new ScopedLocalizableError("converter.float", "outOfRange", Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE)));
            } else {
                retval = new Float(number.floatValue());
            }
        }
        return retval;
    }
}

