/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


#if (BL_SPACEDIM == 2 || BL_SPACEDIM == 3)
#include "IFrame.H"
#include <BoxLib.H>

IFrame::IFrame(const Box& box, double xmin,double xmax, 
			double ymin, double ymax) : 
			xlo(xmin),xhi(xmax),ylo(ymin),yhi(ymax)		     {
	ilo = box.smallEnd()[0];
	jlo = box.smallEnd()[1];
	ihi = box.bigEnd()[0];
	jhi = box.bigEnd()[1];
	if( (ihi-ilo)*(jhi-jlo) == 0 ) BoxLib::Error("IFrame():zero width frame");
	delx = (xmax-xmin)/(ihi-ilo);
	dely = (ymax-ymin)/(jhi-jlo);
}

IntVect IFrame::toIV( const double* coord ) const {
	double x,y;
	int i,j;
	x = (coord[0]-xlo)/delx;
	if( x > 0 ) i = int(x+0.5)+ilo;
	else i = int(x-0.5)+ilo;
	
	y = (coord[1]-ylo)/dely;
	if( y > 0 ) j = int(y+0.5)+jlo;
	else j = int(y-0.5)+jlo;

#if (BL_SPACEDIM==2)
	return IntVect(i,j);
#elif (BL_SPACEDIM == 3)
	int k=0;
	return IntVect(i,j,k);
#endif
}

double IFrame::toX(const IntVect p ) const {
	return xlo+(p[0]-ilo)*delx;
}

double IFrame::toY(const IntVect p ) const {
	return ylo+(p[1]-jlo)*dely;
}
#endif
