language_order = [
    "en",
    "ru",
    "es",
    "de",
    "fr",
    "ja",
    "tr",
    "fa",
    "zh",
    "zh-Hans",
    "it",
    "vi",
    "pt",
    "nl",
    "pl",
    "ar",
    "ko",
    "id",
    "uk",
    "cs",
    "th",
    "he",
    "sv",
    "el",
    "ro",
    "da",
    "hu",
    "fi",
    "sr",
    "sr-Cyrl",
    "sk",
    "bg",
    "nb",
    "hr",
    "lt",
    "sl",
    "hi",
    "ca",
    "et",
    "lv",
    "bn",
    "ur",
    "sw",
    "pa-Arab",
    "te",
    "mr",
    "ta",
    "yue",
    "fil",
    "gu",
    "kn",
    "ps",
    "zh-Hant",
    "ml",
    "or",
    "my",
    "pa",
    "pa-Guru",
    "am",
    "om",
    "ha",
    "uz",
    "uz-Latn",
    "yo",
    "ms",
    "ig",
    "mg",
    "ne",
    "as",
    "so",
    "si",
    "km",
    "zu",
    "sn",
    "kk",
    "rw",
    "ckb",
    "qu",
    "ak",
    "be",
    "ti",
    "az",
    "az-Latn",
    "af",
    "sr-Latn",
    "ii",
    "bm",
    "ki",
    "gsw",
    "ug",
    "zgh",
    "ff",
    "rn",
    "sq",
    "ks",
    "hy",
    "luy",
    "lg",
    "lo",
    "bem",
    "kok",
    "luo",
    "uz-Cyrl",
    "ka",
    "ee",
    "mzn",
    "bs-Cyrl",
    "bs",
    "bs-Latn",
    "kln",
    "kam",
    "gl",
    "tzm",
    "dje",
    "kab",
    "bo",
    "shi-Latn",
    "shi",
    "shi-Tfng",
    "mn",
    "ln",
    "ky",
    "sg",
    "nyn",
    "guz",
    "cgg",
    "xog",
    "lrc",
    "mer",
    "lu",
    "teo",
    "brx",
    "nd",
    "mk",
    "uz-Arab",
    "mas",
    "nn",
    "kde",
    "mfe",
    "seh",
    "mgh",
    "az-Cyrl",
    "ga",
    "eu",
    "yi",
    "ce",
    "ksb",
    "bez",
    "ewo",
    "fy",
    "ebu",
    "nus",
    "ast",
    "asa",
    "ses",
    "os",
    "br",
    "cy",
    "kea",
    "lag",
    "sah",
    "mt",
    "vun",
    "rof",
    "jmc",
    "lb",
    "dav",
    "dyo",
    "dz",
    "nnh",
    "is",
    "khq",
    "bas",
    "naq",
    "mua",
    "ksh",
    "saq",
    "se",
    "dua",
    "rwk",
    "mgo",
    "sbp",
    "to",
    "jgo",
    "ksf",
    "fo",
    "gd",
    "kl",
    "rm",
    "fur",
    "agq",
    "haw",
    "chr",
    "hsb",
    "wae",
    "nmg",
    "lkt",
    "twq",
    "dsb",
    "yav",
    "kw",
    "gv",
    "smn",
    "eo",
    "tl"
]

language_map = {
    "af": [
        "af"
    ],
    "agq": [
        "agq"
    ],
    "ak": [
        "ak"
    ],
    "am": [
        "am"
    ],
    "ar": [
        "ar"
    ],
    "as": [
        "as"
    ],
    "asa": [
        "asa"
    ],
    "ast": [
        "ast"
    ],
    "az": [
        "az",
        "az-Cyrl",
        "az-Latn"
    ],
    "bas": [
        "bas"
    ],
    "be": [
        "be"
    ],
    "bem": [
        "bem"
    ],
    "bez": [
        "bez"
    ],
    "bg": [
        "bg"
    ],
    "bm": [
        "bm"
    ],
    "bn": [
        "bn"
    ],
    "bo": [
        "bo"
    ],
    "br": [
        "br"
    ],
    "brx": [
        "brx"
    ],
    "bs": [
        "bs",
        "bs-Cyrl",
        "bs-Latn"
    ],
    "ca": [
        "ca"
    ],
    "ce": [
        "ce"
    ],
    "cgg": [
        "cgg"
    ],
    "chr": [
        "chr"
    ],
    "ckb": [
        "ckb"
    ],
    "cs": [
        "cs"
    ],
    "cy": [
        "cy"
    ],
    "da": [
        "da"
    ],
    "dav": [
        "dav"
    ],
    "de": [
        "de"
    ],
    "dje": [
        "dje"
    ],
    "dsb": [
        "dsb"
    ],
    "dua": [
        "dua"
    ],
    "dyo": [
        "dyo"
    ],
    "dz": [
        "dz"
    ],
    "ebu": [
        "ebu"
    ],
    "ee": [
        "ee"
    ],
    "el": [
        "el"
    ],
    "en": [
        "en"
    ],
    "eo": [
        "eo"
    ],
    "es": [
        "es"
    ],
    "et": [
        "et"
    ],
    "eu": [
        "eu"
    ],
    "ewo": [
        "ewo"
    ],
    "fa": [
        "fa"
    ],
    "ff": [
        "ff"
    ],
    "fi": [
        "fi"
    ],
    "fil": [
        "fil"
    ],
    "fo": [
        "fo"
    ],
    "fr": [
        "fr"
    ],
    "fur": [
        "fur"
    ],
    "fy": [
        "fy"
    ],
    "ga": [
        "ga"
    ],
    "gd": [
        "gd"
    ],
    "gl": [
        "gl"
    ],
    "gsw": [
        "gsw"
    ],
    "gu": [
        "gu"
    ],
    "guz": [
        "guz"
    ],
    "gv": [
        "gv"
    ],
    "ha": [
        "ha"
    ],
    "haw": [
        "haw"
    ],
    "he": [
        "he"
    ],
    "hi": [
        "hi"
    ],
    "hr": [
        "hr"
    ],
    "hsb": [
        "hsb"
    ],
    "hu": [
        "hu"
    ],
    "hy": [
        "hy"
    ],
    "id": [
        "id"
    ],
    "ig": [
        "ig"
    ],
    "ii": [
        "ii"
    ],
    "is": [
        "is"
    ],
    "it": [
        "it"
    ],
    "ja": [
        "ja"
    ],
    "jgo": [
        "jgo"
    ],
    "jmc": [
        "jmc"
    ],
    "ka": [
        "ka"
    ],
    "kab": [
        "kab"
    ],
    "kam": [
        "kam"
    ],
    "kde": [
        "kde"
    ],
    "kea": [
        "kea"
    ],
    "khq": [
        "khq"
    ],
    "ki": [
        "ki"
    ],
    "kk": [
        "kk"
    ],
    "kl": [
        "kl"
    ],
    "kln": [
        "kln"
    ],
    "km": [
        "km"
    ],
    "kn": [
        "kn"
    ],
    "ko": [
        "ko"
    ],
    "kok": [
        "kok"
    ],
    "ks": [
        "ks"
    ],
    "ksb": [
        "ksb"
    ],
    "ksf": [
        "ksf"
    ],
    "ksh": [
        "ksh"
    ],
    "kw": [
        "kw"
    ],
    "ky": [
        "ky"
    ],
    "lag": [
        "lag"
    ],
    "lb": [
        "lb"
    ],
    "lg": [
        "lg"
    ],
    "lkt": [
        "lkt"
    ],
    "ln": [
        "ln"
    ],
    "lo": [
        "lo"
    ],
    "lrc": [
        "lrc"
    ],
    "lt": [
        "lt"
    ],
    "lu": [
        "lu"
    ],
    "luo": [
        "luo"
    ],
    "luy": [
        "luy"
    ],
    "lv": [
        "lv"
    ],
    "mas": [
        "mas"
    ],
    "mer": [
        "mer"
    ],
    "mfe": [
        "mfe"
    ],
    "mg": [
        "mg"
    ],
    "mgh": [
        "mgh"
    ],
    "mgo": [
        "mgo"
    ],
    "mk": [
        "mk"
    ],
    "ml": [
        "ml"
    ],
    "mn": [
        "mn"
    ],
    "mr": [
        "mr"
    ],
    "ms": [
        "ms"
    ],
    "mt": [
        "mt"
    ],
    "mua": [
        "mua"
    ],
    "my": [
        "my"
    ],
    "mzn": [
        "mzn"
    ],
    "naq": [
        "naq"
    ],
    "nb": [
        "nb"
    ],
    "nd": [
        "nd"
    ],
    "ne": [
        "ne"
    ],
    "nl": [
        "nl"
    ],
    "nmg": [
        "nmg"
    ],
    "nn": [
        "nn"
    ],
    "nnh": [
        "nnh"
    ],
    "nus": [
        "nus"
    ],
    "nyn": [
        "nyn"
    ],
    "om": [
        "om"
    ],
    "or": [
        "or"
    ],
    "os": [
        "os"
    ],
    "pa": [
        "pa",
        "pa-Arab",
        "pa-Guru"
    ],
    "pl": [
        "pl"
    ],
    "ps": [
        "ps"
    ],
    "pt": [
        "pt"
    ],
    "qu": [
        "qu"
    ],
    "rm": [
        "rm"
    ],
    "rn": [
        "rn"
    ],
    "ro": [
        "ro"
    ],
    "rof": [
        "rof"
    ],
    "ru": [
        "ru"
    ],
    "rw": [
        "rw"
    ],
    "rwk": [
        "rwk"
    ],
    "sah": [
        "sah"
    ],
    "saq": [
        "saq"
    ],
    "sbp": [
        "sbp"
    ],
    "se": [
        "se"
    ],
    "seh": [
        "seh"
    ],
    "ses": [
        "ses"
    ],
    "sg": [
        "sg"
    ],
    "shi": [
        "shi",
        "shi-Latn",
        "shi-Tfng"
    ],
    "si": [
        "si"
    ],
    "sk": [
        "sk"
    ],
    "sl": [
        "sl"
    ],
    "smn": [
        "smn"
    ],
    "sn": [
        "sn"
    ],
    "so": [
        "so"
    ],
    "sq": [
        "sq"
    ],
    "sr": [
        "sr",
        "sr-Cyrl",
        "sr-Latn"
    ],
    "sv": [
        "sv"
    ],
    "sw": [
        "sw"
    ],
    "ta": [
        "ta"
    ],
    "te": [
        "te"
    ],
    "teo": [
        "teo"
    ],
    "th": [
        "th"
    ],
    "ti": [
        "ti"
    ],
    "tl": [
        "tl"
    ],
    "to": [
        "to"
    ],
    "tr": [
        "tr"
    ],
    "twq": [
        "twq"
    ],
    "tzm": [
        "tzm"
    ],
    "ug": [
        "ug"
    ],
    "uk": [
        "uk"
    ],
    "ur": [
        "ur"
    ],
    "uz": [
        "uz",
        "uz-Arab",
        "uz-Cyrl",
        "uz-Latn"
    ],
    "vi": [
        "vi"
    ],
    "vun": [
        "vun"
    ],
    "wae": [
        "wae"
    ],
    "xog": [
        "xog"
    ],
    "yav": [
        "yav"
    ],
    "yi": [
        "yi"
    ],
    "yo": [
        "yo"
    ],
    "yue": [
        "yue"
    ],
    "zgh": [
        "zgh"
    ],
    "zh": [
        "zh",
        "zh-Hans",
        "zh-Hant"
    ],
    "zu": [
        "zu"
    ]
}

language_locale_dict = {
    "en": [
        "en-001",
        "en-150",
        "en-AG",
        "en-AI",
        "en-AS",
        "en-AT",
        "en-AU",
        "en-BB",
        "en-BE",
        "en-BI",
        "en-BM",
        "en-BS",
        "en-BW",
        "en-BZ",
        "en-CA",
        "en-CC",
        "en-CH",
        "en-CK",
        "en-CM",
        "en-CX",
        "en-CY",
        "en-DE",
        "en-DG",
        "en-DK",
        "en-DM",
        "en-ER",
        "en-FI",
        "en-FJ",
        "en-FK",
        "en-FM",
        "en-GB",
        "en-GD",
        "en-GG",
        "en-GH",
        "en-GI",
        "en-GM",
        "en-GU",
        "en-GY",
        "en-HK",
        "en-IE",
        "en-IL",
        "en-IM",
        "en-IN",
        "en-IO",
        "en-JE",
        "en-JM",
        "en-KE",
        "en-KI",
        "en-KN",
        "en-KY",
        "en-LC",
        "en-LR",
        "en-LS",
        "en-MG",
        "en-MH",
        "en-MO",
        "en-MP",
        "en-MS",
        "en-MT",
        "en-MU",
        "en-MW",
        "en-MY",
        "en-NA",
        "en-NF",
        "en-NG",
        "en-NL",
        "en-NR",
        "en-NU",
        "en-NZ",
        "en-PG",
        "en-PH",
        "en-PK",
        "en-PN",
        "en-PR",
        "en-PW",
        "en-RW",
        "en-SB",
        "en-SC",
        "en-SD",
        "en-SE",
        "en-SG",
        "en-SH",
        "en-SI",
        "en-SL",
        "en-SS",
        "en-SX",
        "en-SZ",
        "en-TC",
        "en-TK",
        "en-TO",
        "en-TT",
        "en-TV",
        "en-TZ",
        "en-UG",
        "en-UM",
        "en-VC",
        "en-VG",
        "en-VI",
        "en-VU",
        "en-WS",
        "en-ZA",
        "en-ZM",
        "en-ZW"
    ],
    "ru": [
        "ru-BY",
        "ru-KG",
        "ru-KZ",
        "ru-MD",
        "ru-UA"
    ],
    "es": [
        "es-419",
        "es-AR",
        "es-BO",
        "es-BR",
        "es-BZ",
        "es-CL",
        "es-CO",
        "es-CR",
        "es-CU",
        "es-DO",
        "es-EA",
        "es-EC",
        "es-GQ",
        "es-GT",
        "es-HN",
        "es-IC",
        "es-MX",
        "es-NI",
        "es-PA",
        "es-PE",
        "es-PH",
        "es-PR",
        "es-PY",
        "es-SV",
        "es-US",
        "es-UY",
        "es-VE"
    ],
    "de": [
        "de-AT",
        "de-BE",
        "de-CH",
        "de-IT",
        "de-LI",
        "de-LU"
    ],
    "fr": [
        "fr-BE",
        "fr-BF",
        "fr-BI",
        "fr-BJ",
        "fr-BL",
        "fr-CA",
        "fr-CD",
        "fr-CF",
        "fr-CG",
        "fr-CH",
        "fr-CI",
        "fr-CM",
        "fr-DJ",
        "fr-DZ",
        "fr-GA",
        "fr-GF",
        "fr-GN",
        "fr-GP",
        "fr-GQ",
        "fr-HT",
        "fr-KM",
        "fr-LU",
        "fr-MA",
        "fr-MC",
        "fr-MF",
        "fr-MG",
        "fr-ML",
        "fr-MQ",
        "fr-MR",
        "fr-MU",
        "fr-NC",
        "fr-NE",
        "fr-PF",
        "fr-PM",
        "fr-RE",
        "fr-RW",
        "fr-SC",
        "fr-SN",
        "fr-SY",
        "fr-TD",
        "fr-TG",
        "fr-TN",
        "fr-VU",
        "fr-WF",
        "fr-YT"
    ],
    "ja": [],
    "tr": [
        "tr-CY"
    ],
    "fa": [
        "fa-AF"
    ],
    "zh": [],
    "zh-Hans": [
        "zh-Hans-HK",
        "zh-Hans-MO",
        "zh-Hans-SG"
    ],
    "it": [
        "it-CH",
        "it-SM",
        "it-VA"
    ],
    "vi": [],
    "pt": [
        "pt-AO",
        "pt-CH",
        "pt-CV",
        "pt-GQ",
        "pt-GW",
        "pt-LU",
        "pt-MO",
        "pt-MZ",
        "pt-PT",
        "pt-ST",
        "pt-TL"
    ],
    "nl": [
        "nl-AW",
        "nl-BE",
        "nl-BQ",
        "nl-CW",
        "nl-SR",
        "nl-SX"
    ],
    "pl": [],
    "ar": [
        "ar-AE",
        "ar-BH",
        "ar-DJ",
        "ar-DZ",
        "ar-EG",
        "ar-EH",
        "ar-ER",
        "ar-IL",
        "ar-IQ",
        "ar-JO",
        "ar-KM",
        "ar-KW",
        "ar-LB",
        "ar-LY",
        "ar-MA",
        "ar-MR",
        "ar-OM",
        "ar-PS",
        "ar-QA",
        "ar-SA",
        "ar-SD",
        "ar-SO",
        "ar-SS",
        "ar-SY",
        "ar-TD",
        "ar-TN",
        "ar-YE"
    ],
    "ko": [
        "ko-KP"
    ],
    "id": [],
    "uk": [],
    "cs": [],
    "th": [],
    "he": [],
    "sv": [
        "sv-AX",
        "sv-FI"
    ],
    "el": [
        "el-CY"
    ],
    "ro": [
        "ro-MD"
    ],
    "da": [
        "da-GL"
    ],
    "hu": [],
    "fi": [],
    "sr": [],
    "sr-Cyrl": [
        "sr-Cyrl-BA",
        "sr-Cyrl-ME",
        "sr-Cyrl-XK"
    ],
    "sk": [],
    "bg": [],
    "nb": [
        "nb-SJ"
    ],
    "hr": [
        "hr-BA"
    ],
    "lt": [],
    "sl": [],
    "hi": [],
    "ca": [
        "ca-AD",
        "ca-FR",
        "ca-IT"
    ],
    "et": [],
    "lv": [],
    "bn": [
        "bn-IN"
    ],
    "ur": [
        "ur-IN"
    ],
    "sw": [
        "sw-CD",
        "sw-KE",
        "sw-UG"
    ],
    "pa-Arab": [],
    "te": [],
    "mr": [],
    "ta": [
        "ta-LK",
        "ta-MY",
        "ta-SG"
    ],
    "yue": [],
    "fil": [],
    "gu": [],
    "kn": [],
    "ps": [],
    "zh-Hant": [
        "zh-Hant-HK",
        "zh-Hant-MO"
    ],
    "ml": [],
    "or": [],
    "my": [],
    "pa": [],
    "pa-Guru": [],
    "am": [],
    "om": [
        "om-KE"
    ],
    "ha": [
        "ha-GH",
        "ha-NE"
    ],
    "uz": [],
    "uz-Latn": [],
    "yo": [
        "yo-BJ"
    ],
    "ms": [
        "ms-BN",
        "ms-SG"
    ],
    "ig": [],
    "mg": [],
    "ne": [
        "ne-IN"
    ],
    "as": [],
    "so": [
        "so-DJ",
        "so-ET",
        "so-KE"
    ],
    "si": [],
    "km": [],
    "zu": [],
    "sn": [],
    "kk": [],
    "rw": [],
    "ckb": [
        "ckb-IR"
    ],
    "qu": [
        "qu-BO",
        "qu-EC"
    ],
    "ak": [],
    "be": [],
    "ti": [
        "ti-ER"
    ],
    "az": [],
    "az-Latn": [],
    "af": [
        "af-NA"
    ],
    "sr-Latn": [
        "sr-Latn-BA",
        "sr-Latn-ME",
        "sr-Latn-XK"
    ],
    "ii": [],
    "bm": [],
    "ki": [],
    "gsw": [
        "gsw-FR",
        "gsw-LI"
    ],
    "ug": [],
    "zgh": [],
    "ff": [
        "ff-CM",
        "ff-GN",
        "ff-MR"
    ],
    "rn": [],
    "sq": [
        "sq-MK",
        "sq-XK"
    ],
    "ks": [],
    "hy": [],
    "luy": [],
    "lg": [],
    "lo": [],
    "bem": [],
    "kok": [],
    "luo": [],
    "uz-Cyrl": [],
    "ka": [],
    "ee": [
        "ee-TG"
    ],
    "mzn": [],
    "bs-Cyrl": [],
    "bs": [],
    "bs-Latn": [],
    "kln": [],
    "kam": [],
    "gl": [],
    "tzm": [],
    "dje": [],
    "kab": [],
    "bo": [
        "bo-IN"
    ],
    "shi-Latn": [],
    "shi": [],
    "shi-Tfng": [],
    "mn": [],
    "ln": [
        "ln-AO",
        "ln-CF",
        "ln-CG"
    ],
    "ky": [],
    "sg": [],
    "nyn": [],
    "guz": [],
    "cgg": [],
    "xog": [],
    "lrc": [
        "lrc-IQ"
    ],
    "mer": [],
    "lu": [],
    "teo": [
        "teo-KE"
    ],
    "brx": [],
    "nd": [],
    "mk": [],
    "uz-Arab": [],
    "mas": [
        "mas-TZ"
    ],
    "nn": [],
    "kde": [],
    "mfe": [],
    "seh": [],
    "mgh": [],
    "az-Cyrl": [],
    "ga": [],
    "eu": [],
    "yi": [],
    "ce": [],
    "ksb": [],
    "bez": [],
    "ewo": [],
    "fy": [],
    "ebu": [],
    "nus": [],
    "ast": [],
    "asa": [],
    "ses": [],
    "os": [
        "os-RU"
    ],
    "br": [],
    "cy": [],
    "kea": [],
    "lag": [],
    "sah": [],
    "mt": [],
    "vun": [],
    "rof": [],
    "jmc": [],
    "lb": [],
    "dav": [],
    "dyo": [],
    "dz": [],
    "nnh": [],
    "is": [],
    "khq": [],
    "bas": [],
    "naq": [],
    "mua": [],
    "ksh": [],
    "saq": [],
    "se": [
        "se-FI",
        "se-SE"
    ],
    "dua": [],
    "rwk": [],
    "mgo": [],
    "sbp": [],
    "to": [],
    "jgo": [],
    "ksf": [],
    "fo": [
        "fo-DK"
    ],
    "gd": [],
    "kl": [],
    "rm": [],
    "fur": [],
    "agq": [],
    "haw": [],
    "chr": [],
    "hsb": [],
    "wae": [],
    "nmg": [],
    "lkt": [],
    "twq": [],
    "dsb": [],
    "yav": [],
    "kw": [],
    "gv": [],
    "smn": [],
    "eo": [],
    "tl": []
}
