// A Bison parser, made by GNU Bison 3.7.5.

// Skeleton implementation for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2021 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.

// DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
// especially those whose name start with YY_ or yy_.  They are
// private implementation details that can be changed or removed.





#include "Parser.hh"


// Unqualified %code blocks.
#line 48 "Parser.yy"

#include "Driver.hh"

/* this "connects" the bison parser in the driver to the flex scanner class
 * object. it defines the yylex() function call to pull the next token from the
 * current lexer object of the driver context. */
#undef yylex
#define yylex driver.lexer->lex


#line 57 "Parser.cc"


#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> // FIXME: INFRINGES ON USER NAME SPACE.
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif


// Whether we are compiled with exception support.
#ifndef YY_EXCEPTIONS
# if defined __GNUC__ && !defined __EXCEPTIONS
#  define YY_EXCEPTIONS 0
# else
#  define YY_EXCEPTIONS 1
# endif
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K].location)
/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

# ifndef YYLLOC_DEFAULT
#  define YYLLOC_DEFAULT(Current, Rhs, N)                               \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).begin  = YYRHSLOC (Rhs, 1).begin;                   \
          (Current).end    = YYRHSLOC (Rhs, N).end;                     \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).begin = (Current).end = YYRHSLOC (Rhs, 0).end;      \
        }                                                               \
    while (false)
# endif


// Enable debugging if requested.
#if YYDEBUG

// A pseudo ostream that takes yydebug_ into account.
# define YYCDEBUG if (yydebug_) (*yycdebug_)

# define YY_SYMBOL_PRINT(Title, Symbol)         \
  do {                                          \
    if (yydebug_)                               \
    {                                           \
      *yycdebug_ << Title << ' ';               \
      yy_print_ (*yycdebug_, Symbol);           \
      *yycdebug_ << '\n';                       \
    }                                           \
  } while (false)

# define YY_REDUCE_PRINT(Rule)          \
  do {                                  \
    if (yydebug_)                       \
      yy_reduce_print_ (Rule);          \
  } while (false)

# define YY_STACK_PRINT()               \
  do {                                  \
    if (yydebug_)                       \
      yy_stack_print_ ();                \
  } while (false)

#else // !YYDEBUG

# define YYCDEBUG if (false) std::cerr
# define YY_SYMBOL_PRINT(Title, Symbol)  YY_USE (Symbol)
# define YY_REDUCE_PRINT(Rule)           static_cast<void> (0)
# define YY_STACK_PRINT()                static_cast<void> (0)

#endif // !YYDEBUG

#define yyerrok         (yyerrstatus_ = 0)
#define yyclearin       (yyla.clear ())

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYRECOVERING()  (!!yyerrstatus_)

#line 25 "Parser.yy"
namespace Tokenizer {
#line 150 "Parser.cc"

  /// Build a parser object.
  parser::parser (macro::Driver &driver_yyarg)
#if YYDEBUG
    : yydebug_ (false),
      yycdebug_ (&std::cerr),
#else
    :
#endif
      driver (driver_yyarg)
  {}

  parser::~parser ()
  {}

  parser::syntax_error::~syntax_error () YY_NOEXCEPT YY_NOTHROW
  {}

  /*---------------.
  | symbol kinds.  |
  `---------------*/

  // basic_symbol.
  template <typename Base>
  parser::basic_symbol<Base>::basic_symbol (const basic_symbol& that)
    : Base (that)
    , value ()
    , location (that.location)
  {
    switch (this->kind ())
    {
      case symbol_kind::S_statement: // statement
      case symbol_kind::S_directive: // directive
      case symbol_kind::S_directive_one_line: // directive_one_line
      case symbol_kind::S_directive_multiline: // directive_multiline
      case symbol_kind::S_for: // for
      case symbol_kind::S_if: // if
      case symbol_kind::S_ifdef: // ifdef
      case symbol_kind::S_ifndef: // ifndef
      case symbol_kind::S_text: // text
      case symbol_kind::S_eval: // eval
        value.copy< DirectivePtr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_for_when: // for_when
      case symbol_kind::S_primary_expr: // primary_expr
      case symbol_kind::S_oper_expr: // oper_expr
      case symbol_kind::S_colon_expr: // colon_expr
      case symbol_kind::S_expr: // expr
        value.copy< ExpressionPtr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_function: // function
        value.copy< FunctionPtr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_symbol: // symbol
        value.copy< VariablePtr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_elseif: // elseif
      case symbol_kind::S_else: // else
        value.copy< pair<ExpressionPtr, vector<DirectivePtr>> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_NAME: // NAME
      case symbol_kind::S_TEXT: // TEXT
      case symbol_kind::S_QUOTED_STRING: // QUOTED_STRING
      case symbol_kind::S_NUMBER: // NUMBER
        value.copy< string > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_function_args: // function_args
      case symbol_kind::S_comma_expr: // comma_expr
      case symbol_kind::S_tuple_comma_expr: // tuple_comma_expr
        value.copy< vector<ExpressionPtr> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_if_list: // if_list
      case symbol_kind::S_if_list1: // if_list1
        value.copy< vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_name_list: // name_list
        value.copy< vector<string> > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

  }



  template <typename Base>
  parser::symbol_kind_type
  parser::basic_symbol<Base>::type_get () const YY_NOEXCEPT
  {
    return this->kind ();
  }

  template <typename Base>
  bool
  parser::basic_symbol<Base>::empty () const YY_NOEXCEPT
  {
    return this->kind () == symbol_kind::S_YYEMPTY;
  }

  template <typename Base>
  void
  parser::basic_symbol<Base>::move (basic_symbol& s)
  {
    super_type::move (s);
    switch (this->kind ())
    {
      case symbol_kind::S_statement: // statement
      case symbol_kind::S_directive: // directive
      case symbol_kind::S_directive_one_line: // directive_one_line
      case symbol_kind::S_directive_multiline: // directive_multiline
      case symbol_kind::S_for: // for
      case symbol_kind::S_if: // if
      case symbol_kind::S_ifdef: // ifdef
      case symbol_kind::S_ifndef: // ifndef
      case symbol_kind::S_text: // text
      case symbol_kind::S_eval: // eval
        value.move< DirectivePtr > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_for_when: // for_when
      case symbol_kind::S_primary_expr: // primary_expr
      case symbol_kind::S_oper_expr: // oper_expr
      case symbol_kind::S_colon_expr: // colon_expr
      case symbol_kind::S_expr: // expr
        value.move< ExpressionPtr > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_function: // function
        value.move< FunctionPtr > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_symbol: // symbol
        value.move< VariablePtr > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_elseif: // elseif
      case symbol_kind::S_else: // else
        value.move< pair<ExpressionPtr, vector<DirectivePtr>> > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_NAME: // NAME
      case symbol_kind::S_TEXT: // TEXT
      case symbol_kind::S_QUOTED_STRING: // QUOTED_STRING
      case symbol_kind::S_NUMBER: // NUMBER
        value.move< string > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_function_args: // function_args
      case symbol_kind::S_comma_expr: // comma_expr
      case symbol_kind::S_tuple_comma_expr: // tuple_comma_expr
        value.move< vector<ExpressionPtr> > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_if_list: // if_list
      case symbol_kind::S_if_list1: // if_list1
        value.move< vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_name_list: // name_list
        value.move< vector<string> > (YY_MOVE (s.value));
        break;

      default:
        break;
    }

    location = YY_MOVE (s.location);
  }

  // by_kind.
  parser::by_kind::by_kind ()
    : kind_ (symbol_kind::S_YYEMPTY)
  {}

#if 201103L <= YY_CPLUSPLUS
  parser::by_kind::by_kind (by_kind&& that)
    : kind_ (that.kind_)
  {
    that.clear ();
  }
#endif

  parser::by_kind::by_kind (const by_kind& that)
    : kind_ (that.kind_)
  {}

  parser::by_kind::by_kind (token_kind_type t)
    : kind_ (yytranslate_ (t))
  {}

  void
  parser::by_kind::clear () YY_NOEXCEPT
  {
    kind_ = symbol_kind::S_YYEMPTY;
  }

  void
  parser::by_kind::move (by_kind& that)
  {
    kind_ = that.kind_;
    that.clear ();
  }

  parser::symbol_kind_type
  parser::by_kind::kind () const YY_NOEXCEPT
  {
    return kind_;
  }

  parser::symbol_kind_type
  parser::by_kind::type_get () const YY_NOEXCEPT
  {
    return this->kind ();
  }


  // by_state.
  parser::by_state::by_state () YY_NOEXCEPT
    : state (empty_state)
  {}

  parser::by_state::by_state (const by_state& that) YY_NOEXCEPT
    : state (that.state)
  {}

  void
  parser::by_state::clear () YY_NOEXCEPT
  {
    state = empty_state;
  }

  void
  parser::by_state::move (by_state& that)
  {
    state = that.state;
    that.clear ();
  }

  parser::by_state::by_state (state_type s) YY_NOEXCEPT
    : state (s)
  {}

  parser::symbol_kind_type
  parser::by_state::kind () const YY_NOEXCEPT
  {
    if (state == empty_state)
      return symbol_kind::S_YYEMPTY;
    else
      return YY_CAST (symbol_kind_type, yystos_[+state]);
  }

  parser::stack_symbol_type::stack_symbol_type ()
  {}

  parser::stack_symbol_type::stack_symbol_type (YY_RVREF (stack_symbol_type) that)
    : super_type (YY_MOVE (that.state), YY_MOVE (that.location))
  {
    switch (that.kind ())
    {
      case symbol_kind::S_statement: // statement
      case symbol_kind::S_directive: // directive
      case symbol_kind::S_directive_one_line: // directive_one_line
      case symbol_kind::S_directive_multiline: // directive_multiline
      case symbol_kind::S_for: // for
      case symbol_kind::S_if: // if
      case symbol_kind::S_ifdef: // ifdef
      case symbol_kind::S_ifndef: // ifndef
      case symbol_kind::S_text: // text
      case symbol_kind::S_eval: // eval
        value.YY_MOVE_OR_COPY< DirectivePtr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_for_when: // for_when
      case symbol_kind::S_primary_expr: // primary_expr
      case symbol_kind::S_oper_expr: // oper_expr
      case symbol_kind::S_colon_expr: // colon_expr
      case symbol_kind::S_expr: // expr
        value.YY_MOVE_OR_COPY< ExpressionPtr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_function: // function
        value.YY_MOVE_OR_COPY< FunctionPtr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_symbol: // symbol
        value.YY_MOVE_OR_COPY< VariablePtr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_elseif: // elseif
      case symbol_kind::S_else: // else
        value.YY_MOVE_OR_COPY< pair<ExpressionPtr, vector<DirectivePtr>> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_NAME: // NAME
      case symbol_kind::S_TEXT: // TEXT
      case symbol_kind::S_QUOTED_STRING: // QUOTED_STRING
      case symbol_kind::S_NUMBER: // NUMBER
        value.YY_MOVE_OR_COPY< string > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_function_args: // function_args
      case symbol_kind::S_comma_expr: // comma_expr
      case symbol_kind::S_tuple_comma_expr: // tuple_comma_expr
        value.YY_MOVE_OR_COPY< vector<ExpressionPtr> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_if_list: // if_list
      case symbol_kind::S_if_list1: // if_list1
        value.YY_MOVE_OR_COPY< vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_name_list: // name_list
        value.YY_MOVE_OR_COPY< vector<string> > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

#if 201103L <= YY_CPLUSPLUS
    // that is emptied.
    that.state = empty_state;
#endif
  }

  parser::stack_symbol_type::stack_symbol_type (state_type s, YY_MOVE_REF (symbol_type) that)
    : super_type (s, YY_MOVE (that.location))
  {
    switch (that.kind ())
    {
      case symbol_kind::S_statement: // statement
      case symbol_kind::S_directive: // directive
      case symbol_kind::S_directive_one_line: // directive_one_line
      case symbol_kind::S_directive_multiline: // directive_multiline
      case symbol_kind::S_for: // for
      case symbol_kind::S_if: // if
      case symbol_kind::S_ifdef: // ifdef
      case symbol_kind::S_ifndef: // ifndef
      case symbol_kind::S_text: // text
      case symbol_kind::S_eval: // eval
        value.move< DirectivePtr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_for_when: // for_when
      case symbol_kind::S_primary_expr: // primary_expr
      case symbol_kind::S_oper_expr: // oper_expr
      case symbol_kind::S_colon_expr: // colon_expr
      case symbol_kind::S_expr: // expr
        value.move< ExpressionPtr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_function: // function
        value.move< FunctionPtr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_symbol: // symbol
        value.move< VariablePtr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_elseif: // elseif
      case symbol_kind::S_else: // else
        value.move< pair<ExpressionPtr, vector<DirectivePtr>> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_NAME: // NAME
      case symbol_kind::S_TEXT: // TEXT
      case symbol_kind::S_QUOTED_STRING: // QUOTED_STRING
      case symbol_kind::S_NUMBER: // NUMBER
        value.move< string > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_function_args: // function_args
      case symbol_kind::S_comma_expr: // comma_expr
      case symbol_kind::S_tuple_comma_expr: // tuple_comma_expr
        value.move< vector<ExpressionPtr> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_if_list: // if_list
      case symbol_kind::S_if_list1: // if_list1
        value.move< vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_name_list: // name_list
        value.move< vector<string> > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

    // that is emptied.
    that.kind_ = symbol_kind::S_YYEMPTY;
  }

#if YY_CPLUSPLUS < 201103L
  parser::stack_symbol_type&
  parser::stack_symbol_type::operator= (const stack_symbol_type& that)
  {
    state = that.state;
    switch (that.kind ())
    {
      case symbol_kind::S_statement: // statement
      case symbol_kind::S_directive: // directive
      case symbol_kind::S_directive_one_line: // directive_one_line
      case symbol_kind::S_directive_multiline: // directive_multiline
      case symbol_kind::S_for: // for
      case symbol_kind::S_if: // if
      case symbol_kind::S_ifdef: // ifdef
      case symbol_kind::S_ifndef: // ifndef
      case symbol_kind::S_text: // text
      case symbol_kind::S_eval: // eval
        value.copy< DirectivePtr > (that.value);
        break;

      case symbol_kind::S_for_when: // for_when
      case symbol_kind::S_primary_expr: // primary_expr
      case symbol_kind::S_oper_expr: // oper_expr
      case symbol_kind::S_colon_expr: // colon_expr
      case symbol_kind::S_expr: // expr
        value.copy< ExpressionPtr > (that.value);
        break;

      case symbol_kind::S_function: // function
        value.copy< FunctionPtr > (that.value);
        break;

      case symbol_kind::S_symbol: // symbol
        value.copy< VariablePtr > (that.value);
        break;

      case symbol_kind::S_elseif: // elseif
      case symbol_kind::S_else: // else
        value.copy< pair<ExpressionPtr, vector<DirectivePtr>> > (that.value);
        break;

      case symbol_kind::S_NAME: // NAME
      case symbol_kind::S_TEXT: // TEXT
      case symbol_kind::S_QUOTED_STRING: // QUOTED_STRING
      case symbol_kind::S_NUMBER: // NUMBER
        value.copy< string > (that.value);
        break;

      case symbol_kind::S_function_args: // function_args
      case symbol_kind::S_comma_expr: // comma_expr
      case symbol_kind::S_tuple_comma_expr: // tuple_comma_expr
        value.copy< vector<ExpressionPtr> > (that.value);
        break;

      case symbol_kind::S_if_list: // if_list
      case symbol_kind::S_if_list1: // if_list1
        value.copy< vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (that.value);
        break;

      case symbol_kind::S_name_list: // name_list
        value.copy< vector<string> > (that.value);
        break;

      default:
        break;
    }

    location = that.location;
    return *this;
  }

  parser::stack_symbol_type&
  parser::stack_symbol_type::operator= (stack_symbol_type& that)
  {
    state = that.state;
    switch (that.kind ())
    {
      case symbol_kind::S_statement: // statement
      case symbol_kind::S_directive: // directive
      case symbol_kind::S_directive_one_line: // directive_one_line
      case symbol_kind::S_directive_multiline: // directive_multiline
      case symbol_kind::S_for: // for
      case symbol_kind::S_if: // if
      case symbol_kind::S_ifdef: // ifdef
      case symbol_kind::S_ifndef: // ifndef
      case symbol_kind::S_text: // text
      case symbol_kind::S_eval: // eval
        value.move< DirectivePtr > (that.value);
        break;

      case symbol_kind::S_for_when: // for_when
      case symbol_kind::S_primary_expr: // primary_expr
      case symbol_kind::S_oper_expr: // oper_expr
      case symbol_kind::S_colon_expr: // colon_expr
      case symbol_kind::S_expr: // expr
        value.move< ExpressionPtr > (that.value);
        break;

      case symbol_kind::S_function: // function
        value.move< FunctionPtr > (that.value);
        break;

      case symbol_kind::S_symbol: // symbol
        value.move< VariablePtr > (that.value);
        break;

      case symbol_kind::S_elseif: // elseif
      case symbol_kind::S_else: // else
        value.move< pair<ExpressionPtr, vector<DirectivePtr>> > (that.value);
        break;

      case symbol_kind::S_NAME: // NAME
      case symbol_kind::S_TEXT: // TEXT
      case symbol_kind::S_QUOTED_STRING: // QUOTED_STRING
      case symbol_kind::S_NUMBER: // NUMBER
        value.move< string > (that.value);
        break;

      case symbol_kind::S_function_args: // function_args
      case symbol_kind::S_comma_expr: // comma_expr
      case symbol_kind::S_tuple_comma_expr: // tuple_comma_expr
        value.move< vector<ExpressionPtr> > (that.value);
        break;

      case symbol_kind::S_if_list: // if_list
      case symbol_kind::S_if_list1: // if_list1
        value.move< vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (that.value);
        break;

      case symbol_kind::S_name_list: // name_list
        value.move< vector<string> > (that.value);
        break;

      default:
        break;
    }

    location = that.location;
    // that is emptied.
    that.state = empty_state;
    return *this;
  }
#endif

  template <typename Base>
  void
  parser::yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const
  {
    if (yymsg)
      YY_SYMBOL_PRINT (yymsg, yysym);
  }

#if YYDEBUG
  template <typename Base>
  void
  parser::yy_print_ (std::ostream& yyo, const basic_symbol<Base>& yysym) const
  {
    std::ostream& yyoutput = yyo;
    YY_USE (yyoutput);
    if (yysym.empty ())
      yyo << "empty symbol";
    else
      {
        symbol_kind_type yykind = yysym.kind ();
        yyo << (yykind < YYNTOKENS ? "token" : "nterm")
            << ' ' << yysym.name () << " ("
            << yysym.location << ": ";
        YY_USE (yykind);
        yyo << ')';
      }
  }
#endif

  void
  parser::yypush_ (const char* m, YY_MOVE_REF (stack_symbol_type) sym)
  {
    if (m)
      YY_SYMBOL_PRINT (m, sym);
    yystack_.push (YY_MOVE (sym));
  }

  void
  parser::yypush_ (const char* m, state_type s, YY_MOVE_REF (symbol_type) sym)
  {
#if 201103L <= YY_CPLUSPLUS
    yypush_ (m, stack_symbol_type (s, std::move (sym)));
#else
    stack_symbol_type ss (s, sym);
    yypush_ (m, ss);
#endif
  }

  void
  parser::yypop_ (int n)
  {
    yystack_.pop (n);
  }

#if YYDEBUG
  std::ostream&
  parser::debug_stream () const
  {
    return *yycdebug_;
  }

  void
  parser::set_debug_stream (std::ostream& o)
  {
    yycdebug_ = &o;
  }


  parser::debug_level_type
  parser::debug_level () const
  {
    return yydebug_;
  }

  void
  parser::set_debug_level (debug_level_type l)
  {
    yydebug_ = l;
  }
#endif // YYDEBUG

  parser::state_type
  parser::yy_lr_goto_state_ (state_type yystate, int yysym)
  {
    int yyr = yypgoto_[yysym - YYNTOKENS] + yystate;
    if (0 <= yyr && yyr <= yylast_ && yycheck_[yyr] == yystate)
      return yytable_[yyr];
    else
      return yydefgoto_[yysym - YYNTOKENS];
  }

  bool
  parser::yy_pact_value_is_default_ (int yyvalue)
  {
    return yyvalue == yypact_ninf_;
  }

  bool
  parser::yy_table_value_is_error_ (int yyvalue)
  {
    return yyvalue == yytable_ninf_;
  }

  int
  parser::operator() ()
  {
    return parse ();
  }

  int
  parser::parse ()
  {
    int yyn;
    /// Length of the RHS of the rule being reduced.
    int yylen = 0;

    // Error handling.
    int yynerrs_ = 0;
    int yyerrstatus_ = 0;

    /// The lookahead symbol.
    symbol_type yyla;

    /// The locations where the error started and ended.
    stack_symbol_type yyerror_range[3];

    /// The return value of parse ().
    int yyresult;

#if YY_EXCEPTIONS
    try
#endif // YY_EXCEPTIONS
      {
    YYCDEBUG << "Starting parse\n";


    // User initialization code.
#line 38 "Parser.yy"
{
  // Initialize the location filenames
  yyla.location.begin.filename = yyla.location.end.filename = &driver.file;
}

#line 842 "Parser.cc"


    /* Initialize the stack.  The initial state will be set in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystack_.clear ();
    yypush_ (YY_NULLPTR, 0, YY_MOVE (yyla));

  /*-----------------------------------------------.
  | yynewstate -- push a new symbol on the stack.  |
  `-----------------------------------------------*/
  yynewstate:
    YYCDEBUG << "Entering state " << int (yystack_[0].state) << '\n';
    YY_STACK_PRINT ();

    // Accept?
    if (yystack_[0].state == yyfinal_)
      YYACCEPT;

    goto yybackup;


  /*-----------.
  | yybackup.  |
  `-----------*/
  yybackup:
    // Try to take a decision without lookahead.
    yyn = yypact_[+yystack_[0].state];
    if (yy_pact_value_is_default_ (yyn))
      goto yydefault;

    // Read a lookahead token.
    if (yyla.empty ())
      {
        YYCDEBUG << "Reading a token\n";
#if YY_EXCEPTIONS
        try
#endif // YY_EXCEPTIONS
          {
            yyla.kind_ = yytranslate_ (yylex (&yyla.value, &yyla.location, driver));
          }
#if YY_EXCEPTIONS
        catch (const syntax_error& yyexc)
          {
            YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
            error (yyexc);
            goto yyerrlab1;
          }
#endif // YY_EXCEPTIONS
      }
    YY_SYMBOL_PRINT ("Next token is", yyla);

    if (yyla.kind () == symbol_kind::S_YYerror)
    {
      // The scanner already issued an error message, process directly
      // to error recovery.  But do not keep the error token as
      // lookahead, it is too special and may lead us to an endless
      // loop in error recovery. */
      yyla.kind_ = symbol_kind::S_YYUNDEF;
      goto yyerrlab1;
    }

    /* If the proper action on seeing token YYLA.TYPE is to reduce or
       to detect an error, take that action.  */
    yyn += yyla.kind ();
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yyla.kind ())
      {
        goto yydefault;
      }

    // Reduce or error.
    yyn = yytable_[yyn];
    if (yyn <= 0)
      {
        if (yy_table_value_is_error_ (yyn))
          goto yyerrlab;
        yyn = -yyn;
        goto yyreduce;
      }

    // Count tokens shifted since error; after three, turn off error status.
    if (yyerrstatus_)
      --yyerrstatus_;

    // Shift the lookahead token.
    yypush_ ("Shifting", state_type (yyn), YY_MOVE (yyla));
    goto yynewstate;


  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[+yystack_[0].state];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;


  /*-----------------------------.
  | yyreduce -- do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    {
      stack_symbol_type yylhs;
      yylhs.state = yy_lr_goto_state_ (yystack_[yylen].state, yyr1_[yyn]);
      /* Variants are always initialized to an empty instance of the
         correct type. The default '$$ = $1' action is NOT applied
         when using variants.  */
      switch (yyr1_[yyn])
    {
      case symbol_kind::S_statement: // statement
      case symbol_kind::S_directive: // directive
      case symbol_kind::S_directive_one_line: // directive_one_line
      case symbol_kind::S_directive_multiline: // directive_multiline
      case symbol_kind::S_for: // for
      case symbol_kind::S_if: // if
      case symbol_kind::S_ifdef: // ifdef
      case symbol_kind::S_ifndef: // ifndef
      case symbol_kind::S_text: // text
      case symbol_kind::S_eval: // eval
        yylhs.value.emplace< DirectivePtr > ();
        break;

      case symbol_kind::S_for_when: // for_when
      case symbol_kind::S_primary_expr: // primary_expr
      case symbol_kind::S_oper_expr: // oper_expr
      case symbol_kind::S_colon_expr: // colon_expr
      case symbol_kind::S_expr: // expr
        yylhs.value.emplace< ExpressionPtr > ();
        break;

      case symbol_kind::S_function: // function
        yylhs.value.emplace< FunctionPtr > ();
        break;

      case symbol_kind::S_symbol: // symbol
        yylhs.value.emplace< VariablePtr > ();
        break;

      case symbol_kind::S_elseif: // elseif
      case symbol_kind::S_else: // else
        yylhs.value.emplace< pair<ExpressionPtr, vector<DirectivePtr>> > ();
        break;

      case symbol_kind::S_NAME: // NAME
      case symbol_kind::S_TEXT: // TEXT
      case symbol_kind::S_QUOTED_STRING: // QUOTED_STRING
      case symbol_kind::S_NUMBER: // NUMBER
        yylhs.value.emplace< string > ();
        break;

      case symbol_kind::S_function_args: // function_args
      case symbol_kind::S_comma_expr: // comma_expr
      case symbol_kind::S_tuple_comma_expr: // tuple_comma_expr
        yylhs.value.emplace< vector<ExpressionPtr> > ();
        break;

      case symbol_kind::S_if_list: // if_list
      case symbol_kind::S_if_list1: // if_list1
        yylhs.value.emplace< vector<pair<ExpressionPtr, vector<DirectivePtr>>> > ();
        break;

      case symbol_kind::S_name_list: // name_list
        yylhs.value.emplace< vector<string> > ();
        break;

      default:
        break;
    }


      // Default location.
      {
        stack_type::slice range (yystack_, yylen);
        YYLLOC_DEFAULT (yylhs.location, range, yylen);
        yyerror_range[1].location = yylhs.location;
      }

      // Perform the reduction.
      YY_REDUCE_PRINT (yyn);
#if YY_EXCEPTIONS
      try
#endif // YY_EXCEPTIONS
        {
          switch (yyn)
            {
  case 4: // statements: statement
#line 115 "Parser.yy"
             {
               driver.inContext() ? driver.pushContextTop(yystack_[0].value.as < DirectivePtr > ()) : driver.pushStatements(yystack_[0].value.as < DirectivePtr > ());
             }
#line 1037 "Parser.cc"
    break;

  case 5: // statements: statements statement
#line 119 "Parser.yy"
             {
               driver.inContext() ? driver.pushContextTop(yystack_[0].value.as < DirectivePtr > ()) : driver.pushStatements(yystack_[0].value.as < DirectivePtr > ());
             }
#line 1045 "Parser.cc"
    break;

  case 6: // statement: directive
#line 124 "Parser.yy"
            { yylhs.value.as < DirectivePtr > () = yystack_[0].value.as < DirectivePtr > (); }
#line 1051 "Parser.cc"
    break;

  case 7: // statement: text
#line 125 "Parser.yy"
            { yylhs.value.as < DirectivePtr > () = yystack_[0].value.as < DirectivePtr > (); }
#line 1057 "Parser.cc"
    break;

  case 8: // statement: eval
#line 126 "Parser.yy"
            { yylhs.value.as < DirectivePtr > () = yystack_[0].value.as < DirectivePtr > (); }
#line 1063 "Parser.cc"
    break;

  case 9: // directive: directive_one_line EOL
#line 129 "Parser.yy"
            { yylhs.value.as < DirectivePtr > () = yystack_[1].value.as < DirectivePtr > (); }
#line 1069 "Parser.cc"
    break;

  case 10: // directive: directive_multiline EOL
#line 130 "Parser.yy"
            { yylhs.value.as < DirectivePtr > () = yystack_[1].value.as < DirectivePtr > (); }
#line 1075 "Parser.cc"
    break;

  case 11: // directive_one_line: INCLUDE expr
#line 134 "Parser.yy"
                     { yylhs.value.as < DirectivePtr > () = make_shared<Include>(yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1081 "Parser.cc"
    break;

  case 12: // directive_one_line: INCLUDEPATH expr
#line 136 "Parser.yy"
                     { yylhs.value.as < DirectivePtr > () = make_shared<IncludePath>(yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1087 "Parser.cc"
    break;

  case 13: // directive_one_line: DEFINE symbol
#line 138 "Parser.yy"
                     {
                       auto tmp = make_shared<Real>("1", yylhs.location);
                       yylhs.value.as < DirectivePtr > () = make_shared<Define>(yystack_[0].value.as < VariablePtr > (), tmp, yylhs.location);
                     }
#line 1096 "Parser.cc"
    break;

  case 14: // directive_one_line: DEFINE symbol EQUAL expr
#line 143 "Parser.yy"
                     { yylhs.value.as < DirectivePtr > () = make_shared<Define>(yystack_[2].value.as < VariablePtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1102 "Parser.cc"
    break;

  case 15: // directive_one_line: DEFINE function EQUAL expr
#line 145 "Parser.yy"
                     { yylhs.value.as < DirectivePtr > () = make_shared<Define>(yystack_[2].value.as < FunctionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1108 "Parser.cc"
    break;

  case 16: // directive_one_line: D_ECHO expr
#line 147 "Parser.yy"
                     { yylhs.value.as < DirectivePtr > () = make_shared<Echo>(yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1114 "Parser.cc"
    break;

  case 17: // directive_one_line: ERROR expr
#line 149 "Parser.yy"
                     { yylhs.value.as < DirectivePtr > () = make_shared<Error>(yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1120 "Parser.cc"
    break;

  case 18: // directive_one_line: ECHOMACROVARS
#line 151 "Parser.yy"
                     { yylhs.value.as < DirectivePtr > () = make_shared<EchoMacroVars>(false, yylhs.location); }
#line 1126 "Parser.cc"
    break;

  case 19: // directive_one_line: ECHOMACROVARS name_list
#line 153 "Parser.yy"
                     { yylhs.value.as < DirectivePtr > () = make_shared<EchoMacroVars>(false, yystack_[0].value.as < vector<string> > (), yylhs.location); }
#line 1132 "Parser.cc"
    break;

  case 20: // directive_one_line: ECHOMACROVARS LPAREN SAVE RPAREN
#line 155 "Parser.yy"
                     { yylhs.value.as < DirectivePtr > () = make_shared<EchoMacroVars>(true, yylhs.location); }
#line 1138 "Parser.cc"
    break;

  case 21: // directive_one_line: ECHOMACROVARS LPAREN SAVE RPAREN name_list
#line 157 "Parser.yy"
                     { yylhs.value.as < DirectivePtr > () = make_shared<EchoMacroVars>(true, yystack_[0].value.as < vector<string> > (), yylhs.location); }
#line 1144 "Parser.cc"
    break;

  case 22: // directive_one_line: LINE QUOTED_STRING NUMBER
#line 159 "Parser.yy"
                     {
                       // `@#line` is ignored; adjust newlines in output to accord
                       auto l = static_cast<Tokenizer::parser::location_type>(yylhs.location);
                       yylhs.value.as < DirectivePtr > () = make_shared<TextNode>(string(l.end.line - l.begin.line + 1, '\n'), yylhs.location);
                     }
#line 1154 "Parser.cc"
    break;

  case 23: // name_list: NAME
#line 167 "Parser.yy"
            { yylhs.value.as < vector<string> > () = {yystack_[0].value.as < string > ()}; }
#line 1160 "Parser.cc"
    break;

  case 24: // name_list: name_list NAME
#line 169 "Parser.yy"
            {
              yystack_[1].value.as < vector<string> > ().emplace_back(yystack_[0].value.as < string > ());
              yylhs.value.as < vector<string> > () = yystack_[1].value.as < vector<string> > ();
            }
#line 1169 "Parser.cc"
    break;

  case 25: // directive_multiline: for
#line 175 "Parser.yy"
                      { yylhs.value.as < DirectivePtr > () = yystack_[0].value.as < DirectivePtr > (); }
#line 1175 "Parser.cc"
    break;

  case 26: // directive_multiline: if
#line 176 "Parser.yy"
                      { yylhs.value.as < DirectivePtr > () = yystack_[0].value.as < DirectivePtr > (); }
#line 1181 "Parser.cc"
    break;

  case 27: // directive_multiline: ifdef
#line 177 "Parser.yy"
                      { yylhs.value.as < DirectivePtr > () = yystack_[0].value.as < DirectivePtr > (); }
#line 1187 "Parser.cc"
    break;

  case 28: // directive_multiline: ifndef
#line 178 "Parser.yy"
                      { yylhs.value.as < DirectivePtr > () = yystack_[0].value.as < DirectivePtr > (); }
#line 1193 "Parser.cc"
    break;

  case 29: // for_when: %empty
#line 182 "Parser.yy"
           { yylhs.value.as < ExpressionPtr > () = shared_ptr<Expression>(); }
#line 1199 "Parser.cc"
    break;

  case 30: // for_when: WHEN expr
#line 184 "Parser.yy"
           { yylhs.value.as < ExpressionPtr > () = yystack_[0].value.as < ExpressionPtr > (); }
#line 1205 "Parser.cc"
    break;

  case 31: // $@1: %empty
#line 187 "Parser.yy"
          { driver.pushContext(); }
#line 1211 "Parser.cc"
    break;

  case 32: // for: FOR $@1 expr IN expr for_when EOL statements ENDFOR
#line 188 "Parser.yy"
      {
        vector<VariablePtr> vvnp;
        auto tmpt = dynamic_pointer_cast<Tuple>(yystack_[6].value.as < ExpressionPtr > ());
        auto tmpv = dynamic_pointer_cast<Variable>(yystack_[6].value.as < ExpressionPtr > ());
        if (tmpv)
          vvnp.emplace_back(tmpv);
        else if (tmpt)
          for (const auto & it : tmpt->getValue())
            {
              auto vnp = dynamic_pointer_cast<Variable>(it);
              if (!vnp)
                error(yylhs.location, "For loop indices must be variables");
              vvnp.emplace_back(vnp);
            }
        else
          error(yystack_[8].location, "For loop indices must be a variable or a tuple");

        auto vdp = driver.popContext();
        vdp.emplace_back(make_shared<TextNode>("\n", yystack_[0].location));

        if (!yystack_[3].value.as < ExpressionPtr > ())
          yylhs.value.as < DirectivePtr > () = make_shared<For>(vvnp, yystack_[4].value.as < ExpressionPtr > (), vdp, yylhs.location);
        else
          {
            auto tmpc = make_shared<Comprehension>(true, yystack_[6].value.as < ExpressionPtr > (), yystack_[4].value.as < ExpressionPtr > (), yystack_[3].value.as < ExpressionPtr > (), yystack_[3].location);
            yylhs.value.as < DirectivePtr > () = make_shared<For>(vvnp, tmpc, vdp, yylhs.location);
          }
      }
#line 1244 "Parser.cc"
    break;

  case 33: // $@2: %empty
#line 218 "Parser.yy"
        { driver.pushContext(); }
#line 1250 "Parser.cc"
    break;

  case 34: // if: IF $@2 if_list ENDIF
#line 219 "Parser.yy"
     { yylhs.value.as < DirectivePtr > () = make_shared<If>(yystack_[1].value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (), yylhs.location); }
#line 1256 "Parser.cc"
    break;

  case 35: // $@3: %empty
#line 222 "Parser.yy"
              { driver.pushContext(); }
#line 1262 "Parser.cc"
    break;

  case 36: // ifdef: IFDEF $@3 if_list ENDIF
#line 223 "Parser.yy"
        { yylhs.value.as < DirectivePtr > () = make_shared<Ifdef>(yystack_[1].value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (), yylhs.location); }
#line 1268 "Parser.cc"
    break;

  case 37: // $@4: %empty
#line 226 "Parser.yy"
                { driver.pushContext(); }
#line 1274 "Parser.cc"
    break;

  case 38: // ifndef: IFNDEF $@4 if_list ENDIF
#line 227 "Parser.yy"
         { yylhs.value.as < DirectivePtr > () = make_shared<Ifndef>(yystack_[1].value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (), yylhs.location); }
#line 1280 "Parser.cc"
    break;

  case 39: // if_list: if_list1
#line 230 "Parser.yy"
          { yylhs.value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > () = yystack_[0].value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (); }
#line 1286 "Parser.cc"
    break;

  case 40: // if_list: if_list1 else
#line 232 "Parser.yy"
          {
            yystack_[1].value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > ().emplace_back(yystack_[0].value.as < pair<ExpressionPtr, vector<DirectivePtr>> > ());
            yylhs.value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > () = yystack_[1].value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > ();
          }
#line 1295 "Parser.cc"
    break;

  case 41: // if_list1: expr EOL
#line 239 "Parser.yy"
           {
             auto context = driver.popContext();
             context.emplace_back(make_shared<TextNode>("\n", yystack_[0].location));
             yylhs.value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > () = {{yystack_[1].value.as < ExpressionPtr > (), context}};
           }
#line 1305 "Parser.cc"
    break;

  case 42: // if_list1: expr EOL statements
#line 245 "Parser.yy"
           {
             auto context = driver.popContext();
             context.emplace_back(make_shared<TextNode>("\n", yystack_[0].location));
             yylhs.value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > () = {{yystack_[2].value.as < ExpressionPtr > (), context}};
           }
#line 1315 "Parser.cc"
    break;

  case 43: // if_list1: if_list1 elseif
#line 251 "Parser.yy"
           {
             yystack_[1].value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > ().emplace_back(yystack_[0].value.as < pair<ExpressionPtr, vector<DirectivePtr>> > ());
             yylhs.value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > () = yystack_[1].value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > ();
           }
#line 1324 "Parser.cc"
    break;

  case 44: // elseif_begin: ELSEIF
#line 257 "Parser.yy"
                      { driver.pushContext(); }
#line 1330 "Parser.cc"
    break;

  case 45: // elseif: elseif_begin expr EOL
#line 260 "Parser.yy"
         {
           auto context = driver.popContext();
           context.emplace_back(make_shared<TextNode>("\n", yystack_[0].location));
           yylhs.value.as < pair<ExpressionPtr, vector<DirectivePtr>> > () = {yystack_[1].value.as < ExpressionPtr > (), context};
         }
#line 1340 "Parser.cc"
    break;

  case 46: // elseif: elseif_begin expr EOL statements
#line 266 "Parser.yy"
         {
           auto context = driver.popContext();
           context.emplace_back(make_shared<TextNode>("\n", yystack_[0].location));
           yylhs.value.as < pair<ExpressionPtr, vector<DirectivePtr>> > () = {yystack_[2].value.as < ExpressionPtr > (), context};
         }
#line 1350 "Parser.cc"
    break;

  case 47: // else_begin: ELSE
#line 273 "Parser.yy"
                  { driver.pushContext(); }
#line 1356 "Parser.cc"
    break;

  case 48: // else: else_begin EOL
#line 276 "Parser.yy"
       {
         auto context = driver.popContext();
         context.emplace_back(make_shared<TextNode>("\n", yystack_[0].location));
         yylhs.value.as < pair<ExpressionPtr, vector<DirectivePtr>> > () = {make_shared<Bool>(true, yystack_[1].location), context};
       }
#line 1366 "Parser.cc"
    break;

  case 49: // else: else_begin EOL statements
#line 282 "Parser.yy"
       {
         auto context = driver.popContext();
         context.emplace_back(make_shared<TextNode>("\n", yystack_[0].location));
         yylhs.value.as < pair<ExpressionPtr, vector<DirectivePtr>> > () = {make_shared<Bool>(true, yystack_[2].location), context};
       }
#line 1376 "Parser.cc"
    break;

  case 50: // text: TEXT
#line 290 "Parser.yy"
       { yylhs.value.as < DirectivePtr > () = make_shared<TextNode>(yystack_[0].value.as < string > (), yylhs.location); }
#line 1382 "Parser.cc"
    break;

  case 51: // text: EOL
#line 292 "Parser.yy"
       { yylhs.value.as < DirectivePtr > () = make_shared<TextNode>("\n", yylhs.location); }
#line 1388 "Parser.cc"
    break;

  case 52: // eval: BEGIN_EVAL expr END_EVAL
#line 296 "Parser.yy"
       { yylhs.value.as < DirectivePtr > () = make_shared<Eval>(yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1394 "Parser.cc"
    break;

  case 53: // symbol: NAME
#line 300 "Parser.yy"
         { yylhs.value.as < VariablePtr > () = make_shared<Variable>(yystack_[0].value.as < string > (), yylhs.location); }
#line 1400 "Parser.cc"
    break;

  case 54: // function: NAME LPAREN RPAREN
#line 304 "Parser.yy"
           { yylhs.value.as < FunctionPtr > () = make_shared<Function>(yystack_[2].value.as < string > (), vector<ExpressionPtr>(), yylhs.location); }
#line 1406 "Parser.cc"
    break;

  case 55: // function: NAME LPAREN function_args RPAREN
#line 306 "Parser.yy"
           { yylhs.value.as < FunctionPtr > () = make_shared<Function>(yystack_[3].value.as < string > (), yystack_[1].value.as < vector<ExpressionPtr> > (), yylhs.location); }
#line 1412 "Parser.cc"
    break;

  case 56: // function_args: symbol
#line 310 "Parser.yy"
                { yylhs.value.as < vector<ExpressionPtr> > () = {yystack_[0].value.as < VariablePtr > ()}; }
#line 1418 "Parser.cc"
    break;

  case 57: // function_args: function_args COMMA symbol
#line 312 "Parser.yy"
                { yystack_[2].value.as < vector<ExpressionPtr> > ().emplace_back(yystack_[0].value.as < VariablePtr > ()); yylhs.value.as < vector<ExpressionPtr> > () = yystack_[2].value.as < vector<ExpressionPtr> > (); }
#line 1424 "Parser.cc"
    break;

  case 58: // comma_expr: %empty
#line 316 "Parser.yy"
             { yylhs.value.as < vector<ExpressionPtr> > () = {}; }
#line 1430 "Parser.cc"
    break;

  case 59: // comma_expr: expr
#line 318 "Parser.yy"
             { yylhs.value.as < vector<ExpressionPtr> > () = {yystack_[0].value.as < ExpressionPtr > ()}; }
#line 1436 "Parser.cc"
    break;

  case 60: // comma_expr: comma_expr COMMA expr
#line 320 "Parser.yy"
             { yystack_[2].value.as < vector<ExpressionPtr> > ().emplace_back(yystack_[0].value.as < ExpressionPtr > ()); yylhs.value.as < vector<ExpressionPtr> > () = yystack_[2].value.as < vector<ExpressionPtr> > (); }
#line 1442 "Parser.cc"
    break;

  case 61: // tuple_comma_expr: %empty
#line 324 "Parser.yy"
                   { yylhs.value.as < vector<ExpressionPtr> > () = {}; }
#line 1448 "Parser.cc"
    break;

  case 62: // tuple_comma_expr: expr COMMA
#line 326 "Parser.yy"
                   { yylhs.value.as < vector<ExpressionPtr> > () = {yystack_[1].value.as < ExpressionPtr > ()}; }
#line 1454 "Parser.cc"
    break;

  case 63: // tuple_comma_expr: expr COMMA expr
#line 328 "Parser.yy"
                   { yylhs.value.as < vector<ExpressionPtr> > () = {yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > ()}; }
#line 1460 "Parser.cc"
    break;

  case 64: // tuple_comma_expr: tuple_comma_expr COMMA expr
#line 330 "Parser.yy"
                   { yystack_[2].value.as < vector<ExpressionPtr> > ().emplace_back(yystack_[0].value.as < ExpressionPtr > ()); yylhs.value.as < vector<ExpressionPtr> > () = yystack_[2].value.as < vector<ExpressionPtr> > (); }
#line 1466 "Parser.cc"
    break;

  case 65: // primary_expr: LPAREN expr RPAREN
#line 334 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = yystack_[1].value.as < ExpressionPtr > (); }
#line 1472 "Parser.cc"
    break;

  case 66: // primary_expr: symbol
#line 336 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = yystack_[0].value.as < VariablePtr > (); }
#line 1478 "Parser.cc"
    break;

  case 67: // primary_expr: NAME LBRACKET comma_expr RBRACKET
#line 338 "Parser.yy"
               {
                 yylhs.value.as < ExpressionPtr > () = make_shared<Variable>(yystack_[3].value.as < string > (), make_shared<Array>(yystack_[1].value.as < vector<ExpressionPtr> > (), yystack_[1].location), yylhs.location);
               }
#line 1486 "Parser.cc"
    break;

  case 68: // primary_expr: NAME LPAREN comma_expr RPAREN
#line 342 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<Function>(yystack_[3].value.as < string > (), yystack_[1].value.as < vector<ExpressionPtr> > (), yylhs.location); }
#line 1492 "Parser.cc"
    break;

  case 69: // primary_expr: TRUE
#line 344 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<Bool>(true, yylhs.location); }
#line 1498 "Parser.cc"
    break;

  case 70: // primary_expr: FALSE
#line 346 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<Bool>(false, yylhs.location); }
#line 1504 "Parser.cc"
    break;

  case 71: // primary_expr: NUMBER
#line 348 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<Real>(yystack_[0].value.as < string > (), yylhs.location); }
#line 1510 "Parser.cc"
    break;

  case 72: // primary_expr: QUOTED_STRING
#line 350 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<String>(yystack_[0].value.as < string > (), yylhs.location); }
#line 1516 "Parser.cc"
    break;

  case 73: // primary_expr: LBRACKET comma_expr RBRACKET
#line 352 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<Array>(yystack_[1].value.as < vector<ExpressionPtr> > (), yylhs.location); }
#line 1522 "Parser.cc"
    break;

  case 74: // primary_expr: LPAREN tuple_comma_expr RPAREN
#line 354 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<Tuple>(yystack_[1].value.as < vector<ExpressionPtr> > (), yylhs.location); }
#line 1528 "Parser.cc"
    break;

  case 75: // primary_expr: LBRACKET expr IN expr WHEN expr RBRACKET
#line 356 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<Comprehension>(true, yystack_[5].value.as < ExpressionPtr > (), yystack_[3].value.as < ExpressionPtr > (), yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1534 "Parser.cc"
    break;

  case 76: // primary_expr: LBRACKET expr FOR expr IN expr RBRACKET
#line 358 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<Comprehension>(yystack_[5].value.as < ExpressionPtr > (), yystack_[3].value.as < ExpressionPtr > (), yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1540 "Parser.cc"
    break;

  case 77: // primary_expr: LBRACKET expr FOR expr IN expr WHEN expr RBRACKET
#line 360 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<Comprehension>(yystack_[7].value.as < ExpressionPtr > (), yystack_[5].value.as < ExpressionPtr > (), yystack_[3].value.as < ExpressionPtr > (), yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1546 "Parser.cc"
    break;

  case 78: // primary_expr: LENGTH LPAREN expr RPAREN
#line 362 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::length, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1552 "Parser.cc"
    break;

  case 79: // primary_expr: ISEMPTY LPAREN expr RPAREN
#line 364 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::isempty, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1558 "Parser.cc"
    break;

  case 80: // primary_expr: ISBOOLEAN LPAREN expr RPAREN
#line 366 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::isboolean, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1564 "Parser.cc"
    break;

  case 81: // primary_expr: ISREAL LPAREN expr RPAREN
#line 368 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::isreal, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1570 "Parser.cc"
    break;

  case 82: // primary_expr: ISSTRING LPAREN expr RPAREN
#line 370 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::isstring, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1576 "Parser.cc"
    break;

  case 83: // primary_expr: ISTUPLE LPAREN expr RPAREN
#line 372 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::istuple, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1582 "Parser.cc"
    break;

  case 84: // primary_expr: ISARRAY LPAREN expr RPAREN
#line 374 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::isarray, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1588 "Parser.cc"
    break;

  case 85: // primary_expr: EXP LPAREN expr RPAREN
#line 376 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::exp, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1594 "Parser.cc"
    break;

  case 86: // primary_expr: LOG LPAREN expr RPAREN
#line 378 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::ln, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1600 "Parser.cc"
    break;

  case 87: // primary_expr: LN LPAREN expr RPAREN
#line 380 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::ln, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1606 "Parser.cc"
    break;

  case 88: // primary_expr: LOG10 LPAREN expr RPAREN
#line 382 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::log10, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1612 "Parser.cc"
    break;

  case 89: // primary_expr: SIN LPAREN expr RPAREN
#line 384 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::sin, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1618 "Parser.cc"
    break;

  case 90: // primary_expr: COS LPAREN expr RPAREN
#line 386 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::cos, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1624 "Parser.cc"
    break;

  case 91: // primary_expr: TAN LPAREN expr RPAREN
#line 388 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::tan, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1630 "Parser.cc"
    break;

  case 92: // primary_expr: ASIN LPAREN expr RPAREN
#line 390 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::asin, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1636 "Parser.cc"
    break;

  case 93: // primary_expr: ACOS LPAREN expr RPAREN
#line 392 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::acos, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1642 "Parser.cc"
    break;

  case 94: // primary_expr: ATAN LPAREN expr RPAREN
#line 394 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::atan, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1648 "Parser.cc"
    break;

  case 95: // primary_expr: SQRT LPAREN expr RPAREN
#line 396 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::sqrt, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1654 "Parser.cc"
    break;

  case 96: // primary_expr: CBRT LPAREN expr RPAREN
#line 398 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::cbrt, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1660 "Parser.cc"
    break;

  case 97: // primary_expr: SIGN LPAREN expr RPAREN
#line 400 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::sign, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1666 "Parser.cc"
    break;

  case 98: // primary_expr: FLOOR LPAREN expr RPAREN
#line 402 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::floor, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1672 "Parser.cc"
    break;

  case 99: // primary_expr: CEIL LPAREN expr RPAREN
#line 404 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::ceil, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1678 "Parser.cc"
    break;

  case 100: // primary_expr: TRUNC LPAREN expr RPAREN
#line 406 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::trunc, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1684 "Parser.cc"
    break;

  case 101: // primary_expr: SUM LPAREN expr RPAREN
#line 408 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::sum, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1690 "Parser.cc"
    break;

  case 102: // primary_expr: ERF LPAREN expr RPAREN
#line 410 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::erf, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1696 "Parser.cc"
    break;

  case 103: // primary_expr: ERFC LPAREN expr RPAREN
#line 412 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::erfc, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1702 "Parser.cc"
    break;

  case 104: // primary_expr: GAMMA LPAREN expr RPAREN
#line 414 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::gamma, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1708 "Parser.cc"
    break;

  case 105: // primary_expr: LGAMMA LPAREN expr RPAREN
#line 416 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::lgamma, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1714 "Parser.cc"
    break;

  case 106: // primary_expr: ROUND LPAREN expr RPAREN
#line 418 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::round, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1720 "Parser.cc"
    break;

  case 107: // primary_expr: NORMPDF LPAREN expr RPAREN
#line 420 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::normpdf, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1726 "Parser.cc"
    break;

  case 108: // primary_expr: NORMCDF LPAREN expr RPAREN
#line 422 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::normcdf, yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1732 "Parser.cc"
    break;

  case 109: // primary_expr: MAX LPAREN expr COMMA expr RPAREN
#line 424 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::max, yystack_[3].value.as < ExpressionPtr > (), yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1738 "Parser.cc"
    break;

  case 110: // primary_expr: MIN LPAREN expr COMMA expr RPAREN
#line 426 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::min, yystack_[3].value.as < ExpressionPtr > (), yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1744 "Parser.cc"
    break;

  case 111: // primary_expr: MOD LPAREN expr COMMA expr RPAREN
#line 428 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::mod, yystack_[3].value.as < ExpressionPtr > (), yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1750 "Parser.cc"
    break;

  case 112: // primary_expr: NORMPDF LPAREN expr COMMA expr COMMA expr RPAREN
#line 430 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<TrinaryOp>(codes::TrinaryOp::normpdf, yystack_[5].value.as < ExpressionPtr > (), yystack_[3].value.as < ExpressionPtr > (), yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1756 "Parser.cc"
    break;

  case 113: // primary_expr: NORMCDF LPAREN expr COMMA expr COMMA expr RPAREN
#line 432 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<TrinaryOp>(codes::TrinaryOp::normcdf, yystack_[5].value.as < ExpressionPtr > (), yystack_[3].value.as < ExpressionPtr > (), yystack_[1].value.as < ExpressionPtr > (), yylhs.location); }
#line 1762 "Parser.cc"
    break;

  case 114: // primary_expr: DEFINED LPAREN NAME RPAREN
#line 434 "Parser.yy"
               { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::defined, make_shared<String>(yystack_[1].value.as < string > (), yystack_[1].location), yylhs.location); }
#line 1768 "Parser.cc"
    break;

  case 115: // oper_expr: primary_expr
#line 437 "Parser.yy"
            { yylhs.value.as < ExpressionPtr > () = yystack_[0].value.as < ExpressionPtr > (); }
#line 1774 "Parser.cc"
    break;

  case 116: // oper_expr: LPAREN BOOL RPAREN oper_expr
#line 439 "Parser.yy"
            { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::cast_bool, yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1780 "Parser.cc"
    break;

  case 117: // oper_expr: LPAREN REAL RPAREN oper_expr
#line 441 "Parser.yy"
            { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::cast_real, yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1786 "Parser.cc"
    break;

  case 118: // oper_expr: LPAREN STRING RPAREN oper_expr
#line 443 "Parser.yy"
            { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::cast_string, yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1792 "Parser.cc"
    break;

  case 119: // oper_expr: LPAREN TUPLE RPAREN oper_expr
#line 445 "Parser.yy"
            { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::cast_tuple, yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1798 "Parser.cc"
    break;

  case 120: // oper_expr: LPAREN ARRAY RPAREN oper_expr
#line 447 "Parser.yy"
            { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::cast_array, yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1804 "Parser.cc"
    break;

  case 121: // oper_expr: NOT oper_expr
#line 449 "Parser.yy"
            { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::logical_not, yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1810 "Parser.cc"
    break;

  case 122: // oper_expr: MINUS oper_expr
#line 451 "Parser.yy"
            { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::unary_minus, yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1816 "Parser.cc"
    break;

  case 123: // oper_expr: PLUS oper_expr
#line 453 "Parser.yy"
            { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::unary_plus, yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1822 "Parser.cc"
    break;

  case 124: // oper_expr: oper_expr PLUS oper_expr
#line 455 "Parser.yy"
            { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::plus, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1828 "Parser.cc"
    break;

  case 125: // oper_expr: oper_expr MINUS oper_expr
#line 457 "Parser.yy"
            { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::minus, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1834 "Parser.cc"
    break;

  case 126: // oper_expr: oper_expr TIMES oper_expr
#line 459 "Parser.yy"
            { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::times, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1840 "Parser.cc"
    break;

  case 127: // oper_expr: oper_expr DIVIDE oper_expr
#line 461 "Parser.yy"
            { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::divide, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1846 "Parser.cc"
    break;

  case 128: // oper_expr: oper_expr POWER oper_expr
#line 463 "Parser.yy"
            { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::power, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1852 "Parser.cc"
    break;

  case 129: // oper_expr: oper_expr UNION oper_expr
#line 465 "Parser.yy"
            { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::set_union, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1858 "Parser.cc"
    break;

  case 130: // oper_expr: oper_expr INTERSECTION oper_expr
#line 467 "Parser.yy"
            { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::set_intersection, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1864 "Parser.cc"
    break;

  case 131: // colon_expr: oper_expr COLON oper_expr
#line 471 "Parser.yy"
             { yylhs.value.as < ExpressionPtr > () = make_shared<Range>(yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1870 "Parser.cc"
    break;

  case 132: // colon_expr: oper_expr COLON oper_expr COLON oper_expr
#line 473 "Parser.yy"
             { yylhs.value.as < ExpressionPtr > () = make_shared<Range>(yystack_[4].value.as < ExpressionPtr > (), yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1876 "Parser.cc"
    break;

  case 133: // expr: oper_expr
#line 476 "Parser.yy"
       { yylhs.value.as < ExpressionPtr > () = yystack_[0].value.as < ExpressionPtr > (); }
#line 1882 "Parser.cc"
    break;

  case 134: // expr: colon_expr
#line 477 "Parser.yy"
       { yylhs.value.as < ExpressionPtr > () = yystack_[0].value.as < ExpressionPtr > (); }
#line 1888 "Parser.cc"
    break;

  case 135: // expr: expr EQUAL_EQUAL expr
#line 479 "Parser.yy"
       { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::equal_equal, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1894 "Parser.cc"
    break;

  case 136: // expr: expr NOT_EQUAL expr
#line 481 "Parser.yy"
       { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::not_equal, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1900 "Parser.cc"
    break;

  case 137: // expr: expr LESS expr
#line 483 "Parser.yy"
       { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::less, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1906 "Parser.cc"
    break;

  case 138: // expr: expr GREATER expr
#line 485 "Parser.yy"
       { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::greater, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1912 "Parser.cc"
    break;

  case 139: // expr: expr LESS_EQUAL expr
#line 487 "Parser.yy"
       { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::less_equal, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1918 "Parser.cc"
    break;

  case 140: // expr: expr GREATER_EQUAL expr
#line 489 "Parser.yy"
       { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::greater_equal, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1924 "Parser.cc"
    break;

  case 141: // expr: expr AND expr
#line 491 "Parser.yy"
       { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::logical_and, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1930 "Parser.cc"
    break;

  case 142: // expr: expr OR expr
#line 493 "Parser.yy"
       { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::logical_or, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1936 "Parser.cc"
    break;

  case 143: // expr: expr IN expr
#line 495 "Parser.yy"
       { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::in, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), yylhs.location); }
#line 1942 "Parser.cc"
    break;


#line 1946 "Parser.cc"

            default:
              break;
            }
        }
#if YY_EXCEPTIONS
      catch (const syntax_error& yyexc)
        {
          YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
          error (yyexc);
          YYERROR;
        }
#endif // YY_EXCEPTIONS
      YY_SYMBOL_PRINT ("-> $$ =", yylhs);
      yypop_ (yylen);
      yylen = 0;

      // Shift the result of the reduction.
      yypush_ (YY_NULLPTR, YY_MOVE (yylhs));
    }
    goto yynewstate;


  /*--------------------------------------.
  | yyerrlab -- here on detecting error.  |
  `--------------------------------------*/
  yyerrlab:
    // If not already recovering from an error, report this error.
    if (!yyerrstatus_)
      {
        ++yynerrs_;
        context yyctx (*this, yyla);
        std::string msg = yysyntax_error_ (yyctx);
        error (yyla.location, YY_MOVE (msg));
      }


    yyerror_range[1].location = yyla.location;
    if (yyerrstatus_ == 3)
      {
        /* If just tried and failed to reuse lookahead token after an
           error, discard it.  */

        // Return failure if at end of input.
        if (yyla.kind () == symbol_kind::S_YYEOF)
          YYABORT;
        else if (!yyla.empty ())
          {
            yy_destroy_ ("Error: discarding", yyla);
            yyla.clear ();
          }
      }

    // Else will try to reuse lookahead token after shifting the error token.
    goto yyerrlab1;


  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:
    /* Pacify compilers when the user code never invokes YYERROR and
       the label yyerrorlab therefore never appears in user code.  */
    if (false)
      YYERROR;

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYERROR.  */
    yypop_ (yylen);
    yylen = 0;
    YY_STACK_PRINT ();
    goto yyerrlab1;


  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3;   // Each real token shifted decrements this.
    // Pop stack until we find a state that shifts the error token.
    for (;;)
      {
        yyn = yypact_[+yystack_[0].state];
        if (!yy_pact_value_is_default_ (yyn))
          {
            yyn += symbol_kind::S_YYerror;
            if (0 <= yyn && yyn <= yylast_
                && yycheck_[yyn] == symbol_kind::S_YYerror)
              {
                yyn = yytable_[yyn];
                if (0 < yyn)
                  break;
              }
          }

        // Pop the current state because it cannot handle the error token.
        if (yystack_.size () == 1)
          YYABORT;

        yyerror_range[1].location = yystack_[0].location;
        yy_destroy_ ("Error: popping", yystack_[0]);
        yypop_ ();
        YY_STACK_PRINT ();
      }
    {
      stack_symbol_type error_token;

      yyerror_range[2].location = yyla.location;
      YYLLOC_DEFAULT (error_token.location, yyerror_range, 2);

      // Shift the error token.
      error_token.state = state_type (yyn);
      yypush_ ("Shifting", YY_MOVE (error_token));
    }
    goto yynewstate;


  /*-------------------------------------.
  | yyacceptlab -- YYACCEPT comes here.  |
  `-------------------------------------*/
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;


  /*-----------------------------------.
  | yyabortlab -- YYABORT comes here.  |
  `-----------------------------------*/
  yyabortlab:
    yyresult = 1;
    goto yyreturn;


  /*-----------------------------------------------------.
  | yyreturn -- parsing is finished, return the result.  |
  `-----------------------------------------------------*/
  yyreturn:
    if (!yyla.empty ())
      yy_destroy_ ("Cleanup: discarding lookahead", yyla);

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYABORT or YYACCEPT.  */
    yypop_ (yylen);
    YY_STACK_PRINT ();
    while (1 < yystack_.size ())
      {
        yy_destroy_ ("Cleanup: popping", yystack_[0]);
        yypop_ ();
      }

    return yyresult;
  }
#if YY_EXCEPTIONS
    catch (...)
      {
        YYCDEBUG << "Exception caught: cleaning lookahead and stack\n";
        // Do not try to display the values of the reclaimed symbols,
        // as their printers might throw an exception.
        if (!yyla.empty ())
          yy_destroy_ (YY_NULLPTR, yyla);

        while (1 < yystack_.size ())
          {
            yy_destroy_ (YY_NULLPTR, yystack_[0]);
            yypop_ ();
          }
        throw;
      }
#endif // YY_EXCEPTIONS
  }

  void
  parser::error (const syntax_error& yyexc)
  {
    error (yyexc.location, yyexc.what ());
  }

  /* Return YYSTR after stripping away unnecessary quotes and
     backslashes, so that it's suitable for yyerror.  The heuristic is
     that double-quoting is unnecessary unless the string contains an
     apostrophe, a comma, or backslash (other than backslash-backslash).
     YYSTR is taken from yytname.  */
  std::string
  parser::yytnamerr_ (const char *yystr)
  {
    if (*yystr == '"')
      {
        std::string yyr;
        char const *yyp = yystr;

        for (;;)
          switch (*++yyp)
            {
            case '\'':
            case ',':
              goto do_not_strip_quotes;

            case '\\':
              if (*++yyp != '\\')
                goto do_not_strip_quotes;
              else
                goto append;

            append:
            default:
              yyr += *yyp;
              break;

            case '"':
              return yyr;
            }
      do_not_strip_quotes: ;
      }

    return yystr;
  }

  std::string
  parser::symbol_name (symbol_kind_type yysymbol)
  {
    return yytnamerr_ (yytname_[yysymbol]);
  }



  // parser::context.
  parser::context::context (const parser& yyparser, const symbol_type& yyla)
    : yyparser_ (yyparser)
    , yyla_ (yyla)
  {}

  int
  parser::context::expected_tokens (symbol_kind_type yyarg[], int yyargn) const
  {
    // Actual number of expected tokens
    int yycount = 0;

    int yyn = yypact_[+yyparser_.yystack_[0].state];
    if (!yy_pact_value_is_default_ (yyn))
      {
        /* Start YYX at -YYN if negative to avoid negative indexes in
           YYCHECK.  In other words, skip the first -YYN actions for
           this state because they are default actions.  */
        int yyxbegin = yyn < 0 ? -yyn : 0;
        // Stay within bounds of both yycheck and yytname.
        int yychecklim = yylast_ - yyn + 1;
        int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
        for (int yyx = yyxbegin; yyx < yyxend; ++yyx)
          if (yycheck_[yyx + yyn] == yyx && yyx != symbol_kind::S_YYerror
              && !yy_table_value_is_error_ (yytable_[yyx + yyn]))
            {
              if (!yyarg)
                ++yycount;
              else if (yycount == yyargn)
                return 0;
              else
                yyarg[yycount++] = YY_CAST (symbol_kind_type, yyx);
            }
      }

    if (yyarg && yycount == 0 && 0 < yyargn)
      yyarg[0] = symbol_kind::S_YYEMPTY;
    return yycount;
  }



  int
  parser::yy_syntax_error_arguments_ (const context& yyctx,
                                                 symbol_kind_type yyarg[], int yyargn) const
  {
    /* There are many possibilities here to consider:
       - If this state is a consistent state with a default action, then
         the only way this function was invoked is if the default action
         is an error action.  In that case, don't check for expected
         tokens because there are none.
       - The only way there can be no lookahead present (in yyla) is
         if this state is a consistent state with a default action.
         Thus, detecting the absence of a lookahead is sufficient to
         determine that there is no unexpected or expected token to
         report.  In that case, just report a simple "syntax error".
       - Don't assume there isn't a lookahead just because this state is
         a consistent state with a default action.  There might have
         been a previous inconsistent state, consistent state with a
         non-default action, or user semantic action that manipulated
         yyla.  (However, yyla is currently not documented for users.)
       - Of course, the expected token list depends on states to have
         correct lookahead information, and it depends on the parser not
         to perform extra reductions after fetching a lookahead from the
         scanner and before detecting a syntax error.  Thus, state merging
         (from LALR or IELR) and default reductions corrupt the expected
         token list.  However, the list is correct for canonical LR with
         one exception: it will still contain any token that will not be
         accepted due to an error action in a later state.
    */

    if (!yyctx.lookahead ().empty ())
      {
        if (yyarg)
          yyarg[0] = yyctx.token ();
        int yyn = yyctx.expected_tokens (yyarg ? yyarg + 1 : yyarg, yyargn - 1);
        return yyn + 1;
      }
    return 0;
  }

  // Generate an error message.
  std::string
  parser::yysyntax_error_ (const context& yyctx) const
  {
    // Its maximum.
    enum { YYARGS_MAX = 5 };
    // Arguments of yyformat.
    symbol_kind_type yyarg[YYARGS_MAX];
    int yycount = yy_syntax_error_arguments_ (yyctx, yyarg, YYARGS_MAX);

    char const* yyformat = YY_NULLPTR;
    switch (yycount)
      {
#define YYCASE_(N, S)                         \
        case N:                               \
          yyformat = S;                       \
        break
      default: // Avoid compiler warnings.
        YYCASE_ (0, YY_("syntax error"));
        YYCASE_ (1, YY_("syntax error, unexpected %s"));
        YYCASE_ (2, YY_("syntax error, unexpected %s, expecting %s"));
        YYCASE_ (3, YY_("syntax error, unexpected %s, expecting %s or %s"));
        YYCASE_ (4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
        YYCASE_ (5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
      }

    std::string yyres;
    // Argument number.
    std::ptrdiff_t yyi = 0;
    for (char const* yyp = yyformat; *yyp; ++yyp)
      if (yyp[0] == '%' && yyp[1] == 's' && yyi < yycount)
        {
          yyres += symbol_name (yyarg[yyi++]);
          ++yyp;
        }
      else
        yyres += *yyp;
    return yyres;
  }


  const short parser::yypact_ninf_ = -170;

  const signed char parser::yytable_ninf_ = -30;

  const short
  parser::yypact_[] =
  {
     213,  -170,  -170,  -170,  -170,   376,   376,   -73,   376,   376,
     376,   -13,   -32,  -170,  -170,    20,   213,  -170,  -170,   -20,
      51,  -170,  -170,  -170,  -170,  -170,  -170,   376,   376,   376,
     376,  -170,  -170,   310,   376,    73,   123,   146,   148,   149,
     151,   153,   155,   165,   167,   169,   171,   174,   175,   176,
     189,   190,   197,   204,   205,   219,   231,   232,   234,   235,
     236,   246,   247,   248,   249,   250,   251,   261,   262,   265,
     376,   376,   376,    38,  -170,  -170,  -170,  -170,   164,  -170,
     411,   411,   266,    75,   131,   411,   411,  1023,   144,  -170,
      93,   113,  -170,  -170,  -170,  -170,   922,   212,     1,   -40,
     277,   278,   208,   275,   283,   287,   288,    30,   127,    29,
      10,   376,   376,   376,   376,   376,   376,   376,   376,   376,
     376,   376,   376,   376,   376,   376,   376,   376,   376,   376,
     376,   376,   376,   376,   376,   376,   376,   376,   376,   376,
     376,   376,   376,   376,   376,   220,   221,   221,   221,   376,
     376,   376,   376,   376,   376,   376,   376,   376,   376,   376,
     376,   376,   376,   376,   376,   376,   376,   376,    -2,   376,
     376,  -170,   291,  -170,  -170,   376,  -170,  -170,  -170,   376,
    -170,   225,  -170,   213,  -170,  -170,   376,   376,   376,   376,
     376,   376,  -170,   376,  -170,   376,  -170,   376,   376,   488,
     499,   519,   528,   546,   557,   566,   586,   604,   624,   633,
     644,   662,   421,   430,   671,   691,   702,   729,   441,   738,
     749,   760,   769,   796,   187,   202,   807,   827,   836,   854,
     865,   874,   894,   295,    52,   411,    53,   301,   209,   217,
     -68,   -68,   221,   221,   237,    27,   378,   -51,   -51,   242,
     242,   242,   242,   245,  -170,  -170,  -170,    71,   411,   411,
     233,   -16,   -31,   213,   213,   221,   221,   221,   221,   221,
     411,   411,   411,   980,    -9,  -170,  -170,  -170,  -170,  -170,
    -170,  -170,  -170,  -170,  -170,  -170,  -170,  -170,   376,   376,
    -170,  -170,  -170,  -170,   376,  -170,  -170,  -170,  -170,  -170,
     376,  -170,   376,  -170,  -170,  -170,  -170,  -170,  -170,  -170,
    -170,  -170,  -170,  -170,   376,   238,  -170,    93,   376,   241,
     213,   213,   376,   376,   912,   932,   941,   452,   461,   152,
    -170,   411,   213,   213,   -12,   997,  -170,  -170,  -170,   376,
     376,    50,  -170,   376,  -170,   952,   970,  -170,  1008,  -170,
    -170,  -170
  };

  const unsigned char
  parser::yydefact_[] =
  {
       2,    31,    33,    35,    37,     0,     0,     0,     0,     0,
       0,    18,     0,    51,    50,     0,     3,     4,     6,     0,
       0,    25,    26,    27,    28,     7,     8,     0,     0,     0,
       0,    69,    70,    61,    58,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    53,    72,    71,    66,   115,   133,   134,
      11,    12,    53,    13,     0,    16,    17,     0,     0,    23,
      19,     0,     1,     5,     9,    10,     0,     0,    39,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      59,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   123,   122,   121,    58,
      58,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,     0,    24,    22,     0,    34,    44,    47,     0,
      43,     0,    40,    41,    36,    38,     0,     0,     0,     0,
       0,     0,    74,    62,    65,     0,    73,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    59,     0,   131,   129,   130,
     124,   125,   126,   127,   128,   142,   141,   135,   136,   137,
     138,   139,   140,   143,    54,    53,    56,     0,    14,    15,
      20,   143,     0,    48,    42,   116,   117,   118,   119,   120,
      64,    63,    60,     0,   143,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,     0,     0,
      98,    99,   100,   101,     0,   102,   103,   104,   105,   106,
       0,   107,     0,   108,    78,    79,    80,    81,    82,    83,
      84,   114,    68,    67,     0,     0,    55,    21,     0,     0,
      45,    49,     0,     0,     0,     0,     0,     0,     0,   132,
      57,    30,     0,    46,   143,     0,   109,   110,   111,     0,
       0,     0,    76,     0,    75,     0,     0,    32,     0,   112,
     113,    77
  };

  const short
  parser::yypgoto_[] =
  {
    -170,  -170,  -169,   -14,  -170,  -170,    65,  -170,  -170,  -170,
    -170,  -170,  -170,  -170,  -170,  -170,  -170,   120,  -170,  -170,
    -170,  -170,  -170,  -170,  -170,    -1,  -170,  -170,     3,  -170,
    -170,    25,  -170,    -5
  };

  const short
  parser::yydefgoto_[] =
  {
       0,    15,    16,    17,    18,    19,    90,    20,   319,    21,
      27,    22,    28,    23,    29,    24,    30,    97,    98,   179,
     180,   181,   182,    25,    26,    76,    84,   257,   109,   107,
      77,    78,    79,    99
  };

  const short
  parser::yytable_[] =
  {
      80,    81,    93,    85,    86,    87,    83,    88,   318,   177,
     178,   342,   343,   197,   264,   323,   156,   157,    82,   254,
      92,   158,    96,   163,   164,   165,   166,   167,   108,   110,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   195,   191,
     183,   192,   196,     1,   347,     2,     3,     4,   149,   320,
     150,    91,   -30,     5,     6,     7,   -30,     8,     9,   -30,
      94,   195,   195,   312,   -29,    10,   313,    11,    89,    12,
     159,   160,   161,   162,   163,   164,   165,   166,   198,   255,
     315,   169,   316,   111,   321,   146,   147,   148,   160,   161,
     162,   163,   164,   165,   166,   167,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   209,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
      13,    95,    14,   112,   235,   235,   193,   170,   194,   100,
     101,   333,   234,   236,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   341,   258,   259,   113,   256,   114,   115,
     261,   116,   172,   117,   262,   118,   237,   238,   239,   240,
     241,   242,   243,   244,   173,   119,   270,   120,   271,   121,
     272,   122,   273,   274,   123,   124,   125,   159,   160,   161,
     162,   163,   164,   165,   166,   167,   300,   174,   301,   126,
     127,   265,   266,   267,   268,   269,     1,   128,     2,     3,
       4,   302,   176,   303,   129,   130,     5,     6,     7,   186,
       8,     9,   152,   153,   154,   155,   156,   157,    10,   131,
      11,   158,    12,   151,   152,   153,   154,   155,   156,   157,
      93,   132,   133,   158,   134,   135,   136,   159,   160,   161,
     162,   163,   164,   165,   166,   167,   137,   138,   139,   140,
     141,   142,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   143,   144,   324,   325,   145,   168,   184,   185,   326,
     153,   154,   155,   156,   157,   327,   187,   328,   158,   154,
     155,   156,   157,    13,   188,    14,   158,    93,   189,   190,
     158,   233,   260,   331,   330,   263,   311,   334,   335,    93,
     167,    31,    32,   -30,    89,   317,   -30,    93,     0,   255,
      33,   332,    34,     0,   345,   346,     0,     0,   348,   329,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,   102,   103,   104,   105,   106,    69,
     314,   152,   153,   154,   155,   156,   157,    31,    32,     0,
     158,     0,    70,    71,     0,     0,    33,    72,    34,     0,
       0,    73,     0,    74,    75,     0,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
     288,     0,     0,     0,     0,    69,     0,     0,     0,   289,
     161,   162,   163,   164,   165,   166,   167,     0,    70,    71,
     294,     0,     0,    72,     0,     0,     0,    73,     0,    74,
      75,   339,     0,     0,     0,     0,     0,     0,     0,     0,
     340,   159,   160,   161,   162,   163,   164,   165,   166,   167,
       0,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   275,
       0,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     276,     0,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     277,     0,     0,     0,     0,     0,     0,     0,     0,   278,
       0,     0,     0,     0,     0,     0,     0,     0,   159,   160,
     161,   162,   163,   164,   165,   166,   167,   279,     0,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   280,     0,
       0,     0,     0,     0,     0,     0,     0,   281,     0,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   159,   160,
     161,   162,   163,   164,   165,   166,   167,   282,     0,     0,
       0,     0,     0,     0,     0,     0,   159,   160,   161,   162,
     163,   164,   165,   166,   167,   283,     0,   159,   160,   161,
     162,   163,   164,   165,   166,   167,   159,   160,   161,   162,
     163,   164,   165,   166,   167,   284,     0,     0,     0,     0,
       0,     0,     0,     0,   285,     0,   159,   160,   161,   162,
     163,   164,   165,   166,   167,   286,     0,     0,     0,     0,
       0,     0,     0,     0,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   287,     0,     0,     0,     0,     0,     0,
       0,     0,   290,     0,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   159,   160,   161,   162,   163,   164,   165,
     166,   167,   291,     0,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   292,     0,     0,     0,     0,     0,     0,
       0,     0,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     293,     0,     0,     0,     0,     0,     0,     0,     0,   295,
       0,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     296,     0,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   297,     0,     0,     0,     0,     0,     0,     0,     0,
     298,     0,     0,     0,     0,     0,     0,     0,     0,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   159,   160,
     161,   162,   163,   164,   165,   166,   167,   299,     0,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   304,     0,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   305,     0,
       0,     0,     0,     0,     0,     0,     0,   306,     0,     0,
       0,     0,     0,     0,     0,     0,   159,   160,   161,   162,
     163,   164,   165,   166,   167,   307,     0,   159,   160,   161,
     162,   163,   164,   165,   166,   167,   308,     0,     0,     0,
       0,     0,     0,     0,     0,   309,     0,   159,   160,   161,
     162,   163,   164,   165,   166,   167,   159,   160,   161,   162,
     163,   164,   165,   166,   167,   310,     0,     0,     0,     0,
       0,     0,     0,     0,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   336,     0,   159,   160,   161,   162,   163,
     164,   165,   166,   167,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   337,     0,     0,     0,     0,     0,     0,
       0,     0,   338,     0,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   349,     0,     0,     0,     0,     0,     0,
       0,     0,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   350,   159,   160,   161,   162,   163,   164,   165,   166,
     175,     0,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     344,     0,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   351,     0,     0,     0,     0,     0,     0,     0,     0,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   171,
     159,   160,   161,   162,   163,   164,   165,   166,   322,     0,
       0,     0,     0,     0,     0,     0,     0,   159,   160,   161,
     162,   163,   164,   165,   166,   167,     0,     0,   159,   160,
     161,   162,   163,   164,   165,   166,   167,     0,     0,     0,
       0,     0,     0,   159,   160,   161,   162,   163,   164,   165,
     166,   167
  };

  const short
  parser::yycheck_[] =
  {
       5,     6,    16,     8,     9,    10,     7,    20,    24,     8,
       9,    23,    24,     3,   183,    24,    84,    85,    91,    21,
       0,    89,    27,    74,    75,    76,    77,    78,    33,    34,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    19,    19,
      90,    21,    23,     3,     4,     5,     6,     7,    20,    90,
      22,    93,    78,    13,    14,    15,    78,    17,    18,    78,
      90,    19,    19,    21,    90,    25,    23,    27,    91,    29,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    91,
      19,    16,    21,    20,   263,    70,    71,    72,    71,    72,
      73,    74,    75,    76,    77,    78,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
      90,    90,    92,    20,   149,   150,    19,    16,    21,    29,
      30,   320,   149,   150,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   332,   169,   170,    20,   168,    20,    20,
     175,    20,    28,    20,   179,    20,   151,   152,   153,   154,
     155,   156,   157,   158,    91,    20,   191,    20,   193,    20,
     195,    20,   197,   198,    20,    20,    20,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    19,    94,    21,    20,
      20,   186,   187,   188,   189,   190,     3,    20,     5,     6,
       7,    19,    10,    21,    20,    20,    13,    14,    15,    21,
      17,    18,    80,    81,    82,    83,    84,    85,    25,    20,
      27,    89,    29,    79,    80,    81,    82,    83,    84,    85,
     264,    20,    20,    89,    20,    20,    20,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    20,    20,    20,    20,
      20,    20,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    20,    20,   288,   289,    20,    20,    10,    10,   294,
      81,    82,    83,    84,    85,   300,    21,   302,    89,    82,
      83,    84,    85,    90,    21,    92,    89,   321,    21,    21,
      89,    91,    21,   318,   315,    90,    21,   322,   323,   333,
      78,    11,    12,    78,    91,   260,    89,   341,    -1,    91,
      20,    90,    22,    -1,   339,   340,    -1,    -1,   343,   314,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      79,    80,    81,    82,    83,    84,    85,    11,    12,    -1,
      89,    -1,    82,    83,    -1,    -1,    20,    87,    22,    -1,
      -1,    91,    -1,    93,    94,    -1,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      19,    -1,    -1,    -1,    -1,    69,    -1,    -1,    -1,    19,
      72,    73,    74,    75,    76,    77,    78,    -1,    82,    83,
      19,    -1,    -1,    87,    -1,    -1,    -1,    91,    -1,    93,
      94,    19,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      19,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      -1,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    21,
      -1,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      21,    -1,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      21,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    21,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    21,    -1,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    21,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    21,    -1,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    21,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    21,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    21,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    21,    -1,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    21,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    21,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    21,    -1,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    21,    -1,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    21,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      21,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    21,
      -1,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      21,    -1,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    21,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      21,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    21,    -1,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    21,    -1,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    21,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    21,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    21,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    21,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    21,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    21,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    21,    -1,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    21,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    21,    -1,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    21,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    21,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    -1,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      23,    -1,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    23,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    26,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    -1,    -1,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    71,    72,    73,    74,    75,    76,
      77,    78
  };

  const unsigned char
  parser::yystos_[] =
  {
       0,     3,     5,     6,     7,    13,    14,    15,    17,    18,
      25,    27,    29,    90,    92,    96,    97,    98,    99,   100,
     102,   104,   106,   108,   110,   118,   119,   105,   107,   109,
     111,    11,    12,    20,    22,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    69,
      82,    83,    87,    91,    93,    94,   120,   125,   126,   127,
     128,   128,    91,   120,   121,   128,   128,   128,    20,    91,
     101,    93,     0,    98,    90,    90,   128,   112,   113,   128,
     112,   112,    64,    65,    66,    67,    68,   124,   128,   123,
     128,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,    20,   126,   126,   126,    20,
      22,    79,    80,    81,    82,    83,    84,    85,    89,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    20,    16,
      16,    26,    28,    91,    94,    78,    10,     8,     9,   114,
     115,   116,   117,    90,    10,    10,    21,    21,    21,    21,
      21,    19,    21,    19,    21,    19,    23,     3,    78,   128,
     128,   128,   128,   128,   128,   128,   128,   128,   128,   128,
     128,   128,   128,   128,   128,   128,   128,   128,   128,   128,
     128,   128,   128,   128,   128,   128,   128,   128,   128,   128,
     128,   128,   128,    91,   123,   128,   123,   126,   126,   126,
     126,   126,   126,   126,   126,   128,   128,   128,   128,   128,
     128,   128,   128,   128,    21,    91,   120,   122,   128,   128,
      21,   128,   128,    90,    97,   126,   126,   126,   126,   126,
     128,   128,   128,   128,   128,    21,    21,    21,    21,    21,
      21,    21,    21,    21,    21,    21,    21,    21,    19,    19,
      21,    21,    21,    21,    19,    21,    21,    21,    21,    21,
      19,    21,    19,    21,    21,    21,    21,    21,    21,    21,
      21,    21,    21,    23,    79,    19,    21,   101,    24,   103,
      90,    97,    78,    24,   128,   128,   128,   128,   128,   126,
     120,   128,    90,    97,   128,   128,    21,    21,    21,    19,
      19,    97,    23,    24,    23,   128,   128,     4,   128,    21,
      21,    23
  };

  const unsigned char
  parser::yyr1_[] =
  {
       0,    95,    96,    96,    97,    97,    98,    98,    98,    99,
      99,   100,   100,   100,   100,   100,   100,   100,   100,   100,
     100,   100,   100,   101,   101,   102,   102,   102,   102,   103,
     103,   105,   104,   107,   106,   109,   108,   111,   110,   112,
     112,   113,   113,   113,   114,   115,   115,   116,   117,   117,
     118,   118,   119,   120,   121,   121,   122,   122,   123,   123,
     123,   124,   124,   124,   124,   125,   125,   125,   125,   125,
     125,   125,   125,   125,   125,   125,   125,   125,   125,   125,
     125,   125,   125,   125,   125,   125,   125,   125,   125,   125,
     125,   125,   125,   125,   125,   125,   125,   125,   125,   125,
     125,   125,   125,   125,   125,   125,   125,   125,   125,   125,
     125,   125,   125,   125,   125,   126,   126,   126,   126,   126,
     126,   126,   126,   126,   126,   126,   126,   126,   126,   126,
     126,   127,   127,   128,   128,   128,   128,   128,   128,   128,
     128,   128,   128,   128
  };

  const signed char
  parser::yyr2_[] =
  {
       0,     2,     0,     1,     1,     2,     1,     1,     1,     2,
       2,     2,     2,     2,     4,     4,     2,     2,     1,     2,
       4,     5,     3,     1,     2,     1,     1,     1,     1,     0,
       2,     0,     9,     0,     4,     0,     4,     0,     4,     1,
       2,     2,     3,     2,     1,     3,     4,     1,     2,     3,
       1,     1,     3,     1,     3,     4,     1,     3,     0,     1,
       3,     0,     2,     3,     3,     3,     1,     4,     4,     1,
       1,     1,     1,     3,     3,     7,     7,     9,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     6,
       6,     6,     8,     8,     4,     1,     4,     4,     4,     4,
       4,     2,     2,     2,     3,     3,     3,     3,     3,     3,
       3,     3,     5,     1,     1,     3,     3,     3,     3,     3,
       3,     3,     3,     3
  };


#if YYDEBUG || 1
  // YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
  // First, the terminals, then, starting at \a YYNTOKENS, nonterminals.
  const char*
  const parser::yytname_[] =
  {
  "\"end of file\"", "error", "\"invalid token\"", "FOR", "ENDFOR", "IF",
  "IFDEF", "IFNDEF", "ELSEIF", "ELSE", "ENDIF", "TRUE", "FALSE", "INCLUDE",
  "INCLUDEPATH", "DEFINE", "EQUAL", "D_ECHO", "ERROR", "COMMA", "LPAREN",
  "RPAREN", "LBRACKET", "RBRACKET", "WHEN", "BEGIN_EVAL", "END_EVAL",
  "ECHOMACROVARS", "SAVE", "LINE", "EXP", "LOG", "LN", "LOG10", "SIN",
  "COS", "TAN", "ASIN", "ACOS", "ATAN", "SQRT", "CBRT", "SIGN", "MAX",
  "MIN", "FLOOR", "CEIL", "TRUNC", "SUM", "MOD", "ERF", "ERFC", "GAMMA",
  "LGAMMA", "ROUND", "NORMPDF", "NORMCDF", "LENGTH", "ISEMPTY",
  "ISBOOLEAN", "ISREAL", "ISSTRING", "ISTUPLE", "ISARRAY", "BOOL", "REAL",
  "STRING", "TUPLE", "ARRAY", "DEFINED", "OR", "AND", "EQUAL_EQUAL",
  "NOT_EQUAL", "LESS", "GREATER", "LESS_EQUAL", "GREATER_EQUAL", "IN",
  "COLON", "UNION", "INTERSECTION", "PLUS", "MINUS", "TIMES", "DIVIDE",
  "UNARY", "NOT", "CAST", "POWER", "EOL", "NAME", "TEXT", "QUOTED_STRING",
  "NUMBER", "$accept", "statements_or_empty_file", "statements",
  "statement", "directive", "directive_one_line", "name_list",
  "directive_multiline", "for_when", "for", "$@1", "if", "$@2", "ifdef",
  "$@3", "ifndef", "$@4", "if_list", "if_list1", "elseif_begin", "elseif",
  "else_begin", "else", "text", "eval", "symbol", "function",
  "function_args", "comma_expr", "tuple_comma_expr", "primary_expr",
  "oper_expr", "colon_expr", "expr", YY_NULLPTR
  };
#endif


#if YYDEBUG
  const short
  parser::yyrline_[] =
  {
       0,   110,   110,   111,   114,   118,   124,   125,   126,   129,
     130,   133,   135,   137,   142,   144,   146,   148,   150,   152,
     154,   156,   158,   166,   168,   175,   176,   177,   178,   181,
     183,   187,   187,   218,   218,   222,   222,   226,   226,   230,
     231,   238,   244,   250,   257,   259,   265,   273,   275,   281,
     289,   291,   295,   299,   303,   305,   309,   311,   315,   317,
     319,   323,   325,   327,   329,   333,   335,   337,   341,   343,
     345,   347,   349,   351,   353,   355,   357,   359,   361,   363,
     365,   367,   369,   371,   373,   375,   377,   379,   381,   383,
     385,   387,   389,   391,   393,   395,   397,   399,   401,   403,
     405,   407,   409,   411,   413,   415,   417,   419,   421,   423,
     425,   427,   429,   431,   433,   437,   438,   440,   442,   444,
     446,   448,   450,   452,   454,   456,   458,   460,   462,   464,
     466,   470,   472,   476,   477,   478,   480,   482,   484,   486,
     488,   490,   492,   494
  };

  void
  parser::yy_stack_print_ () const
  {
    *yycdebug_ << "Stack now";
    for (stack_type::const_iterator
           i = yystack_.begin (),
           i_end = yystack_.end ();
         i != i_end; ++i)
      *yycdebug_ << ' ' << int (i->state);
    *yycdebug_ << '\n';
  }

  void
  parser::yy_reduce_print_ (int yyrule) const
  {
    int yylno = yyrline_[yyrule];
    int yynrhs = yyr2_[yyrule];
    // Print the symbols being reduced, and their result.
    *yycdebug_ << "Reducing stack by rule " << yyrule - 1
               << " (line " << yylno << "):\n";
    // The symbols being reduced.
    for (int yyi = 0; yyi < yynrhs; yyi++)
      YY_SYMBOL_PRINT ("   $" << yyi + 1 << " =",
                       yystack_[(yynrhs) - (yyi + 1)]);
  }
#endif // YYDEBUG

  parser::symbol_kind_type
  parser::yytranslate_ (int t)
  {
    // YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to
    // TOKEN-NUM as returned by yylex.
    static
    const signed char
    translate_table[] =
    {
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94
    };
    // Last valid token kind.
    const int code_max = 349;

    if (t <= 0)
      return symbol_kind::S_YYEOF;
    else if (t <= code_max)
      return YY_CAST (symbol_kind_type, translate_table[t]);
    else
      return symbol_kind::S_YYUNDEF;
  }

#line 25 "Parser.yy"
} // Tokenizer
#line 2849 "Parser.cc"

#line 498 "Parser.yy"


void
Tokenizer::parser::error(const Tokenizer::parser::location_type &l, const string &m)
{
  driver.error(l, m);
}
