import gtk
from util.DesktopFiles import DesktopFiles

class Application():
    def __init__(self, pid, command, name, icon):
        self.command = os.path.basename(command.lower().strip())
        self.name = name.lower().strip()
        self.category = ""
        self.icon = icon
        self.icon_name = ""
        self.description = name

        # current application window info
        self.pid = pid
        self.window_name = ""
        self.x = 0
        self.y = 0
        self.fullscreen = False

        self.clients = {}
        return

    def __match_desktop(self,  desktop_files):

        #print "checking desktop files for match....", self.name
        # Try looking up the application list
        for a in desktop_files:
            ex = a.get_exec_array()[0].lower()

            # Check for pulse audio settings first...
            if a.get("X-PulseAudio-Properties"):
                self.category = a.get("X-PulseAudio-Properties")
                break

            if a.get("X-GNOME-Bugzilla-Product") == self.name or ex == self.name or ex == self.command or a.get("Name").lower() == self.name or a.get("Name").lower() == self.command or ex + ".real" == self.command :
                self.icon_name = a.get("Icon")
                self.description = a.get("Name")
                self.category = self.__desktop_categories_to_category( a.get("Categories") )
                #print "category : " + (self.category or "<unknown>")
                break

        if self.command == "skype.real":
            self.category = "phone"
            #print "category : " + self.category
            

    def __desktop_categories_to_category(self, categories):
        if categories:
            for category in categories:
                if "Telephony" in categories or "InstantMessaging" in categories:
                    return "phone"
                if "Music" in categories:
                    return "music"
                if "Video" in categories:
                    return "video"
                if "AudioVideo" in categories:
                    return "music"             
    
        return ""
