/**
 * @author Toru Nagashima <https://github.com/mysticatea>
 */
"use strict";

const fs = require("fs");
const path = require("path");

/**
 * Render the content of `lib/util/unicode/is-combining-character.js`.
 * @param {number[]} chars The character code list to render.
 * @returns {void}
 */
function renderIsCombiningCharacter(chars) {
    return `// THIS FILE WAS GENERATED BY 'tools/update-unicode-utils.js'
"use strict";

const combiningChars = new Set(${JSON.stringify(chars)})

/**
 * Check whether a given character is a combining mark or not.
 * @param {number} c The character code to check.
 * @returns {boolean} \`true\` if the character belongs to the category, one of \`Mc\`, \`Me\`, and \`Mn\`.
 */
module.exports = function isCombiningCharacter(c) {
    return combiningChars.has(c);
};
`;
}

//------------------------------------------------------------------------------
// Main
//------------------------------------------------------------------------------

const combiningChars = Array.from(function *() {
    for (let codePoint = 0; codePoint <= 0x10FFFF; ++codePoint) {
        // eslint-disable-next-line node/no-unsupported-features/es-syntax
        if (/^[\p{Mc}\p{Me}\p{Mn}]$/u.test(String.fromCodePoint(codePoint))) {
            yield codePoint;
        }
    }
}());

fs.writeFileSync(
    path.resolve(__dirname, "../lib/util/unicode/is-combining-character.js"),
    renderIsCombiningCharacter(combiningChars)
);
