/*
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#if (DATA_BITS == 64)
/* FIXME */
#define bus_addr_t	uint64_t
#elif (ADDR_BITS <= 32)
#define bus_addr_t      uint32_t
#else
#error "Bad Address Size."
#endif

#if (BS_BITS != 1 && BS_BITS != 2 && BS_BITS != 4 && BS_BITS != 8)
#error "Bad BS Size."
#endif

#if (DATA_BITS == 8)
#include "sig_cs8.h"
#define bus_data_t	uint8_t
#define sig_bus		sig_cs8
#define sig_bus_funcs	sig_cs8_funcs
#define sig_bus_connect	sig_cs8_connect
#define sig_bus_unmap	sig_cs8_unmap
#elif (DATA_BITS == 16)
#include "sig_cs16.h"
#define bus_data_t	uint16_t
#define sig_bus		sig_cs16
#define sig_bus_funcs	sig_cs16_funcs
#define sig_bus_connect	sig_cs16_connect
#define sig_bus_unmap	sig_cs16_unmap
#elif (DATA_BITS == 32)
#include "sig_cs32.h"
#define bus_data_t	uint32_t
#define sig_bus		sig_cs32
#define sig_bus_funcs	sig_cs32_funcs
#define sig_bus_connect	sig_cs32_connect
#define sig_bus_unmap	sig_cs32_unmap
#elif (DATA_BITS == 64)
#include "sig_cs64.h"
#define bus_data_t	uint64_t
#define sig_bus		sig_cs64
#define sig_bus_funcs	sig_cs64_funcs
#define sig_bus_connect	sig_cs64_connect
#define sig_bus_unmap	sig_cs64_unmap
#else
#error "Bad Data Size."
#endif

#define MEM_SIZE	((1 << ADDR_BITS) * (DATA_BITS / 8))

void *
CHIP_(gui_create)(
	unsigned int page,
	const char *name,
	struct sig_manage *manage,
	struct sig_std_logic *port_power,
	struct sig_bus *port_cs,
	struct sig_mem_bus *port_bus
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return CHIP_(gui_gtk_create)(page, name,
				manage, port_power, port_cs, port_bus);
		break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
CHIP_(gui_destroy)(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		CHIP_(gui_gtk_destroy)(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
CHIP_(gui_suspend)(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		CHIP_(gui_gtk_suspend)(_cpssp, fp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
CHIP_(gui_resume)(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		CHIP_(gui_gtk_resume)(_cpssp, fp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
