package computervisionapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/cognitiveservices/v3.0-preview/computervision"
	"github.com/Azure/go-autorest/autorest"
	"github.com/satori/go.uuid"
	"io"
)

// BaseClientAPI contains the set of methods on the BaseClient type.
type BaseClientAPI interface {
	GetReadResult(ctx context.Context, operationID uuid.UUID) (result computervision.ReadOperationResult, err error)
	Read(ctx context.Context, imageURL computervision.ImageURL, language computervision.OcrDetectionLanguage) (result autorest.Response, err error)
	ReadInStream(ctx context.Context, imageParameter io.ReadCloser, language computervision.OcrDetectionLanguage) (result autorest.Response, err error)
}

var _ BaseClientAPI = (*computervision.BaseClient)(nil)
