/*
Copyright 2023 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package wholepkg

import (
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/runtime/schema"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Struct_Everything) DeepCopyInto(out *Struct_Everything) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	if in.BoolPtrField != nil {
		in, out := &in.BoolPtrField, &out.BoolPtrField
		*out = new(bool)
		**out = **in
	}
	if in.IntPtrField != nil {
		in, out := &in.IntPtrField, &out.IntPtrField
		*out = new(int)
		**out = **in
	}
	if in.StringPtrField != nil {
		in, out := &in.StringPtrField, &out.StringPtrField
		*out = new(string)
		**out = **in
	}
	if in.FloatPtrField != nil {
		in, out := &in.FloatPtrField, &out.FloatPtrField
		*out = new(float64)
		**out = **in
	}
	in.PointerStructField.DeepCopyInto(&out.PointerStructField)
	if in.SliceBoolField != nil {
		in, out := &in.SliceBoolField, &out.SliceBoolField
		*out = make([]bool, len(*in))
		copy(*out, *in)
	}
	if in.SliceByteField != nil {
		in, out := &in.SliceByteField, &out.SliceByteField
		*out = make([]byte, len(*in))
		copy(*out, *in)
	}
	if in.SliceIntField != nil {
		in, out := &in.SliceIntField, &out.SliceIntField
		*out = make([]int, len(*in))
		copy(*out, *in)
	}
	if in.SliceStringField != nil {
		in, out := &in.SliceStringField, &out.SliceStringField
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.SliceFloatField != nil {
		in, out := &in.SliceFloatField, &out.SliceFloatField
		*out = make([]float64, len(*in))
		copy(*out, *in)
	}
	in.SlicesStructField.DeepCopyInto(&out.SlicesStructField)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Struct_Everything.
func (in *Struct_Everything) DeepCopy() *Struct_Everything {
	if in == nil {
		return nil
	}
	out := new(Struct_Everything)
	in.DeepCopyInto(out)
	return out
}

func (in *Struct_Everything) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Struct_Pointer) DeepCopyInto(out *Struct_Pointer) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.PointerStructPrimitivesField.DeepCopyInto(&out.PointerStructPrimitivesField)
	if in.PointerPointerStructPrimitivesField != nil {
		in, out := &in.PointerPointerStructPrimitivesField, &out.PointerPointerStructPrimitivesField
		*out = new(Struct_Primitives)
		(*in).DeepCopyInto(*out)
	}
	in.PointerStructPrimitivesAliasField.DeepCopyInto(&out.PointerStructPrimitivesAliasField)
	in.PointerPointerStructPrimitivesAliasField.DeepCopyInto(&out.PointerPointerStructPrimitivesAliasField)
	in.PointerStructStructPrimitives.DeepCopyInto(&out.PointerStructStructPrimitives)
	if in.PointerPointerStructStructPrimitives != nil {
		in, out := &in.PointerPointerStructStructPrimitives, &out.PointerPointerStructStructPrimitives
		*out = new(Struct_Struct_Primitives)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Struct_Pointer.
func (in *Struct_Pointer) DeepCopy() *Struct_Pointer {
	if in == nil {
		return nil
	}
	out := new(Struct_Pointer)
	in.DeepCopyInto(out)
	return out
}

func (in *Struct_Pointer) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Struct_Primitives) DeepCopyInto(out *Struct_Primitives) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	if in.BoolField != nil {
		in, out := &in.BoolField, &out.BoolField
		*out = new(bool)
		**out = **in
	}
	if in.IntField != nil {
		in, out := &in.IntField, &out.IntField
		*out = new(int)
		**out = **in
	}
	if in.StringField != nil {
		in, out := &in.StringField, &out.StringField
		*out = new(string)
		**out = **in
	}
	if in.FloatField != nil {
		in, out := &in.FloatField, &out.FloatField
		*out = new(float64)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Struct_Primitives.
func (in *Struct_Primitives) DeepCopy() *Struct_Primitives {
	if in == nil {
		return nil
	}
	out := new(Struct_Primitives)
	in.DeepCopyInto(out)
	return out
}

func (in *Struct_Primitives) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Struct_Primitives_Alias) DeepCopyInto(out *Struct_Primitives_Alias) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	if in.BoolField != nil {
		in, out := &in.BoolField, &out.BoolField
		*out = new(bool)
		**out = **in
	}
	if in.IntField != nil {
		in, out := &in.IntField, &out.IntField
		*out = new(int)
		**out = **in
	}
	if in.StringField != nil {
		in, out := &in.StringField, &out.StringField
		*out = new(string)
		**out = **in
	}
	if in.FloatField != nil {
		in, out := &in.FloatField, &out.FloatField
		*out = new(float64)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Struct_Primitives_Alias.
func (in *Struct_Primitives_Alias) DeepCopy() *Struct_Primitives_Alias {
	if in == nil {
		return nil
	}
	out := new(Struct_Primitives_Alias)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Struct_Slices) DeepCopyInto(out *Struct_Slices) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	if in.SliceStructPrimitivesField != nil {
		in, out := &in.SliceStructPrimitivesField, &out.SliceStructPrimitivesField
		*out = make([]Struct_Primitives, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.SlicePointerStructPrimitivesField != nil {
		in, out := &in.SlicePointerStructPrimitivesField, &out.SlicePointerStructPrimitivesField
		*out = make([]*Struct_Primitives, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(Struct_Primitives)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.SliceStructPrimitivesAliasField != nil {
		in, out := &in.SliceStructPrimitivesAliasField, &out.SliceStructPrimitivesAliasField
		*out = make([]Struct_Primitives_Alias, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.SlicePointerStructPrimitivesAliasField != nil {
		in, out := &in.SlicePointerStructPrimitivesAliasField, &out.SlicePointerStructPrimitivesAliasField
		*out = make([]*Struct_Primitives_Alias, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(Struct_Primitives_Alias)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.SliceStructStructPrimitives != nil {
		in, out := &in.SliceStructStructPrimitives, &out.SliceStructStructPrimitives
		*out = make([]Struct_Struct_Primitives, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.SlicePointerStructStructPrimitives != nil {
		in, out := &in.SlicePointerStructStructPrimitives, &out.SlicePointerStructStructPrimitives
		*out = make([]*Struct_Struct_Primitives, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(Struct_Struct_Primitives)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Struct_Slices.
func (in *Struct_Slices) DeepCopy() *Struct_Slices {
	if in == nil {
		return nil
	}
	out := new(Struct_Slices)
	in.DeepCopyInto(out)
	return out
}

func (in *Struct_Slices) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Struct_Struct_Primitives) DeepCopyInto(out *Struct_Struct_Primitives) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.StructField.DeepCopyInto(&out.StructField)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Struct_Struct_Primitives.
func (in *Struct_Struct_Primitives) DeepCopy() *Struct_Struct_Primitives {
	if in == nil {
		return nil
	}
	out := new(Struct_Struct_Primitives)
	in.DeepCopyInto(out)
	return out
}

func (in *Struct_Struct_Primitives) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

func (obj *Struct_Everything) GetObjectKind() schema.ObjectKind        { return schema.EmptyObjectKind }
func (obj *Struct_Pointer) GetObjectKind() schema.ObjectKind           { return schema.EmptyObjectKind }
func (obj *Struct_Primitives) GetObjectKind() schema.ObjectKind        { return schema.EmptyObjectKind }
func (obj *Struct_Slices) GetObjectKind() schema.ObjectKind            { return schema.EmptyObjectKind }
func (obj *Struct_Struct_Primitives) GetObjectKind() schema.ObjectKind { return schema.EmptyObjectKind }
