/******************************************************************************
 * Copyright (c) 2010-2011, Duane Merrill.  All rights reserved.
 * Copyright (c) 2011-2018, NVIDIA CORPORATION.  All rights reserved.
 * Modifications Copyright (c) 2021, Advanced Micro Devices, Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the NVIDIA CORPORATION nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL NVIDIA CORPORATION BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************/

#ifndef HIPCUB_BLOCK_BLOCK_AJACENT_DIFFERENCE_HPP_
#define HIPCUB_BLOCK_BLOCK_AJACENT_DIFFERENCE_HPP_

BEGIN_HIPCUB_NAMESPACE

namespace detail
{
  // Trait checks if FlagOp can be called with 3 arguments (a, b, b_index)
  template<class T, class FlagOp, class = void>
  struct WithBIndexArg
      : std::false_type
  { };

  template<class T, class FlagOp>
  struct WithBIndexArg<
          T, FlagOp,
          typename std::conditional<
             true,
             void,
             decltype(std::declval<FlagOp>()(std::declval<T>(), std::declval<T>(), 0))
          >::type
      > : std::true_type
  { };

}

END_HIPCUB_NAMESPACE

#ifdef __HIP_PLATFORM_AMD__
    #include "../backend/rocprim/block/block_adjacent_difference.hpp"
#elif defined(__HIP_PLATFORM_NVIDIA__)
    #include "../config.hpp"
    #include <cub/block/block_adjacent_difference.cuh>
#endif

#endif // HIPCUB_BLOCK_BLOCK_AJACENT_DIFFERENCE_HPP_
