/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 *          
 * Released under the GPL v2. */

#include "imspector.h"

LoggingPlugin::LoggingPlugin()
{
	handle = NULL;
}

LoggingPlugin::~LoggingPlugin()
{
}

bool LoggingPlugin::loadplugin(std::string filename)
{
	handle = dlopen(filename.c_str(), RTLD_LAZY);
	
	if (!handle)
	{
		syslog(LOG_ERR, "dlopen(): %s\n", dlerror());
		return false;
	}
	
	initloggingplugin = (initloggingplugintype) dlsym(handle, "initloggingplugin");
	closeloggingplugin = (closeloggingplugintype) dlsym(handle, "closeloggingplugin");
	logevents = (logeventstype) dlsym(handle, "logevents");
	
	if (!initloggingplugin || !closeloggingplugin || !logevents)
	{
		syslog(LOG_ERR, "%s: dlsym(): %s\n", filename.c_str(), dlerror());
		return false;
	}
	
	return true;
}

bool LoggingPlugin::unloadplugin(void)
{
	if (handle) dlclose(handle);
	
	return true;
}

bool LoggingPlugin::callinitloggingplugin(class Options &options, bool debugmode)
{
	return (*initloggingplugin)(loggingplugininfo, options, debugmode);
}

void LoggingPlugin::callcloseloggingplugin(void)
{
	return (*closeloggingplugin)();
}

int LoggingPlugin::calllogevents(std::vector<struct imevent> &imevents)
{
	return (*logevents)(imevents);
}
