/*--------------------------------------------------------------------------+
$Id: ETrafficLightColor.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.assessment;

/**
 * Enum for traffic light colors.
 * 
 * Note that the order is relevant: The first Color (RED) is considered the most
 * dominant color (see {@link Assessment#getDominantColor()}).
 * 
 * @author Benjamin Hummel
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 3EF80A03FF6E5A81B2F0601685B19EE2
 */
public enum ETrafficLightColor {
	/** Red signals errors or incomleteness. */
	RED,

	/** Yellow signals warning or lack of control. */
	YELLOW,

	/** Green signals the absence of errors or correctness. */
	GREEN,

	/** This is used if no information is available. */
	UNKNOWN;

}