/*--------------------------------------------------------------------------+
$Id: InvertingComparatorTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.collections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

import junit.framework.TestCase;

/**
 * Test for <code>InvertingComparator</code>-class.
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * 
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 9E714BDADFF834A0446405D1ECAE81AB
 */
public class InvertingComparatorTest extends TestCase {

    /**
     * The inverting comparator is tested on a
     * {@link edu.tum.cs.commons.collections.StringLengthComparator}
     */
    private final Comparator<String> comparator = new InvertingComparator<String>(
            new StringLengthComparator());

    /** Compare two string where the second is longer. */
    public void testLonger() {
        assertTrue(comparator.compare("x", "xx") > 0);
    }

    /** Compare two string where the second is shorter. */
    public void testShorter() {
        assertTrue(comparator.compare("xx", "x") < 0);
    }

    /** Compare two string with equal length. */
    public void testEqual() {
        assertTrue(comparator.compare("yy", "xx") == 0);
    }

    /**
     * Test if sorting a list of strings produces the desired result (longer
     * strings first).
     */
    public void testSorting() {
        ArrayList<String> list = new ArrayList<String>();

        list.add("x");
        list.add("xxx");
        list.add("xx");

        Collections.sort(list, comparator);

        assertEquals("xxx", list.get(0));
        assertEquals("xx", list.get(1));
        assertEquals("x", list.get(2));
    }
}