/*--------------------------------------------------------------------------+
$Id: SortableDataUtilsTest.java 29400 2010-07-27 15:03:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.collections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import junit.framework.TestCase;

/**
 * Tests for the {@link SortableDataUtils}.
 * 
 * @author hummelb
 * @author $Author: juergens $
 * @version $Rev: 29400 $
 * @levd.rating GREEN Hash: C1D7B9B0774B3F74E01E50783CC0C712
 */
public class SortableDataUtilsTest extends TestCase {

	/** Tests the quick sort implementation. */
	public void testQuickSort() {
		testSorting(false);
	}

	/** Tests the bubble sort implementation. */
	public void testBubbleSort() {
		testSorting(true);
	}

	/** Tests the sorting implementation. */
	private void testSorting(boolean bubbleSort) {
		final int size = 100;

		List<Integer> list = new ArrayList<Integer>();
		for (int i = 0; i < size; ++i) {
			list.add(i);
		}
		Collections.shuffle(list);

		if (bubbleSort) {
			SortableDataUtils.bubbleSort(new SortableDataList<Integer>(list,
					list.size()), 0, list.size());
		} else {
			SortableDataUtils.sort(new SortableDataList<Integer>(list, list
					.size()));
		}

		assertEquals(size, list.size());
		for (int i = 0; i < size; ++i) {
			assertEquals(i, (int) list.get(i));
		}
	}

	/** Test sorting with long ranges of equal data. */
	public void testEqualData() {
		List<Integer> list = new ArrayList<Integer>();
		for (int i = 0; i < 100; ++i) {
			for (int j = 0; j < 10; ++j) {
				list.add(j);
			}
		}

		// no testing needed here; this is added as we had a stack overflow in
		// an
		// early version
		SortableDataUtils
				.sort(new SortableDataList<Integer>(list, list.size()));
	}

	/**
	 * Tests the methods for empty lists. Checks mostly that no bad exceptions
	 * are thrown.
	 */
	public void testEmpty() {
		List<Integer> list = new ArrayList<Integer>();
		SortableDataUtils
				.sort(new SortableDataList<Integer>(list, list.size()));
		list.add(0);
		SortableDataUtils.binarySearch(new SortableDataList<Integer>(list, 0),
				0);
	}

	/** Tests the binary search. */
	public void testBinarySearch() {
		final int size = 100;

		List<Integer> list = new ArrayList<Integer>();
		for (int i = 0; i < size; ++i) {
			list.add(2 * i);
		}

		list.add(44);
		assertEquals(22, SortableDataUtils.binarySearch(
				new SortableDataList<Integer>(list, size), size));

		list.set(size, 45);
		assertEquals(23, SortableDataUtils.binarySearch(
				new SortableDataList<Integer>(list, size), size));

		list.set(size, 32432);
		assertEquals(size, SortableDataUtils.binarySearch(
				new SortableDataList<Integer>(list, size), size));
	}

	/** Implementation based on an underlying list used for testing. */
	private static class SortableDataList<T extends Comparable<T>> implements
			ISortableData {

		/** The contained list. */
		private final List<T> list;

		/** The size used. */
		private final int size;

		/** Constructor. */
		public SortableDataList(List<T> list, int size) {
			this.list = list;
			this.size = size;
		}

		/** {@inheritDoc} */
		@Override
		public boolean isLess(int i, int j) {
			return list.get(i).compareTo(list.get(j)) < 0;
		}

		/** {@inheritDoc} */
		@Override
		public int size() {
			return size;
		}

		/** {@inheritDoc} */
		@Override
		public void swap(int i, int j) {
			Collections.swap(list, i, j);
		}

	}
}
