/*--------------------------------------------------------------------------+
$Id: VisitorUtilsTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import edu.tum.cs.commons.collections.CollectionUtils;
import edu.tum.cs.commons.error.NeverThrownRuntimeException;

import junit.framework.TestCase;

/**
 * Tests for the {@link VisitorUtils}.
 * 
 * @author hummelb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 7DB406688EA45F35FABBE1299E860A2B
 */
public class VisitorUtilsTest extends TestCase {

	/** Test tree traversal. */
	public void testVisitTree() {

		// we use lists of lists as tree
		List<Object> root = new ArrayList<Object>();
		List<Object> ch1 = new ArrayList<Object>();
		List<Object> ch2 = new ArrayList<Object>();
		List<Object> ch3 = new ArrayList<Object>();
		root.add(ch1);
		root.add(ch2);
		ch2.add(ch3);

		ch2.add("a");
		ch2.add("b");
		ch2.add("c");
		ch3.add("d");
		ch3.add("e");

		CountingVisitor cv = new CountingVisitor();
		VisitorUtils.visitAllPreOrder(root, new ListWalker(), cv);
		assertEquals(4 + 5, cv.counter);

		cv.counter = 0;
		VisitorUtils.visitLeaves(root, new ListWalker(), cv);
		assertEquals(1 + 5, cv.counter);
	}

	/** Test mesh traversal. */
	public void testVisitMesh() {

		// we use lists of lists as mesh
		List<Object> elem1 = new ArrayList<Object>();
		List<Object> elem2 = new ArrayList<Object>();
		List<Object> elem3 = new ArrayList<Object>();
		List<Object> elem4 = new ArrayList<Object>();

		elem1.add(elem2);
		elem1.add(elem4);

		elem2.add(elem1);
		elem2.add(elem4);
		elem2.add(elem4);
		elem2.add(elem1);
		elem2.add(elem4);

		elem4.add(elem3);

		CountingVisitor cv = new CountingVisitor();
		VisitorUtils.visitAllDepthFirst(elem1, new ListWalker(), cv);
		assertEquals(4, cv.counter);
	}

	/** A visitor counting the number of calls. */
	public static class CountingVisitor implements
			IVisitor<Object, NeverThrownRuntimeException> {

		/** The counter. */
		public int counter = 0;

		/** {@inheritDoc} */
		public void visit(Object element) {
			counter++;
		}

	}

	/** A walker for following trees and meshed composed of simple lists. */
	public static class ListWalker implements
			ITreeWalker<Object, NeverThrownRuntimeException>,
			IMeshWalker<Object, NeverThrownRuntimeException> {

		/** {@inheritDoc} */
		@SuppressWarnings("unchecked")
		public Collection<Object> getChildren(Object node)
				throws NeverThrownRuntimeException {
			if (node instanceof List) {
				return (List<Object>) node;
			}
			return CollectionUtils.emptyList();
		}

		/** {@inheritDoc} */
		public Collection<Object> getAdjacentElements(Object element)
				throws NeverThrownRuntimeException {
			return getChildren(element);
		}

	}
}