/***************************************************************************
                  base32.cpp  -  Test Base32 encode / decode
                             -------------------
    begin                : Fri Oct 01 2010
    copyright            : (C) 2010 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <dclib/core/cstring.h>
#include <dclib/core/cbytearray.h>
#include <dclib/core/cbase32.h>

#include <cstring>
#include <cstdio>

int main( int, char*[] )
{
	/*
	 * RFC 4648 http://tools.ietf.org/html/rfc4648
	 *
	 * FIXME: dclib doesn't do the padding with "="
	 */
	const char* input[7] = {
		"f",
		"fo",
		"foo",
		"foob",
		"fooba",
		"foobar",
		"abcdefghijklmnopqrstuvwx"
	};
	
	const char* output[7] = {
		"MY",         /* MY====== */
		"MZXQ",       /* MZXQ==== */
		"MZXW6",      /* MZXW6=== */
		"MZXW6YQ",    /* MZXW6YQ= */
		"MZXW6YTB",   /* MZXW6YTB */
		"MZXW6YTBOI", /* MZXW6YTBOI====== */
		"MFRGGZDFMZTWQ2LKNNWG23TPOBYXE43UOV3HO6A"
	};
	
	for ( size_t i = 0; i < sizeof(input)/sizeof(char*); ++i )
	{
		CByteArray in;
		CString out;
		in.SetSize(0);
		in.Append(input[i], strlen(input[i]));
		CBase32::Encode(&out, &in);
		if ( out != output[i] )
		{
			printf("CBase32 Encode in=%s expected=%s got=%s\n",input[i],output[i],out.Data());
			return 10;
		}
	}
	
	for ( size_t i = 0; i < sizeof(input)/sizeof(char*); ++i )
	{
		CByteArray out;
		CString in = output[i];
		CString outs;
		CBase32::Decode(&out, &in);
		outs.Set((const char*) out.Data(), out.Size());
		if ( outs != input[i] )
		{
			printf("CBase32 Decode in=%s expected=%s got=%s\n",output[i],input[i],outs.Data());
			return 20;
		}
	}
	
	return 0;
}
