/***************************************************************************
     cstring-self.cpp  -  test assigning / appending CString to itself
                             -------------------
    begin                : Thu Sep 11 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/**
 * This ability was accidentally broken when all that temporary copying
 * was removed from CString, until the necessary pointer checks were
 * added: memcpy does not work if the memory areas overlap, and
 * memmove is not going to help because usually the memory area will
 * be expanded with realloc before memcpy, possibly moving it to
 * somewhere else in memory.
 */

#include <dclib/core/cstring.h>

#include <stdio.h>

#define TESTS 6

int main( int, char*[] )
{
	/* These all assume CString == works */
	bool results[TESTS];
	
	/* Append tests */
	CString abcdefg = "abcdefg";
	abcdefg += abcdefg;
	abcdefg += abcdefg;
	
	results[0] = (abcdefg == "abcdefgabcdefgabcdefgabcdefg");
	
	abcdefg = "abcdefg";
	abcdefg += abcdefg.Data();
	
	results[1] = (abcdefg == "abcdefgabcdefg");
	
	abcdefg = "abcdefg";
	abcdefg += abcdefg.Data()+3;
	
	results[2] = (abcdefg == "abcdefgdefg");
	
	/* Assign tests */
	abcdefg = "abcdefg";
	abcdefg = abcdefg;
	abcdefg = abcdefg;
	
	results[3] = (abcdefg == "abcdefg");
	
	abcdefg = "abcdefg";
	abcdefg = abcdefg.Data();
	abcdefg = abcdefg.Data();
	
	results[4] = (abcdefg == "abcdefg");
	
	abcdefg = "abcdefg";
	abcdefg = abcdefg.Data()+1;
	abcdefg = abcdefg.Data()+1;
	abcdefg = abcdefg.Data()+1;
	
	results[5] = (abcdefg == "defg");
	
	int ret = 0;
	for ( int i = 0; i < TESTS; ++i )
	{
		if ( results[i] == false )
		{
			printf("cstring-self: test %d failed\n",i);
			ret = 100;
		}
	}
	
	return ret;
}
