/* $Id: builtins.c,v 1.1 2005/09/15 15:17:00 cegger Exp $
******************************************************************************

   libgiigic builtin target bindings

   Copyright (C) 2005 Christoph Egger

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "config.h"
#include <ggi/gg.h>
#include <ggi/internal/gic_debug.h>
#include <string.h>


typedef int (giigicrecognizersfunc_dlinit)(void);

#ifdef BUILTIN_RECOGNIZERS
giigicrecognizersfunc_dlinit GICdl_cheat;
giigicrecognizersfunc_dlinit GICdl_keys;
giigicrecognizersfunc_dlinit GICdl_mousebutton;
giigicrecognizersfunc_dlinit GICdl_relmouse;
giigicrecognizersfunc_dlinit GICdl_valuator;
#endif


struct target {
	const char *target;
	giigicrecognizersfunc_dlinit *func;
};

static struct target _targets[] = {

#ifdef BUILTIN_RECOGNIZERS
	{ "GICdl_keys", &GICdl_keys },
	{ "GICdl_mousebutton", &GICdl_mousebutton },
	{ "GICdl_relmouse", &GICdl_relmouse },
	{ "GICdl_valuator", &GICdl_valuator },
	{ "GICdl_cheat", &GICdl_cheat },
#endif
	{ NULL, NULL }

};


static void *_builtins_get(void * _, const char *symbol)
{
	struct target *t;

	for (t = _targets; t->target != NULL; t++) {
		if (!strcmp(t->target, symbol)) {
			DPRINT_LIBS("builtin symbol found: '%s'\n", symbol);
			return t->func;
		}
	}
	DPRINT_LIBS("builtin symbol '%s' not found\n", symbol);
	return NULL;
}

static gg_scope _builtins;

void _giigicInitBuiltins(void);
void _giigicExitBuiltins(void);

void _giigicInitBuiltins(void)
{
	_builtins = ggNewScope("@libgiigic", NULL, &_builtins_get, NULL);
}

void _giigicExitBuiltins(void)
{
	ggDelScope(_builtins);
}

