/*
 * @(#)FunctionMeasure.java
 *
 * Copyright (C) 2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.module;


import net.sourceforge.groboutils.codecoverage.v2.IAnalysisMetaData;
import net.sourceforge.groboutils.codecoverage.v2.IAnalysisModule;
import net.sourceforge.groboutils.codecoverage.v2.IMethodCode;


/**
 * Processes methods for function coverage analysis, which checks that each
 * method/function has been invoked.  Currently, this
 * does not support localization.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:26 $
 * @since     February 17, 2003
 * @see       IAnalysisMetaData
 */
public class FunctionMeasure implements IAnalysisModule
{
    /**
     * Returns the human-readable name of the measure.
     */
    public String getMeasureName()
    {
        return "Function";
    }
    
    /**
     * Returns the unit name for this particular coverage measure.
     */
    public String getMeasureUnit()
    {
        return "functions";
    }
    
    
    /**
     * Returns the text format used in meta-data formatted text.  This should
     * be the mime encoding type, such as "text/plain" or "text/html".
     */
    public String getMimeEncoding()
    {
        return "text/plain";
    }
    
    
    /**
     * Perform the analysis on the method.
     */
    public void analyze( IMethodCode method )
    {
        IAnalysisMetaData amd = createAnalysisMetaData(
            method.getClassName(), method.getMethodName() );
        method.markInstruction( 0, amd );
    }
    
    
    private IAnalysisMetaData createAnalysisMetaData( String clazz,
            String method )
    {
        return new DefaultAnalysisMetaData(
            "Method "+method+" in class "+clazz,
            "Didn't ever invoke method "+method+" in class "+clazz+".",
            (byte)0 );
    }
}

