/*
 * @(#)AntTestA.java
 *
 * Copyright (C) 2004 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.ant;


import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

import org.apache.tools.ant.BuildFileTestA;


/**
 * Framework extention to the Ant build file test class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:27 $
 * @since     February 25, 2004
 */
public abstract class AntTestA extends BuildFileTestA
{
    private Vector tempFiles = new Vector();
    
    public AntTestA( String name )
    {
        super( name );
    }
    
    
    protected void addTempFile( File f )
    {
        if (f != null)
        {
            this.tempFiles.addElement( f );
        }
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        Enumeration e = this.tempFiles.elements();
        while (e.hasMoreElements())
        {
            File f = (File)e.nextElement();
            if (f.exists())
            {
                f.delete();
            }
        }
        
        super.tearDown();
    }


    /**
     * Overload the parent.  We'll use the resource stream to load the
     * XML file.
     */
    protected void configureProject(String filename, int logLevel)
    {
        try
        {
            InputStream is = this.getClass().getResourceAsStream( filename );
            try
            {
                File dir = new File(
                    Long.toString( System.currentTimeMillis() ) );
                dir.mkdirs();
                File tmp = new File( dir, filename );
                FileOutputStream fos = new FileOutputStream( tmp );
                try
                {
                    byte[] buff = new byte[ 4096 ];
                    int size = is.read( buff );
                    while (size > 0)
                    {
                        fos.write( buff, 0, size );
                        size = is.read( buff );
                    }
                }
                finally
                {
                    fos.close();
                }
                
                super.configureProject( tmp.getAbsolutePath(), logLevel );
            }
            catch (IOException ioe)
            {
                ioe.printStackTrace();
                fail( ioe.getMessage() );
            }
            finally
            {
                try
                {
                    is.close();
                }
                catch (IOException ioe)
                {
                    ioe.printStackTrace();
                    fail( ioe.getMessage() );
                }
            }
        }
        catch (RuntimeException ex)
        {
            ex.printStackTrace();
            throw ex;
        }
    }
}

