/*
 *  @(#)TransitionType.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.mbtf.v1.ant;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.taskdefs.Definer;

import java.util.Vector;

import net.sourceforge.groboutils.mbtf.v1.IValidate;
import net.sourceforge.groboutils.mbtf.v1.ISystem;
import net.sourceforge.groboutils.mbtf.v1.IAction;

import net.sourceforge.groboutils.mbtf.v1.assembler.AsmblTransition;

import org.apache.log4j.Logger;


/**
 * An ant datatype encapsulating the IState instance.  This includes an
 * <tt>execute()</tt> method to allow for this to be defined in a
 * &lt;typedef&gt; declaration, rather than inside a target as a
 * &lt;datatype&gt; declaration.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:25 $
 * @since      June 13, 2002
 */
public class TransitionType extends AbstractStateMachineType
{
    private static final Logger LOG = Logger.getLogger( TransitionType.class );
    
    public static final String DEFAULT_ANT_NAME = "mbtf.transition";
    
    private Vector transitions = new Vector();
    private String nextState;
    private IAction action;
    
    
    public void setNextState( String name )
    {
        this.nextState = name;
    }
    
    
    public String getNextState()
    {
        if (isReference())
        {
            return ((TransitionType)getCheckedRef(
                TransitionType.class, DEFAULT_ANT_NAME )).
                getNextState();
        }
        return this.nextState;
    }
    
    
    public void addAntAction( ValidateTaskType action )
            throws BuildException
    {
        if (this.action != null)
        {
            throw new BuildException(
                "too many action elements: only one allowed" );
        }
        this.action = action;
    }
    
    
    public void addJavaAction( ValidateJavaType action )
            throws BuildException
    {
        if (this.action != null)
        {
            throw new BuildException(
                "too many action elements: only one allowed" );
        }
        LOG.debug("Adding ValidateJavaType");
        this.action = action;
    }
    
    
    public void setAntActionRef( Reference ref )
    {
        ValidateTaskType vtt = new ValidateTaskType();
        vtt.setProject( project );
        vtt.setRefid( ref );
        
        addAntAction( vtt );
    }
    
    
    public void setJavaActionRef( Reference ref )
    {
        Object o = ref.getReferencedObject( project );
        if (o != null && o instanceof TaskAdapter)
        {
            ((TaskAdapter)o).execute();
            o = ((TaskAdapter)o).getProxy();
        }
        addJavaAction( (ValidateJavaType)o );
    }
    
    
    public IAction getAction()
    {
        if (isReference())
        {
            return ((TransitionType)getCheckedRef(
                TransitionType.class, DEFAULT_ANT_NAME )).
                getAction();
        }
        if (project != null)
        {
            if (this.action instanceof ProjectComponent)
            {
                LOG.debug("Setting action "+this.action+"'s project to "+
                    getProject());
                ((ProjectComponent)this.action).setProject( getProject() );
            }
            else
            {
                LOG.debug("Action "+this.action+
                    " is not a ProjectComponent, but "+this.action.getClass().
                    getName());
            }
        }
        else
        {
            LOG.debug("Transition "+getName()+" has null project");
        }
        return this.action;
    }
    
    
    public AsmblTransition createTransition()
    {
        if (isReference())
        {
            return ((TransitionType)getCheckedRef(
                TransitionType.class, DEFAULT_ANT_NAME )).
                createTransition();
        }
        verifySettings();
        
        AsmblTransition at = new AsmblTransition();
        at.setName( getName() );
        at.setNextStateName( getNextState() );
        at.setAction( getAction() );

        IValidate v[] = getValidates();
        for (int i = 0; i < v.length; ++i)
        {
            at.addValidate( v[i] );
        }
        
        return at;
    }
    
    
    protected void verifySettings()
            throws BuildException
    {
        if (isReference())
        {
            ((TransitionType)getCheckedRef(
                TransitionType.class, DEFAULT_ANT_NAME )).
                verifySettings();
            return;
        }
        super.verifySettings();
        if (this.nextState == null)
        {
            throw new BuildException( "next state name not set", location );
        }
        if (this.action == null)
        {
            throw new BuildException( "next state name not set", location );
        }
    }
}

