/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.cactus.FilterTestCase;
import org.apache.cactus.WebRequest;
import org.apache.cactus.WebResponse;
import org.apache.cactus.server.RequestDispatcherWrapper;
import org.tuckey.web.filters.urlrewrite.TestRunObj;
import org.tuckey.web.filters.urlrewrite.UrlRewriteFilter;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

public class UrlRewriteFilterContainerTest
extends FilterTestCase {
    private UrlRewriteFilter filter = new UrlRewriteFilter();
    private String CONTENT = "<p>some content</p>";
    private FilterChain testFilterChain = new FilterChain(){

        public void doFilter(ServletRequest theRequest, ServletResponse theResponse) throws IOException {
            PrintWriter writer = theResponse.getWriter();
            writer.print(UrlRewriteFilterContainerTest.this.CONTENT);
            writer.close();
        }
    };
    static /* synthetic */ Class class$org$tuckey$web$filters$urlrewrite$UrlRewriteFilterContainerTest;
    static /* synthetic */ Class class$org$tuckey$web$filters$urlrewrite$TestRunObj;

    public void setUp() {
        this.config.setInitParameter("logLevel", "sysout:TRACE");
        this.filter.init((FilterConfig)this.config);
    }

    public void tearDown() {
        this.filter.destroy();
    }

    public static Test suite() {
        return new TestSuite(class$org$tuckey$web$filters$urlrewrite$UrlRewriteFilterContainerTest == null ? (class$org$tuckey$web$filters$urlrewrite$UrlRewriteFilterContainerTest = UrlRewriteFilterContainerTest.class$("org.tuckey.web.filters.urlrewrite.UrlRewriteFilterContainerTest")) : class$org$tuckey$web$filters$urlrewrite$UrlRewriteFilterContainerTest);
    }

    public void beginProduct(WebRequest theRequest) {
        theRequest.setURL("blah.org", "", "/products/987", null, null);
    }

    public void testProduct() throws ServletException, IOException {
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.testFilterChain);
    }

    public void endProduct(WebResponse theResponse) {
        UrlRewriteFilterContainerTest.assertEquals((String)"product 987", (String)theResponse.getText());
    }

    public void beginSimpleDistEx(WebRequest theRequest) {
        theRequest.setURL("blah.org", "", "/test/status/", null, null);
    }

    public void testSimpleDistEx() throws ServletException, IOException {
        TestResponseWrapper testResponseWrapper = new TestResponseWrapper(this.response);
        TestRequestWrapper testRequestWrapper = new TestRequestWrapper((HttpServletRequest)this.request);
        testRequestWrapper.setContextPath("/blah");
        this.filter.doFilter((ServletRequest)testRequestWrapper, (ServletResponse)testResponseWrapper, this.testFilterChain);
        UrlRewriteFilterContainerTest.assertEquals((String)"/blah/rewrite-status", (String)testResponseWrapper.redirectToUrl);
    }

    public void beginBasicSets(WebRequest theRequest) {
        theRequest.setURL("blah.org", "", "/settest/674", null, null);
    }

    public void testBasicSets() throws ServletException, IOException {
        TestRequestWrapper testRequestWrapper = new TestRequestWrapper((HttpServletRequest)this.request);
        this.filter.doFilter((ServletRequest)testRequestWrapper, (ServletResponse)this.response, this.testFilterChain);
        UrlRewriteFilterContainerTest.assertTrue((boolean)this.response.containsHeader("cache-control"));
        UrlRewriteFilterContainerTest.assertEquals((Object)"hello!", (Object)this.request.getSession().getAttribute("testsession"));
    }

    public void beginMultipleProduct(WebRequest theRequest) {
        theRequest.setURL("blah.org", "", "/multiple/products/987", null, null);
    }

    public void testMultipleProduct() throws ServletException, IOException {
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.testFilterChain);
    }

    public void endMultipleProduct(WebResponse theResponse) {
        UrlRewriteFilterContainerTest.assertEquals((String)"product 987", (String)theResponse.getText());
    }

    public void beginNullTo(WebRequest theRequest) {
        theRequest.setURL("blah.org", "", "/hideme/anb.jsp;dsaddd?asdasds#sdsfd", null, null);
    }

    public void testNullTo() throws ServletException, IOException {
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.testFilterChain);
    }

    public void endNullTo(WebResponse theResponse) {
        UrlRewriteFilterContainerTest.assertEquals((String)"should have status set", (int)403, (int)theResponse.getStatusCode());
        UrlRewriteFilterContainerTest.assertFalse((String)"should not output above content", (boolean)this.CONTENT.equals(StringUtils.trim(theResponse.getText())));
    }

    public void beginYear(WebRequest theRequest) {
        theRequest.setURL("blah.org", "", "/time/year/current", null, null);
    }

    public void testYear() throws ServletException, IOException {
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.testFilterChain);
    }

    public void endYear(WebResponse theResponse) {
        UrlRewriteFilterContainerTest.assertEquals((String)"echo yearisbetween1970and3000", (String)theResponse.getText());
    }

    public void beginTestAxis(WebRequest theRequest) {
        theRequest.setURL("blah.org", "", "/services/blah?qwerty", null, null);
    }

    public void testTestAxis() throws ServletException, IOException {
        TestResponseWrapper testResponseWrapper = new TestResponseWrapper(this.response);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)testResponseWrapper, this.testFilterChain);
        UrlRewriteFilterContainerTest.assertEquals((String)"/axis/services/blah?qwerty", (String)testResponseWrapper.redirectToUrl);
    }

    public void beginTestErik(WebRequest theRequest) {
        theRequest.setURL("blah.org", "", "/eriktest/hi.ho", null, null);
        theRequest.addHeader("host", "blah.com");
    }

    public void testTestErik() throws ServletException, IOException {
        TestResponseWrapper testResponseWrapper = new TestResponseWrapper(this.response);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)testResponseWrapper, this.testFilterChain);
        UrlRewriteFilterContainerTest.assertEquals((String)"http://www.example.com/context/hi.ho", (String)testResponseWrapper.redirectToUrl);
    }

    public void beginTestEncode(WebRequest theRequest) {
        theRequest.setURL("blah.org", "", "/went%20to%20bahamas/", null, null);
    }

    public void testTestEncode() throws ServletException, IOException {
        TestResponseWrapper testResponseWrapper = new TestResponseWrapper(this.response);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)testResponseWrapper, this.testFilterChain);
        UrlRewriteFilterContainerTest.assertEquals((String)"/bahamas/;jsess", (String)testResponseWrapper.redirectToUrl);
    }

    public void beginTestUtf(WebRequest theRequest) {
        theRequest.setURL("blah.org", "", "/utf/F\u00eatel'ha\u00efvolap\u00fck/", null, null);
    }

    public void testTestUtf() throws ServletException, IOException {
        TestResponseWrapper testResponseWrapper = new TestResponseWrapper(this.response);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)testResponseWrapper, this.testFilterChain);
        UrlRewriteFilterContainerTest.assertEquals((String)"/utf-redir/F\u00eatel'ha\u00efvolap\u00fck/", (String)testResponseWrapper.redirectToUrl);
    }

    public void beginSimpleRun(WebRequest theRequest) {
        theRequest.setURL("blah.org", "", "/run/test/test1", null, null);
    }

    public void testSimpleRun() throws ServletException, IOException {
        UrlRewriteFilterContainerTest.assertTrue((String)"should be inited", (boolean)TestRunObj.isInitCalled());
        TestResponseWrapper testResponseWrapper = new TestResponseWrapper(this.response);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)testResponseWrapper, this.testFilterChain);
    }

    public void endSimpleRun(WebResponse theResponse) {
        UrlRewriteFilterContainerTest.assertEquals((String)("this is " + (class$org$tuckey$web$filters$urlrewrite$TestRunObj == null ? (class$org$tuckey$web$filters$urlrewrite$TestRunObj = UrlRewriteFilterContainerTest.class$("org.tuckey.web.filters.urlrewrite.TestRunObj")) : class$org$tuckey$web$filters$urlrewrite$TestRunObj).getName()), (String)theResponse.getText());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class TestRequestDispatcherWrapper
    extends RequestDispatcherWrapper {
        boolean forwarding = false;
        boolean including = false;

        public TestRequestDispatcherWrapper(RequestDispatcher requestDispatcher) {
            super(requestDispatcher);
        }

        public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
            this.forwarding = true;
            super.forward(servletRequest, servletResponse);
        }

        public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
            this.including = true;
            super.include(servletRequest, servletResponse);
        }
    }

    public class TestRequestWrapper
    extends HttpServletRequestWrapper {
        TestRequestDispatcherWrapper dispatcher;
        public String dispatcherUrl = "not set";
        public String contextPath = "not set";

        public TestRequestWrapper(HttpServletRequest httpServletRequest) {
            super(httpServletRequest);
        }

        public RequestDispatcher getRequestDispatcher(String url) {
            this.dispatcherUrl = url;
            this.dispatcher = new TestRequestDispatcherWrapper(super.getRequestDispatcher(url));
            return this.dispatcher;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public void setContextPath(String contextPath) {
            this.contextPath = contextPath;
        }
    }

    public class TestResponseWrapper
    extends HttpServletResponseWrapper {
        public String redirectToUrl = "not yet!";
        private int status;

        public TestResponseWrapper(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
        }

        public void sendRedirect(String to) {
            this.redirectToUrl = to;
        }

        public void setStatus(int i) {
            this.status = i;
            super.setStatus(i);
        }

        public int getStatus() {
            return this.status;
        }

        public String encodeRedirectURL(String s) {
            return super.encodeRedirectURL(s) + ";jsess";
        }
    }
}

