#ifndef UTIL_H
#define UTIL_H 1

#ifdef LOG_AUTHPRIV
#define PAM_RSA_FACILITY LOG_AUTHPRIV
#else
#define PAM_RSA_FACILITY LOG_AUTH
#endif /* LOG_AUTHPRIV */


#ifndef LOG_MSGLEN
#define LOG_MSGLEN 256
#endif

#ifndef LINE_LEN
#define LINE_LEN 1024
#endif 

#ifndef MAXIMUM_PATH
#define MAXIMUM_PATH 1024
#endif 

/* This macro requires that each function that calls STRERROR
 * must define "char ebuf[512]" or something like that */

#ifdef HAVE_STRERROR_R
#define STRERROR(X) strerror_r(X, ebuf, sizeof(ebuf))
#else
#define STRERROR(X) strerror(X)
#endif

/* parse_path returns one of these. PARSEPATH_SUCCESS means success, anything
 * else signifies failure of some kind.
 */
enum { PARSEPATH_SUCCESS = 0, PARSEPATH_EMPTY, PARSEPATH_NOTABSOLUTE,
	PARSEPATH_TOOLONG, PARSEPATH_TWOSLASHES, PARSEPATH_OUTOFMEMORY };

void pamrsa_log(int level, const char *fmt, ...);
int set_bool(int *b, const char *s);
int is_safestr(const char *s);
int parse_path(const char *p, char ***parsed, int *nelem);
int is_safepath(const char *path, const char *fty, const char *fpe);
int is_safefile(const char *file, const char *fty, const char *fpe, unsigned int *errs);
const char *parsepath_error(int e);



#endif /* UTIL_H */
