// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use SocketFamily;
use ffi;
use glib;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct InetAddress(Object<ffi::GInetAddress, ffi::GInetAddressClass>);

    match fn {
        get_type => || ffi::g_inet_address_get_type(),
    }
}

impl InetAddress {
    pub fn new_any(family: SocketFamily) -> InetAddress {
        unsafe {
            from_glib_full(ffi::g_inet_address_new_any(family.to_glib()))
        }
    }

    pub fn new_from_string(string: &str) -> InetAddress {
        unsafe {
            from_glib_full(ffi::g_inet_address_new_from_string(string.to_glib_none().0))
        }
    }

    pub fn new_loopback(family: SocketFamily) -> InetAddress {
        unsafe {
            from_glib_full(ffi::g_inet_address_new_loopback(family.to_glib()))
        }
    }
}

pub trait InetAddressExt {
    fn get_family(&self) -> SocketFamily;

    fn get_is_any(&self) -> bool;

    fn get_is_link_local(&self) -> bool;

    fn get_is_loopback(&self) -> bool;

    fn get_is_mc_global(&self) -> bool;

    fn get_is_mc_link_local(&self) -> bool;

    fn get_is_mc_node_local(&self) -> bool;

    fn get_is_mc_org_local(&self) -> bool;

    fn get_is_mc_site_local(&self) -> bool;

    fn get_is_multicast(&self) -> bool;

    fn get_is_site_local(&self) -> bool;

    fn get_native_size(&self) -> usize;

    //fn get_property_bytes(&self) -> /*Unimplemented*/Fundamental: Pointer;

    fn connect_property_bytes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_is_any_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_is_link_local_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_is_loopback_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_is_mc_global_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_is_mc_link_local_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_is_mc_node_local_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_is_mc_org_local_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_is_mc_site_local_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_is_multicast_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_is_site_local_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<InetAddress> + IsA<glib::object::Object>> InetAddressExt for O {
    fn get_family(&self) -> SocketFamily {
        unsafe {
            from_glib(ffi::g_inet_address_get_family(self.to_glib_none().0))
        }
    }

    fn get_is_any(&self) -> bool {
        unsafe {
            from_glib(ffi::g_inet_address_get_is_any(self.to_glib_none().0))
        }
    }

    fn get_is_link_local(&self) -> bool {
        unsafe {
            from_glib(ffi::g_inet_address_get_is_link_local(self.to_glib_none().0))
        }
    }

    fn get_is_loopback(&self) -> bool {
        unsafe {
            from_glib(ffi::g_inet_address_get_is_loopback(self.to_glib_none().0))
        }
    }

    fn get_is_mc_global(&self) -> bool {
        unsafe {
            from_glib(ffi::g_inet_address_get_is_mc_global(self.to_glib_none().0))
        }
    }

    fn get_is_mc_link_local(&self) -> bool {
        unsafe {
            from_glib(ffi::g_inet_address_get_is_mc_link_local(self.to_glib_none().0))
        }
    }

    fn get_is_mc_node_local(&self) -> bool {
        unsafe {
            from_glib(ffi::g_inet_address_get_is_mc_node_local(self.to_glib_none().0))
        }
    }

    fn get_is_mc_org_local(&self) -> bool {
        unsafe {
            from_glib(ffi::g_inet_address_get_is_mc_org_local(self.to_glib_none().0))
        }
    }

    fn get_is_mc_site_local(&self) -> bool {
        unsafe {
            from_glib(ffi::g_inet_address_get_is_mc_site_local(self.to_glib_none().0))
        }
    }

    fn get_is_multicast(&self) -> bool {
        unsafe {
            from_glib(ffi::g_inet_address_get_is_multicast(self.to_glib_none().0))
        }
    }

    fn get_is_site_local(&self) -> bool {
        unsafe {
            from_glib(ffi::g_inet_address_get_is_site_local(self.to_glib_none().0))
        }
    }

    fn get_native_size(&self) -> usize {
        unsafe {
            ffi::g_inet_address_get_native_size(self.to_glib_none().0)
        }
    }

    //fn get_property_bytes(&self) -> /*Unimplemented*/Fundamental: Pointer {
    //    unsafe {
    //        let mut value = Value::from_type(</*Unknown type*/ as StaticType>::static_type());
    //        gobject_ffi::g_object_get_property(self.to_glib_none().0, "bytes".to_glib_none().0, value.to_glib_none_mut().0);
    //        value.get().unwrap()
    //    }
    //}

    fn connect_property_bytes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::bytes",
                transmute(notify_bytes_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::family",
                transmute(notify_family_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_is_any_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::is-any",
                transmute(notify_is_any_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_is_link_local_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::is-link-local",
                transmute(notify_is_link_local_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_is_loopback_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::is-loopback",
                transmute(notify_is_loopback_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_is_mc_global_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::is-mc-global",
                transmute(notify_is_mc_global_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_is_mc_link_local_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::is-mc-link-local",
                transmute(notify_is_mc_link_local_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_is_mc_node_local_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::is-mc-node-local",
                transmute(notify_is_mc_node_local_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_is_mc_org_local_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::is-mc-org-local",
                transmute(notify_is_mc_org_local_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_is_mc_site_local_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::is-mc-site-local",
                transmute(notify_is_mc_site_local_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_is_multicast_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::is-multicast",
                transmute(notify_is_multicast_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_is_site_local_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::is-site-local",
                transmute(notify_is_site_local_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn notify_bytes_trampoline<P>(this: *mut ffi::GInetAddress, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<InetAddress> {
    callback_guard!();
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&InetAddress::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_family_trampoline<P>(this: *mut ffi::GInetAddress, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<InetAddress> {
    callback_guard!();
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&InetAddress::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_is_any_trampoline<P>(this: *mut ffi::GInetAddress, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<InetAddress> {
    callback_guard!();
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&InetAddress::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_is_link_local_trampoline<P>(this: *mut ffi::GInetAddress, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<InetAddress> {
    callback_guard!();
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&InetAddress::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_is_loopback_trampoline<P>(this: *mut ffi::GInetAddress, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<InetAddress> {
    callback_guard!();
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&InetAddress::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_is_mc_global_trampoline<P>(this: *mut ffi::GInetAddress, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<InetAddress> {
    callback_guard!();
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&InetAddress::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_is_mc_link_local_trampoline<P>(this: *mut ffi::GInetAddress, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<InetAddress> {
    callback_guard!();
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&InetAddress::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_is_mc_node_local_trampoline<P>(this: *mut ffi::GInetAddress, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<InetAddress> {
    callback_guard!();
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&InetAddress::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_is_mc_org_local_trampoline<P>(this: *mut ffi::GInetAddress, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<InetAddress> {
    callback_guard!();
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&InetAddress::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_is_mc_site_local_trampoline<P>(this: *mut ffi::GInetAddress, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<InetAddress> {
    callback_guard!();
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&InetAddress::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_is_multicast_trampoline<P>(this: *mut ffi::GInetAddress, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<InetAddress> {
    callback_guard!();
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&InetAddress::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_is_site_local_trampoline<P>(this: *mut ffi::GInetAddress, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<InetAddress> {
    callback_guard!();
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&InetAddress::from_glib_borrow(this).downcast_unchecked())
}
