/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Action_H
#define Action_H

#include <string>
#include <ostream>

using namespace std;

class Action {
public:
	Action(const string& = "*" ,const string& = "*" );
	~Action(); // Change to virtual if base class

	bool operator<(const Action&) const;
	const string& name() const;
	const string& mode() const;

protected:
	void print(ostream&) const; // Change to virtual if base class	

private:
	// No copy allowed
	string name_;
	string mode_;

	friend ostream& operator<<(ostream& s,const Action& p)
		{ p.print(s); return s; }

};

inline void destroy(Action**) {}

#endif
