/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef LanguageHelper_H
#define LanguageHelper_H

#include "Highlighter.h"
#include "VerbFunctionHelp.h"

/* -----------------------------------------------------------------------
    class LanguageHelper

    Base class. There will be one derived class for each programming
    language that the editor will be able to handle.
    The helper classes will provide the editor with any language-specific
    functionality (e.g. syntax highlighting, how to execute, etc.)
   ----------------------------------------------------------------------- */


class QTextDocument;


class LanguageHelper
{
public:
    LanguageHelper() {};
    virtual ~LanguageHelper(){}


    virtual Highlighter *createHighlighter(QTextDocument *parent = 0) = 0;
    virtual bool canCheckSyntax() = 0;
    virtual bool canRun() = 0;
    virtual bool canDebug() = 0;
    virtual bool runAsService() = 0;
    virtual bool isHelpAvailableForFunction(const QString &function) = 0;
    virtual QString pathToFunctionList() {return QString("");};
    virtual QString pathToTemplateList() {return QString("");};

    virtual QString commentBlock(const QString &text);                // makes the text lines into a comment block
    virtual bool isHeaderLine(const QString &) {return false;};       // is the text a header line (e.g. "# Metview Macro")?
    virtual QString requiredHeaderLine()       {return QString("");}; // required header line to be added automatically
    virtual bool isAutoLicenceTextAllowed()    {return true;};        // is 'auto licence text' allowed for this language?
    virtual QString autoHeaderText()           {return QString("");}; // standard header line to add to empty file


    QString name()        {return languageName_;}
    QString className()   {return className_;}
    QString serviceName() {return serviceName_;}
    
    // convenience function to test whether the given string matches any of the language's names
    bool isLanguageName(const QString &testName) {return name() == testName || className() == testName;}

    VerbFunctionHelp *verbFunctionHelp() {return verbFunctionHelp_;}



protected:
    QString languageName_;
    QString className_;
    QString serviceName_;
    VerbFunctionHelp *verbFunctionHelp_;
};


#endif
