---
Name: goleft indexcov
URL: https://github.com/brentp/goleft/tree/master/indexcov
Description: >
    Quickly estimate coverage from a whole-genome bam index, providing 16KB resolution.
    This is useful as a quick QC to get coverage values across the genome.
---

The goleft indexcov module parses results generated by
[goleft indexcov](https://github.com/brentp/goleft/tree/master/indexcov). It
uses the PED and ROC data files to create diagnostic plots of coverage per
sample, helping to identify sample gender and coverage issues.

By default, we attempt to only plot chromosomes using standard human-like naming
(chr1, chr2... chrX or 1, 2 ... X) but you can specify chromosomes for detailed
ROC plots for alternative naming schemes in your configuration with:

```yaml
goleft_indexcov_config:
  chromosomes:
    - I
    - II
    - III
```

The number of plotted chromosomes is limited to 50 by default, you can customise this with the following:

```yaml
goleft_indexcov_config:
  max_chroms: 80
```
