#!/usr/bin/perl

# testdeps.pl - Testing modules for NagiosGrapher
# Copyright (C) 2004, NETWAYS GmbH, Gerd Mueller, Marius Hein
# $Id: testdeps.pl 741 2006-06-14 13:18:55Z mhein $
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use strict;
use CPAN;
use vars qw(@modules $out $mode);
$mode = $ARGV[0];
$mode = 'test' if (!defined($mode));

@modules = qw (
	Data::Dumper
	File::Copy
	File::Basename
	Carp
	POSIX
	Time::HiRes
	Time::Local
	Storable
	GD
	Image::Magick
	RRDs
	CGI
	CGI::Carp
	IO::Handle
	URI::Escape
	Calendar::Simple
);
$out = 0;

while (my $module = shift @modules) {
	print "Checking $module";
	eval "use $module;";
	if ($@) {
		if ($mode eq 'test') {
			print " ... not installed!\n";
			$out = 1;
		}
		elsif ($mode eq 'fix') {
			print "... not installed. I'll do this for you!\n";
			CPAN::install($module);
		}
	}
	else {
		print " ... found\n";
	}
}

exit ($out);