C
C	$Id: crebin.f,v 1.5 2008-07-27 01:04:31 haley Exp $
C                                                                      
C                Copyright (C)  2000
C        University Corporation for Atmospheric Research
C                All Rights Reserved
C
C The use of this Software is governed by a License Agreement.
C

      SUBROUTINE CREBIN(INUNIT,IOUTUN,INNUM,ITEMP,LENTEM)
C
C ROUTINE TO TRANSFORM A SEQUENCE OF INTEGERS INTO A CONTINUOUS BIT
C STREAM.
C
C ON ENTRY
C     INUNIT IS A FILE WHICH CONTAINS INNUM CARD IMAGES. EACH CARD
C     IMAGE CONTAINS 16 INTEGERS, EACH IN AN I5 FORMAT. EACH INTEGER
C     REPRESENTS A POSITIVE 15 BIT VALUE.
C     INUNIT CAN BE READ BY CREBIN.
C     IOUTUN IS A UNIT NUMBER WHERE CREBIN CAN WRITE A RECORD.
C     IOUTUN IS ASSUMED TO BE POSITIONED RIGHT.
C     ITEMP IS AN ARRAY OF LENGTH LENTEM. ITS ELEMENTS MAY HAVE
C     ANY VALUE.
C     LENTEM MUST BE (INNUM*15*16-1)/NBWD+1 OR BIGGER WHERE NBWD IS
C     THE NUMBER OF BITS PER WORD.
C     INNUM IS THE NUMBER OF CARD IMAGES ON FILE INUNIT.
C ON EXIT
C     THE VALUES OF INUNIT,IOUTUN, AND INNUM ARE UNCHANGED.
C     FILE INUNIT IS REWOUND BUT OTHERWISE UNCHANGED.
C     ITEMP CONTAINS THE INTEGERS FROM FILE INUNIT STORED
C     CONSECUTIVELY WITHOUT CONSIDERING WORD BOUNDARIES.
C     A BINARY RECORD IS CREATED ON UNIT IOUTUN WHICH CONTAINS THE FIRST
C     NUMOUT WORDS OF THE ARRAY ITEMP AS ONE LONG BIT STRING,
C     WHERE NUMOUT IS EXACTLY (INNUM*15*16-1)/NBWD+1.
C CALLS
C     IAND,IOR,ISHIFT
C
      DIMENSION ITEMP(LENTEM)
C
C TEMPORARY STORAGE TO CONTAIN 1 CARD IMAGE.
      DIMENSION ICARD(16)
C
C SEE BLOCK DATA DPORTX FOR MEANING OF CONSTANTS IN COMMON BLOCKS.
      COMMON /IDC1/ NBWD, IZERO, MA15
      COMMON /IDC2/ MASK15(15)
C
C LOCAL VARIABLES
C   IWORD - THE ENTRY IN THE ARRAY ITEMP WHICH IS CURRENTLY BEING
C           FILLED
C   IN15 - CONTAINS 15 BIT UNIT, RIGHT JUSTIFIED.
C   IIN15 - CONTAINS THE 15 BIT UNIT - OR PART OF IT - AT THE POSITION
C           WHICH IT WILL HAVE IN ITEMP(IWORD)
C   IPOS - THE NUMBER OF THE FIRST BIT IN THE WORD ITEMP(IWORD), WHERE
C          THE NEXT 15 BIT UNIT WILL BE STORED - 1 .
C          (COUNT FROM LEFT TO RIGHT, START WITH 0)
C   ICARD - TEMPORARY STORAGE FOR 1 CARD IMAGE.
C
C
      REWIND INUNIT
C
      IWORD = 1
      IPOS = 0
      ITEMP(1) = IZERO
C
C LOOP THROUGH ALL CARD IMAGES.
      DO 1 I = 1,INNUM
      READ(INUNIT,100)(ICARD(J),J=1,16)
C LOOP THROUG ALL 15 BIT UNITS ON A CARD IMAGE.
      DO 10 J=1,16
      IN15 = ICARD(J)
C STORE 15 BIT UNIT AS A WHOLE IF POSSIBLE OR LEFT PART OF IT IF IT
C HITS WORD BOUNDARY.
      IIN15 = ISHIFT(IAND(IN15,MA15),NBWD-15-IPOS)
      ITEMP(IWORD) = IOR(ITEMP(IWORD),IIN15)
      IPOS = IPOS + 15
      IF (IPOS .LT. NBWD) GOTO 11
C WORD BOUNDARY REACHED. STORE RIGHT PART OF UNIT INTO NEXT WORD.
      IPOS = IPOS - NBWD
      IWORD = IWORD + 1
      ITEMP(IWORD) = IZERO
      IIN15 = ISHIFT(IAND(IN15,MA15),NBWD-IPOS)
      ITEMP(IWORD) = IOR(ITEMP(IWORD),IIN15)
      ITEMP(IWORD) = IAND(ITEMP(IWORD),MASK15(IPOS+1))
   11 CONTINUE
   10 CONTINUE
    1 CONTINUE
C
      WRITE(IOUTUN) (ITEMP(J),J=1,IWORD)
C
      REWIND INUNIT
C
  100 FORMAT(16I5)
C
      RETURN
      END
