4.5.15
  - [Fix] `es5-sham`: `getPrototypeOf`: avoid infinite loop in pre-`__proto__` browsers
  - [Fix] `split`: add a function name to the "broken capturing groups" shim
  - [Robustness] cache Math methods
  - [readme] add standalone shims
  - [meta] add `in-publish` to avoid running the minifier on install
  - [meta] run `aud` in `posttest`
  - [Tests] migrate tests to Github Actions (#474)
  - [Tests] run `nyc` on all tests
  - [actions] add "Allow Edits" workflow
  - [actions] switch Automatic Rebase workflow to `pull_request_target` event
  - [Dev Deps] update `eslint`, `@ljharb/eslint-config`

4.5.14
  - [Fix] handle no `deleteCount` to `splice()` in Opera (#465)
  - [Refactor] remove unnecessary comparison
  - [meta] remove unused Makefile and associated utilities
  - [meta] add `funding` field
  - [meta] Rename CHANGES to CHANGELOG.md
  - [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `replace`, `semver`; add `safe-publish-latest`
  - [Tests] fix negative Date tests to handle TZData
  - [Tests] use shared travis-ci configs
  - [Tests] remove `jscs`
  - [Tests] clarify toPrecision's range increased in ES2018
  - [actions] add automatic rebasing / merge commit blocking

4.5.13
  - [Fix] exclude deprecated Firefox keys (#460)
  - [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `jasmine-node`, `replace`, `semver`

4.5.12
  - [meta] republish broken 4.5.11

4.5.11
  - [Fix] sync Object.keys excluded list from object-keys (#456)
  - [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `jasmine-node`, `replace`, `semver`
  - [Tests] pin jasmine-node to ~1.13

4.5.10
  - [Fix] Safari 11 throws on `.sort({})`, but not on `.sort(null)`
  - [Fix] ensure the shimmed parseInt throws with Symbols (#450)
  - [Fix] skip over `localStorage`, which can’t be accessed on file://
  - [Fix] Accessing window.top.{constructor|prototype} throws error in iOS (#445)
  - [Fix] avoid `width` and `height` on `window`, to prevent reflow (https://github.com/ljharb/object-keys/issues/31)
  - [Fix] ensure minified literal of `1000000000000000128` stays as that literal (#441)
  - [Robustness] always prefer `String(x)` over `x.toString()`
  - [Tests] up to `node` `v9.3`, `v8.9`, `v7.10`, `v6.12`, `v5.12`, `v4.8`; improve test matrix; use `nvm install-latest-npm`; comment out OS X builds; pin included builds to LTS
  - [Tests] `parseInt`: add another test for NaN parsing (#433)
  - [Dev Deps] `uglify-js`: add `--support-ie8` and peg to v2.7.x since it doesn’t follow semver
  - [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `jscs`, `uglify-js`, `semver`; remove `concurrently` (#421)

4.5.9
  - [Fix] parseInt and parseFloat should both accept null/undefined (#402)
  - [Tests] up to `node` `v6.2`
  - [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `jscs`, `concurrently`

4.5.8
  - [Fix] Check if property descriptor is configurable before re-defining it (#394, #373)
  - [Dev Deps] update `eslint`, `jscs`, `@ljharb/eslint-config`
  - [Tests] up to `node` `v5.10`, `v4.4`
  - [Tests] Use `concurrently` instead of `parallelshell`
  - [Tests] use `pretest` to run the linter

4.5.7
  - [Fix] `bind` in IE 8: Update `is-callable` implementation to v1.1.3 (#390)

4.5.6
  - [Fix] `new Date(new Date())` should work in IE 8 (#389)
  - [Tests] on `node` `v5.7`
  - [Dev Deps] update `uglify-js`

4.5.5
  - [Fix] Adobe Photoshop’s JS engine bizarrely can have `+date !== date.getTime()` (#365)
  - [Dev Deps] update `eslint`
  - [Refactor] Update `is-callable` implementation to match latest
  - [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `jscs`

4.5.4
  - [Fix] careless error from 5cf99aca49e59bae03b5d542381424bb1b13ec42

4.5.3
  - [Fix] Saturday is a day in the week (#386)
  - [Robustness] improve Function#bind (#381)
  - [Tests] on `node` `v5.6`, `v4.3`
  - [Tests] use json3 (#382)
  - [Dev Deps] update `eslint`, `@ljharb/eslint-config`
  - [Docs] add note about script order (#379)

4.5.2
  - [shim: fix] use `Array#slice`, not `String#slice`, on `String#split` output (#380)

4.5.1
  - [Fix] Make sure preexisting + broken `Array#` methods that throw don’t break the runtime (#377)
  - [Dev Deps] update `jscs`

4.5.0
  - [New] `parseFloat('-0')` should return -0 in Opera 12 (#371)
  - [New] Provide and replace Date UTC methods (#360)
  - [Robustness] cache `Date` getUTC* methods so that `Date#toISOString` doesn’t observably look them up on the receiver
  - [Robustness] use a cached and shimmed `String#trim`
  - [Tests] up to `node` `v5.5`
  - [Tests] add `parallelshell` and use it in a few tasks
  - [Refactor] rename cached methods to avoid linter warnings
  - [Dev Deps] update `eslint`, `jscs`, '@ljharb/eslint-config'
  - [Docs] Update license year to 2016 (#374)

4.4.2
  - [shim: fix] use `Array#slice`, not `String#slice`, on `String#split` output (#380)

4.4.1
  - [Fix] ensure that IE 11 in compatibility mode doesn't throw (#370)
  - [Docs] add missing shimmed things

4.4.0
  - [New] Detect and patch `RegExp#toString` in IE 8, which returns flags in the wrong order (#364)
  - [Fix] Patch `Array#sort` on {Chrome, Safari, IE < 9, FF 4} that throws improperly, per ES5 (#354)
  - [Fix] In IE 6, `window.external` makes `Object.keys` throw
  - [Fix] `Array#slice`: boxed string access on IE <= 8 (#349)
  - [Fix] `Array#join`: fix IE 6-8 join called on string literal (#352)
  - [Fix] Ensure that `Error#message` and `Error#name` are non-enumerable (#358)
  - [Fix: sham] `Object.getOwnPropertyDescriptor`: In Opera 11.6, `propertyIsEnumerable` is a nonshadowable global, like `toString`
  - [Robustness] Use a bound form of `Array#slice.call`
  - [Tests] Properly check for descriptor support in IE <= 8
  - [Tests] on `node` `v5.1`
  - [Tests] Add `Array#slice` tests (#346)
  - [Dev Deps] update `uglify-js`, `eslint`, `jscs`, `uglify-js`, `semver`
  - [Docs] Fix broken UMD links (#344)

4.3.2
  - [shim: fix] use `Array#slice`, not `String#slice`, on `String#split` output (#380)

4.3.1
  - [Fix] `String#split`: revert part of dcce96ae21185a69d2d40e67416e7496b73e8e47 which broke in older browsers (#342)
  - [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `jscs`
  - [Tests] Firefox allows `Number#toPrecision` values of [1,100], which the spec permits

4.3.0
  - [New] `Array#push`: in IE <= 7, `Array#push` was not generic (#336)
  - [New] `Array#push` in Opera `10.6` has a super weird bug when pushing `undefined`
  - [New] `Array#join`: In IE <= 7, passing `undefined` didn't use the default separator (#333)
  - [New] `Error#toString`: prints out the proper message in IE 7 and below (#334)
  - [New] `Number#toPrecision`: IE 7 and below incorrectly throw when an explicit `undefined` precision is passed (#340)
  - [Fix] `String#lastIndexOf`: ensure the correct length in IE 8
  - [Fix] ensure `parseInt` accepts negative and plus-prefixed hex values (#332)
  - [Robustness] Use a bound `Array#push` instead of relying on `Function#call`
  - [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `jscs`
  - [Tests] Add some conditionals to avoid impossible-to-fix test failures in IE 6-8, due to it being unable to distinguish between `undefined` and an absent index (#114)
  - [Tests] Fix false negatives in IE 6-8 with jasmine comparing arrays to arraylikes (#114)
  - [Tests] add additional `Array#shift` tests (#337)
  - [Tests] Add additional `Array#splice` tests (#339)
  - [Tests] Add `Array#pop` tests, just in case (#338)
  - [Tests] include `global` tests in HTML test files
  - [Tests] Make sure the HTML tests run with the right charset
  - [Tests] ensure `node` `v0.8` tests stay passing.
  - [Tests] Prevent nondeterminism in the tests - this sometime produced values that are one ms off
  - [Tests] on `node` `v5.0`
  - [Tests] fix npm upgrades for older nodes

4.2.1
  - [shim: fix] use `Array#slice`, not `String#slice`, on `String#split` output (#380)

4.2.0
  - [shim: new] Overwrite `String#lastIndexOf` in IE 9, 10, 11, and Edge, so it has proper unicode support.
  - [Dev Deps] update `eslint`, `jscs`

4.1.16
  - [shim: fix] use `Array#slice`, not `String#slice`, on `String#split` output (#380)

4.1.15
  - [shim: fix] new Date + Date.parse: Fix a Safari 8 & 9 bug where the `ms` arg is treated as a signed instead of unsigned int (#329)
  - [shim: fix] add 'frame' to blacklisted keys (#330)
  - [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `jscs`, `uglify-js`
  - [Tests] on `node` `v4.2`
  - [Tests] Date: prevent nondeterminism in the tests - this sometime produced values that are one ms off

4.1.14
  - [shim: fix] Wrap more things in a try/catch, because IE sucks and sometimes throws on [[Get]] of window.localStorage (#327)
  - [Refactor] Use `ES.ToUint32` instead of inline `>>>`
  - [Tests] up to `node` `v4.1`
  - [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `semver`, `jscs`

4.1.13
  - [shim: fix] Fix a bug where `Date(x)` threw instead of equalling `String(Date(x))` (#326)

4.1.12
  - [fix] Make sure uglify doesn't remove function names
  - [shim: fix] Use `is-arguments` implementation; don't call down legacy code path in modern engines (#325)
  - [Tests] up to `io.js` `v3.3`
  - [Dev Deps] update `eslint`, `@ljharb/eslint-config`

4.1.11
  - [shim: fix] Object.keys in Safari 9 has some bugs. (Already fixed in Webkit Nightly)
  - [shim: fix] Omit !Date.parse check in the if statement (#323)
  - [sham: fix] Fix Object.create sham to not set __proto__ (#301)
  - [sham: fix] Add a typeof check to Object.getPrototypeOf (#319, #320)
  - [Tests] up to `io.js` `v3.1`
  - [Tests] Make sure `Object.getPrototypeOf` tests don't fail when engines implement ES6 semantics
  - [Docs] Switch from vb.teelaun.ch to versionbadg.es for the npm version badge SVG (#318)
  - [Dev Deps] Update `eslint`, `uglify-js`, `jscs`; use my personal shared `eslint` config

4.1.10
  - [Fix] Fix IE 8 issue with `window.frameElement` access in a child iframe (#322)
  - [Tests] Consolidating `Date.parse` extended year tests
  - [Tests] Account for a `Date.parse` precision variance in Safari 8
  - [Tests] DRY up some Date.parse tests
  - [Tests] Don't create globals in Date tests
  - [Tests] Better failure output when an invalid date's toJSON throws
  - [Tests] Also compare lengths of array-likes
  - [Tests] Extra check on Object.keys(arguments)
  - [Tests] Skip appropriate tests when objects aren't extensible/freezeable/sealable

4.1.9
  - [Fix] Remove "extended", add "unicode" in `String#split` shim, to match ES6
  - [Fix] Object.keys: Preserve the IE 8 dontEnum bugfix, and the automation equality bugfix.
  - [Fix] Object.keys: Prevent a deprecation message from showing up in Chrome.
  - [Performance] Speed up blacklisted key check for Object.keys automation equality bug.
  - [Tests] Test on `io.js` `v2.4`
  - [Dev Deps] Update `eslint`, `semver`

4.1.8
  - [Fix] Fix an `Object.keys` IE 8 bug where `localStorage.prototype.constructor === localStorage` would throw (#275)
  - [Fix] Shimmed `Object.defineProperty` should not throw for an empty descriptor (#315)
  - [Fix] Fix `Date#toISOString` in Safari 5.1 (#243)
  - [Fix] Use `Object#propertyIsEnumerable` to default the initial "enumerable" value in `Object.getOwnPropertyDescriptor` sham (#289)
  - [Fix] Fix `Array#splice` with large sparse arrays in Safari 7/8, and Opera 12.15 (#295)
  - [Robustness] Safely use and reference many builtins internally (also see #313)
  - [Tests] Add `Date#{getUTCDate,getUTCMonth}` tests to expose Opera 10.6/11.61/12 `Date` bugs
  - [Dev Deps] Update `eslint`

4.1.7
  - Make sure `Date.parse` is not enumerable (#310)

4.1.6
  - Support IE 8 when `document.domain` is set (#306, #150)
  - Remove version from `bower.json` (#307)

4.1.5
  - Add a failing runtime check for Safari 8 `Date.parse`
  - Update `eslint`, `semver`
  - Test on `io.js` `v2.2`

4.1.4
  - Make sure copied `Date` properties remain non-enumerable.
  - Using a more reliable check for supported property descriptors in non-IE ES3
  - Fix 'constructor' in Object.defineProperties sham in ES3 (#252, #305)
  - Use a reference to `Array#concat` rather than relying on the runtime environment's `concat`.
  - Test on `io.js` `v2.1`
  - Clean up `Array.prototype` iteration methods

4.1.3
  - Update `license` in `package.json` per https://docs.npmjs.com/files/package.json#license
  - Update `uglify-js`, `eslint`

4.1.2
  - In IE 6-8, `Date` inside the function expression does not reference `DateShim` (#303)
  - Date: Ensure all code paths have the correct `constructor` property
  - Date: Don't copy non-own properties from original `Date`
  - Test up to `io.js` `v2.0.0`
  - Simplify `isPrimitive` check.
  - Adding sanity check tests for ES5 `Number` constants.
  - Update `uglify-js`, `eslint`, `semver`

4.1.1
  - Fix name of `parseInt` replacement.
  - Update copyright year
  - Update `eslint`, `jscs`
  - Lock `uglify-js` down to v2.4.17, since v2.4.18 and v2.4.19 have a breaking change.
  - All grade A-supported `node`/`iojs` versions now ship with an `npm` that understands `^`.
  - Run `travis-ci` tests on latest `node` and `iojs`; speed up builds; allow 0.8 failures.
  - Ensure some Object tests don't fail in ES6
  - Make sure `Date` instances don't have an enumerable `constructor` property, when possible.

4.1.0
  - Update `eslint`
  - Improve type checks: `Array.isArray`, `isRegex`
  - Replace `isRegex`/`isString`/`isCallable` checks with inlined versions from npm modules
  - Note which ES abstract methods are replaceable via `es-abstract`
  - Run `travis-ci` tests on `iojs`!

4.0.6
  - Update `jscs`, `uglify-js`, add `eslint`
  - es5-sham: fix Object.defineProperty to not check for own properties (#211)
  - Fix Array#splice bug in Safari 5 (#284)
  - Fix `Object.keys` issue with boxed primitives with extra properties in older browsers. (#242, #285)

4.0.5
  - Update `jscs` so tests pass

4.0.4
  - Style/indentation/whitespace cleanups.
  - README tweaks

4.0.3
  - Fix keywords (#268)
  - add some Date tests
  - Note in README that the es5-sham requires the es5-shim (https://github.com/es-shims/es5-shim/issues/256#issuecomment-52875710)

4.0.2
  - Start including version numbers in minified files (#267)

4.0.1
  - Fix legacy arguments object detection in Object.keys (#260)

4.0.0
  - No longer shim the ES5-spec behavior of splice when `deleteCount` is omitted - since no engines implement it, and ES6 changes it. (#255)
  - Use Object.defineProperty where available, so that polyfills are non-enumerable when possible (#250)
  - lots of internal refactoring
  - Fixed a bug referencing String#indexOf and String#lastIndexOf before polyfilling it (#253, #254)

3.4.0
  - Removed nonstandard SpiderMonkey extension to Array#splice - when `deleteCount` is omitted, it's now treated as 0. (#192, #239)
  - Fix Object.keys with Arguments objects in Safari 5.0
  - Now shimming String#split in Opera 10.6
  - Avoid using "toString" as a variable name, since that breaks Opera
  - Internal implementation and test cleanups

3.3.2
 - Remove an internal "bind" call, which should make the shim a bit faster
 - Fix a bug with object boxing in Array#reduceRight that was failing a test in IE 6

3.3.1
 - Fixing an Array#splice bug in IE 6/7
 - cleaning up Array#splice tests

3.3.0
 - Fix Array#reduceRight in node 0.6 and older browsers (#238)

3.2.0
 - Fix es5-sham UMD definition to work properly with AMD (#237)
 - Ensure that Array methods do not autobox context in strict mode (#233)

3.1.1
 - Update minified files (#231)

3.1.0
 - Fix String#replace in Firefox up through 29 (#228)

3.0.2
 - Fix `Function#bind` in IE 7 and 8 (#224, #225, #226)

3.0.1
 - Version bump to ensure npm has newest minified assets

3.0.0
 - es5-sham: fix `Object.getPrototypeOf` and `Object.getOwnPropertyDescriptor` for Opera Mini
 - Better override noncompliant native ES5 methods: `Array#forEach`, `Array#map`, `Array#filter`, `Array#every`, `Array#some`, `Array#reduce`, `Date.parse`, `String#trim`
 - Added spec-compliant shim for `parseInt`
 - Ensure `Object.keys` handles more edge cases with `arguments` objects and boxed primitives
 - Improve minification of builds

2.3.0
 - parseInt is now properly shimmed in ES3 browsers to default the radix
 - update URLs to point to the new organization

2.2.0
 - Function.prototype.bind shim now reports correct length on a bound function
 - fix node 0.6.x v8 bug in Array#forEach
 - test improvements

2.1.0
 - Object.create fixes
 - tweaks to the Object.defineProperties shim

2.0.0
 - Separate reliable shims from dubious shims (shams).

1.2.10
 - Group-effort Style Cleanup
 - Took a stab at fixing Object.defineProperty on IE8 without
   bad side-effects. (@hax)
 - Object.isExtensible no longer fakes it. (@xavierm)
 - Date.prototype.toISOString no longer deals with partial
   ISO dates, per spec (@kitcambridge)
 - More (mostly from @bryanforbes)

1.2.9
 - Corrections to toISOString by @kitcambridge
 - Fixed three bugs in array methods revealed by Jasmine tests.
 - Cleaned up Function.prototype.bind with more fixes and tests from
   @bryanforbes.

1.2.8
 - Actually fixed problems with Function.prototype.bind, and regressions
   from 1.2.7 (@bryanforbes, @jdalton #36)

1.2.7 - REGRESSED
 - Fixed problems with Function.prototype.bind when called as a constructor.
   (@jdalton #36)

1.2.6
 - Revised Date.parse to match ES 5.1 (kitcambridge)

1.2.5
 - Fixed a bug for padding it Date..toISOString (tadfisher issue #33)

1.2.4
 - Fixed a descriptor bug in Object.defineProperty (raynos)

1.2.3
 - Cleaned up RequireJS and <script> boilerplate

1.2.2
 - Changed reduce to follow the letter of the spec with regard to having and
   owning properties.
 - Fixed a bug where RegExps pass as Functions in some engines in reduce.

1.2.1
 - Adding few fixes to make jshint happy.
 - Fix for issue #12, function expressions can cause scoping issues in IE.
 - NPM will minify on install or when `npm run-script install` is executed.
 - Adding .gitignore to avoid publishing dev dependencies.

1.2.0
 - Making script loadable as AMD module.
 - Adding `indexOf` to the list of safe shims.

1.1.0
 - Added support for accessor properties where possible (which is all browsers
   except IE).
 - Stop exposing bound function's (that are returned by
   `Function.prototype.bind`) internal properties (`bound, boundTo, boundArgs`)
   as in some cases (when using facade objects for example) capabilities of the
   enclosed functions will be leaked.
 - `Object.create` now explicitly sets `__proto__` property to guarantee
   correct behavior of `Object.getPrototypeOf`'s on all objects created using
   `Object.create`.
 - Switched to `===` from `==` where possible as it's slightly faster on older
   browsers that are target of this lib.
 - Added names to all anonymous functions to have a better stack traces.

1.0.0
 - fixed Date.toISODate, using UTC accessors, as in
   http://code.google.com/p/v8/source/browse/trunk/src/date.js?r=6120#986
   (arian)

0.0.4
 - Revised Object.getPrototypeOf to work in more cases
   in response to http://ejohn.org/blog/objectgetprototypeof/
   [issue #2] (fschaefer)

0.0.3
 - Fixed typos in Object.keys (samsonjs)

0.0.2
   Per kangax's recommendations:
 - faster Object.create(null)
 - fixed a function-scope function declaration statement in Object.create

0.0.1
 - fixed Object.create(null), in so far as that's possible
 - reworked Rhino Object.freeze(Function) bug detector and patcher

0.0.0
 - forked from narwhal-lib

