/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2011 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::sprayCloud

Description
    Virtual abstract base class for templated SprayCloud

SourceFiles
    sprayCloud.C

\*---------------------------------------------------------------------------*/

#ifndef sprayCloud_H
#define sprayCloud_H

#include "typeInfo.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                       Class sprayCloud Declaration
\*---------------------------------------------------------------------------*/

class sprayCloud
{
    // Private Member Functions

        //- No copy construct
        sprayCloud(const sprayCloud&) = delete;

        //- No copy assignment
        void operator=(const sprayCloud&) = delete;


public:

    //- Runtime type information
    TypeName("sprayCloud");

    // Constructors

        //- Null constructor
        sprayCloud();


    //- Destructor
    virtual ~sprayCloud();
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
