#!/usr/bin/env python
#
#   Copyright (C) 2014 Dave Schaefer
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, version 3 of the License.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.

# list of many Mozilla locale codes
# kept in a separate file so it doesn't take up space in the main module.
# base list taken from
# https://svn.mozilla.org/libs/product-details/json/languages.json
# other codes added as extensions make use of them

MOZILLA_LOCALE_CODES = {
	'ach': True,
	'af': True,
	'ak': True,
	'am-et': True,
	'an': True,
	'ar': True,
	'as': True,
	'ast': True,
	'az': True,
	'be': True,
	'bg': True,
	'bg-BG': True,
	'bn-BD': True,
	'bn-IN': True,
	'br': True,
	'bs': True,
	'ca': True,
	'ca-valencia': True,
	'cs': True,
	'cs-CZ': True,
	'csb': True,
	'cy': True,
	'da': True,
	'dbg': True,
	'de': True,
	'de-AT': True,
	'de-CH': True,
	'de-DE': True,
	'dsb': True,
	'ee': True,
	'el': True,
	'en-AU': True,
	'en-CA': True,
	'en-GB': True,
	'en-NZ': True,
	'en-US': True,
	'en-ZA': True,
	'eo': True,
	'es': True,
	'es-AR': True,
	'es-CL': True,
	'es-ES': True,
	'es-MX': True,
	'et': True,
	'et-EE': True,
	'eu': True,
	'fa': True,
	'ff': True,
	'fi': True,
	'fj-FJ': True,
	'fr': True,
	'fur-IT': True,
	'fy-NL': True,
	'ga': True,
	'ga-IE': True,
	'gd': True,
	'gl': True,
	'gl-ES': True,
	'gu': True,
	'gu-IN': True,
	'he': True,
	'hi': True,
	'hi-IN': True,
	'hr': True,
	'hr-HR': True,
	'hsb': True,
	'hu': True,
	'hu-HU': True,
	'hy-AM': True,
	'id': True,
	'is': True,
	'it': True,
	'ja': True,
	'ja-JP': True,
	'ja-JP-mac': True,
	'ka': True,
	'kk': True,
	'km': True,
	'kn': True,
	'ko': True,
	'ku': True,
	'la': True,
	'lg': True,
	'lij': True,
	'ln': True,
	'lo': True,
	'lt': True,
	'lv': True,
	'lv-LV': True,
	'mai': True,
	'mg': True,
	'mi': True,
	'mk': True,
	'ml': True,
	'mn': True,
	'mr': True,
	'ms': True,
	'ms-MY': True,
	'my': True,
	'nb-NO': True,
	'ne-NP': True,
	'nl': True,
	'nn-NO': True,
	'nr': True,
	'nso': True,
	'oc': True,
	'or': True,
	'pa': True,
	'pa-IN': True,
	'pl': True,
	'pt-BR': True,
	'pt-PT': True,
	'rm': True,
	'ro': True,
	'ru': True,
	'rw': True,
	'sa': True,
	'sah': True,
	'sat': True,
	'si': True,
	'sk': True,
	'sk-SK': True,
	'sl': True,
	'sl-SI': True,
	'son': True,
	'sq': True,
	'sr': True,
	'sr-Cyrl': True,
	'sr-Latn': True,
	'ss': True,
	'st': True,
	'sv-SE': True,
	'sw': True,
	'ta': True,
	'ta-IN': True,
	'ta-LK': True,
	'te': True,
	'th': True,
	'tn': True,
	'tr': True,
	'ts': True,
	'tt-RU': True,
	'uk': True,
	'uk-UA': True,
	'ur': True,
	'uz': True,
	've': True,
	'vi': True,
	'wo': True,
	'x-testing': True,
	'xh': True,
	'zh-CN': True,
	'zh-TW': True,
	'zu': True
}

if __name__ == "__main__":
	pass

