# frozen_string_literal: true

require 'spec_helper'

describe 'Stdlib::Base64' do
  describe 'valid handling' do
    ['asdasdASDSADA342386832/746+=', 'asdasdASDSADA34238683274/6+', 'asdasdASDSADA3423868327/46+=='].each do |value|
      describe value.inspect do
        it { is_expected.to allow_value(value) }
      end
    end
  end

  describe 'invalid path handling' do
    context 'garbage inputs' do
      [
        [nil],
        [nil, nil],
        { 'foo' => 'bar' },
        {},
        '',
        "\nasdasdASDSADA342386832/746+=",
        "\nasdasdASDSADA342386832/746+=\n",
        "asdasdASDSADA342386832/746+=\n",
        'asdasd!@#$',
        '=asdasd9879876876+/',
        'asda=sd9879876876+/',
        'asdaxsd9879876876+/===',
        'asdads asdasd',
      ].each do |value|
        describe value.inspect do
          it { is_expected.not_to allow_value(value) }
        end
      end
    end
  end
end
