/**********************************************************************
 * $show_value example -- C source code using TF/ACC PLI routines
 *
 * C source to print the names and current logic value of a signal.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage: $show_value(<signal_name>);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_ShowVal_checktf(), PLIbook_ShowVal_calltf();
 *  /* table entries -/
 *   {usertask,                     /* type of PLI routine -/
 *     0,                           /* user_data value -/
 *     PLIbook_ShowVal_checktf,     /* checktf routine -/
 *     0,                           /* sizetf routine -/
 *     PLIbook_ShowVal_calltf,      /* calltf routine -/
 *     0,                           /* misctf routine -/
 *     "$show_value",               /* system task/function name -/
 *     1                            /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF routine library  */
#include "acc_user.h"         /* IEEE 1364 PLI ACC routine library */

/**********************************************************************
 * checktf routine
 *********************************************************************/
int PLIbook_ShowVal_checktf()
{
  int    arg_type;
  handle arg_handle;
  
  if (tf_nump() != 1)
    tf_error("$show_value must have 1 argument.");
  else if (tf_typep(1) == TF_NULLPARAM)
    tf_error("$show_value arg cannot be null.");
  else {
    arg_handle = acc_handle_tfarg(1);
    arg_type = acc_fetch_type(arg_handle);
    if (!(arg_type == accNet || arg_type == accReg))
      tf_error("$show_value arg must be a net or reg.");
  }
  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_ShowVal_calltf()
{
  handle arg_handle;

  arg_handle = acc_handle_tfarg(1);
  io_printf("Signal %s has the value %s\n",
            acc_fetch_fullname(arg_handle),
            acc_fetch_value(arg_handle, "%b", null));
  return(0);
}
/*********************************************************************/

