# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IssuerParameters(Model):
    """Parameters for the issuer of the X509 component of a certificate.

    :param name: Name of the referenced issuer object or reserved names; for
     example, 'Self' or 'Unknown'.
    :type name: str
    :param certificate_type: Type of certificate to be requested from the
     issuer provider.
    :type certificate_type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'certificate_type': {'key': 'cty', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, certificate_type: str=None, **kwargs) -> None:
        super(IssuerParameters, self).__init__(**kwargs)
        self.name = name
        self.certificate_type = certificate_type
