# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class KeyVaultReference(Model):
    """Identifies the Azure key vault associated with a Batch account.

    :param id: The resource ID of the Azure key vault associated with the
     Batch account.
    :type id: str
    :param url: The URL of the Azure key vault associated with the Batch
     account.
    :type url: str
    """

    _validation = {
        'id': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(self, id, url):
        super(KeyVaultReference, self).__init__()
        self.id = id
        self.url = url
