# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResourceUsage(Model):
    """Output of check resource usage API.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_type: Resource type for which the usage is provided.
    :vartype resource_type: str
    :ivar unit: Unit of the usage. e.g. Count.
    :vartype unit: str
    :ivar current_value: Actual value of usage on the specified resource type.
    :vartype current_value: int
    :ivar limit: Quota of the specified resource type.
    :vartype limit: int
    """

    _validation = {
        'resource_type': {'readonly': True},
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
    }

    def __init__(self, **kwargs) -> None:
        super(ResourceUsage, self).__init__(**kwargs)
        self.resource_type = None
        self.unit = None
        self.current_value = None
        self.limit = None
