# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BuildArgument(Model):
    """Properties of a build argument.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the argument. Default value:
     "DockerBuildArgument" .
    :vartype type: str
    :param name: Required. The name of the argument.
    :type name: str
    :param value: Required. The value of the argument.
    :type value: str
    :param is_secret: Flag to indicate whether the argument represents a
     secret and want to be removed from build logs. Default value: False .
    :type is_secret: bool
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'is_secret': {'key': 'isSecret', 'type': 'bool'},
    }

    type = "DockerBuildArgument"

    def __init__(self, **kwargs):
        super(BuildArgument, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)
        self.is_secret = kwargs.get('is_secret', False)
