# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .linked_integration_runtime_properties import LinkedIntegrationRuntimeProperties


class LinkedIntegrationRuntimeRbac(LinkedIntegrationRuntimeProperties):
    """The base definition of a secret type.

    :param authorization_type: Constant filled by server.
    :type authorization_type: str
    :param resource_id: The resource ID of the integration runtime to be
     shared.
    :type resource_id: str
    """

    _validation = {
        'authorization_type': {'required': True},
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'authorization_type': {'key': 'authorizationType', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(self, resource_id):
        super(LinkedIntegrationRuntimeRbac, self).__init__()
        self.resource_id = resource_id
        self.authorization_type = 'RBAC'
