# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class GetUserTablesSqlSyncTaskOutput(Model):
    """Output of the task that collects user tables for the given list of
    databases.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar databases_to_source_tables: Mapping from database name to list of
     source tables
    :vartype databases_to_source_tables: dict[str,
     list[~azure.mgmt.datamigration.models.DatabaseTable]]
    :ivar databases_to_target_tables: Mapping from database name to list of
     target tables
    :vartype databases_to_target_tables: dict[str,
     list[~azure.mgmt.datamigration.models.DatabaseTable]]
    :ivar table_validation_errors: Mapping from database name to list of
     validation errors
    :vartype table_validation_errors: dict[str, list[str]]
    :ivar validation_errors: Validation errors
    :vartype validation_errors:
     list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'databases_to_source_tables': {'readonly': True},
        'databases_to_target_tables': {'readonly': True},
        'table_validation_errors': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'databases_to_source_tables': {'key': 'databasesToSourceTables', 'type': '{[DatabaseTable]}'},
        'databases_to_target_tables': {'key': 'databasesToTargetTables', 'type': '{[DatabaseTable]}'},
        'table_validation_errors': {'key': 'tableValidationErrors', 'type': '{[str]}'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(self, **kwargs) -> None:
        super(GetUserTablesSqlSyncTaskOutput, self).__init__(**kwargs)
        self.databases_to_source_tables = None
        self.databases_to_target_tables = None
        self.table_validation_errors = None
        self.validation_errors = None
